/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.sampledb;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.IConnectionFactory;
import org.eclipse.birt.report.data.oda.sampledb.SampledbPlugin;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class SampleDBJDBCConnectionFactory
implements IConnectionFactory {
    private static final Logger logger = Logger.getLogger(SampleDBJDBCConnectionFactory.class.getName());
    private Driver derbyDriver;
    private DerbyClassLoader derbyClassLoader;
    static /* synthetic */ Class class$org$eclipse$birt$report$data$oda$sampledb$SampleDBJDBCConnectionFactory$DerbyClassLoader;

    public Connection getConnection(String driverClass, String url, Properties connectionProperties) throws SQLException {
        if (!driverClass.equals("org.eclipse.birt.report.data.oda.sampledb.Driver")) {
            logger.log(Level.SEVERE, "Unexpected driverClass: " + driverClass);
            throw new SQLException("Unexpected driverClass " + driverClass);
        }
        if (!url.equals("jdbc:classicmodels:sampledb")) {
            logger.log(Level.WARNING, "Unexpected url: " + url);
            throw new SQLException("Classic Models Inc. Sample Database Driver does not recognize url: " + driverClass);
        }
        String dbUrl = SampledbPlugin.getDBUrl();
        Properties props = connectionProperties != null ? (Properties)connectionProperties.clone() : new Properties();
        props.put("user", "ClassicModels");
        props.put("password", "");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting Sample DB JDBC connection. DriverClass=org.apache.derby.jdbc.EmbeddedDriver, Url=" + dbUrl);
        }
        this.initClassLoaders();
        return this.getDerbyDriver().connect(dbUrl, props);
    }

    private void initClassLoaders() {
        ClassLoader contextLoader;
        if (this.derbyClassLoader == null) {
            this.derbyClassLoader = new DerbyClassLoader();
        }
        if (this.derbyClassLoader.isGood() && (contextLoader = Thread.currentThread().getContextClassLoader()) != null && !(contextLoader instanceof ContextClassLoaderDelegator)) {
            Thread.currentThread().setContextClassLoader(new ContextClassLoaderDelegator(contextLoader, this.derbyClassLoader));
        }
    }

    private Driver getDerbyDriver() throws SQLException {
        if (this.derbyDriver == null) {
            try {
                this.derbyDriver = (Driver)Class.forName("org.apache.derby.jdbc.EmbeddedDriver", true, this.derbyClassLoader).newInstance();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load Derby embedded driver: org.apache.derby.jdbc.EmbeddedDriver", e);
                throw new SQLException(e.getLocalizedMessage());
            }
        }
        return this.derbyDriver;
    }

    public static String getDbUser() {
        return "ClassicModels";
    }

    private static class DerbyClassLoader
    extends URLClassLoader {
        boolean isGood = false;

        public DerbyClassLoader() {
            super(new URL[]{}, (class$org$eclipse$birt$report$data$oda$sampledb$SampleDBJDBCConnectionFactory$DerbyClassLoader == null ? (class$org$eclipse$birt$report$data$oda$sampledb$SampleDBJDBCConnectionFactory$DerbyClassLoader = SampleDBJDBCConnectionFactory.class$("org.eclipse.birt.report.data.oda.sampledb.SampleDBJDBCConnectionFactory$DerbyClassLoader")) : class$org$eclipse$birt$report$data$oda$sampledb$SampleDBJDBCConnectionFactory$DerbyClassLoader).getClassLoader());
            Bundle derbyBundle = Platform.getBundle((String)"org.apache.derby.core");
            if (derbyBundle == null) {
                logger.severe("Failed to find plugin org.apache.derby.core");
            } else {
                URL fileURL = derbyBundle.getEntry("derby.jar");
                if (fileURL == null) {
                    logger.severe("Failed to find derby.jar in plugin org.apache.derby.core");
                } else {
                    this.addURL(fileURL);
                    this.isGood = true;
                }
            }
        }

        public static boolean isDerbyClass(String className) {
            return className.startsWith("org.apache.derby");
        }

        public static boolean isDerbyResource(String name) {
            return name.startsWith("org/apache/derby") || name.startsWith("/org/apache/derby");
        }

        public boolean isGood() {
            return this.isGood;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.isGood && DerbyClassLoader.isDerbyClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Load derby class: " + name);
                    }
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }

        public URL getResource(String name) {
            if (this.isGood && DerbyClassLoader.isDerbyResource(name)) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Load derby resource: " + name);
                }
                return this.findResource(name);
            }
            return super.getResource(name);
        }
    }

    private static class ContextClassLoaderDelegator
    extends ClassLoader {
        private DerbyClassLoader derbyLoader;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ContextClassLoaderDelegator(ClassLoader defaultLoader, DerbyClassLoader derbyLoader) {
            super(defaultLoader);
            if (!$assertionsDisabled && derbyLoader == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !derbyLoader.isGood()) {
                throw new AssertionError();
            }
            this.derbyLoader = derbyLoader;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (DerbyClassLoader.isDerbyClass(name)) {
                return this.derbyLoader.loadClass(name, resolve);
            }
            return super.loadClass(name, resolve);
        }

        public URL getResource(String name) {
            if (DerbyClassLoader.isDerbyResource(name)) {
                return this.derbyLoader.getResource(name);
            }
            return super.getResource(name);
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$data$oda$sampledb$SampleDBJDBCConnectionFactory == null ? (class$org$eclipse$birt$report$data$oda$sampledb$SampleDBJDBCConnectionFactory = SampleDBJDBCConnectionFactory.class$("org.eclipse.birt.report.data.oda.sampledb.SampleDBJDBCConnectionFactory")) : class$org$eclipse$birt$report$data$oda$sampledb$SampleDBJDBCConnectionFactory).desiredAssertionStatus();
        }
    }
}

