/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.io.Serializable;
import java.net.DatagramPacket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.snmp.AbstractPollingInfo;
import org.eclipse.aperi.snmp.AbstractSnmpPoller;
import org.eclipse.aperi.snmp.PollingInfo;
import org.eclipse.aperi.snmp.PseudoPoller;
import org.eclipse.aperi.snmp.ShortcutInfo;
import org.eclipse.aperi.snmp.ShortcutPoller;
import org.eclipse.aperi.snmp.SnmpMetaPDU;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpPoller;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.SwadeohPoller;
import org.eclipse.aperi.snmp.TablePoller;
import org.eclipse.aperi.snmp.TablePollingInfo;
import org.eclipse.aperi.snmp.TableWalker;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.utils.Queue;
import org.eclipse.aperi.snmp.utils.SingleInstanceFactory;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.TimerService;
import org.eclipse.aperi.snmp.utils.Wakeable;

class PollingDriver
implements Wakeable {
    protected boolean anyChanges;
    protected Vector tables;
    private Vector pollers;
    private Vector addThese;
    private Vector removeThese;
    private Hashtable mibvar;
    private Hashtable ravbim;
    private Hashtable responses;
    private SnmpSession session;
    private SnmpPDU[] getPDU;
    private DatagramPacket[] getPDUber;
    private boolean[][] lastRow;
    private boolean inProgress;
    private boolean stopping;
    private Timer timer;
    private int interval;
    private long nextWakeUpTime;
    private boolean viaTimerPop;
    private static final int VARBINDS_PER_PDU = 20;

    public PollingDriver(SnmpSession snmpSession, int n) {
        this.session = snmpSession;
        this.interval = n;
        this.inProgress = false;
        this.pollers = new Vector();
        this.addThese = new Vector();
        this.removeThese = new Vector();
        this.tables = new Vector();
        this.mibvar = new Hashtable();
        this.ravbim = new Hashtable();
        this.responses = new Hashtable();
        this.anyChanges = false;
        this.stopping = false;
        this.viaTimerPop = true;
    }

    public void notByTimerPop() {
        this.viaTimerPop = false;
    }

    public synchronized void add(AbstractSnmpPoller abstractSnmpPoller, Object object) {
        AbstractPollingInfo abstractPollingInfo = null;
        if (abstractSnmpPoller instanceof ShortcutPoller) {
            abstractPollingInfo = new ShortcutInfo((ShortcutPoller)abstractSnmpPoller, object, this.session);
        } else if (abstractSnmpPoller instanceof SnmpPoller) {
            abstractPollingInfo = new PollingInfo((SnmpPoller)abstractSnmpPoller, object);
        } else if (abstractSnmpPoller instanceof TablePoller) {
            TablePoller tablePoller = (TablePoller)abstractSnmpPoller;
            long[] lArray = new long[tablePoller.oids[0].value.length - 2];
            int n = 0;
            while (n < lArray.length) {
                lArray[n] = tablePoller.oids[0].value[n];
                ++n;
            }
            OID oID = new OID(lArray, true);
            TableWalker tableWalker = null;
            int n2 = 0;
            while (tableWalker == null && n2 < this.tables.size()) {
                TableWalker tableWalker2 = (TableWalker)this.tables.elementAt(n2);
                if (tableWalker2.tableoid.equals(oID)) {
                    boolean bl = false;
                    if (tablePoller.index == null && tableWalker2.index == null) {
                        bl = true;
                    } else if (tablePoller.index != null && tableWalker2.index != null && tablePoller.index.length == tableWalker2.index.length) {
                        bl = true;
                        int n3 = 0;
                        while (bl && n3 < tablePoller.index.length) {
                            bl = tablePoller.index[n3] == tableWalker2.index[n3];
                            ++n3;
                        }
                    }
                    if (bl) {
                        tableWalker = tableWalker2;
                    }
                }
                ++n2;
            }
            if (tableWalker == null) {
                tableWalker = new TableWalker(oID, tablePoller.oids[0], tablePoller.index, this.interval, this, this.session);
                this.tables.addElement(tableWalker);
            }
            abstractPollingInfo = new TablePollingInfo(tablePoller, object, tableWalker);
            tableWalker.addPoller((TablePollingInfo)abstractPollingInfo);
        } else {
            abstractPollingInfo = new AbstractPollingInfo(abstractSnmpPoller, object);
        }
        if (this.inProgress) {
            this.addThese.addElement(abstractPollingInfo);
        } else {
            this.pollers.addElement(abstractPollingInfo);
            this.anyChanges = true;
        }
        if (!this.inProgress && this.pollers.size() == 1) {
            this.startSampling();
        }
    }

    public synchronized void remove(AbstractSnmpPoller abstractSnmpPoller) {
        AbstractPollingInfo abstractPollingInfo;
        boolean bl = false;
        Enumeration enumeration = this.pollers.elements();
        while (!bl && enumeration.hasMoreElements()) {
            abstractPollingInfo = (AbstractPollingInfo)enumeration.nextElement();
            if (abstractPollingInfo.poller != abstractSnmpPoller) continue;
            bl = true;
            if (this.inProgress) {
                this.removeThese.addElement(abstractPollingInfo);
            } else {
                this.pollers.removeElement(abstractPollingInfo);
                this.anyChanges = true;
            }
            if (!(abstractPollingInfo instanceof TablePollingInfo)) continue;
            ((TablePollingInfo)abstractPollingInfo).removed = true;
            boolean bl2 = false;
            int n = 0;
            while (!bl2 && n < this.tables.size()) {
                TableWalker tableWalker = (TableWalker)this.tables.elementAt(n);
                if (tableWalker.pollers.contains(abstractPollingInfo)) {
                    tableWalker.removePoller((TablePollingInfo)abstractPollingInfo);
                }
                ++n;
            }
        }
        if (!bl) {
            enumeration = this.addThese.elements();
            while (!bl && enumeration.hasMoreElements()) {
                abstractPollingInfo = (AbstractPollingInfo)enumeration.nextElement();
                if (abstractPollingInfo.poller != abstractSnmpPoller) continue;
                bl = true;
                this.addThese.removeElement(abstractPollingInfo);
                if (!(abstractPollingInfo instanceof TablePollingInfo)) continue;
                ((TablePollingInfo)abstractPollingInfo).removed = true;
            }
        }
        if (this.pollers.size() == 0) {
            this.stopSampling();
        }
    }

    public synchronized int count() {
        return this.pollers.size() + this.addThese.size() - this.removeThese.size();
    }

    protected synchronized void startSampling() {
        if (this.viaTimerPop) {
            long l = this.interval;
            long l2 = System.currentTimeMillis();
            l = (l2 + (long)this.interval - 1L) / (long)this.interval * (long)this.interval - l2;
            l = this.session.redshift < this.interval ? (l += (long)this.session.redshift) : (l += (long)((int)((double)this.interval * Math.random())));
            this.timer = TimerService.scheduleWakeUp((int)l, this);
            this.nextWakeUpTime = l + l2;
        }
    }

    protected synchronized void stopSampling() {
        if (this.inProgress) {
            this.stopping = true;
        } else if (this.viaTimerPop) {
            TimerService.cancelWakeUp(this.timer);
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(Object object) {
        int n;
        Object object2;
        int n2;
        Serializable[] serializableArray;
        Object object3;
        Serializable[] serializableArray2;
        Object object4;
        int n3;
        int n4;
        long l;
        int n5;
        Object object5;
        int n6;
        Serializable serializable;
        Object object6;
        int n7;
        Enumeration enumeration;
        int n8;
        long l2 = this.nextWakeUpTime;
        this.nextWakeUpTime += (long)this.interval;
        long l3 = System.currentTimeMillis();
        if (this.viaTimerPop) {
            Vector vector = new Vector();
            PollingDriver pollingDriver = this;
            synchronized (pollingDriver) {
                this.inProgress = true;
                n8 = this.addThese.size();
                int n9 = 0;
                while (n9 < n8) {
                    enumeration = (AbstractPollingInfo)this.addThese.elementAt(n9);
                    this.pollers.addElement(enumeration);
                    this.anyChanges = true;
                    ++n9;
                }
                this.addThese.removeAllElements();
                n8 = this.removeThese.size();
                n9 = 0;
                while (n9 < n8) {
                    enumeration = (AbstractPollingInfo)this.removeThese.elementAt(n9);
                    this.pollers.removeElement(enumeration);
                    this.anyChanges = true;
                    ++n9;
                }
                this.removeThese.removeAllElements();
                n9 = 0;
                while (n9 < this.pollers.size()) {
                    enumeration = (AbstractPollingInfo)this.pollers.elementAt(n9);
                    if (((AbstractPollingInfo)((Object)enumeration)).poller.interval.interval != this.interval) {
                        this.pollers.removeElementAt(n9);
                        vector.addElement(enumeration);
                        this.anyChanges = true;
                        continue;
                    }
                    if (enumeration instanceof TablePollingInfo) {
                        TablePollingInfo tablePollingInfo = (TablePollingInfo)((Object)enumeration);
                        TableWalker tableWalker = tablePollingInfo.walker;
                        synchronized (tableWalker) {
                            tablePollingInfo.walker.polling = true;
                            if (tablePollingInfo.anyChanges) {
                                this.anyChanges = true;
                            }
                        }
                    }
                    ++n9;
                }
                if (this.pollers.size() == 0) {
                    this.timer = null;
                    this.inProgress = false;
                }
            }
            n8 = vector.size();
            n7 = 0;
            while (n7 < n8) {
                AbstractPollingInfo abstractPollingInfo = (AbstractPollingInfo)vector.elementAt(n7);
                this.session.add(abstractPollingInfo.poller, abstractPollingInfo.cookie);
                ++n7;
            }
            vector.removeAllElements();
        } else {
            this.inProgress = true;
        }
        if (!this.inProgress) {
            n8 = this.pollers.size();
            int n10 = 0;
            while (n10 < n8) {
                if (this.pollers.elementAt(n10) instanceof TablePollingInfo) {
                    TablePollingInfo tablePollingInfo;
                    TablePollingInfo tablePollingInfo2 = tablePollingInfo = (TablePollingInfo)this.pollers.elementAt(n10);
                    synchronized (tablePollingInfo2) {
                        tablePollingInfo.walker.polling = false;
                        tablePollingInfo.walker.notify();
                    }
                }
                ++n10;
            }
            return;
        }
        if (this.anyChanges) {
            this.mibvar.clear();
            this.ravbim.clear();
            n8 = this.pollers.size();
            int n11 = 0;
            while (n11 < n8) {
                int n12;
                int n13;
                AbstractPollingInfo abstractPollingInfo = (AbstractPollingInfo)this.pollers.elementAt(n11);
                if (abstractPollingInfo instanceof PollingInfo) {
                    PollingInfo pollingInfo = (PollingInfo)abstractPollingInfo;
                    enumeration = (SnmpPoller)pollingInfo.poller;
                    n13 = ((SnmpPoller)((Object)enumeration)).oids.length;
                    n12 = 0;
                    while (n12 < n13) {
                        object6 = SnmpMetaPDU.getPreviousOID(((SnmpPoller)((Object)enumeration)).oids[n12]);
                        this.mibvar.put(((SnmpPoller)((Object)enumeration)).oids[n12], object6);
                        this.ravbim.put(object6, ((SnmpPoller)((Object)enumeration)).oids[n12]);
                        ++n12;
                    }
                } else if (abstractPollingInfo instanceof TablePollingInfo) {
                    int n14;
                    TablePollingInfo tablePollingInfo = (TablePollingInfo)abstractPollingInfo;
                    enumeration = (TablePoller)tablePollingInfo.poller;
                    n13 = ((TablePoller)((Object)enumeration)).oids[0].value.length;
                    n12 = tablePollingInfo.walker.rows.size();
                    if (n12 > (n14 = ((TablePoller)((Object)enumeration)).getMaxRows())) {
                        n12 = n14;
                    }
                    int n15 = 0;
                    while (n15 < n12) {
                        OID oID;
                        OID oID2;
                        serializable = (OID)tablePollingInfo.walker.rows.elementAt(n15);
                        n6 = ((OID)serializable).value.length - n13;
                        object5 = new long[n6];
                        int n16 = 0;
                        while (n16 < n6) {
                            object5[n16] = ((OID)serializable).value[n13 + n16];
                            ++n16;
                        }
                        if (n15 >= 1) {
                            oID2 = (OID)tablePollingInfo.walker.rows.elementAt(n15 - 1);
                            oID = (OID)tablePollingInfo.walker.rows.elementAt(n15);
                            if (!this.mibvar.containsKey(oID)) {
                                this.mibvar.put(oID, oID2);
                            }
                            if (!this.ravbim.containsKey(oID2)) {
                                this.ravbim.put(oID2, oID);
                            }
                        } else {
                            oID2 = ((TablePoller)((Object)enumeration)).oids[0].concatenate(((TablePoller)((Object)enumeration)).index);
                            oID = (OID)tablePollingInfo.walker.rows.elementAt(0);
                            if (!this.mibvar.containsKey(oID)) {
                                this.mibvar.put(oID, oID2);
                            }
                            if (!this.ravbim.containsKey(oID2)) {
                                this.ravbim.put(oID2, oID);
                            }
                        }
                        n16 = ((TablePoller)((Object)enumeration)).oids.length;
                        int n17 = 0;
                        while (n17 < n16) {
                            OID oID3 = ((TablePoller)((Object)enumeration)).oids[n17].concatenate((long[])object5);
                            OID oID4 = SnmpMetaPDU.getPreviousOID(oID3);
                            if (!this.mibvar.containsKey(oID3)) {
                                this.mibvar.put(oID3, oID4);
                            }
                            if (!this.ravbim.containsKey(oID4)) {
                                this.ravbim.put(oID4, oID3);
                            }
                            ++n17;
                        }
                        ++n15;
                    }
                    if (n12 > 0 && n14 == Integer.MAX_VALUE) {
                        int[] nArray = new int[]{-1};
                        serializable = (OID)tablePollingInfo.walker.rows.elementAt(tablePollingInfo.walker.rows.size() - 1);
                        OID oID = ((TablePoller)((Object)enumeration)).oids[0].concatenate(((TablePoller)((Object)enumeration)).index).concatenate(nArray);
                        int n18 = tablePollingInfo.walker.tableoid.value.length + 1;
                        oID.value[n18] = ((OID)serializable).value[n18];
                        if (!this.mibvar.containsKey(oID)) {
                            this.mibvar.put(oID, serializable);
                        }
                        if (!this.ravbim.containsKey(serializable)) {
                            this.ravbim.put(serializable, oID);
                        }
                    }
                    tablePollingInfo.anyChanges = false;
                }
                ++n11;
            }
            n11 = 1 + (this.mibvar.size() - 1) / 20;
            this.getPDU = new SnmpPDU[n11];
            this.getPDUber = new DatagramPacket[n11];
            this.lastRow = new boolean[n11][20];
            n7 = 20;
            int n19 = -1;
            enumeration = this.mibvar.elements();
            while (enumeration.hasMoreElements()) {
                OID oID = (OID)enumeration.nextElement();
                if (n7 == 20) {
                    this.getPDU[++n19] = this.session.makePDU();
                    this.getPDU[n19].operation = 1;
                    this.getPDU[n19].correlator = n19;
                    n7 = 0;
                }
                this.getPDU[n19].addVarBind(oID);
                OID oID5 = (OID)this.ravbim.get(oID);
                if (oID5.value[oID5.value.length - 1] == -1L) {
                    this.lastRow[n19][n7] = true;
                }
                ++n7;
            }
            if (this.session.canReplayMessages) {
                int n20 = 0;
                while (n20 < this.getPDU.length) {
                    if (this.getPDU[n20] != null) {
                        this.getPDUber[n20] = this.session.socket.encodeThePDU(this.session, this.getPDU[n20], true);
                    }
                    ++n20;
                }
            }
        }
        long l4 = System.currentTimeMillis();
        int n21 = this.mibvar.size();
        this.anyChanges = false;
        int n22 = 0;
        int n23 = 0;
        while (n23 < this.getPDU.length) {
            if (this.getPDU[n23] != null) {
                ++n22;
            }
            ++n23;
        }
        n23 = n22;
        int n24 = 0;
        this.responses.clear();
        object6 = new Queue(true);
        SnmpPDU snmpPDU = null;
        if (this.session.canReplayMessages) {
            this.session.send(this.getPDU, this.getPDUber, (Queue)object6);
        } else {
            this.session.send(this.getPDU, (Queue)object6);
        }
        serializable = new Vector();
        n8 = this.pollers.size();
        n6 = 0;
        while (n6 < n8) {
            object5 = (AbstractPollingInfo)this.pollers.elementAt(n6);
            if (object5 instanceof TablePollingInfo) {
                ((Vector)serializable).addElement(object5);
            }
            ++n6;
        }
        Vector<OID> vector = new Vector<OID>();
        while (n22 > 0) {
            snmpPDU = (SnmpPDU)((Queue)object6).dequeue();
            if (snmpPDU.errorStatus == 0) {
                n8 = snmpPDU.varBindListSize();
                int n25 = 0;
                while (n25 < n8) {
                    OID oID;
                    Serializable serializable2;
                    int n26 = snmpPDU.correlator;
                    if (!this.lastRow[n26][n25]) {
                        serializable2 = snmpPDU.varBindAt(n25);
                        oID = ((SnmpVarBind)serializable2).get_oid();
                        this.responses.put(oID, ((SnmpVarBind)serializable2).get_value());
                    } else {
                        serializable2 = this.getPDU[n26].varBindAt(n25).get_oid();
                        oID = (OID)this.ravbim.get(serializable2);
                        OID oID6 = snmpPDU.varBindAt(n25).get_oid();
                        n5 = oID.value.length - 1;
                        if (oID6.value.length >= n5) {
                            boolean bl = true;
                            int n27 = n5 - 1;
                            while (bl && n27 >= 0) {
                                bl = oID6.value[n27] == oID.value[n27];
                                --n27;
                            }
                            if (bl) {
                                vector.addElement(oID6);
                            }
                        }
                    }
                    ++n25;
                }
                --n22;
                continue;
            }
            if (snmpPDU.errorStatus == 100 || snmpPDU.errorStatus == 102) {
                SnmpPDU snmpPDU2 = this.getPDU[snmpPDU.correlator];
                Object object7 = SingleInstanceFactory.getInstance("org.eclipse.aperi.snmp.data.Timeout");
                n8 = snmpPDU2.varBindListSize();
                int n28 = 0;
                while (n28 < n8) {
                    OID oID = snmpPDU2.varBindAt(n28).get_oid();
                    OID oID7 = (OID)this.ravbim.get(oID);
                    this.responses.put(oID7, object7);
                    ++n28;
                }
                --n22;
                if (snmpPDU.errorStatus != 102 || this.session.switchedDestination) continue;
                this.stopSampling();
                System.out.println("SnmpSession: KILLING SAMPLING");
                continue;
            }
            if (this.stopping) {
                --n22;
                continue;
            }
            this.anyChanges = true;
            SnmpPDU snmpPDU3 = this.getPDU[snmpPDU.correlator];
            OID oID = snmpPDU3.varBindAt(snmpPDU.errorIndex - 1).get_oid();
            this.responses.put(oID, SingleInstanceFactory.getInstance("org.eclipse.aperi.snmp.data.NotSupported"));
            snmpPDU3.errorStatus = snmpPDU.errorStatus;
            snmpPDU3.errorIndex = snmpPDU.errorIndex;
            snmpPDU3.fix();
            int n29 = snmpPDU.correlator;
            int n30 = 19;
            int n31 = snmpPDU.errorIndex - 1;
            while (n31 < n30) {
                this.lastRow[n29][n31] = this.lastRow[n29][n31 + 1];
                ++n31;
            }
            this.session.send(snmpPDU3, (Queue)object6);
        }
        this.session.switchedDestination = false;
        long l5 = l = System.currentTimeMillis();
        n8 = ((Vector)serializable).size();
        int n32 = 0;
        while (n32 < n8) {
            n5 = 0;
            TablePollingInfo tablePollingInfo = (TablePollingInfo)((Vector)serializable).elementAt(n32);
            TablePoller tablePoller = (TablePoller)tablePollingInfo.poller;
            n4 = tablePollingInfo.walker.rows.size();
            int n33 = 0;
            while (n33 < n4) {
                if (this.responses.get(tablePollingInfo.walker.rows.elementAt(n33)) == null) {
                    n5 = 1;
                }
                ++n33;
            }
            if (tablePoller.changed) {
                n5 = 1;
                tablePoller.changed = false;
            }
            if (n5 == 0) {
                OID oID = tablePoller.oids[0].concatenate(tablePoller.index);
                n3 = 0;
                while (n5 == 0 && n3 < vector.size()) {
                    object4 = (OID)vector.elementAt(n3);
                    if (((OID)object4).startsWith(oID)) {
                        n5 = 1;
                        vector.removeElementAt(n3);
                    }
                    ++n3;
                }
            }
            if (n4 == 0) {
                n5 = 1;
            }
            if (n5 != 0) {
                tablePollingInfo.walker.rescan = true;
            }
            ++n32;
        }
        if (this.stopping) {
            if (this.viaTimerPop && this.session.pollDrivers != null) {
                this.session.pollDrivers.remove(new Integer(this.interval));
            }
            this.pollers.removeAllElements();
            return;
        }
        Object object8 = SingleInstanceFactory.getInstance("org.eclipse.aperi.snmp.data.NotSupported");
        Vector<OID> vector2 = null;
        n8 = this.pollers.size();
        int n34 = 0;
        while (n34 < n8) {
            AbstractPollingInfo abstractPollingInfo = (AbstractPollingInfo)this.pollers.elementAt(n34);
            if (abstractPollingInfo instanceof PollingInfo) {
                PollingInfo pollingInfo = (PollingInfo)abstractPollingInfo;
                SnmpPoller snmpPoller = (SnmpPoller)pollingInfo.poller;
                n3 = snmpPoller.oids.length;
                int n35 = 0;
                while (n35 < n3) {
                    Object object9;
                    if (snmpPoller.keepOldValues) {
                        pollingInfo.oldValues[n35] = pollingInfo.newValues[n35];
                    }
                    if ((object9 = this.responses.get(snmpPoller.oids[n35])) == null) {
                        object9 = object8;
                        if (vector2 == null) {
                            vector2 = new Vector<OID>();
                        }
                        vector2.addElement(snmpPoller.oids[n35]);
                    }
                    pollingInfo.newValues[n35] = object9;
                    ++n35;
                }
            } else if (abstractPollingInfo instanceof TablePollingInfo) {
                TablePollingInfo tablePollingInfo = (TablePollingInfo)abstractPollingInfo;
                TablePoller tablePoller = (TablePoller)tablePollingInfo.poller;
                n3 = tablePoller.oids[0].value.length;
                int n36 = tablePollingInfo.walker.rows.size();
                int n37 = 0;
                while (n37 < n36) {
                    serializableArray2 = (Serializable[])tablePollingInfo.newValues.elementAt(n37);
                    object3 = (Serializable[])tablePollingInfo.oldValues.elementAt(n37);
                    serializableArray = (Serializable[])tablePollingInfo.walker.rows.elementAt(n37);
                    n2 = serializableArray.value.length - n3;
                    object2 = new long[n2];
                    int n38 = 0;
                    while (n38 < n2) {
                        object2[n38] = serializableArray.value[n3 + n38];
                        ++n38;
                    }
                    n38 = tablePoller.oids.length;
                    n = 0;
                    while (n < n38) {
                        if (tablePoller.keepOldValues) {
                            object3[n] = serializableArray2[n];
                        }
                        OID oID = tablePoller.oids[n].concatenate((long[])object2);
                        serializableArray2[n] = (Serializable)this.responses.get(oID);
                        if (serializableArray2[n] == null) {
                            serializableArray2[n] = (Serializable)object8;
                            if (vector2 == null) {
                                vector2 = new Vector();
                            }
                            vector2.addElement(oID);
                        }
                        ++n;
                    }
                    ++n37;
                }
            }
            ++n34;
        }
        long l6 = System.currentTimeMillis();
        if (vector2 != null) {
            n24 = vector2.size();
            this.responses.clear();
            n22 = vector2.size();
            n4 = 0;
            while (n4 < n22) {
                SnmpPDU snmpPDU4 = this.session.makePDU();
                snmpPDU4.operation = 0;
                snmpPDU4.addVarBind((OID)vector2.elementAt(n4));
                this.session.send(snmpPDU4, (Queue)object6);
                ++n4;
            }
            n4 = 0;
            while (n4 < n22) {
                snmpPDU = (SnmpPDU)((Queue)object6).dequeue();
                if (snmpPDU.errorStatus == 0) {
                    SnmpVarBind snmpVarBind = snmpPDU.varBindAt(0);
                    this.responses.put(snmpVarBind.get_oid(), snmpVarBind.get_value());
                }
                ++n4;
            }
            l5 = System.currentTimeMillis();
            n8 = this.pollers.size();
            n4 = 0;
            while (n4 < n8) {
                AbstractPollingInfo abstractPollingInfo = (AbstractPollingInfo)this.pollers.elementAt(n4);
                if (abstractPollingInfo instanceof PollingInfo) {
                    PollingInfo pollingInfo = (PollingInfo)abstractPollingInfo;
                    object4 = (SnmpPoller)pollingInfo.poller;
                    int n39 = ((SnmpPoller)object4).oids.length;
                    int n40 = 0;
                    while (n40 < n39) {
                        if (pollingInfo.newValues[n40] == object8 && (object3 = this.responses.get(((SnmpPoller)object4).oids[n40])) != null) {
                            pollingInfo.newValues[n40] = object3;
                        }
                        ++n40;
                    }
                } else if (abstractPollingInfo instanceof TablePollingInfo) {
                    TablePollingInfo tablePollingInfo = (TablePollingInfo)abstractPollingInfo;
                    object4 = (TablePoller)tablePollingInfo.poller;
                    int n41 = ((TablePoller)object4).oids[0].value.length;
                    int n42 = tablePollingInfo.walker.rows.size();
                    int n43 = 0;
                    while (n43 < n42) {
                        serializableArray = (Serializable[])tablePollingInfo.newValues.elementAt(n43);
                        OID oID = (OID)tablePollingInfo.walker.rows.elementAt(n43);
                        int n44 = oID.value.length - n41;
                        long[] lArray = new long[n44];
                        n = 0;
                        while (n < n44) {
                            lArray[n] = oID.value[n41 + n];
                            ++n;
                        }
                        n = ((TablePoller)object4).oids.length;
                        int n45 = 0;
                        while (n45 < n) {
                            OID oID8;
                            Object v;
                            if (serializableArray[n45] == object8 && (v = this.responses.get(oID8 = ((TablePoller)object4).oids[n45].concatenate(lArray))) != null) {
                                serializableArray[n45] = (Serializable)v;
                            }
                            ++n45;
                        }
                        ++n43;
                    }
                }
                ++n4;
            }
        }
        long l7 = System.currentTimeMillis();
        if (this.stopping) {
            if (this.viaTimerPop && this.session.pollDrivers != null) {
                this.session.pollDrivers.remove(new Integer(this.interval));
            }
            this.pollers.removeAllElements();
            if (this.viaTimerPop) {
                SnmpSession snmpSession = this.session;
                synchronized (snmpSession) {
                    if (this.session.pollDrivers != null && this.session.pollDrivers.size() == 0) {
                        this.session.pollDrivers = null;
                    }
                }
            }
            return;
        }
        Vector<AbstractPollingInfo> vector3 = new Vector<AbstractPollingInfo>();
        n8 = this.pollers.size();
        int n46 = 0;
        while (n46 < n8) {
            AbstractPollingInfo abstractPollingInfo = (AbstractPollingInfo)this.pollers.elementAt(n46);
            if (!this.removeThese.contains(abstractPollingInfo)) {
                if (abstractPollingInfo instanceof PollingInfo) {
                    serializableArray2 = (PollingInfo)abstractPollingInfo;
                    object3 = (SnmpPoller)serializableArray2.poller;
                    try {
                        if (object3.prefilter != null) {
                            object3.prefilter.preHandle(serializableArray2.cookie, serializableArray2.newValues, serializableArray2.oldValues, l5);
                        }
                        boolean bl = true;
                        if (object3.filter != null) {
                            bl = object3.filter.evaluate(serializableArray2.cookie, serializableArray2.newValues, serializableArray2.oldValues, l5);
                        }
                        if (bl && object3.action != null) {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("SnmpSession calling handle (" + serializableArray2.cookie + ")");
                            }
                            object3.action.handle(serializableArray2.cookie, serializableArray2.newValues, serializableArray2.oldValues, l5);
                        } else if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("SnmpSession filter=false not calling handle (" + serializableArray2.cookie + ")");
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Recovered from the following exception:");
                        exception.printStackTrace();
                    }
                } else {
                    if (abstractPollingInfo instanceof TablePollingInfo) {
                        serializableArray2 = (TablePollingInfo)abstractPollingInfo;
                        object3 = (TablePoller)serializableArray2.poller;
                        try {
                            if (object3.prefilter != null) {
                                object3.prefilter.preHandle(serializableArray2.cookie, serializableArray2.rowCookie, serializableArray2.newValues, serializableArray2.oldValues, l5);
                            }
                            boolean bl = true;
                            if (object3.filter != null) {
                                bl = object3.filter.evaluate(serializableArray2.cookie, serializableArray2.rowCookie, serializableArray2.newValues, serializableArray2.oldValues, l5);
                            }
                            if (bl && object3.action != null) {
                                if (SnmpV1API.isTracing()) {
                                    SnmpV1API.trace("SnmpSession calling table handle (" + serializableArray2.cookie + ")");
                                }
                                object3.action.handle(serializableArray2.cookie, serializableArray2.rowCookie, serializableArray2.newValues, serializableArray2.oldValues, l5);
                            } else if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("SnmpSession filter=false not calling table handle (" + serializableArray2.cookie + ")");
                            }
                        }
                        catch (Exception exception) {
                            System.err.println("Recovered from the following exception:");
                            exception.printStackTrace();
                        }
                        TableWalker tableWalker = serializableArray2.walker;
                        synchronized (tableWalker) {
                            serializableArray2.walker.polling = false;
                            serializableArray2.walker.notify();
                        }
                    }
                    vector3.addElement(abstractPollingInfo);
                }
            }
            ++n46;
        }
        long l8 = System.currentTimeMillis();
        serializableArray2 = new Vector();
        n8 = vector3.size();
        int n47 = 0;
        while (n47 < n8) {
            AbstractPollingInfo abstractPollingInfo = (AbstractPollingInfo)vector3.elementAt(n47);
            PseudoPoller pseudoPoller = (PseudoPoller)abstractPollingInfo.poller;
            if (pseudoPoller instanceof SwadeohPoller) {
                serializableArray2.addElement(abstractPollingInfo);
            } else {
                pseudoPoller.action.intervalCompleted(abstractPollingInfo.cookie, l5);
            }
            ++n47;
        }
        long l9 = System.currentTimeMillis();
        n8 = serializableArray2.size();
        n2 = 0;
        while (n2 < n8) {
            object2 = (AbstractPollingInfo)serializableArray2.elementAt(n2);
            SwadeohPoller swadeohPoller = (SwadeohPoller)((AbstractPollingInfo)object2).poller;
            swadeohPoller.scheduledStartTime = l2;
            swadeohPoller.actualStartTime = l3;
            swadeohPoller.pdusBuiltTime = l4;
            swadeohPoller.pdusReceivedTime = l;
            swadeohPoller.dataExtractedTime = l6;
            swadeohPoller.secondRoundTime = l7;
            swadeohPoller.pollersDoneTime = l8;
            swadeohPoller.pseudosDoneTime = l9;
            swadeohPoller.numOIDs = n21;
            swadeohPoller.numPDUs = n23;
            swadeohPoller.numDeviants = n24;
            swadeohPoller.action.intervalCompleted(((AbstractPollingInfo)object2).cookie, l9);
            ++n2;
        }
        n8 = this.tables.size();
        n2 = 0;
        while (n2 < n8) {
            object2 = (TableWalker)this.tables.elementAt(n2);
            if (((TableWalker)object2).rescan) {
                ((TableWalker)object2).rescan = false;
                ((TableWalker)object2).walkTheTable();
            }
            ++n2;
        }
        if (this.viaTimerPop) {
            n2 = (int)(this.nextWakeUpTime - System.currentTimeMillis());
            if (n2 < 0) {
                n2 = -n2;
                while (n2 > this.interval) {
                    this.nextWakeUpTime += (long)this.interval;
                    n2 -= this.interval;
                }
                n2 = 0;
            }
            this.timer = TimerService.scheduleWakeUp(n2, this);
        }
    }
}

