/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.cmd;

import com.ibm.log.cmd.Channel;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class LogCmd {
    public static final String OPTION_PORT = "-o";
    protected Channel channel = null;
    protected InputStream cmdIn;
    protected int port = 9992;
    protected OutputStream cmdErr;
    protected OutputStream cmdOut;
    protected String[] args;

    public static void main(String[] stringArray) {
        int n = 1;
        LogCmd logCmd = new LogCmd(stringArray, System.in, System.out, System.err);
        try {
            n = logCmd.execute();
        }
        catch (ConnectException connectException) {
            String string = Integer.toString(logCmd.port);
            LogUtil.errorMsg(LogUtil.getLogMsg("ERR_CMD_SERVER_CONNECT_FAIL", string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(n);
    }

    public LogCmd(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        this.args = stringArray;
        this.cmdIn = inputStream;
        this.cmdOut = outputStream;
        this.cmdErr = outputStream2;
    }

    public int execute() throws IOException, NumberFormatException {
        int n = 1;
        try {
            String string = this.processLocalOptions(this.args);
            Socket socket = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(null);
                socket = new Socket(inetAddress, this.port);
            }
            catch (UnknownHostException unknownHostException) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_LOCALHOST_CMD_SOCKET"));
                int n2 = n;
                if (this.channel != null) {
                    this.channel.close();
                }
                return n2;
            }
            this.channel = new Channel(socket);
            this.channel.open();
            this.channel.write("Cmd:");
            this.channel.write(string);
            n = this.completeCommand();
        }
        finally {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        return n;
    }

    protected String processLocalOptions(String[] stringArray) throws NumberFormatException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        while (n < stringArray.length && !bl) {
            String string2 = stringArray[n];
            if (string2.startsWith(OPTION_PORT)) {
                String string3 = string2.length() > OPTION_PORT.length() ? string2.substring(OPTION_PORT.length()) : stringArray[++n];
                this.port = Integer.parseInt(string3);
                ++n;
                continue;
            }
            if (string2.equals("-h")) {
                bl2 = true;
                string = "help";
                ++n;
                continue;
            }
            bl = true;
        }
        while (n < stringArray.length && !bl2) {
            string = String.valueOf(string) + stringArray[n++] + " ";
        }
        if (string.trim().equals("")) {
            string = "help";
        }
        return string;
    }

    protected int completeCommand() throws IOException, NumberFormatException {
        boolean bl = false;
        int n = 1;
        while (!bl) {
            byte[] byArray;
            String string = this.channel.read();
            if (string.equals("Stdout:")) {
                byArray = this.channel.read().getBytes();
                this.cmdOut.write(byArray);
                continue;
            }
            if (string.equals("Stderr:")) {
                byArray = this.channel.read().getBytes();
                this.cmdErr.write(byArray);
                continue;
            }
            if (!string.equals("RC:")) continue;
            bl = true;
            String string2 = this.channel.read();
            n = Integer.parseInt(string2);
        }
        return n;
    }
}

