/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;

class CacheMapManager {
    private FolderUtil folderUtil = new FolderUtil();
    private String tempDir;
    private static Integer cacheCounter1 = new Integer(0);
    private static Integer cacheCounter2 = new Integer(0);
    private static Map cacheMap = new HashMap();

    CacheMapManager(String tempDir) {
        this.tempDir = tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesSaveToCache(DataSourceAndDataSet dsAndDs) {
        String cacheDirStr = null;
        Map map = cacheMap;
        synchronized (map) {
            cacheDirStr = (String)cacheMap.get(dsAndDs);
        }
        if (cacheDirStr != null && new File(cacheDirStr).exists()) {
            return false;
        }
        map = cacheMap;
        synchronized (map) {
            cacheDirStr = (String)cacheMap.get(dsAndDs);
            if (cacheDirStr != null && new File(cacheDirStr).exists()) {
                return false;
            }
            cacheMap.put(dsAndDs, this.folderUtil.createSessionTempDir());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doesLoadFromCache(DataSourceAndDataSet dsAndDs) {
        String cacheDirStr = null;
        Map map = cacheMap;
        synchronized (map) {
            cacheDirStr = (String)cacheMap.get(dsAndDs);
        }
        return cacheDirStr != null && new File(cacheDirStr).exists();
    }

    String getSaveFolder(DataSourceAndDataSet dsAndDs) {
        return (String)cacheMap.get(dsAndDs);
    }

    String getLoadFolder(DataSourceAndDataSet dsAndDs) {
        return (String)cacheMap.get(dsAndDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(DataSourceAndDataSet dsAndDs) {
        Object cacheDir = null;
        Map map = cacheMap;
        synchronized (map) {
            cacheDir = cacheMap.remove(dsAndDs);
        }
        if (cacheDir != null) {
            this.folderUtil.deleteDir(cacheDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForTest() {
        CacheMapManager cacheMapManager = this;
        synchronized (cacheMapManager) {
            cacheMap = new HashMap();
            this.folderUtil = new FolderUtil();
        }
    }

    private class FolderUtil {
        private String tempRootDirStr = null;

        private FolderUtil() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createTempRootDir() {
            if (this.tempRootDirStr != null && new File(this.tempRootDirStr).exists()) {
                return;
            }
            File tempDtEDir = null;
            Integer n = cacheCounter1;
            synchronized (n) {
                tempDtEDir = new File(CacheMapManager.this.tempDir, "BirtDataCache" + System.currentTimeMillis() + cacheCounter1);
                cacheCounter1 = new Integer(cacheCounter1 + 1);
                int x = 0;
                while (tempDtEDir.exists()) {
                    tempDtEDir = new File(CacheMapManager.this.tempDir, "BirtDataCache" + System.currentTimeMillis() + cacheCounter1 + "_" + ++x);
                }
                tempDtEDir.mkdir();
                tempDtEDir.deleteOnExit();
            }
            try {
                this.tempRootDirStr = tempDtEDir.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String createSessionTempDir() {
            this.createTempRootDir();
            String prefix = "session_";
            Integer n = cacheCounter2;
            synchronized (n) {
                String sessionTempDir = this.tempRootDirStr + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2;
                cacheCounter2 = new Integer(cacheCounter2 + 1);
                File sessionDirFile = new File(sessionTempDir);
                int x = 0;
                while (sessionDirFile.exists()) {
                    sessionTempDir = this.tempRootDirStr + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2 + "_" + ++x;
                    sessionDirFile = new File(sessionTempDir);
                }
                sessionDirFile.mkdir();
                sessionDirFile.deleteOnExit();
                return sessionTempDir;
            }
        }

        private void deleteDir(String dirStr) {
            File sessionsFolder = new File(dirStr);
            if (!sessionsFolder.exists()) {
                return;
            }
            File[] sessionFiles = sessionsFolder.listFiles();
            for (int i = 0; i < sessionFiles.length; ++i) {
                sessionFiles[i].delete();
            }
            sessionsFolder.delete();
        }
    }
}

