/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.CustomField;
import org.eclipse.birt.data.engine.executor.DataSource;
import org.eclipse.birt.data.engine.executor.OdaResultSet;
import org.eclipse.birt.data.engine.executor.ParameterBinding;
import org.eclipse.birt.data.engine.executor.ParameterMetaData;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IParameterMetaData;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;

class DataSourceQuery
extends BaseQuery
implements IDataSourceQuery,
IPreparedDSQuery {
    protected DataSource dataSource;
    protected String queryText;
    protected String queryType;
    protected PreparedStatement odaStatement;
    protected Collection resultHints;
    protected Collection customFields;
    protected IResultClass resultMetadata;
    protected String[] projectedFields;
    private Collection parameterHints;
    private Collection inputParamValues;
    private ArrayList propNames;
    private ArrayList propValues;
    private DataEngineSession session;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$util$Date;

    DataSourceQuery(DataSource dataSource, String queryType, String queryText, DataEngineSession session) {
        this.dataSource = dataSource;
        this.queryText = queryText;
        this.queryType = queryType;
        this.session = session;
    }

    public void setResultHints(Collection columnDefns) {
        this.resultHints = columnDefns;
    }

    public void setResultProjection(String[] fieldNames) throws DataException {
        if (fieldNames == null || fieldNames.length == 0) {
            return;
        }
        this.projectedFields = fieldNames;
    }

    public void setParameterHints(Collection parameterHints) {
        this.parameterHints = parameterHints;
    }

    public void addProperty(String name, String value) throws DataException {
        if (name == null) {
            throw new NullPointerException("Property name is null");
        }
        if (this.odaStatement != null) {
            throw new DataException("data.engine.QueryAlreadyPrepared");
        }
        if (this.propNames == null) {
            if (!$assertionsDisabled && this.propValues != null) {
                throw new AssertionError();
            }
            this.propNames = new ArrayList();
            this.propValues = new ArrayList();
        }
        if (!$assertionsDisabled && this.propValues == null) {
            throw new AssertionError();
        }
        this.propNames.add(name);
        this.propValues.add(value);
    }

    public void declareCustomField(String fieldName, int dataType) throws DataException {
        if (fieldName == null || fieldName.length() == 0) {
            throw new DataException("data.engine.EmptyCustomFieldName");
        }
        if (this.customFields == null) {
            this.customFields = new ArrayList();
        } else {
            Iterator cfIt = this.customFields.iterator();
            while (cfIt.hasNext()) {
                CustomField cf = (CustomField)cfIt.next();
                if (!cf.name.equals(fieldName)) continue;
                throw new DataException("data.engine.DupCustomFieldName", fieldName);
            }
        }
        this.customFields.add(new CustomField(fieldName, dataType));
    }

    public IPreparedDSQuery prepare() throws DataException {
        if (this.odaStatement != null) {
            throw new DataException("data.engine.QueryAlreadyPrepared");
        }
        this.odaStatement = this.dataSource.prepareStatement(this.queryText, this.queryType);
        this.addProperties();
        this.addParameterDefns();
        this.addCustomFields(this.odaStatement);
        this.addColumnHints(this.odaStatement);
        this.odaStatement.setColumnsProjection(this.projectedFields);
        try {
            this.resultMetadata = this.odaStatement.getMetaData();
        }
        catch (DataException e) {
            this.resultMetadata = null;
        }
        return this;
    }

    private void addProperties() throws DataException {
        if (!$assertionsDisabled && this.odaStatement == null) {
            throw new AssertionError();
        }
        if (this.propNames != null) {
            if (!$assertionsDisabled && this.propValues == null) {
                throw new AssertionError();
            }
            Iterator it_name = this.propNames.iterator();
            Iterator it_val = this.propValues.iterator();
            while (it_name.hasNext()) {
                if (!$assertionsDisabled && !it_val.hasNext()) {
                    throw new AssertionError();
                }
                String name = (String)it_name.next();
                String val = (String)it_val.next();
                this.odaStatement.setProperty(name, val);
            }
        }
    }

    private void addParameterDefns() throws DataException {
        if (this.parameterHints == null) {
            return;
        }
        Iterator it = this.parameterHints.iterator();
        while (it.hasNext()) {
            ParameterHint parameterHint = (ParameterHint)it.next();
            this.odaStatement.addParameterHint(parameterHint);
            if (!parameterHint.isInputMode() || parameterHint.getDefaultInputValue() == null) continue;
            Class paramHintDataType = parameterHint.getDataType();
            if (paramHintDataType == (class$java$util$Date == null ? DataSourceQuery.class$("java.util.Date") : class$java$util$Date)) {
                paramHintDataType = parameterHint.getEffectiveDataType(this.dataSource.getDriverName(), this.queryType);
            }
            Object inputValue = DataSourceQuery.convertToValue(parameterHint.getDefaultInputValue(), paramHintDataType);
            if (this.isParameterPositionValid(parameterHint.getPosition())) {
                this.setInputParamValue(parameterHint.getPosition(), inputValue);
                continue;
            }
            this.setInputParamValue(parameterHint.getName(), inputValue);
        }
        this.setInputParameterBinding();
    }

    private boolean isParameterPositionValid(int parameterPosition) {
        return parameterPosition > 0;
    }

    private void setInputParamValue(String inputParamName, Object paramValue) throws DataException {
        ParameterBinding pb = new ParameterBinding(inputParamName, paramValue);
        this.getInputParamValues().add(pb);
    }

    private void setInputParamValue(int inputParamPos, Object paramValue) throws DataException {
        ParameterBinding pb = new ParameterBinding(inputParamPos, paramValue);
        this.getInputParamValues().add(pb);
    }

    private void addCustomFields(PreparedStatement stmt) throws DataException {
        if (this.customFields != null) {
            Iterator it = this.customFields.iterator();
            while (it.hasNext()) {
                CustomField customField = (CustomField)it.next();
                stmt.declareCustomColumn(customField.getName(), DataType.getClass((int)customField.getDataType()));
            }
        }
    }

    private void addColumnHints(PreparedStatement stmt) throws DataException {
        if (!$assertionsDisabled && stmt == null) {
            throw new AssertionError();
        }
        if (this.resultHints == null || this.resultHints.size() == 0) {
            return;
        }
        Iterator it = this.resultHints.iterator();
        while (it.hasNext()) {
            IDataSourceQuery.ResultFieldHint odiHint = (IDataSourceQuery.ResultFieldHint)it.next();
            ColumnHint colHint = new ColumnHint(odiHint.getName());
            colHint.setAlias(odiHint.getAlias());
            if (odiHint.getDataType() == 0) {
                colHint.setDataType(null);
            } else {
                colHint.setDataType(DataType.getClass((int)odiHint.getDataType()));
            }
            colHint.setNativeDataType(odiHint.getNativeDataType());
            if (odiHint.getPosition() > 0) {
                colHint.setPosition(odiHint.getPosition());
            }
            stmt.addColumnHint(colHint);
        }
    }

    public IResultClass getResultClass() {
        return this.resultMetadata;
    }

    public Collection getParameterMetaData() throws DataException {
        if (this.odaStatement == null) {
            throw new DataException("data.engine.QueryNotPrepared");
        }
        Collection odaParamsInfo = this.odaStatement.getParameterMetaData();
        if (odaParamsInfo == null || odaParamsInfo.isEmpty()) {
            return null;
        }
        ArrayList<ParameterMetaData> paramMetaDataList = new ArrayList<ParameterMetaData>(odaParamsInfo.size());
        Iterator odaParamMDIter = odaParamsInfo.iterator();
        while (odaParamMDIter.hasNext()) {
            org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData odaMetaData = (org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData)odaParamMDIter.next();
            paramMetaDataList.add(new ParameterMetaData(odaMetaData));
        }
        return paramMetaDataList;
    }

    private Collection getInputParamValues() {
        if (this.inputParamValues == null) {
            this.inputParamValues = new ArrayList();
        }
        return this.inputParamValues;
    }

    public IResultIterator execute(IEventHandler eventHandler) throws DataException {
        if (!$assertionsDisabled && this.odaStatement == null) {
            throw new AssertionError();
        }
        this.setInputParameterBinding();
        if (!this.odaStatement.execute()) {
            throw new DataException("data.engine.NoResultSet");
        }
        ResultSet rs = this.odaStatement.getResultSet();
        if (this.resultMetadata == null) {
            this.resultMetadata = rs.getMetaData();
            if (this.resultMetadata == null) {
                throw new DataException("data.engine.NoResultMetadata");
            }
        }
        if (!this.session.getDataSetCacheManager().doesSaveToCache()) {
            if (!this.hasOutputParams()) {
                return new CachedResultSet((BaseQuery)this, this.resultMetadata, rs, eventHandler, this.session);
            }
            OdaResultSet populator = new OdaResultSet(rs);
            return new CachedResultSet((BaseQuery)this, this.resultMetadata, populator, eventHandler, this.session);
        }
        return new CachedResultSet((BaseQuery)this, this.resultMetadata, new DataSetResultCache(rs, this.resultMetadata, this.session), eventHandler, this.session);
    }

    private boolean hasOutputParams() {
        boolean hasOutputParam = false;
        if (this.parameterHints != null) {
            Iterator it = this.parameterHints.iterator();
            while (it.hasNext()) {
                ParameterHint hint = (ParameterHint)it.next();
                if (!hint.isOutputMode()) continue;
                hasOutputParam = true;
                break;
            }
        }
        return hasOutputParam;
    }

    private void setInputParameterBinding() throws DataException {
        Iterator inputParamValueslist = this.getInputParamValues().iterator();
        while (inputParamValueslist.hasNext()) {
            ParameterBinding paramBind = (ParameterBinding)inputParamValueslist.next();
            if (this.isParameterPositionValid(paramBind.getPosition())) {
                this.odaStatement.setParameterValue(paramBind.getPosition(), paramBind.getValue());
                continue;
            }
            this.odaStatement.setParameterValue(paramBind.getName(), paramBind.getValue());
        }
    }

    public Object getOutputParameterValue(int index) throws DataException {
        if (!$assertionsDisabled && this.odaStatement == null) {
            throw new AssertionError();
        }
        int newIndex = this.getCorrectParamIndex(index);
        return this.odaStatement.getParameterValue(newIndex);
    }

    public Object getOutputParameterValue(String name) throws DataException {
        if (!$assertionsDisabled && this.odaStatement == null) {
            throw new AssertionError();
        }
        this.checkOutputParamNameValid(name);
        return this.odaStatement.getParameterValue(name);
    }

    private int getCorrectParamIndex(int index) throws DataException {
        if (index <= 0) {
            throw new DataException("data.engine.invalidOutputParameterIndex", new Integer(index));
        }
        int newIndex = 0;
        int curOutputIndex = 0;
        Collection collection = this.getParameterMetaData();
        if (collection != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                ++newIndex;
                IParameterMetaData metaData = (IParameterMetaData)it.next();
                if (!metaData.isOutputMode().booleanValue() || ++curOutputIndex != index) continue;
                break;
            }
        }
        if (curOutputIndex < index) {
            throw new DataException("data.engine.outputParameterOutOfBound", new Integer(index));
        }
        return newIndex;
    }

    private void checkOutputParamNameValid(String name) throws DataException {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        boolean isValid = false;
        Collection collection = this.getParameterMetaData();
        if (collection != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                IParameterMetaData metaData = (IParameterMetaData)it.next();
                String paramName = metaData.getName();
                if (!paramName.equals(name)) continue;
                isValid = metaData.isOutputMode();
                break;
            }
        }
        if (!isValid) {
            throw new DataException("data.engine.invalidOutputParameterName", name);
        }
    }

    public void close() {
        if (this.odaStatement != null) {
            this.dataSource.closeStatement(this.odaStatement);
            this.odaStatement = null;
        }
        this.dataSource = null;
    }

    private static Object convertToValue(String inputValue, Class typeClass) throws DataException {
        try {
            return DataTypeUtil.convert((Object)inputValue, (Class)typeClass);
        }
        catch (Exception ex) {
            throw new DataException("data.engine.ConvertDataTypeError", (Throwable)ex, new Object[]{inputValue, typeClass});
        }
    }

    static {
        $assertionsDisabled = !DataSourceQuery.class.desiredAssertionStatus();
    }
}

