/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskDirectExport;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskSortExport2;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

abstract class DiskDataExport {
    protected ResultObjectUtil resultObjectUtil;

    DiskDataExport() {
    }

    static DiskDataExport newInstance(Map infoMap, Comparator comparator, IResultClass rsMetaData, ResultObjectUtil resultObjectUtil) {
        DiskDataExport dbExport = comparator != null ? new DiskSortExport2(infoMap, comparator, resultObjectUtil) : new DiskDirectExport(infoMap, resultObjectUtil);
        dbExport.resultObjectUtil = resultObjectUtil;
        return dbExport;
    }

    public abstract void exportStartDataToDisk(IResultObject[] var1) throws IOException;

    public abstract int exportRestDataToDisk(IResultObject var1, IRowResultSet var2) throws DataException, IOException;

    public abstract IRowIterator getRowIterator();

    public abstract void close();

    protected int innerExportStartData(IResultObject[] resultObjects) throws IOException {
        this.outputResultObjects(resultObjects, 0);
        return resultObjects.length;
    }

    protected int innerExportRestData(IResultObject resultObject, IRowResultSet rs, int dataCountOfUnit) throws DataException, IOException {
        int columnCount = rs.getMetaData().getFieldCount();
        IResultObject[] rowDatas = new IResultObject[dataCountOfUnit];
        rowDatas[0] = resultObject;
        int currDataCount = 1;
        int dataIndex = 1;
        IResultObject odaObject = null;
        while ((odaObject = rs.next()) != null) {
            Object[] ob = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                ob[i] = odaObject.getFieldValue(i + 1);
            }
            ResultObject rowData = this.resultObjectUtil.newResultObject(ob);
            if (currDataCount % dataCountOfUnit == 0) {
                int indexOfUnit = currDataCount / dataCountOfUnit - 1;
                if (indexOfUnit >= 0) {
                    this.outputResultObjects(rowDatas, indexOfUnit + 1);
                }
                dataIndex = 0;
            }
            rowDatas[dataIndex++] = rowData;
            ++currDataCount;
        }
        IResultObject[] rowDatas2 = rowDatas;
        int indexOfUnit = currDataCount / dataCountOfUnit - 1;
        if (currDataCount % dataCountOfUnit != 0) {
            ++indexOfUnit;
            int length = currDataCount % dataCountOfUnit;
            rowDatas2 = new IResultObject[length];
            System.arraycopy(rowDatas, 0, rowDatas2, 0, length);
        }
        this.outputResultObjects(rowDatas2, indexOfUnit + 1);
        return currDataCount;
    }

    protected abstract void outputResultObjects(IResultObject[] var1, int var2) throws IOException;
}

