/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaInfo;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ExprMetaUtil {
    public static final String POS_NAME = "_$$_dte_inner_row_id_$$_";
    private static ExprMetaUtil instance = new ExprMetaUtil();
    private Set nameSet;

    public static void saveExprMetaInfo(IBaseQueryDefinition queryDefn, Set nameSet, OutputStream outputStream) throws DataException {
        ExprMetaUtil.instance.nameSet = nameSet;
        List exprMetaList = instance.prepareQueryDefn(queryDefn);
        ExprMetaInfo[] exprMetas = exprMetaList.toArray(new ExprMetaInfo[0]);
        DataOutputStream dos = new DataOutputStream(outputStream);
        try {
            int size = exprMetas.length;
            IOUtil.writeInt((OutputStream)dos, (int)size);
            for (int i = 0; i < size; ++i) {
                ExprMetaInfo exprMeta = exprMetas[i];
                IOUtil.writeString((DataOutputStream)dos, (String)exprMeta.getName());
                IOUtil.writeInt((OutputStream)dos, (int)exprMeta.getGroupLevel());
                IOUtil.writeInt((OutputStream)dos, (int)exprMeta.getDataType());
                IOUtil.writeInt((OutputStream)dos, (int)exprMeta.getType());
                IOUtil.writeString((DataOutputStream)dos, (String)exprMeta.getJSText());
            }
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", "expression metadata");
        }
    }

    private List prepareQueryDefn(IBaseQueryDefinition queryDefn) {
        ArrayList exprMetaList = new ArrayList();
        this.prepareGroup(queryDefn, exprMetaList);
        return exprMetaList;
    }

    private void prepareGroup(IBaseQueryDefinition trans, List exprMetaList) {
        Map exprMap = trans.getResultSetExpressions();
        if (exprMap == null) {
            return;
        }
        Iterator it = exprMap.keySet().iterator();
        while (it.hasNext()) {
            String exprName = (String)it.next();
            if (!this.nameSet.contains(exprName)) continue;
            IBaseExpression baseExpr = (IBaseExpression)exprMap.get(exprName);
            ExprMetaInfo exprMeta = new ExprMetaInfo();
            exprMeta.setDataType(baseExpr.getDataType());
            exprMeta.setGroupLevel(0);
            exprMeta.setName(exprName);
            if (baseExpr instanceof IScriptExpression) {
                exprMeta.setType(0);
                exprMeta.setJSText(((IScriptExpression)baseExpr).getText());
            }
            exprMetaList.add(exprMeta);
        }
    }

    public static ExprMetaInfo[] loadExprMetaInfo(InputStream inputStream) throws DataException {
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            int size = IOUtil.readInt((InputStream)dis);
            ExprMetaInfo[] exprMetas = new ExprMetaInfo[size];
            for (int i = 0; i < size; ++i) {
                exprMetas[i] = new ExprMetaInfo();
                exprMetas[i].setName(IOUtil.readString((DataInputStream)dis));
                exprMetas[i].setGroupLevel(IOUtil.readInt((InputStream)dis));
                exprMetas[i].setDataType(IOUtil.readInt((InputStream)dis));
                exprMetas[i].setType(IOUtil.readInt((InputStream)dis));
                exprMetas[i].setJSText(IOUtil.readString((DataInputStream)dis));
            }
            dis.close();
            return exprMetas;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", e);
        }
    }

    public static ExprMetaInfo[] buildExprDataMetaInfo(ExprMetaInfo[] inExprMetas) {
        ExprMetaInfo[] exprMetas = null;
        if (!ExprMetaUtil.isBasedOnRD(inExprMetas)) {
            exprMetas = new ExprMetaInfo[inExprMetas.length + 1];
            System.arraycopy(inExprMetas, 0, exprMetas, 0, inExprMetas.length);
            ExprMetaInfo[] tempExprMetaInfo = ExprMetaUtil.getAssistExprMetaInfo();
            System.arraycopy(tempExprMetaInfo, 0, exprMetas, inExprMetas.length, tempExprMetaInfo.length);
        } else {
            exprMetas = inExprMetas;
        }
        return exprMetas;
    }

    public static IResultClass buildExprDataResultClass(ExprMetaInfo[] exprMetas) {
        ArrayList<ResultFieldMetadata> newProjectedColumns = new ArrayList<ResultFieldMetadata>();
        for (int i = 0; i < exprMetas.length; ++i) {
            Class clazz;
            String name = exprMetas[i].getName();
            ResultFieldMetadata metaData = new ResultFieldMetadata(0, name, name, clazz, (clazz = DataType.getClass((int)exprMetas[i].getDataType())) == null ? null : clazz.toString(), i == exprMetas.length - 1);
            newProjectedColumns.add(metaData);
        }
        return new ResultClass(newProjectedColumns);
    }

    public static boolean isBasedOnRD(ExprMetaInfo[] exprMetas) {
        boolean isBasedOnSecondRD = false;
        for (int i = 0; i < exprMetas.length; ++i) {
            if (!exprMetas[i].getName().equals(POS_NAME)) continue;
            isBasedOnSecondRD = true;
            break;
        }
        return isBasedOnSecondRD;
    }

    public static boolean isBasedOnRD(IResultClass resultClass) {
        return ExprMetaUtil.getIdColumnPos(resultClass) >= 0;
    }

    public static int getIdColumnPos(IResultClass resultClass) {
        int columnPos = -1;
        for (int i = 0; i < resultClass.getFieldCount(); ++i) {
            try {
                if (!resultClass.getFieldName(i + 1).equals(POS_NAME)) continue;
                columnPos = i + 1;
                break;
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        return columnPos;
    }

    private static ExprMetaInfo[] getAssistExprMetaInfo() {
        ExprMetaInfo[] exprMetas = new ExprMetaInfo[]{new ExprMetaInfo()};
        exprMetas[0].setName(POS_NAME);
        exprMetas[0].setGroupLevel(0);
        exprMetas[0].setDataType(2);
        exprMetas[0].setType(0);
        exprMetas[0].setJSText("dataSetRow._rowPosition");
        return exprMetas;
    }
}

