/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public final class DataTypeUtil {
    private static String sm_className = DataTypeUtil.class.getName();
    private static String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    private DataTypeUtil() {
    }

    public static Class toTypeClass(int odaDataType) {
        String methodName = "toTypeClass";
        Class fieldClass = null;
        try {
            fieldClass = org.eclipse.birt.core.data.DataTypeUtil.toOdiTypeClass((int)odaDataType);
        }
        catch (BirtException e) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.UnrecognizedOdaType", new Object[]{new Integer(odaDataType)});
            sm_logger.logp(Level.SEVERE, sm_className, "toTypeClass", "Invalid ODA data type: {0}", new Integer(odaDataType));
            throw new IllegalArgumentException(localizedMessage);
        }
        if (odaDataType == 2004) {
            fieldClass = IBlob.class;
        } else if (odaDataType == 2005) {
            Class clazz = fieldClass = IClob.class;
        }
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, "toTypeClass", "Converted from ODA data type {0} to Java data type class {1}.", new Object[]{new Integer(odaDataType), fieldClass});
        }
        return fieldClass;
    }

    public static int toOdaType(Class javaClass) {
        String methodName = "toOdaType";
        int odaType = 1;
        odaType = javaClass == IBlob.class ? 2004 : (javaClass == IClob.class ? 2005 : org.eclipse.birt.core.data.DataTypeUtil.toOdaDataType((Class)javaClass));
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, "toOdaType", "Converted from Java data type class {0} to ODA data type {1}.", new Object[]{javaClass, new Integer(odaType)});
        }
        return odaType;
    }

    static int toOdaType(int nativeTypeCode, String odaDataSourceId, String dataSetType) {
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            return 0;
        }
        return ManifestExplorer.getInstance().getDefaultOdaDataTypeCode(nativeTypeCode, odaDataSourceId, dataSetType);
    }
}

