/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.LogFileHandler;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.api.SRMVersion;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.monitor.DiskEventQueue;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.CliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.tape.TapeCollectionService;
import org.eclipse.aperi.tape.TapeMonitor;
import org.eclipse.aperi.tape.TapeReportingService;
import org.eclipse.aperi.tape.api.ITapeManagerService;
import org.eclipse.aperi.tape.api.TapeVersion;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.sblim.wbem.cim.CIMObjectPath;

public class TapeManagerService
implements ITapeManagerService,
IService,
ICliDispatcher,
MessageListener {
    public Status cStatus = new Status(5, 6);
    protected ServiceHelper cServiceHelper;
    static TapeReportingService cRepOps;
    static TapeCollectionService cCollOps;
    static TapeMonitor cMon;
    private static Factory factory;
    private static TopicSubscriber subscriber;
    protected static String className;
    protected static ILogger msgLogger;
    protected static ILogger traceLogger;
    private DiskEventQueue cEventQueue;

    static {
        Class<?> clazz;
        cRepOps = null;
        cCollOps = null;
        cMon = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.tape.TapeManagerService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.TapeManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.TapeManager");
        msgLogger.setMessageFile("org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }

    public TapeManagerService(ServiceHelper serviceHelper) {
        cRepOps = new TapeReportingService();
        cCollOps = new TapeCollectionService(serviceHelper);
    }

    public String[] getTapeLibraries(HashMap hashMap) throws ServerException, InvalidParameterException {
        return cRepOps.getTapeLibraries(hashMap);
    }

    public String[] getTapeLibraries() throws ServerException, InvalidParameterException {
        return cRepOps.getTapeLibraries();
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, Boolean bl) {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.discoverCIMOMs(stringArray, bl);
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, boolean bl) {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.discoverCIMOMs(stringArray, bl);
    }

    public CIMOM[] getCIMOMs() {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.getCIMOMsWithoutPW();
    }

    public String[] getCIMOMIDs() {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.getCIMOMIDs();
    }

    public void modifyCIMOMs(CIMOM[] cIMOMArray) {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        cIMOMManager.modifyCIMOMs(cIMOMArray);
    }

    public String[] addCIMOMs(CIMOM[] cIMOMArray) {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.addCIMOMs(cIMOMArray);
    }

    public void deleteCIMOMs(String[] stringArray) {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        cIMOMManager.deleteCIMOMs(stringArray);
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cIMOMArray) {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.testCIMOMConnection(cIMOMArray);
    }

    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cIMOMArray, CIMObjectPath cIMObjectPath) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.testCIMOMConnection(cIMOMArray, cIMObjectPath);
    }

    public AsyncResult getJobStatus(String string) {
        return DiscoverUtils.cancelJob((String)string);
    }

    public AsyncResult waitForJobToComplete(String string) {
        return DiscoverUtils.waitForJobToComplete((String)string);
    }

    public void cancelJob(String string) {
        DiscoverUtils.cancelJob((String)string);
    }

    public SRMVersion getAPIVersion() {
        return new TapeVersion();
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getName() {
        return "TapeManagerService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("TapeManagerService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("TapeManagerService_Description");
    }

    public boolean startup() {
        String string;
        block8: {
            string = "startup";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            this.cStatus.setInstallStatus(5);
            this.cStatus.setRunStatus(9);
            this.cEventQueue = new DiskEventQueue();
            cMon = new TapeMonitor(this.cEventQueue);
            cMon.start();
            try {
                Class<?> clazz;
                factory = FactoryFactory.createFactory((int)2, null);
                try {
                    clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                subscriber = factory.createSubscriber(clazz.getName(), null, null, (MessageListener)this);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Successfully subscribed for CIMIndicationEvents");
                }
            }
            catch (Exception exception) {
                if (msgLogger.isLogging()) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)exception, "Subscription for CIMIndicationEvents failed");
                }
                if (!traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)exception, "Subscription for CIMIndicationEvents failed");
            }
        }
        this.cStatus.setRunStatus(8);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    public boolean shutdown() {
        this.cStatus.setRunStatus(11);
        if (cMon != null) {
            cMon.shutdown();
            this.cEventQueue.shutdown();
            cMon = null;
        }
        this.cStatus.setRunStatus(10);
        return true;
    }

    public String getDescription() {
        return "Performs discovery and data collection for tape resources";
    }

    public Status getStatus() {
        return this.cStatus;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("getTapeLibraries", new Integer(RoleChecker.TAPE_VIEWER));
        hashtable.put("getTapeLibraryAttributes", new Integer(RoleChecker.TAPE_VIEWER));
        hashtable.put("getComponents", new Integer(RoleChecker.TAPE_VIEWER));
        hashtable.put("getComponentAttributes", new Integer(RoleChecker.TAPE_VIEWER));
        hashtable.put("getComponentLocation", new Integer(RoleChecker.TAPE_VIEWER));
        hashtable.put("getComponentPorts", new Integer(RoleChecker.TAPE_VIEWER));
        hashtable.put("discoverTapeLibraries", new Integer(RoleChecker.TAPE_VIEWER));
        hashtable.put("probeTapeLibraries", new Integer(RoleChecker.TAPE_VIEWER));
        return hashtable;
    }

    public String dispatch(String string, String[] stringArray) {
        return CliDispatcher.dispatch((Object)this, (String)string, (String[])stringArray);
    }

    public AsyncResult discoverTapeLibraries(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return cCollOps.discoverTapeLibraries(stringArray);
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.discoverDevicesFromCIMOM(stringArray);
    }

    public AsyncResult probeTapeLibraries(String[] stringArray, Integer n) throws ServerException, InvalidParameterException, MissingParameterException {
        return cCollOps.probeTapeLibraries(stringArray, n);
    }

    public AsyncResult probeTapeLibraries(String[] stringArray, int n) throws ServerException, InvalidParameterException, MissingParameterException {
        return cCollOps.probeTapeLibraries(stringArray, n);
    }

    public HashMap[] getTapeLibraryAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException {
        return cRepOps.getTapeLibraryAttributes(stringArray, stringArray2);
    }

    public String[] getComponents(int n, String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponents(n, string, hashMap);
    }

    public HashMap[] getComponentAttributes(int n, String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponentAttributes(n, stringArray, stringArray2);
    }

    public String getCartrigeAttrByLocationID(String string, String[] stringArray) {
        return cRepOps.getCartrigeAttrByLocationID(string, stringArray);
    }

    public String[] getComponentNodes(int n, String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponentNodes(n, stringArray);
    }

    public String[] getComponentPorts(int n, String string) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponentPorts(n, string);
    }

    public String[] getComponentLocation(int n, String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return cRepOps.getComponentLocation(n, stringArray);
    }

    public String help() {
        String string = "Commands accepted by the Tape Manager CLI:\n\n";
        string = String.valueOf(string) + "  startDiscovery <URL>: Start discovery of tape library at the given CIMOM URL\n";
        string = String.valueOf(string) + "  listTapeLibraries: Lists previously discovered tape libraries\n";
        string = String.valueOf(string) + "  attrsOfTapeLibrary <number>: Lists attribute of selected tape library\n";
        string = String.valueOf(string) + "  startProbe <number>: Start basic probe of selected tape library\n";
        string = String.valueOf(string) + "  startDetailedProbe <number>: Start detailed probe of selected tape library\n";
        return string;
    }

    public String listTapeLibraries() {
        String string = "";
        String[] stringArray = this.getTapeLibraries();
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n] + "\n";
            ++n;
        }
        return string;
    }

    public String attrsOfTapeLibrary(int n) {
        String[] stringArray = this.getTapeLibraries();
        if (n < 1 || n > stringArray.length) {
            return "Error, argument must be between 1 and " + stringArray.length;
        }
        HashMap hashMap = this.getTapeLibraryAttributes(new String[]{stringArray[n - 1]}, null)[0];
        return hashMap.toString();
    }

    public String startDiscovery(String string) {
        AsyncResult asyncResult = this.discoverTapeLibraries(new String[]{string});
        return "Discovery of tape library started, job ID: " + asyncResult.getJobId();
    }

    public String startProbe(int n) {
        String[] stringArray = this.getTapeLibraries();
        if (n < 1 || n > stringArray.length) {
            return "Error, argument must be between 1 and " + stringArray.length;
        }
        AsyncResult asyncResult = this.probeTapeLibraries(new String[]{stringArray[n - 1]}, 2);
        return "Basic probe of tape library started, job ID: " + asyncResult.getJobId();
    }

    public String startDetailedProbe(int n) {
        String[] stringArray = this.getTapeLibraries();
        if (n < 1 || n > stringArray.length) {
            return "Error, argument must be between 1 and " + stringArray.length;
        }
        AsyncResult asyncResult = this.probeTapeLibraries(new String[]{stringArray[n - 1]}, 3);
        return "Detailed probe of tape library started, job ID: " + asyncResult.getJobId();
    }

    public void onMessage(Message message) {
        String string;
        block11: {
            string = "onMessage";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if (message instanceof ObjectMessage) {
                try {
                    Serializable serializable = ((ObjectMessage)message).getObject();
                    if (serializable instanceof CIMIndicationEvent) {
                        CIMIndicationEvent cIMIndicationEvent = (CIMIndicationEvent)serializable;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Received CIMIndication: " + cIMIndicationEvent.getCIMInstance());
                        }
                        if (Configuration.debug) {
                            System.out.println("TapeManagerService received indication, putting on queue");
                        }
                        this.cEventQueue.add(cIMIndicationEvent);
                    } else if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Received unexpected indication of type " + serializable.getClass().getName());
                    }
                }
                catch (JMSException jMSException) {
                    if (msgLogger.isLogging()) {
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)jMSException);
                    }
                    if (!traceLogger.isLogging()) break block11;
                    traceLogger.exception(IRecordType.TYPE_ERR, (Object)className, string, (Throwable)jMSException);
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public ReadLogResponse getLog(String string, byte by, LogFilePos logFilePos, int n) throws RemoteException {
        String string2 = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        ReadLogResponse readLogResponse = new ReadLogResponse();
        readLogResponse = LogFileHandler.getLog((String)string, (byte)by, (LogFilePos)logFilePos, (int)n);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return readLogResponse;
    }

    public ReadLogResponse getLog(String string, byte by, LogFilePos logFilePos, String string2, int n) throws RemoteException {
        String string3 = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        ReadLogResponse readLogResponse = new ReadLogResponse();
        readLogResponse = LogFileHandler.getLog((String)string, (byte)by, (LogFilePos)logFilePos, (String)string2, (int)n);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return readLogResponse;
    }

    public ReadLogResponse getLog(int n, String string, byte by, LogFilePos logFilePos, int n2) throws RemoteException {
        String string2 = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        ReadLogResponse readLogResponse = new ReadLogResponse();
        try {
            readLogResponse = LogFileHandler.getLog((int)n, (String)string, (byte)by, (LogFilePos)logFilePos, (int)n2);
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ENTRY, (Object)className, string2, (Throwable)exception);
            }
            readLogResponse = null;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return readLogResponse;
    }

    public ReadLogResponse getLog(int n, String string, byte by, LogFilePos logFilePos, String string2, int n2) throws RemoteException {
        String string3 = "getLog";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        ReadLogResponse readLogResponse = new ReadLogResponse();
        try {
            readLogResponse = LogFileHandler.getLog((int)n, (String)string, (byte)by, (LogFilePos)logFilePos, (String)string2, (int)n2);
        }
        catch (Exception exception) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ENTRY, (Object)className, string3, (Throwable)exception);
            }
            readLogResponse = null;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        return readLogResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getCIMOMtoDevices(String string) throws RemoteException, ServerException {
        ArrayList arrayList;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getCIMOMtoDevices", (Object[])new Object[]{string});
        ArrayList arrayList2 = null;
        try {
            try {
                logTraceHelper.traceDMInvokation(new Object[]{string});
                CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
                arrayList = arrayList2 = cIMOMManager.getCIMOMtoDevices(string);
                Object var5_8 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (RuntimeException runtimeException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)runtimeException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            logTraceHelper.traceDMReturn(arrayList2);
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        logTraceHelper.traceDMReturn((Object)arrayList2);
        logTraceHelper.exit((Object)arrayList2);
        return arrayList;
    }
}

