/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.discovery.parser.GenericProcessor;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class TapeCIMProcessor
extends CIMProcessor {
    public static final String MESSAGE_NAME = "aperi.logger.message.TapeManager";
    public static final String TRACE_NAME = "aperi.logger.trace.TapeManager";
    protected static String className;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    protected String cSMISVersion;
    protected String cDeviceModel;
    protected String cInstrumentationVersion;
    protected Hashtable cDBReferences = null;
    private PersistenceInfo cObjectToPersist = null;
    private String cScannerId;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.tape.collection.TapeCIMProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
    }

    public TapeCIMProcessor(String string) {
        this.cScannerId = string;
    }

    public void handleAssociation(JobInfo jobInfo, String string, String string2, Hashtable hashtable, String string3, Hashtable hashtable2, Hashtable hashtable3) {
        String string4 = "handleAssociation";
        Hashtable hashtable4 = null;
        TapeLibrary tapeLibrary = this.retrieveTapeLibrary(this.cDBReferences);
        if (tapeLibrary == null) {
            return;
        }
        short s = tapeLibrary.getNameFormat();
        String string5 = (String)hashtable2.get("originalcimclassname");
        hashtable2.putAll(this.cDBReferences);
        if (!(this.cObjectToPersist == null || string5.equalsIgnoreCase("CIM_FCPort") || string5.equalsIgnoreCase("CIM_StorageMediaLocation") || string5.equalsIgnoreCase("CIM_SCSIProtocolController") || string5.equalsIgnoreCase("CIM_SoftwareIdentity"))) {
            this.cObjectToPersist.getPropertiesToPersist().put("SCSI", "true");
            this.cObjectToPersist.persistStoredObject(this.cDBReferences);
            this.cObjectToPersist = null;
        }
        if (string5.equalsIgnoreCase("CIM_MediaAccessDevice") || string5.equalsIgnoreCase("CIM_ChangerDevice")) {
            IDBAttributeMapper iDBAttributeMapper = MapperRouter.getMapperRouter().findMapper(string3, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, null, string5);
            this.cObjectToPersist = new PersistenceInfo(iDBAttributeMapper, hashtable2, this.getScanID(jobInfo));
        } else if (string5.equalsIgnoreCase("CIM_SoftwareIdentity")) {
            if (string3.indexOf("TapeLibrarySoftwareIdentity") > 1) {
                IDBAttributeMapper iDBAttributeMapper = MapperRouter.getMapperRouter().findMapper(string3, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, null, string5);
                String string6 = DBConstants.getKeyFromValue((String)"SMISName_Format", (String)String.valueOf(s));
                hashtable2.put("nameformat", string6);
                if (iDBAttributeMapper == null) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string4, "DB Mapper does not exist for " + string3 + " or original class " + string5);
                    if (Configuration.debug) {
                        System.out.println("DB Mapper does not exist for " + string3 + " or original class " + string5 + " " + hashtable2);
                    }
                    return;
                }
                try {
                    MapperResult mapperResult = iDBAttributeMapper.persist(this.connection, hashtable2, this.getScanID(jobInfo));
                    hashtable4 = mapperResult.getKeyReferences();
                    this.cDBReferences.putAll(hashtable4);
                    this.connection.commit();
                }
                catch (SQLException sQLException) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string4, (Throwable)sQLException);
                    sQLException.printStackTrace();
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException sQLException2) {
                    }
                }
                catch (Exception exception) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string4, (Throwable)exception);
                    exception.printStackTrace();
                }
            } else {
                this.cObjectToPersist.addVersionString(hashtable2);
            }
        } else {
            MapperResult mapperResult;
            IDBAttributeMapper iDBAttributeMapper;
            if (string5.equalsIgnoreCase("CIM_FCPort")) {
                try {
                    iDBAttributeMapper = new Hashtable();
                    iDBAttributeMapper.putAll(this.cObjectToPersist.getPropertiesToPersist());
                    iDBAttributeMapper.putAll(this.cDBReferences);
                    mapperResult = this.cObjectToPersist.getRequiredMapper().persist(this.connection, (Hashtable)iDBAttributeMapper, this.cObjectToPersist.cScanID);
                    iDBAttributeMapper = null;
                    hashtable4 = mapperResult.getKeyReferences();
                    this.cDBReferences.putAll(hashtable4);
                    this.cDBReferences.remove("ref_node_id");
                    hashtable2.putAll(mapperResult.getKeyReferences());
                    this.connection.commit();
                }
                catch (Exception exception) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string4, (Throwable)exception);
                    exception.printStackTrace();
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            if (string5.equalsIgnoreCase("CIM_SCSIProtocolController")) {
                return;
            }
            iDBAttributeMapper = MapperRouter.getMapperRouter().findMapper(string3, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, null, string5);
            if (iDBAttributeMapper == null) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string4, "DB Mapper does not exist for " + string3 + " or original class " + string5);
                if (Configuration.debug) {
                    System.out.println("DB Mapper does not exist for " + string3 + " or original class " + string5 + " " + hashtable2);
                }
                return;
            }
            try {
                mapperResult = iDBAttributeMapper.persist(this.connection, hashtable2, this.getScanID(jobInfo));
                hashtable4 = mapperResult.getKeyReferences();
                if (hashtable4.get("ref_cartridge_tag") == null) {
                    this.cDBReferences.remove("ref_cartridge_tag");
                }
                this.cDBReferences.putAll(hashtable4);
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string4, (Throwable)sQLException);
                sQLException.printStackTrace();
                try {
                    this.connection.rollback();
                }
                catch (SQLException sQLException3) {}
            }
            catch (Exception exception) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string4, (Throwable)exception);
                exception.printStackTrace();
            }
        }
    }

    protected String getScanID(JobInfo jobInfo) {
        String string = super.getScanID(jobInfo);
        if (string == null) {
            string = this.cScannerId;
        }
        return string;
    }

    public Hashtable getDBReferences() {
        return this.cDBReferences;
    }

    public void setDBReferences(Hashtable hashtable) {
        this.cDBReferences = hashtable;
    }

    public void initializeForTapeLibraryType(String string, String string2, String string3) {
        this.cSMISVersion = string;
        this.cDeviceModel = string2;
        this.cInstrumentationVersion = string3;
    }

    private TapeLibrary retrieveTapeLibrary(Hashtable hashtable) {
        TapeLibrary tapeLibrary = new TapeLibrary();
        tapeLibrary.setName((String)hashtable.get("ref_toplevelsystem_name"));
        tapeLibrary.setNameFormat(Short.parseShort((String)hashtable.get("ref_toplevelsystem_nameformat")));
        try {
            tapeLibrary.retrieve(this.connection);
        }
        catch (SQLException sQLException) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "retrieveTapeLibrary", (Throwable)sQLException);
            sQLException.printStackTrace();
        }
        return tapeLibrary;
    }

    private class PersistenceInfo {
        private IDBAttributeMapper cRequiredMapper = null;
        private Hashtable cPropertiesToPersist = new Hashtable();
        private String cScanID = "";

        public PersistenceInfo(IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, String string) {
            this.cRequiredMapper = iDBAttributeMapper;
            this.cPropertiesToPersist = hashtable;
            this.cScanID = string;
        }

        public void addVersionString(Hashtable hashtable) {
            String string = (String)hashtable.get("versionstring");
            if (string != null) {
                this.cPropertiesToPersist.put("firmware_version", string);
            }
        }

        public MapperResult persistStoredObject(Hashtable hashtable) {
            String string = "persistStoredObject";
            MapperResult mapperResult = null;
            try {
                this.cPropertiesToPersist.putAll(TapeCIMProcessor.this.cDBReferences);
                mapperResult = this.cRequiredMapper.persist(((GenericProcessor)TapeCIMProcessor.this).connection, this.cPropertiesToPersist, ((TapeCIMProcessor)TapeCIMProcessor.this).cObjectToPersist.cScanID);
                ((GenericProcessor)TapeCIMProcessor.this).connection.commit();
            }
            catch (Exception exception) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                exception.printStackTrace();
                try {
                    ((GenericProcessor)TapeCIMProcessor.this).connection.rollback();
                }
                catch (SQLException sQLException) {}
            }
            return mapperResult;
        }

        public IDBAttributeMapper getRequiredMapper() {
            return this.cRequiredMapper;
        }

        public Hashtable getPropertiesToPersist() {
            return this.cPropertiesToPersist;
        }

        public String getScanID() {
            return this.cScanID;
        }
    }
}

