/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class OwnerDrawLabelProvider
extends CellLabelProvider {
    public static void setUpOwnerDraw(final ColumnViewer viewer) {
        viewer.getControl().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                CellLabelProvider provider = viewer.getViewerColumn(event.index).getLabelProvider();
                Object element = event.item.getData();
                if (provider instanceof OwnerDrawLabelProvider) {
                    ((OwnerDrawLabelProvider)provider).measure(event, element);
                }
            }
        });
        viewer.getControl().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CellLabelProvider provider = viewer.getViewerColumn(event.index).getLabelProvider();
                Object element = event.item.getData();
                if (provider instanceof OwnerDrawLabelProvider) {
                    ((OwnerDrawLabelProvider)provider).paint(event, element);
                }
            }
        });
        viewer.getControl().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                CellLabelProvider provider = this.getLabelProvider(viewer, event);
                Object element = this.getElement(event);
                if (provider instanceof OwnerDrawLabelProvider) {
                    ((OwnerDrawLabelProvider)provider).erase(event, element);
                }
            }

            private Object getElement(Event event) {
                return event.item.getData();
            }

            private CellLabelProvider getLabelProvider(ColumnViewer viewer2, Event event) {
                return viewer2.getViewerColumn(event.index).getLabelProvider();
            }
        });
    }

    protected void erase(Event event, Object element) {
        Rectangle bounds = event.getBounds();
        if ((event.detail & 2) != 0) {
            Color oldForeground = event.gc.getForeground();
            Color oldBackground = event.gc.getBackground();
            event.gc.setBackground(event.item.getDisplay().getSystemColor(26));
            event.gc.setForeground(event.item.getDisplay().getSystemColor(27));
            event.gc.fillRectangle(bounds);
            event.gc.setForeground(oldForeground);
            event.gc.setBackground(oldBackground);
            event.detail &= 0xFFFFFFFD;
        }
    }

    protected abstract void paint(Event var1, Object var2);

    protected abstract void measure(Event var1, Object var2);

    public void update(ViewerCell cell) {
        Rectangle cellBounds = cell.getBounds();
        cell.getControl().redraw(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height, true);
    }
}

