/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.eclipse.equinox.http.servlet.internal.HttpServiceFactory;
import org.eclipse.equinox.http.servlet.internal.ProxyServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class Activator
implements BundleActivator {
    private static final String DEFAULT_SERVICE_DESCRIPTION = "Equinox Servlet Bridge";
    private static final String DEFAULT_SERVICE_VENDOR = "Eclipse.org";
    private static BundleContext context;
    private static Map serviceRegistrations;

    static {
        serviceRegistrations = new HashMap();
    }

    public void start(BundleContext bundleContext) throws Exception {
        Activator.startHttpServiceProxy(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        Activator.stopHttpServiceProxy(bundleContext);
    }

    private static synchronized void startHttpServiceProxy(BundleContext bundleContext) {
        context = bundleContext;
        Object[] objectArray = serviceRegistrations.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            ServiceRegistration serviceRegistration = Activator.registerHttpService((ProxyServlet)((Object)objectArray[n]));
            serviceRegistrations.put(objectArray[n], serviceRegistration);
            ++n;
        }
    }

    private static synchronized void stopHttpServiceProxy(BundleContext bundleContext) {
        Object[] objectArray = serviceRegistrations.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            ServiceRegistration serviceRegistration = serviceRegistrations.put(objectArray[n], null);
            serviceRegistration.unregister();
            ++n;
        }
        context = null;
    }

    static synchronized void addProxyServlet(ProxyServlet proxyServlet) {
        ServiceRegistration serviceRegistration = null;
        if (context != null) {
            serviceRegistration = Activator.registerHttpService(proxyServlet);
        }
        serviceRegistrations.put(proxyServlet, serviceRegistration);
    }

    private static ServiceRegistration registerHttpService(ProxyServlet proxyServlet) {
        HttpServiceFactory httpServiceFactory = new HttpServiceFactory(proxyServlet);
        Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
        ServletConfig servletConfig = proxyServlet.getServletConfig();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Dictionary)hashtable).put(string, servletConfig.getInitParameter(string));
        }
        if (((Dictionary)hashtable).get("service.vendor") == null) {
            ((Dictionary)hashtable).put("service.vendor", DEFAULT_SERVICE_VENDOR);
        }
        if (((Dictionary)hashtable).get("service.description") == null) {
            ((Dictionary)hashtable).put("service.description", DEFAULT_SERVICE_DESCRIPTION);
        }
        return context.registerService(HttpService.class.getName(), (Object)httpServiceFactory, hashtable);
    }

    static synchronized void removeProxyServlet(ProxyServlet proxyServlet) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)serviceRegistrations.remove((Object)proxyServlet);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }
}

