/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.api.DataID;

public class InstanceID {
    protected InstanceID parentId;
    protected long designId;
    protected DataID dataId;

    public InstanceID(InstanceID parent, long designId, DataID dataId) {
        this.parentId = parent;
        this.designId = designId;
        this.dataId = dataId;
    }

    public InstanceID getParentID() {
        return this.parentId;
    }

    public long getComponentID() {
        return this.designId;
    }

    public DataID getDataID() {
        return this.dataId;
    }

    protected void append(StringBuffer buffer) {
        buffer.append("/");
        buffer.append(this.designId);
        if (this.dataId != null) {
            buffer.append("(");
            this.dataId.append(buffer);
            buffer.append(")");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer);
        return buffer.toString();
    }

    public static InstanceID parse(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        return InstanceID.parse(instanceId.toCharArray(), 0, instanceId.length());
    }

    public static InstanceID parse(char[] buffer, int offset, int length) {
        DataID dataId = null;
        int ptr = offset + length - 1;
        if (ptr >= offset && buffer[ptr] == ')') {
            --ptr;
            while (ptr >= offset && buffer[ptr] != '(') {
                --ptr;
            }
            if (ptr < offset || buffer[ptr] != '(') {
                return null;
            }
            dataId = DataID.parse(buffer, ptr + 1, offset + length - ptr - 2);
            if (dataId == null) {
                return null;
            }
            length = --ptr - offset + 1;
        }
        while (ptr >= offset && buffer[ptr] != '/') {
            --ptr;
        }
        if (ptr >= offset && buffer[ptr] == '/') {
            String strDesignId = new String(buffer, ptr + 1, offset + length - ptr - 1);
            long designId = Long.parseLong(strDesignId);
            if (--ptr >= offset) {
                length = ptr - offset + 1;
                InstanceID parent = InstanceID.parse(buffer, offset, length);
                if (parent != null) {
                    return new InstanceID(parent, designId, dataId);
                }
            } else {
                return new InstanceID(null, designId, dataId);
            }
        }
        return null;
    }
}

