/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ImageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;

class ScriptedDesignVisitor
extends DesignVisitor {
    protected static Logger logger = Logger.getLogger(ScriptedDesignVisitor.class.getName());
    protected ReportDesignHandle handle;
    protected ExecutionContext executionContext;

    ScriptedDesignVisitor(ReportDesignHandle handle, ExecutionContext executionContext) {
        this.handle = handle;
        this.executionContext = executionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnPrepare(ReportItemHandle handle) {
        block15: {
            boolean hasJavaCode;
            boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
            boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
            if (!hasJavaScript && !hasJavaCode) {
                return;
            }
            this.executionContext.pushHandle((DesignElementHandle)handle);
            try {
                if (handle instanceof DataItemHandle) {
                    DataItemScriptExecutor.handleOnPrepare((DataItemHandle)handle, this.executionContext);
                    break block15;
                }
                if (handle instanceof GridHandle) {
                    GridScriptExecutor.handleOnPrepare((GridHandle)handle, this.executionContext);
                    break block15;
                }
                if (handle instanceof ImageHandle) {
                    ImageScriptExecutor.handleOnPrepare((ImageHandle)handle, this.executionContext);
                    break block15;
                }
                if (handle instanceof LabelHandle) {
                    LabelScriptExecutor.handleOnPrepare((LabelHandle)handle, this.executionContext);
                    break block15;
                }
                if (handle instanceof ListHandle) {
                    ListScriptExecutor.handleOnPrepare((ListHandle)handle, this.executionContext);
                    break block15;
                }
                if (handle instanceof TableHandle) {
                    TableScriptExecutor.handleOnPrepare((TableHandle)handle, this.executionContext);
                    break block15;
                }
                if (handle instanceof TextItemHandle) {
                    TextItemScriptExecutor.handleOnPrepare((TextItemHandle)handle, this.executionContext);
                    break block15;
                }
                if (handle instanceof TextDataHandle) {
                    DynamicTextScriptExecutor.handleOnPrepare((TextDataHandle)handle, this.executionContext);
                    break block15;
                }
                try {
                    this.executionContext.newScope(handle);
                    this.executionContext.execute(handle.getOnPrepare());
                }
                finally {
                    this.executionContext.exitScope();
                }
            }
            finally {
                this.executionContext.popHandle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnPrepare(CellHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        try {
            CellScriptExecutor.handleOnPrepare(handle, this.executionContext);
        }
        finally {
            this.executionContext.popHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnPrepare(GroupHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        try {
            if (handle instanceof TableGroupHandle) {
                TableGroupScriptExecutor.handleOnPrepare((TableGroupHandle)handle, this.executionContext);
            }
            if (handle instanceof ListGroupHandle) {
                ListGroupScriptExecutor.handleOnPrepare((ListGroupHandle)handle, this.executionContext);
            }
        }
        finally {
            this.executionContext.popHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnPrepare(RowHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        try {
            RowScriptExecutor.handleOnPrepare(handle, this.executionContext);
        }
        finally {
            this.executionContext.popHandle();
        }
    }

    public void visitReportDesign(ReportDesignHandle handle) {
        SlotHandle pageSlot = handle.getMasterPages();
        for (int i = 0; i < pageSlot.getCount(); ++i) {
            this.apply(pageSlot.get(i));
        }
        SlotHandle componentsSlot = handle.getComponents();
        for (int i = 0; i < componentsSlot.getCount(); ++i) {
            this.apply(componentsSlot.get(i));
        }
        SlotHandle bodySlot = handle.getBody();
        for (int i = 0; i < bodySlot.getCount(); ++i) {
            this.apply(bodySlot.get(i));
        }
        SlotHandle dataSourceSlot = handle.getDataSources();
        for (int i = 0; i < dataSourceSlot.getCount(); ++i) {
            this.apply(dataSourceSlot.get(i));
        }
        SlotHandle dataSetSlot = handle.getDataSets();
        for (int i = 0; i < dataSetSlot.getCount(); ++i) {
            this.apply(dataSetSlot.get(i));
        }
        SlotHandle parameterSlot = handle.getParameters();
        for (int i = 0; i < parameterSlot.getCount(); ++i) {
            this.apply(parameterSlot.get(i));
        }
        SlotHandle scratchSlot = handle.getScratchPad();
        for (int i = 0; i < scratchSlot.getCount(); ++i) {
            this.apply(scratchSlot.get(i));
        }
        SlotHandle styleSlot = handle.getStyles();
        for (int i = 0; i < styleSlot.getCount(); ++i) {
            this.apply(styleSlot.get(i));
        }
    }

    public void visitGraphicMasterPage(GraphicMasterPageHandle handle) {
        SlotHandle contentSlot = handle.getContent();
        for (int i = 0; i < contentSlot.getCount(); ++i) {
            this.apply(contentSlot.get(i));
        }
    }

    public void visitSimpleMasterPage(SimpleMasterPageHandle handle) {
        SlotHandle headerSlot = handle.getPageHeader();
        for (int i = 0; i < headerSlot.getCount(); ++i) {
            this.apply(headerSlot.get(i));
        }
        SlotHandle footerSlot = handle.getPageFooter();
        for (int i = 0; i < footerSlot.getCount(); ++i) {
            this.apply(footerSlot.get(i));
        }
    }

    public void visitList(ListHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        for (int i = 0; i < headerSlot.getCount(); ++i) {
            this.apply(headerSlot.get(i));
        }
        SlotHandle detailSlot = handle.getDetail();
        for (int i = 0; i < detailSlot.getCount(); ++i) {
            this.apply(detailSlot.get(i));
        }
        SlotHandle footerSlot = handle.getFooter();
        for (int i = 0; i < footerSlot.getCount(); ++i) {
            this.apply(footerSlot.get(i));
        }
        SlotHandle groupsSlot = handle.getGroups();
        for (int i = 0; i < groupsSlot.getCount(); ++i) {
            this.apply(groupsSlot.get(i));
        }
    }

    public void visitFreeForm(FreeFormHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle slot = handle.getReportItems();
        for (int i = 0; i < slot.getCount(); ++i) {
            this.apply(slot.get(i));
        }
    }

    public void visitTextDataItem(TextDataHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitParameterGroup(ParameterGroupHandle handle) {
        SlotHandle parameters = handle.getParameters();
        int size = parameters.getCount();
        for (int n = 0; n < size; ++n) {
            this.apply(parameters.get(n));
        }
    }

    public void visitCascadingParameterGroup(CascadingParameterGroupHandle handle) {
        SlotHandle parameters = handle.getParameters();
        int size = parameters.getCount();
        for (int n = 0; n < size; ++n) {
            this.apply(parameters.get(n));
        }
    }

    public void visitScalarParameter(ScalarParameterHandle handle) {
    }

    public void visitLabel(LabelHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitDataItem(DataItemHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitGrid(GridHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle columnSlot = handle.getColumns();
        for (int i = 0; i < columnSlot.getCount(); ++i) {
            this.apply(columnSlot.get(i));
        }
        SlotHandle rowSlot = handle.getRows();
        for (int i = 0; i < rowSlot.getCount(); ++i) {
            this.apply(rowSlot.get(i));
        }
    }

    public void visitImage(ImageHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitTable(TableHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        for (int i = 0; i < headerSlot.getCount(); ++i) {
            this.apply(headerSlot.get(i));
        }
        SlotHandle detailSlot = handle.getDetail();
        for (int i = 0; i < detailSlot.getCount(); ++i) {
            this.apply(detailSlot.get(i));
        }
        SlotHandle footerSlot = handle.getFooter();
        for (int i = 0; i < footerSlot.getCount(); ++i) {
            this.apply(footerSlot.get(i));
        }
        SlotHandle columnSlot = handle.getColumns();
        for (int i = 0; i < columnSlot.getCount(); ++i) {
            this.apply(columnSlot.get(i));
        }
        SlotHandle groupSlot = handle.getGroups();
        for (int i = 0; i < groupSlot.getCount(); ++i) {
            this.apply(groupSlot.get(i));
        }
    }

    public void visitColumn(ColumnHandle handle) {
    }

    public void visitRow(RowHandle handle) {
        this.handleOnPrepare(handle);
        SlotHandle cellSlot = handle.getCells();
        for (int i = 0; i < cellSlot.getCount(); ++i) {
            this.apply(cellSlot.get(i));
        }
    }

    public void visitCell(CellHandle handle) {
        this.handleOnPrepare(handle);
        SlotHandle contentSlot = handle.getContent();
        for (int i = 0; i < contentSlot.getCount(); ++i) {
            this.apply(contentSlot.get(i));
        }
    }

    public void visitListGroup(ListGroupHandle handle) {
        this.handleOnPrepare((GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        for (int i = 0; i < headerSlot.getCount(); ++i) {
            this.apply(headerSlot.get(i));
        }
        SlotHandle footerSlot = handle.getFooter();
        for (int i = 0; i < footerSlot.getCount(); ++i) {
            this.apply(footerSlot.get(i));
        }
    }

    public void visitTableGroup(TableGroupHandle handle) {
        this.handleOnPrepare((GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        for (int i = 0; i < headerSlot.getCount(); ++i) {
            this.apply(headerSlot.get(i));
        }
        SlotHandle footerSlot = handle.getFooter();
        for (int i = 0; i < footerSlot.getCount(); ++i) {
            this.apply(footerSlot.get(i));
        }
    }

    public void visitTextItem(TextItemHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    protected void visitExtendedItem(ExtendedItemHandle obj) {
    }
}

