/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.CompositeStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class Column
implements IColumn {
    protected transient IReportContent report;
    protected transient CSSEngine cssEngine;
    protected DimensionType width;
    protected String styleClass;
    protected InstanceID instanceId;
    protected String visibleFormat;
    protected IStyle inlineStyle;
    protected transient IStyle style;
    protected transient IStyle computedStyle;
    protected transient Object generateBy;
    protected static final int VERSION = 0;
    static final int FIELD_NONE = -1;
    static final int FIELD_WIDTH = 0;
    static final int FIELD_STYLECLASS = 1;
    static final int FIELD_INSTANCE_ID = 2;
    static final int FIELD_VISIBLE_FORMAT = 3;
    static final int FIELD_INLINESTYLE = 8;

    public Column(IReportContent report) {
        this.report = report;
        this.cssEngine = report.getCSSEngine();
    }

    public IStyle getStyle() {
        if (this.style == null) {
            if (this.inlineStyle == null) {
                this.inlineStyle = this.report.createStyle();
            }
            String styleClass = this.getStyleClass();
            IStyle classStyle = this.report.findStyle(styleClass);
            this.style = new CompositeStyle(classStyle, this.inlineStyle);
        }
        return this.style;
    }

    public DimensionType getWidth() {
        if (this.width != null) {
            return this.width;
        }
        if (this.generateBy instanceof ColumnDesign) {
            return ((ColumnDesign)this.generateBy).getWidth();
        }
        return null;
    }

    public void setWidth(DimensionType width) {
        this.width = width;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        if (this.generateBy instanceof ColumnDesign) {
            return ((ColumnDesign)this.generateBy).getStyleName();
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public InstanceID getInstanceID() {
        return this.instanceId;
    }

    public void setInstanceID(InstanceID id) {
        this.instanceId = id;
    }

    public String getVisibleFormat() {
        return this.visibleFormat;
    }

    public void setVisibleFormat(String visibleFormat) {
        this.visibleFormat = visibleFormat;
    }

    public void setInlineStyle(IStyle style) {
        this.inlineStyle = style;
        this.style = null;
        this.computedStyle = null;
    }

    public IStyle getInlineStyle() {
        return this.inlineStyle;
    }

    public void setGenerateBy(Object generateBy) {
        this.generateBy = generateBy;
    }

    public Object getGenerateBy() {
        return this.generateBy;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        String cssText;
        if (this.width != null) {
            IOUtil.writeInt((OutputStream)out, (int)0);
            this.width.writeObject(out);
        }
        if (this.styleClass != null) {
            IOUtil.writeInt((OutputStream)out, (int)1);
            IOUtil.writeString((DataOutputStream)out, (String)this.styleClass);
        }
        if (this.instanceId != null) {
            IOUtil.writeInt((OutputStream)out, (int)2);
            IOUtil.writeString((DataOutputStream)out, (String)this.instanceId.toString());
        }
        if (this.visibleFormat != null) {
            IOUtil.writeInt((OutputStream)out, (int)3);
            IOUtil.writeString((DataOutputStream)out, (String)this.visibleFormat);
        }
        if (this.inlineStyle != null && (cssText = this.inlineStyle.getCssText()) != null && cssText.length() != 0) {
            IOUtil.writeInt((OutputStream)out, (int)8);
            IOUtil.writeString((DataOutputStream)out, (String)cssText);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 0: {
                this.width = new DimensionType();
                this.width.readObject(in);
                break;
            }
            case 1: {
                this.styleClass = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 2: {
                String value = IOUtil.readString((DataInputStream)in);
                this.instanceId = InstanceID.parse(value);
                break;
            }
            case 3: {
                this.visibleFormat = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 8: {
                String style = IOUtil.readString((DataInputStream)in);
                if (style == null || style.length() == 0) break;
                this.inlineStyle = new StyleDeclaration(this.cssEngine);
                this.inlineStyle.setCssText(style);
            }
        }
    }

    public void readObject(DataInputStream in) throws IOException {
        int version = IOUtil.readInt((InputStream)in);
        int filedId = IOUtil.readInt((InputStream)in);
        while (filedId != -1) {
            this.readField(version, filedId, in);
            filedId = IOUtil.readInt((InputStream)in);
        }
    }

    public void writeObject(DataOutputStream out) throws IOException {
        IOUtil.writeInt((OutputStream)out, (int)0);
        this.writeFields(out);
        IOUtil.writeInt((OutputStream)out, (int)-1);
    }

    public CSSEngine getCssEngine() {
        return this.cssEngine;
    }

    public boolean hasDataItemsInDetail() {
        if (this.generateBy instanceof ColumnDesign) {
            return ((ColumnDesign)this.generateBy).hasDataItemsInDetail();
        }
        return false;
    }
}

