/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.RowExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;

public class GridItemExecutor
extends QueryItemExecutor {
    int curRowDesign;
    int curRowContent;

    public GridItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        ITableContent tableContent = this.report.createTableContent();
        this.setContent(tableContent);
        this.executeQuery();
        this.initializeContent(gridDesign, tableContent);
        this.processAction(gridDesign, tableContent);
        this.processBookmark(gridDesign, tableContent);
        this.processStyle(gridDesign, tableContent);
        this.processVisibility(gridDesign, tableContent);
        for (int i = 0; i < gridDesign.getColumnCount(); ++i) {
            ColumnDesign columnDesign = gridDesign.getColumn(i);
            Column column = new Column(this.report);
            column.setGenerateBy(columnDesign);
            InstanceID iid = new InstanceID(null, columnDesign.getID(), null);
            column.setInstanceID(iid);
            this.processColumnVisibility(columnDesign, column);
            tableContent.addColumn(column);
        }
        if (this.context.isInFactory()) {
            GridScriptExecutor.handleOnCreate(tableContent, this.context);
        }
        this.startTOCEntry(tableContent);
        if (this.emitter != null) {
            this.emitter.startTable(tableContent);
        }
        this.curRowDesign = 0;
        this.curRowContent = 0;
        return tableContent;
    }

    public void close() {
        TableContent tableContent = (TableContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endTable(tableContent);
        }
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(0, this);
    }

    public boolean hasNextChild() {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        return this.curRowDesign < gridDesign.getRowCount();
    }

    public IReportItemExecutor getNextChild() {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        if (this.curRowDesign < gridDesign.getRowCount()) {
            RowDesign rowDesign = gridDesign.getRow(this.curRowDesign++);
            RowExecutor rowExecutor = (RowExecutor)this.manager.createExecutor(this, rowDesign);
            rowExecutor.setRowId(this.curRowContent++);
            return rowExecutor;
        }
        return null;
    }
}

