/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCEntry;

public abstract class ReportItemExecutor
implements IReportItemExecutor {
    protected static Logger logger;
    protected ExecutorManager manager;
    protected IReportContent report;
    protected ExecutionContext context;
    protected ReportItemExecutor parent;
    protected ReportItemDesign design;
    protected IContentEmitter emitter;
    protected IContent content;
    protected IResultSet rset;
    protected TOCEntry tocEntry;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ReportItemExecutor(ExecutorManager manager) {
        this.manager = manager;
        this.emitter = manager.emitter;
        this.context = manager.context;
        this.report = this.context.getReportContent();
    }

    public void execute(ReportItemDesign item, IContentEmitter emitter) {
        this.execute();
        while (this.hasNextChild() && !this.context.isCanceled()) {
            ReportItemExecutor child = (ReportItemExecutor)this.getNextChild();
            child.execute(child.getDesign(), emitter);
        }
        this.close();
    }

    public boolean hasNextChild() {
        return false;
    }

    public IReportItemExecutor getNextChild() {
        return null;
    }

    void reset() {
        this.tocEntry = null;
    }

    void setParent(ReportItemExecutor parent) {
        this.parent = parent;
    }

    ReportItemExecutor getParent() {
        return this.parent;
    }

    IContent getParentContent() {
        if (this.parent != null) {
            return this.parent.getContent();
        }
        return null;
    }

    void setDesign(ReportItemDesign design) {
        this.design = design;
        this.context.setItemDesign(design);
    }

    ReportItemDesign getDesign() {
        return this.design;
    }

    IContent getContent() {
        return this.content;
    }

    void setContent(IContent content) {
        this.context.setContent(content);
        this.content = content;
    }

    Object evaluate(String expr) {
        return this.context.evaluate(expr);
    }

    protected void processBookmark(ReportItemDesign item, IContent itemContent) {
        Object tmp;
        String toc;
        Object tmp2;
        String bookmark = item.getBookmark();
        if (bookmark != null && (tmp2 = this.evaluate(bookmark)) != null) {
            itemContent.setBookmark(tmp2.toString());
        }
        if ((toc = item.getTOC()) != null && (tmp = this.evaluate(toc)) != null) {
            itemContent.setTOC(tmp);
        }
    }

    protected void processAction(ReportItemDesign item, IContent itemContent) {
        if (!$assertionsDisabled && itemContent == null) {
            throw new AssertionError();
        }
        ActionDesign action = item.getAction();
        if (action != null) {
            switch (action.getActionType()) {
                case 1: {
                    if (!$assertionsDisabled && action.getHyperlink() == null) {
                        throw new AssertionError();
                    }
                    Object value = this.evaluate(action.getHyperlink());
                    if (value == null) break;
                    IHyperlinkAction obj = this.report.createActionContent();
                    obj.setHyperlink(value.toString(), action.getTargetWindow());
                    itemContent.setHyperlinkAction(obj);
                    break;
                }
                case 2: {
                    if (!$assertionsDisabled && action.getBookmark() == null) {
                        throw new AssertionError();
                    }
                    Object value = this.evaluate(action.getBookmark());
                    if (value == null) break;
                    IHyperlinkAction obj = this.report.createActionContent();
                    obj.setBookmark(value.toString());
                    obj.setBookmarkType(action.isBookmark());
                    itemContent.setHyperlinkAction(obj);
                    break;
                }
                case 3: {
                    Object value;
                    if (!$assertionsDisabled && action.getDrillThrough() == null) {
                        throw new AssertionError();
                    }
                    DrillThroughActionDesign drill = action.getDrillThrough();
                    String bookmark = null;
                    String bookmarkExpr = drill.getBookmark();
                    if (bookmarkExpr != null && (value = this.evaluate(drill.getBookmark())) != null) {
                        bookmark = value.toString();
                    }
                    boolean isBookmark = drill.isBookmark();
                    HashMap paramsVal = new HashMap();
                    Map params = drill.getParameters();
                    if (params != null) {
                        Iterator paramsDesignIte = params.entrySet().iterator();
                        while (paramsDesignIte.hasNext()) {
                            Map.Entry entry = paramsDesignIte.next();
                            Object valueObj = entry.getValue();
                            Object paramValue = null;
                            if (valueObj != null) {
                                String valueExpr = valueObj.toString();
                                paramValue = this.evaluate(valueExpr);
                            }
                            paramsVal.put(entry.getKey(), paramValue);
                        }
                    }
                    String reportName = drill.getReportName();
                    String format = drill.getFormat();
                    IHyperlinkAction obj = this.report.createActionContent();
                    obj.setDrillThrough(bookmark, isBookmark, reportName, paramsVal, null, action.getTargetWindow(), format);
                    itemContent.setHyperlinkAction(obj);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }

    protected void processVisibility(ReportItemDesign design, IContent content) {
        VisibilityDesign visibility = design.getVisibility();
        boolean isFirst = true;
        if (visibility != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < visibility.count(); ++i) {
                VisibilityRuleDesign rule = visibility.getRule(i);
                String expr = rule.getExpression();
                Object result = null;
                if (expr != null) {
                    result = this.evaluate(expr);
                }
                if (result == null || !(result instanceof Boolean)) {
                    logger.log(Level.WARNING, "The following visibility expression does not evaluate to a legal boolean value: {0}", rule.getExpression());
                    continue;
                }
                boolean isHidden = (Boolean)result;
                if (!isHidden) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(rule.getFormat());
            }
            content.getStyle().setVisibleFormat(buffer.toString());
        }
    }

    protected void processColumnVisibility(ColumnDesign design, Column column) {
        VisibilityDesign visibility = design.getVisibility();
        boolean isFirst = true;
        if (visibility != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < visibility.count(); ++i) {
                VisibilityRuleDesign rule = visibility.getRule(i);
                String expr = rule.getExpression();
                Object result = null;
                if (expr != null) {
                    result = this.evaluate(expr);
                }
                if (result == null || !(result instanceof Boolean)) {
                    logger.log(Level.WARNING, "The following visibility expression does not evaluate to a legal boolean value: {0}", rule.getExpression());
                    continue;
                }
                boolean isHidden = (Boolean)result;
                if (!isHidden) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(rule.getFormat());
            }
            column.setVisibleFormat(buffer.toString());
        }
    }

    protected DataID getDataID() {
        IResultSet curRset = this.getResultSet();
        if (curRset != null) {
            DataSetID dataSetID = curRset.getID();
            long position = curRset.getCurrentPosition();
            return new DataID(dataSetID, position);
        }
        return null;
    }

    protected void initializeContent(ReportElementDesign design, IContent content) {
        InstanceID pid = null;
        IContent parent = this.getParentContent();
        if (parent != null) {
            pid = parent.getInstanceID();
            content.setParent(parent);
        }
        InstanceID id = new InstanceID(pid, design == null ? -1L : design.getID(), this.getDataID());
        content.setInstanceID(id);
        content.setGenerateBy(design);
    }

    TOCEntry getParentTOCEntry() {
        if (this.parent != null) {
            if (this.parent.tocEntry != null) {
                return this.parent.tocEntry;
            }
            return this.parent.getParentTOCEntry();
        }
        return null;
    }

    protected void startTOCEntry(IContent content) {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null && content != null) {
            TOCEntry parentTOCEntry = this.getParentTOCEntry();
            String hiddenFormats = content.getStyle().getVisibleFormat();
            Object tocValue = content.getTOC();
            if (tocValue != null) {
                String bookmark = content.getBookmark();
                this.tocEntry = tocBuilder.startEntry(parentTOCEntry, tocValue, bookmark, hiddenFormats);
                String tocId = this.tocEntry.getNode().getNodeID();
                if (bookmark == null) {
                    content.setBookmark(tocId);
                }
                return;
            }
            if (hiddenFormats != null) {
                this.tocEntry = tocBuilder.startDummyEntry(parentTOCEntry, hiddenFormats);
            }
        }
    }

    protected void finishTOCEntry() {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null && this.tocEntry != null) {
            tocBuilder.closeEntry(this.tocEntry);
        }
    }

    protected void startGroupTOCEntry(IGroupContent group) {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null) {
            TOCEntry entry = this.getParentTOCEntry();
            String hiddenFormats = group.getStyle().getVisibleFormat();
            this.tocEntry = tocBuilder.startGroupEntry(entry, group.getTOC(), group.getBookmark(), hiddenFormats);
            String tocId = this.tocEntry.getNode().getNodeID();
            if (group.getBookmark() == null) {
                group.setBookmark(tocId);
            }
        }
    }

    protected void finishGroupTOCEntry() {
        TOCBuilder tocBuilder = this.context.getTOCBuilder();
        if (tocBuilder != null) {
            tocBuilder.closeGroupEntry(this.tocEntry);
        }
    }

    void setResultSet(IResultSet rset) {
        this.rset = rset;
    }

    IResultSet getResultSet() {
        return this.rset;
    }

    IResultSet getParentResultSet() {
        if (this.parent != null) {
            IResultSet rset = this.parent.getResultSet();
            if (rset == null) {
                rset = this.parent.getParentResultSet();
            }
            return rset;
        }
        return null;
    }

    protected void restoreResultSet() {
        this.context.setResultSet(this.getParentResultSet());
    }

    static {
        $assertionsDisabled = !ReportItemExecutor.class.desiredAssertionStatus();
        logger = Logger.getLogger(ReportItemExecutor.class.getName());
    }
}

