/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.IOConstants;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.MultiLineItemDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class EngineIRReader
implements IOConstants {
    protected Report reportDesign;

    public Report read(InputStream in) throws IOException {
        DataInputStream dis = new DataInputStream(in);
        long version = IOUtil.readLong((DataInputStream)dis);
        if (version != 0L) {
            throw new IOException("unsupported version:" + version);
        }
        String designVersion = IOUtil.readString((DataInputStream)dis);
        if (!"3.2.6".equals(designVersion)) {
            throw new IOException("un-compatable design version" + designVersion);
        }
        this.reportDesign = new Report();
        String basePath = IOUtil.readString((DataInputStream)dis);
        this.reportDesign.setBasePath(basePath);
        String unit = IOUtil.readString((DataInputStream)dis);
        this.reportDesign.setUnit(unit);
        int styleCount = IOUtil.readInt((InputStream)dis);
        for (int i = 0; i < styleCount; ++i) {
            String styleName = IOUtil.readString((DataInputStream)dis);
            IStyle style = this.readStyle(dis);
            this.reportDesign.addStyle(styleName, style);
        }
        String rootStyleName = IOUtil.readString((DataInputStream)dis);
        this.reportDesign.setRootStyleName(rootStyleName);
        Map namedExpressions = IOUtil.readMap((DataInputStream)dis);
        if (namedExpressions != null) {
            this.reportDesign.getNamedExpressions().putAll(namedExpressions);
        }
        PageSetupDesign pageSetup = this.reportDesign.getPageSetup();
        int masterPageCount = IOUtil.readInt((InputStream)dis);
        for (int i = 0; i < masterPageCount; ++i) {
            SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)this.readDesign(dis);
            pageSetup.addMasterPage(masterPage);
        }
        int count = IOUtil.readInt((InputStream)dis);
        for (int i = 0; i < count; ++i) {
            ReportItemDesign item = (ReportItemDesign)this.readDesign(dis);
            this.reportDesign.addContent(item);
        }
        return this.reportDesign;
    }

    public void link(Report report, ReportDesignHandle handle) {
        new ReportItemVisitor(handle, report).link();
    }

    protected Object readDesign(DataInputStream in) throws IOException {
        short designType = IOUtil.readShort((InputStream)in);
        byte[] buffer = IOUtil.readBytes((DataInputStream)in);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buffer));
        switch (designType) {
            case 2: {
                ReportItemDesign item;
                int i;
                SimpleMasterPageDesign masterPage = new SimpleMasterPageDesign();
                this.readSimpleMasterPage(dis, masterPage);
                int count = IOUtil.readInt((InputStream)in);
                for (i = 0; i < count; ++i) {
                    item = (ReportItemDesign)this.readDesign(in);
                    masterPage.addHeader(item);
                }
                count = IOUtil.readInt((InputStream)in);
                for (i = 0; i < count; ++i) {
                    item = (ReportItemDesign)this.readDesign(in);
                    masterPage.addFooter(item);
                }
                return masterPage;
            }
            case 3: {
                GridItemDesign grid = new GridItemDesign();
                this.readGrid(dis, grid);
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    RowDesign row = (RowDesign)this.readDesign(in);
                    grid.addRow(row);
                }
                return grid;
            }
            case 4: {
                FreeFormItemDesign freeForm = new FreeFormItemDesign();
                this.readFreeForm(dis, freeForm);
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    ReportItemDesign item = (ReportItemDesign)this.readDesign(in);
                    freeForm.addItem(item);
                }
                return freeForm;
            }
            case 6: {
                RowDesign row = new RowDesign();
                this.readRow(dis, row);
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    CellDesign cell = (CellDesign)this.readDesign(in);
                    row.addCell(cell);
                }
                return row;
            }
            case 7: {
                CellDesign cell = new CellDesign();
                this.readCell(dis, cell);
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    ReportItemDesign item = (ReportItemDesign)this.readDesign(in);
                    cell.addContent(item);
                }
                return cell;
            }
            case 8: {
                ListItemDesign list = new ListItemDesign();
                this.readList(dis, list);
                if (IOUtil.readBool((InputStream)in)) {
                    ListBandDesign header = (ListBandDesign)this.readDesign(in);
                    list.setHeader(header);
                }
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    ListGroupDesign group = (ListGroupDesign)this.readDesign(in);
                    list.addGroup(group);
                }
                if (IOUtil.readBool((InputStream)in)) {
                    ListBandDesign detail = (ListBandDesign)this.readDesign(in);
                    list.setDetail(detail);
                }
                if (IOUtil.readBool((InputStream)in)) {
                    ListBandDesign footer = (ListBandDesign)this.readDesign(in);
                    list.setFooter(footer);
                }
                return list;
            }
            case 9: {
                ListGroupDesign listGroup = new ListGroupDesign();
                this.readListGroup(dis, listGroup);
                if (IOUtil.readBool((InputStream)in)) {
                    ListBandDesign groupHeader = (ListBandDesign)this.readDesign(in);
                    listGroup.setHeader(groupHeader);
                }
                if (IOUtil.readBool((InputStream)in)) {
                    ListBandDesign footer = (ListBandDesign)this.readDesign(in);
                    listGroup.setFooter(footer);
                }
                return listGroup;
            }
            case 10: {
                ListBandDesign listBand = new ListBandDesign();
                this.readListBand(dis, listBand);
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    ReportItemDesign item = (ReportItemDesign)this.readDesign(in);
                    listBand.addContent(item);
                }
                return listBand;
            }
            case 11: {
                TableItemDesign table = new TableItemDesign();
                this.readTable(dis, table);
                if (IOUtil.readBool((InputStream)in)) {
                    TableBandDesign header = (TableBandDesign)this.readDesign(in);
                    table.setHeader(header);
                }
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    TableGroupDesign group = (TableGroupDesign)this.readDesign(in);
                    table.addGroup(group);
                }
                if (IOUtil.readBool((InputStream)in)) {
                    TableBandDesign detail = (TableBandDesign)this.readDesign(in);
                    table.setDetail(detail);
                }
                if (IOUtil.readBool((InputStream)in)) {
                    TableBandDesign footer = (TableBandDesign)this.readDesign(in);
                    table.setFooter(footer);
                }
                return table;
            }
            case 12: {
                TableGroupDesign tableGroup = new TableGroupDesign();
                this.readTableGroup(dis, tableGroup);
                if (IOUtil.readBool((InputStream)in)) {
                    TableBandDesign groupHeader = (TableBandDesign)this.readDesign(in);
                    tableGroup.setHeader(groupHeader);
                }
                if (IOUtil.readBool((InputStream)in)) {
                    TableBandDesign footer = (TableBandDesign)this.readDesign(in);
                    tableGroup.setFooter(footer);
                }
                return tableGroup;
            }
            case 13: {
                TableBandDesign band = new TableBandDesign();
                this.readTableBand(dis, band);
                int count = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < count; ++i) {
                    RowDesign row = (RowDesign)this.readDesign(in);
                    band.addContent(row);
                }
                return band;
            }
            case 14: {
                LabelItemDesign design = new LabelItemDesign();
                this.readLabel(dis, design);
                return design;
            }
            case 15: {
                TextItemDesign design = new TextItemDesign();
                this.readText(dis, design);
                return design;
            }
            case 16: {
                DataItemDesign design = new DataItemDesign();
                this.readData(dis, design);
                return design;
            }
            case 17: {
                MultiLineItemDesign design = new MultiLineItemDesign();
                this.readMultiline(dis, design);
                return design;
            }
            case 18: {
                ImageItemDesign design = new ImageItemDesign();
                this.readImage(dis, design);
                return design;
            }
            case 19: {
                TemplateDesign design = new TemplateDesign();
                this.readTemplate(dis, design);
                return design;
            }
            case 20: {
                ExtendedItemDesign design = new ExtendedItemDesign();
                this.readExtended(dis, design);
                return design;
            }
            case 21: {
                AutoTextItemDesign design = new AutoTextItemDesign();
                this.readAutoText(dis, design);
                return design;
            }
        }
        throw new IOException("unknow design type:" + designType);
    }

    protected void readReportElementField(DataInputStream in, ReportElementDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 0: {
                long id = IOUtil.readLong((DataInputStream)in);
                design.setID(id);
                break;
            }
            case 1: {
                String name = IOUtil.readString((DataInputStream)in);
                design.setName(name);
                break;
            }
            case 2: {
                String ext = IOUtil.readString((DataInputStream)in);
                design.setExtends(ext);
                break;
            }
            case 3: {
                String javaClass = IOUtil.readString((DataInputStream)in);
                design.setJavaClass(javaClass);
                break;
            }
            case 4: {
                Map namedExpression = IOUtil.readMap((DataInputStream)in);
                if (namedExpression == null) break;
                design.getNamedExpressions().putAll(namedExpression);
                break;
            }
            case 5: {
                Map customProperties = IOUtil.readMap((DataInputStream)in);
                if (customProperties == null) break;
                design.getCustomProperties().putAll(customProperties);
                break;
            }
            default: {
                throw new IOException("unknow field type " + fieldType);
            }
        }
    }

    protected void readStyledElementField(DataInputStream in, StyledElementDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 6: {
                String styleName = IOUtil.readString((DataInputStream)in);
                design.setStyleName(styleName);
                break;
            }
            case 7: {
                MapDesign map = this.readMap(in);
                design.setMap(map);
                break;
            }
            case 8: {
                HighlightDesign highlight = this.readHighlight(in);
                design.setHighlight(highlight);
                break;
            }
            default: {
                this.readReportElementField(in, design, fieldType);
            }
        }
    }

    protected void readReportItemField(DataInputStream in, ReportItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 20: {
                DimensionType x = this.readDimension(in);
                design.setX(x);
                break;
            }
            case 21: {
                DimensionType y = this.readDimension(in);
                design.setY(y);
                break;
            }
            case 22: {
                DimensionType height = this.readDimension(in);
                design.setHeight(height);
                break;
            }
            case 23: {
                DimensionType width = this.readDimension(in);
                design.setWidth(width);
                break;
            }
            case 24: {
                String bookmark = IOUtil.readString((DataInputStream)in);
                design.setBookmark(bookmark);
                break;
            }
            case 25: {
                String toc = IOUtil.readString((DataInputStream)in);
                design.setTOC(toc);
                break;
            }
            case 26: {
                String onCreate = IOUtil.readString((DataInputStream)in);
                design.setOnCreate(onCreate);
                break;
            }
            case 27: {
                String onRender = IOUtil.readString((DataInputStream)in);
                design.setOnRender(onRender);
                break;
            }
            case 28: {
                String onPageBreak = IOUtil.readString((DataInputStream)in);
                design.setOnPageBreak(onPageBreak);
                break;
            }
            case 29: {
                VisibilityDesign visibility = this.readVisibility(in);
                design.setVisibility(visibility);
                break;
            }
            case 112: {
                ActionDesign action = this.readAction(in);
                design.setAction(action);
                break;
            }
            default: {
                this.readStyledElementField(in, design, fieldType);
            }
        }
    }

    protected void readMasterPageField(DataInputStream in, MasterPageDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 200: {
                String pageType = IOUtil.readString((DataInputStream)in);
                design.setPageType(pageType);
                break;
            }
            case 201: {
                DimensionType width = this.readDimension(in);
                DimensionType height = this.readDimension(in);
                design.setPageSize(width, height);
                break;
            }
            case 202: {
                DimensionType top = this.readDimension(in);
                DimensionType left = this.readDimension(in);
                DimensionType bottom = this.readDimension(in);
                DimensionType right = this.readDimension(in);
                design.setMargin(top, left, bottom, right);
                break;
            }
            case 203: {
                String orientation = IOUtil.readString((DataInputStream)in);
                design.setOrientation(orientation);
                break;
            }
            case 204: {
                String bodyStyleName = IOUtil.readString((DataInputStream)in);
                design.setBodyStyleName(bodyStyleName);
                break;
            }
            default: {
                this.readStyledElementField(in, design, fieldType);
            }
        }
    }

    protected void readSimpleMasterPage(DataInputStream in, SimpleMasterPageDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readSimpleMasterPageField(in, design, fieldType);
        }
    }

    protected void readSimpleMasterPageField(DataInputStream in, SimpleMasterPageDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 210: {
                boolean showHeaderOnFirst = IOUtil.readBool((InputStream)in);
                design.setShowHeaderOnFirst(showHeaderOnFirst);
                break;
            }
            case 211: {
                boolean showFooterOnLast = IOUtil.readBool((InputStream)in);
                design.setShowFooterOnLast(showFooterOnLast);
                break;
            }
            case 212: {
                boolean floatingFooter = IOUtil.readBool((InputStream)in);
                design.setFloatingFooter(floatingFooter);
                break;
            }
            case 213: {
                DimensionType headerHeight = this.readDimension(in);
                design.setHeaderHeight(headerHeight);
                break;
            }
            case 214: {
                DimensionType footerHeight = this.readDimension(in);
                design.setFooterHeight(footerHeight);
                break;
            }
            default: {
                this.readMasterPageField(in, design, fieldType);
            }
        }
    }

    protected void readGraphicMasterPageField(DataInputStream in, GraphicMasterPageDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 70: {
                int columns = IOUtil.readInt((InputStream)in);
                design.setColumns(columns);
                break;
            }
            case 220: {
                DimensionType columnSpacing = this.readDimension(in);
                design.setColumnSpacing(columnSpacing);
                break;
            }
            default: {
                this.readMasterPageField(in, design, fieldType);
            }
        }
    }

    protected void readListingField(DataInputStream in, ListingDesign listing, short fieldType) throws IOException {
        switch (fieldType) {
            case 31: {
                boolean repeatHeader = IOUtil.readBool((InputStream)in);
                listing.setRepeatHeader(repeatHeader);
                break;
            }
            case 30: {
                int pageBreakInterval = IOUtil.readInt((InputStream)in);
                listing.setPageBreakInterval(pageBreakInterval);
                break;
            }
            default: {
                this.readReportItemField(in, listing, fieldType);
            }
        }
    }

    protected void readGroupField(DataInputStream in, GroupDesign group, short fieldType) throws IOException {
        switch (fieldType) {
            case 40: {
                int groupLevel = IOUtil.readInt((InputStream)in);
                group.setGroupLevel(groupLevel);
                break;
            }
            case 41: {
                String pageBreakBefore = IOUtil.readString((DataInputStream)in);
                group.setPageBreakBefore(pageBreakBefore);
                break;
            }
            case 42: {
                String pageBreakAfter = IOUtil.readString((DataInputStream)in);
                group.setPageBreakAfter(pageBreakAfter);
                break;
            }
            case 44: {
                boolean hideDetail = IOUtil.readBool((InputStream)in);
                group.setHideDetail(hideDetail);
                break;
            }
            case 43: {
                boolean headerRepeat = IOUtil.readBool((InputStream)in);
                group.setHeaderRepeat(headerRepeat);
                break;
            }
            default: {
                this.readReportItemField(in, group, fieldType);
            }
        }
    }

    protected void readBandField(DataInputStream in, BandDesign band, short fieldType) throws IOException {
        switch (fieldType) {
            case 50: {
                int bandType = IOUtil.readInt((InputStream)in);
                band.setBandType(bandType);
                break;
            }
            default: {
                this.readReportItemField(in, band, fieldType);
            }
        }
    }

    protected void readList(DataInputStream in, ListItemDesign list) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readListField(in, list, fieldType);
        }
    }

    protected void readListField(DataInputStream in, ListItemDesign list, short fieldType) throws IOException {
        this.readListingField(in, list, fieldType);
    }

    protected void readListGroup(DataInputStream in, ListGroupDesign listGroup) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readListGroupField(in, listGroup, fieldType);
        }
    }

    protected void readListGroupField(DataInputStream in, ListGroupDesign group, short fieldType) throws IOException {
        this.readGroupField(in, group, fieldType);
    }

    protected void readListBand(DataInputStream in, ListBandDesign listBand) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readListBandField(in, listBand, fieldType);
        }
    }

    protected void readListBandField(DataInputStream in, ListBandDesign listBand, short fieldType) throws IOException {
        this.readBandField(in, listBand, fieldType);
    }

    protected void readTable(DataInputStream in, TableItemDesign table) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readTableField(in, table, fieldType);
        }
    }

    protected void readTableField(DataInputStream in, TableItemDesign table, short fieldType) throws IOException {
        switch (fieldType) {
            case 60: {
                String captionKey = IOUtil.readString((DataInputStream)in);
                String caption = IOUtil.readString((DataInputStream)in);
                table.setCaption(captionKey, caption);
                break;
            }
            case 70: {
                int columnCount = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < columnCount; ++i) {
                    byte[] bytes = IOUtil.readBytes((DataInputStream)in);
                    DataInputStream buffer = new DataInputStream(new ByteArrayInputStream(bytes));
                    ColumnDesign column = new ColumnDesign();
                    this.readColumn(buffer, column);
                    table.addColumn(column);
                }
                break;
            }
            default: {
                this.readListingField(in, table, fieldType);
            }
        }
    }

    protected void readTableGroup(DataInputStream in, TableGroupDesign tableGroup) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readTableGroupField(in, tableGroup, fieldType);
        }
    }

    protected void readTableGroupField(DataInputStream in, TableGroupDesign group, short fieldType) throws IOException {
        this.readGroupField(in, group, fieldType);
    }

    protected void readTableBand(DataInputStream in, TableBandDesign tableBand) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readTableBandField(in, tableBand, fieldType);
        }
    }

    protected void readTableBandField(DataInputStream in, TableBandDesign tableBand, short fieldType) throws IOException {
        this.readBandField(in, tableBand, fieldType);
    }

    protected void readGrid(DataInputStream in, GridItemDesign grid) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readGridField(in, grid, fieldType);
        }
    }

    protected void readGridField(DataInputStream in, GridItemDesign grid, short fieldType) throws IOException {
        switch (fieldType) {
            case 70: {
                int columnCount = IOUtil.readInt((InputStream)in);
                for (int i = 0; i < columnCount; ++i) {
                    byte[] bytes = IOUtil.readBytes((DataInputStream)in);
                    ColumnDesign column = new ColumnDesign();
                    this.readColumn(new DataInputStream(new ByteArrayInputStream(bytes)), column);
                    grid.addColumn(column);
                }
                break;
            }
            default: {
                this.readReportItemField(in, grid, fieldType);
            }
        }
    }

    protected void readColumn(DataInputStream in, ColumnDesign column) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readColumnField(in, column, fieldType);
        }
    }

    protected void readColumnField(DataInputStream in, ColumnDesign column, short fieldType) throws IOException {
        switch (fieldType) {
            case 23: {
                DimensionType width = this.readDimension(in);
                column.setWidth(width);
                break;
            }
            case 80: {
                boolean suppressDuplicate = IOUtil.readBool((InputStream)in);
                column.setSuppressDuplicate(suppressDuplicate);
                break;
            }
            case 29: {
                VisibilityDesign visibility = this.readVisibility(in);
                column.setVisibility(visibility);
                break;
            }
            case 81: {
                boolean hasDataItemsInDetail = IOUtil.readBool((InputStream)in);
                column.setHasDataItemsInDetail(hasDataItemsInDetail);
                break;
            }
            default: {
                this.readStyledElementField(in, column, fieldType);
            }
        }
    }

    protected void readRow(DataInputStream in, RowDesign row) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readRowField(in, row, fieldType);
        }
    }

    protected void readRowField(DataInputStream in, RowDesign row, short fieldType) throws IOException {
        switch (fieldType) {
            case 90: {
                boolean isStartOfGroup = IOUtil.readBool((InputStream)in);
                row.setStartOfGroup(isStartOfGroup);
                break;
            }
            default: {
                this.readReportItemField(in, row, fieldType);
            }
        }
    }

    protected void readCell(DataInputStream in, CellDesign cell) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readCellField(in, cell, fieldType);
        }
    }

    protected void readCellField(DataInputStream in, CellDesign cell, short fieldType) throws IOException {
        switch (fieldType) {
            case 100: {
                int column = IOUtil.readInt((InputStream)in);
                cell.setColumn(column);
                break;
            }
            case 101: {
                int colSpan = IOUtil.readInt((InputStream)in);
                cell.setColSpan(colSpan);
                break;
            }
            case 102: {
                int rowSpan = IOUtil.readInt((InputStream)in);
                cell.setRowSpan(rowSpan);
                break;
            }
            case 103: {
                String drop = IOUtil.readString((DataInputStream)in);
                cell.setDrop(drop);
                break;
            }
            case 104: {
                boolean displayGroupIcon = IOUtil.readBool((InputStream)in);
                cell.setDisplayGroupIcon(displayGroupIcon);
                break;
            }
            default: {
                this.readReportItemField(in, cell, fieldType);
            }
        }
    }

    protected void readFreeForm(DataInputStream in, FreeFormItemDesign freeForm) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readFreeFormField(in, freeForm, fieldType);
        }
    }

    protected void readFreeFormField(DataInputStream in, FreeFormItemDesign freeForm, short fieldType) throws IOException {
        this.readReportItemField(in, freeForm, fieldType);
    }

    protected void readLabel(DataInputStream in, LabelItemDesign label) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readLabelField(in, label, fieldType);
        }
    }

    protected void readLabelField(DataInputStream in, LabelItemDesign label, short fieldType) throws IOException {
        switch (fieldType) {
            case 110: {
                String textKey = IOUtil.readString((DataInputStream)in);
                String text = IOUtil.readString((DataInputStream)in);
                label.setText(textKey, text);
                break;
            }
            case 111: {
                String helpTextKey = IOUtil.readString((DataInputStream)in);
                String helpText = IOUtil.readString((DataInputStream)in);
                label.setHelpText(helpTextKey, helpText);
                break;
            }
            default: {
                this.readReportItemField(in, label, fieldType);
            }
        }
    }

    protected void readData(DataInputStream in, DataItemDesign data) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readDataField(in, data, fieldType);
        }
    }

    protected void readDataField(DataInputStream in, DataItemDesign data, short fieldType) throws IOException {
        switch (fieldType) {
            case 120: {
                String value = IOUtil.readString((DataInputStream)in);
                try {
                    String columnName = ExpressionUtil.getColumnBindingName((String)value);
                    if (columnName == null) break;
                    data.setBindingColumn(columnName);
                }
                catch (BirtException ex) {}
                break;
            }
            case 121: {
                String bindingColumn = IOUtil.readString((DataInputStream)in);
                data.setBindingColumn(bindingColumn);
                break;
            }
            case 80: {
                boolean suppressDuplicate = IOUtil.readBool((InputStream)in);
                data.setSuppressDuplicate(suppressDuplicate);
                break;
            }
            case 111: {
                String helpTextKey = IOUtil.readString((DataInputStream)in);
                String helpText = IOUtil.readString((DataInputStream)in);
                data.setHelpText(helpTextKey, helpText);
                break;
            }
            default: {
                this.readReportItemField(in, data, fieldType);
            }
        }
    }

    protected void readText(DataInputStream in, TextItemDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readTextField(in, design, fieldType);
        }
    }

    protected void readTextField(DataInputStream in, TextItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 130: {
                String textType = IOUtil.readString((DataInputStream)in);
                design.setTextType(textType);
                break;
            }
            case 110: {
                String textKey = IOUtil.readString((DataInputStream)in);
                String text = IOUtil.readString((DataInputStream)in);
                design.setText(textKey, text);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected void readMultiline(DataInputStream in, MultiLineItemDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readMultilineField(in, design, fieldType);
        }
    }

    protected void readMultilineField(DataInputStream in, MultiLineItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 140: {
                String contentType = IOUtil.readString((DataInputStream)in);
                design.setContentType(contentType);
                break;
            }
            case 141: {
                String content = IOUtil.readString((DataInputStream)in);
                design.setContent(content);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected void readImage(DataInputStream in, ImageItemDesign image) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readImageField(in, image, fieldType);
        }
    }

    protected void readImageField(DataInputStream in, ImageItemDesign image, short fieldType) throws IOException {
        block0 : switch (fieldType) {
            case 150: {
                int imageSource = IOUtil.readInt((InputStream)in);
                switch (imageSource) {
                    case 1: {
                        String imageName = IOUtil.readString((DataInputStream)in);
                        image.setImageName(imageName);
                        break block0;
                    }
                    case 3: {
                        String imageFile = IOUtil.readString((DataInputStream)in);
                        image.setImageFile(imageFile);
                        break block0;
                    }
                    case 0: {
                        String imageUri = IOUtil.readString((DataInputStream)in);
                        image.setImageUri(imageUri);
                        break block0;
                    }
                    case 2: {
                        String imageExpr = IOUtil.readString((DataInputStream)in);
                        String imageFormat = IOUtil.readString((DataInputStream)in);
                        image.setImageExpression(imageExpr, imageFormat);
                        break block0;
                    }
                }
                throw new IOException("invalid image source: " + imageSource);
            }
            case 151: {
                String altTextKey = IOUtil.readString((DataInputStream)in);
                String altText = IOUtil.readString((DataInputStream)in);
                image.setAltText(altTextKey, altText);
                break;
            }
            case 111: {
                String helpTextKey = IOUtil.readString((DataInputStream)in);
                String helpText = IOUtil.readString((DataInputStream)in);
                image.setHelpText(helpTextKey, helpText);
                break;
            }
            default: {
                this.readReportItemField(in, image, fieldType);
            }
        }
    }

    protected void readExtended(DataInputStream in, ExtendedItemDesign extended) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readExtendedField(in, extended, fieldType);
        }
    }

    protected void readExtendedField(DataInputStream in, ExtendedItemDesign extended, short fieldType) throws IOException {
        switch (fieldType) {
            case 151: {
                String altTextKey = IOUtil.readString((DataInputStream)in);
                String altText = IOUtil.readString((DataInputStream)in);
                extended.setAltText(altTextKey, altText);
                break;
            }
            default: {
                this.readReportItemField(in, extended, fieldType);
            }
        }
    }

    protected void readAutoText(DataInputStream in, AutoTextItemDesign autoText) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readAutoTextField(in, autoText, fieldType);
        }
    }

    protected void readAutoTextField(DataInputStream in, AutoTextItemDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 160: {
                String type = IOUtil.readString((DataInputStream)in);
                design.setType(type);
                break;
            }
            case 110: {
                String textKey = IOUtil.readString((DataInputStream)in);
                String text = IOUtil.readString((DataInputStream)in);
                design.setText(textKey, text);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected void readTemplate(DataInputStream in, TemplateDesign design) throws IOException {
        while (in.available() > 0) {
            short fieldType = IOUtil.readShort((InputStream)in);
            this.readTemplateField(in, design, fieldType);
        }
    }

    protected void readTemplateField(DataInputStream in, TemplateDesign design, short fieldType) throws IOException {
        switch (fieldType) {
            case 170: {
                String allowedType = IOUtil.readString((DataInputStream)in);
                design.setAllowedType(allowedType);
                break;
            }
            case 171: {
                String promptTextKey = IOUtil.readString((DataInputStream)in);
                String promptText = IOUtil.readString((DataInputStream)in);
                design.setPromptText(promptText);
                design.setPromptTextKey(promptTextKey);
                break;
            }
            default: {
                this.readReportItemField(in, design, fieldType);
            }
        }
    }

    protected DimensionType readDimension(DataInputStream in) throws IOException {
        boolean notNull = IOUtil.readBool((InputStream)in);
        if (notNull) {
            DimensionType dimension = new DimensionType();
            dimension.readObject(in);
            return dimension;
        }
        return null;
    }

    protected VisibilityDesign readVisibility(DataInputStream in) throws IOException {
        VisibilityDesign visibility = new VisibilityDesign();
        int ruleCount = IOUtil.readInt((InputStream)in);
        for (int i = 0; i < ruleCount; ++i) {
            VisibilityRuleDesign rule = new VisibilityRuleDesign();
            String format = IOUtil.readString((DataInputStream)in);
            String expr = IOUtil.readString((DataInputStream)in);
            rule.setFormat(format);
            rule.setExpression(expr);
            visibility.addRule(rule);
        }
        return visibility;
    }

    protected MapDesign readMap(DataInputStream in) throws IOException {
        MapDesign map = new MapDesign();
        int ruleCount = IOUtil.readInt((InputStream)in);
        for (int i = 0; i < ruleCount; ++i) {
            MapRuleDesign rule = new MapRuleDesign();
            String testExpr = IOUtil.readString((DataInputStream)in);
            String oper = IOUtil.readString((DataInputStream)in);
            String value1 = IOUtil.readString((DataInputStream)in);
            String value2 = IOUtil.readString((DataInputStream)in);
            String displayText = IOUtil.readString((DataInputStream)in);
            String displayKey = IOUtil.readString((DataInputStream)in);
            rule.setTestExpression(testExpr);
            rule.setExpression(oper, value1, value2);
            rule.setDisplayText(displayKey, displayText);
            map.addRule(rule);
        }
        return map;
    }

    protected HighlightDesign readHighlight(DataInputStream in) throws IOException {
        HighlightDesign highlight = new HighlightDesign();
        int ruleCount = IOUtil.readInt((InputStream)in);
        for (int i = 0; i < ruleCount; ++i) {
            HighlightRuleDesign rule = new HighlightRuleDesign();
            String testExpr = IOUtil.readString((DataInputStream)in);
            String oper = IOUtil.readString((DataInputStream)in);
            String value1 = IOUtil.readString((DataInputStream)in);
            String value2 = IOUtil.readString((DataInputStream)in);
            IStyle style = this.readStyle(in);
            rule.setTestExpression(testExpr);
            rule.setExpression(oper, value1, value2);
            rule.setStyle(style);
            highlight.addRule(rule);
        }
        return highlight;
    }

    protected IStyle readStyle(DataInputStream in) throws IOException {
        String cssText = IOUtil.readString((DataInputStream)in);
        IStyle style = (IStyle)this.reportDesign.getCSSEngine().parseStyleDeclaration(cssText);
        return style;
    }

    protected ActionDesign readAction(DataInputStream in) throws IOException {
        ActionDesign action = new ActionDesign();
        int actionType = IOUtil.readInt((InputStream)in);
        switch (actionType) {
            case 2: {
                String bookmark = IOUtil.readString((DataInputStream)in);
                action.setBookmark(bookmark);
                break;
            }
            case 3: {
                DrillThroughActionDesign drillThrough = this.readDrillThrough(in);
                action.setDrillThrough(drillThrough);
                break;
            }
            case 1: {
                String hyperlink = IOUtil.readString((DataInputStream)in);
                action.setHyperlink(hyperlink);
                break;
            }
            default: {
                throw new IOException("invalid action type:" + actionType);
            }
        }
        boolean isBookmark = IOUtil.readBool((InputStream)in);
        String targetWindow = IOUtil.readString((DataInputStream)in);
        action.setBookmarkType(isBookmark);
        action.setTargetWindow(targetWindow);
        return action;
    }

    protected DrillThroughActionDesign readDrillThrough(DataInputStream in) throws IOException {
        DrillThroughActionDesign drillThrough = new DrillThroughActionDesign();
        String reportName = IOUtil.readString((DataInputStream)in);
        Map parameters = IOUtil.readMap((DataInputStream)in);
        Map search = IOUtil.readMap((DataInputStream)in);
        String format = IOUtil.readString((DataInputStream)in);
        boolean isBookmark = IOUtil.readBool((InputStream)in);
        String bookmark = IOUtil.readString((DataInputStream)in);
        drillThrough.setReportName(reportName);
        drillThrough.setParameters(parameters);
        drillThrough.setSearch(search);
        drillThrough.setFormat(format);
        drillThrough.setBookmarkType(isBookmark);
        drillThrough.setBookmark(bookmark);
        return drillThrough;
    }

    protected class ReportItemVisitor
    extends DefaultReportItemVisitorImpl {
        ReportDesignHandle handle;
        Report report;

        ReportItemVisitor(ReportDesignHandle handle, Report report) {
            this.handle = handle;
            this.report = report;
        }

        public void link() {
            this.report.setReportDesign(this.handle);
            PageSetupDesign pageSetup = this.report.getPageSetup();
            int masterPageCount = pageSetup.getMasterPageCount();
            for (int i = 0; i < masterPageCount; ++i) {
                ReportItemDesign item;
                int j;
                SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)pageSetup.getMasterPage(i);
                this.linkReportElement(masterPage);
                int count = masterPage.getHeaderCount();
                for (j = 0; j < count; ++j) {
                    item = masterPage.getHeader(j);
                    item.accept(this, null);
                }
                count = masterPage.getFooterCount();
                for (j = 0; j < count; ++j) {
                    item = masterPage.getFooter(j);
                    item.accept(this, null);
                }
            }
            int count = this.report.getContentCount();
            for (int i = 0; i < count; ++i) {
                ReportItemDesign item = this.report.getContent(i);
                item.accept(this, null);
            }
        }

        protected void linkReportElement(ReportElementDesign element) {
            long id = element.getID();
            DesignElementHandle elementHandle = this.handle.getElementByID(id);
            element.setHandle(elementHandle);
            this.report.setReportItemInstanceID(id, element);
        }

        public Object visitBand(BandDesign band, Object value) {
            this.linkReportElement(band);
            int count = band.getContentCount();
            for (int i = 0; i < count; ++i) {
                ReportItemDesign item = band.getContent(i);
                item.accept(this, value);
            }
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            this.linkReportElement(cell);
            int count = cell.getContentCount();
            for (int i = 0; i < count; ++i) {
                ReportItemDesign item = cell.getContent(i);
                item.accept(this, value);
            }
            return value;
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            this.linkReportElement(container);
            int count = container.getItemCount();
            for (int i = 0; i < count; ++i) {
                ReportItemDesign item = container.getItem(i);
                item.accept(this, value);
            }
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            int i;
            this.linkReportElement(grid);
            int count = grid.getColumnCount();
            for (i = 0; i < count; ++i) {
                ColumnDesign column = grid.getColumn(i);
                this.linkReportElement(column);
            }
            count = grid.getRowCount();
            for (i = 0; i < count; ++i) {
                RowDesign item = grid.getRow(i);
                ((ReportItemDesign)item).accept(this, value);
            }
            return value;
        }

        public Object visitGroup(GroupDesign group, Object value) {
            BandDesign footer;
            this.linkReportElement(group);
            BandDesign header = group.getHeader();
            if (header != null) {
                header.accept(this, value);
            }
            if ((footer = group.getFooter()) != null) {
                footer.accept(this, value);
            }
            return value;
        }

        public Object visitListing(ListingDesign listing, Object value) {
            BandDesign footer;
            this.linkReportElement(listing);
            BandDesign header = listing.getHeader();
            if (header != null) {
                header.accept(this, value);
            }
            int count = listing.getGroupCount();
            for (int i = 0; i < count; ++i) {
                GroupDesign group = listing.getGroup(i);
                group.accept(this, value);
            }
            BandDesign detail = listing.getDetail();
            if (detail != null) {
                detail.accept(this, null);
            }
            if ((footer = listing.getFooter()) != null) {
                footer.accept(this, value);
            }
            return value;
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            this.visitListing(table, value);
            int count = table.getColumnCount();
            for (int i = 0; i < count; ++i) {
                ColumnDesign column = table.getColumn(i);
                this.linkReportElement(column);
            }
            return value;
        }

        public Object visitReportItem(ReportItemDesign item, Object value) {
            this.linkReportElement(item);
            return value;
        }

        public Object visitRow(RowDesign row, Object value) {
            this.linkReportElement(row);
            int count = row.getCellCount();
            for (int i = 0; i < count; ++i) {
                CellDesign cell = row.getCell(i);
                cell.accept(this, value);
            }
            return value;
        }
    }
}

