/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.css.CSSValueList;

public class FontMappingManager {
    private static final String SERIF = "serif";
    private static final String SANS_SERIF = "sans-serif";
    private static final String CURSIVE = "cursive";
    private static final String MONOSPACE = "monospace";
    private static final String FANTASY = "fantasy";
    private static final String DEFAULT_SERIF_FONT = "Times-Roman";
    private static final String DEFAULT_SANS_SERIF_FONT = "Helvetica";
    private static final String DEFAULT_CURSIVE_FONT = "ZapfDingbats";
    private static final String DEFAULT_MONOSPACE_FONT = "Courier";
    private static final String DEFAULT_FANTASY_FONT = "Times-Roman";
    private static final int UNICODE_BLOCK_NUMBER = 154;
    private static final String DEFAULT_FONT = "Times-Roman";
    private HashMap fontMapping = null;
    private HashMap fontEncoding = null;
    private LinkedList[] fontNodes = new LinkedList[154];
    private HashMap baseFonts = new HashMap();
    private static final int[] blockEdges = new int[]{0, 127, 128, 255, 256, 383, 384, 591, 592, 687, 688, 767, 768, 879, 880, 1023, 1024, 1279, 1280, 1327, 1328, 1423, 1424, 1535, 1536, 1791, 1792, 1871, 1872, 1919, 1920, 1983, 1984, 2047, 2304, 2431, 2432, 2559, 2560, 2687, 2688, 2815, 2816, 2943, 2944, 3071, 3072, 3199, 3200, 3327, 3328, 3455, 3456, 3583, 3584, 3711, 3712, 3839, 3840, 4095, 4096, 4255, 4256, 4351, 4352, 4607, 4608, 4991, 4992, 5023, 5024, 5119, 5120, 5759, 5760, 5791, 5792, 5887, 5888, 5919, 5920, 5951, 5952, 5983, 5984, 6015, 6016, 6143, 6144, 6319, 6400, 6479, 6480, 6527, 6528, 6623, 6624, 6655, 6656, 6687, 6912, 7039, 7424, 7551, 7552, 7615, 7616, 7679, 7680, 7935, 7936, 8191, 8192, 8303, 8304, 8351, 8352, 8399, 8400, 8447, 8448, 8527, 8528, 8591, 8592, 8703, 8704, 8959, 8960, 9215, 9216, 9279, 9280, 9311, 9312, 9471, 9472, 9599, 9600, 9631, 9632, 9727, 9728, 9983, 9984, 10175, 10176, 10223, 10224, 10239, 10240, 10495, 10496, 10623, 10624, 10751, 10752, 11007, 11008, 11263, 11264, 11359, 11360, 11391, 11392, 11519, 11520, 11567, 11568, 11647, 11648, 11743, 11776, 11903, 11904, 12031, 12032, 12255, 12272, 12287, 12288, 12351, 12352, 12447, 12448, 12543, 12544, 12591, 12592, 12687, 12688, 12703, 12704, 12735, 12736, 12783, 12784, 12799, 12800, 13055, 13056, 13311, 13312, 19903, 19904, 19967, 19968, 40959, 40960, 42127, 42128, 42191, 42752, 42783, 42784, 43007, 43008, 43055, 43072, 43135, 44032, 55215, 55296, 56191, 56192, 56319, 56320, 57343, 57344, 63743, 63744, 64255, 64256, 64335, 64336, 65023, 65024, 65039, 65040, 65055, 65056, 65071, 65072, 65103, 65104, 65135, 65136, 65279, 65280, 65519, 65520, 65535, 65536, 65663, 65664, 65791, 65792, 65855, 65856, 65935, 66304, 66351, 66352, 66383, 66432, 66463, 66464, 66527, 66560, 66639, 66640, 66687, 66688, 66735, 67584, 67647, 67840, 67871, 68096, 68191, 73728, 74751, 74752, 74879, 118784, 119039, 119040, 119295, 119296, 119375, 119552, 119647, 119648, 119679, 119808, 120831, 131072, 173791, 194560, 195103, 917504, 917631, 917760, 917999, 983040, 1048575, 0x100000, 0x10FFFF};

    FontMappingManager() {
        this.initializeFontMapping();
        this.initializeFontEncoding();
    }

    protected void initializeFontMapping() {
        this.fontMapping = new HashMap();
        this.fontMapping.put(SERIF, "Times-Roman");
        this.fontMapping.put(SANS_SERIF, DEFAULT_SANS_SERIF_FONT);
        this.fontMapping.put(CURSIVE, DEFAULT_CURSIVE_FONT);
        this.fontMapping.put(MONOSPACE, DEFAULT_MONOSPACE_FONT);
        this.fontMapping.put(FANTASY, "Times-Roman");
    }

    protected void initializeFontEncoding() {
        this.fontEncoding = new HashMap();
        this.fontEncoding.put("Times-Roman", "Cp1252");
        this.fontEncoding.put(DEFAULT_SANS_SERIF_FONT, "Cp1252");
        this.fontEncoding.put(DEFAULT_MONOSPACE_FONT, "Cp1252");
        this.fontEncoding.put("Symbol", "Cp1252");
        this.fontEncoding.put(DEFAULT_CURSIVE_FONT, "Cp1252");
        this.fontEncoding.put("Times", "Cp1252");
    }

    private int getBlockIndex(char c) {
        int low = 0;
        int high = 153;
        while (low <= high) {
            int mid = (low + high) / 2;
            int minVal = blockEdges[mid * 2];
            int maxVal = blockEdges[mid * 2 + 1];
            if (c < minVal) {
                high = mid - 1;
                continue;
            }
            if (c > maxVal) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public BaseFont getMappedFont(char c, CSSValueList fontFamilies, int fontStyle) {
        String fontName = null;
        BaseFont candidateFont = null;
        for (int i = 0; i < fontFamilies.getLength(); ++i) {
            String fontFamilyName = fontFamilies.item(i).getCssText();
            fontName = this.getConcreteFont(fontFamilyName);
            candidateFont = this.getBaseFont(fontName, c, fontStyle);
            if (null == candidateFont) continue;
            return candidateFont;
        }
        int blockIndex = this.getBlockIndex(c);
        if (blockIndex < 0) {
            return null;
        }
        if (null == this.fontNodes[blockIndex]) {
            return null;
        }
        Iterator i = this.fontNodes[blockIndex].iterator();
        while (i.hasNext()) {
            fontName = (String)i.next();
            candidateFont = this.getBaseFont(fontName, c, fontStyle);
            if (null == candidateFont) continue;
            return candidateFont;
        }
        return null;
    }

    public BaseFont getDefaultFont(int fontStyle) {
        return this.createFont("Times-Roman", fontStyle);
    }

    public void setFontMappingByBlockIndex(int blockIndex, String fontFamily) {
        if (blockIndex < 0) {
            return;
        }
        if (this.fontNodes[blockIndex] == null) {
            this.fontNodes[blockIndex] = new LinkedList();
        }
        this.fontNodes[blockIndex].addLast(fontFamily);
    }

    public void addFontEncoding(HashMap fontEncoding) {
        this.fontEncoding.putAll(fontEncoding);
    }

    public void addFontMapping(HashMap fontMapping) {
        this.fontMapping.putAll(fontMapping);
    }

    private String getConcreteFont(String fontFamilyName) {
        String mappedFontFamily = (String)this.fontMapping.get(fontFamilyName);
        return null == mappedFontFamily ? fontFamilyName : mappedFontFamily;
    }

    private String getEncoding(String fontFamilyName) {
        String encoding = (String)this.fontEncoding.get(fontFamilyName);
        return null == encoding ? "Identity-H" : encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFont createFont(String ffn, int fontStyle) {
        String key = ffn + fontStyle;
        HashMap hashMap = this.baseFonts;
        synchronized (hashMap) {
            BaseFont font = (BaseFont)this.baseFonts.get(key);
            if (font == null) {
                String encoding = this.getEncoding(ffn);
                Font f = FontFactory.getFont((String)ffn, (String)encoding, (boolean)false, (float)14.0f, (int)fontStyle);
                font = f.getBaseFont();
                this.baseFonts.put(key, font);
            }
            return font;
        }
    }

    private BaseFont getBaseFont(String fontName, char c, int fontStyle) {
        BaseFont bf = this.createFont(fontName, fontStyle);
        if (null != bf && bf.charExists(c)) {
            return bf;
        }
        return null;
    }
}

