/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IDynamicTextEventHandler;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.DynamicText;
import org.eclipse.birt.report.engine.script.internal.instance.DynamicTextInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;

public class DynamicTextScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(TextDataHandle textDataHandle, ExecutionContext context) {
        try {
            DynamicText text = new DynamicText(textDataHandle);
            if (DynamicTextScriptExecutor.handleJS((Object)text, textDataHandle.getOnPrepare(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textDataHandle, context);
            if (eh != null) {
                eh.onPrepare(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IForeignContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            DynamicTextInstance text = new DynamicTextInstance(content, context);
            if (DynamicTextScriptExecutor.handleJS((Object)text, textItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onCreate(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IForeignContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            DynamicTextInstance text = new DynamicTextInstance(content, context);
            if (DynamicTextScriptExecutor.handleJS((Object)text, textItemDesign.getOnRender(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onRender(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IForeignContent content, ExecutionContext context) {
        try {
            ReportItemDesign textItemDesign = (ReportItemDesign)content.getGenerateBy();
            DynamicTextInstance text = new DynamicTextInstance(content, context);
            if (DynamicTextScriptExecutor.handleJS((Object)text, textItemDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IDynamicTextEventHandler eh = DynamicTextScriptExecutor.getEventHandler(textItemDesign, context);
            if (eh != null) {
                eh.onPageBreak(text, context.getReportContext());
            }
        }
        catch (Exception e) {
            DynamicTextScriptExecutor.addException(context, e);
        }
    }

    private static IDynamicTextEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        TextDataHandle handle = (TextDataHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return DynamicTextScriptExecutor.getEventHandler(handle, context);
    }

    private static IDynamicTextEventHandler getEventHandler(TextDataHandle handle, ExecutionContext context) {
        IDynamicTextEventHandler eh = null;
        try {
            eh = (IDynamicTextEventHandler)DynamicTextScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            DynamicTextScriptExecutor.addClassCastException(context, e, handle.getEventHandlerClass(), IDynamicTextEventHandler.class);
        }
        return eh;
    }
}

