/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.extensions;

import java.util.Hashtable;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

public abstract class AbstractExtensionMgr
implements IRegistryChangeListener,
IDisposable {
    private static final String EXTENSION_IMPL = "impl";
    protected Hashtable<String, Object> cache = new Hashtable();

    public AbstractExtensionMgr() {
        this(true);
    }

    public AbstractExtensionMgr(boolean bl) {
        if (bl) {
            this.initialize();
        }
    }

    public abstract String getExtensionPointId();

    public void initialize() {
        this.cache = new Hashtable();
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public Object getExtensionImpl(String string) throws ExtensionException {
        return this.getExtensionImpl(string, true);
    }

    public Object getExtensionImpl(String string, boolean bl) throws ExtensionException {
        Object object = null;
        if (bl) {
            object = this.cache.get(string);
        }
        if (object == null) {
            try {
                IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
                IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(this.getExtensionPointId());
                IExtension iExtension = iExtensionPoint.getExtension(string);
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                object = iConfigurationElementArray[0].createExecutableExtension(EXTENSION_IMPL);
                if (bl) {
                    this.cache.put(string, object);
                }
            }
            catch (Exception exception) {
                throw new ExtensionException(exception);
            }
        }
        return object;
    }

    public String[] getAllExtensionIds() {
        String[] stringArray = null;
        try {
            IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(this.getExtensionPointId());
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            String[] stringArray2 = new String[iExtensionArray.length];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray2[n] = iExtensionArray[n].getUniqueIdentifier();
                ++n;
            }
            stringArray = stringArray2;
        }
        catch (Exception exception) {}
        return stringArray;
    }

    public boolean isExtensionDefined(String string) {
        IExtension iExtension = null;
        try {
            IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(this.getExtensionPointId());
            iExtension = iExtensionPoint.getExtension(string);
        }
        catch (Exception exception) {}
        return iExtension != null;
    }

    protected IExtension getExtension(String string) {
        IExtension iExtension = null;
        try {
            IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
            IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(this.getExtensionPointId());
            iExtension = iExtensionPoint.getExtension(string);
        }
        catch (Exception exception) {}
        return iExtension;
    }

    public String getExtensionAttribute(String string, String string2) {
        String string3 = null;
        try {
            IConfigurationElement[] iConfigurationElementArray = this.getExtension(string).getConfigurationElements();
            string3 = iConfigurationElementArray[0].getAttribute(string2);
        }
        catch (Exception exception) {}
        return string3;
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            String string = iExtensionDeltaArray[n].getExtensionPoint().getUniqueIdentifier();
            if (string.equals(this.getExtensionPointId())) {
                String string2 = iExtensionDeltaArray[n].getExtension().getUniqueIdentifier();
                if (iExtensionDeltaArray[n].getKind() == 2) {
                    this.cache.remove(string2);
                    this.extensionRemoved(string2);
                } else if (iExtensionDeltaArray[n].getKind() == 1) {
                    this.extensionAdded(string2);
                }
            }
            ++n;
        }
    }

    protected void extensionAdded(String string) {
    }

    protected void extensionRemoved(String string) {
    }

    public void dispose() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry != null) {
            iExtensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)this);
        }
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
    }
}

