/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.RPCRouterServlet;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.eclipse.aperi.connector.Constants;
import org.eclipse.aperi.connector.internal.Activator;
import org.eclipse.aperi.connector.internal.SecurityContext;
import org.eclipse.aperi.connector.internal.SessionContext;
import org.eclipse.aperi.connector.internal.SystemSecurityContext;
import org.eclipse.aperi.connector.internal.server.DeploymentDescriptorFactory;
import org.eclipse.aperi.connector.log.LogHelper;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

public class Connector
extends RPCRouterServlet
implements ServiceListener,
IDisposable,
Constants {
    public static final long serialVersionUID = 4813483L;
    private boolean registered = false;

    public void start() {
        String string = "start";
        LogHelper.traceEntry(this.getClass(), string);
        ServiceReference serviceReference = Activator.getContext().getServiceReference(HttpService.class.getName());
        this.registerWithHttpService(serviceReference);
        LogHelper.log("CNT004I", this.getClass(), string);
        Activator.registerDisposable(this);
        LogHelper.log("CNT017I", this.getClass(), string);
        Activator.getContext().addServiceListener((ServiceListener)this);
        LogHelper.log("CNT018I", this.getClass(), string);
        LogHelper.traceExit(this.getClass(), string);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        super.init();
        SecurityContext.setDefaultContext(new SystemSecurityContext());
        this.registerExistingServices();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        SessionContext.addSession(httpServletRequest);
        try {
            super.doPost(httpServletRequest, httpServletResponse);
        }
        finally {
            SessionContext.removeSession(httpServletRequest);
        }
    }

    public void destroy() {
    }

    protected synchronized void deploy(String string, Object object) {
        try {
            DeploymentDescriptor deploymentDescriptor = DeploymentDescriptorFactory.createDD(string, object.getClass());
            ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)this.getServletContext());
            serviceManager.deploy(deploymentDescriptor);
            LogHelper.log("CNT003I", this.getClass(), "deploy", string);
        }
        catch (Exception exception) {
            LogHelper.logException(exception, this.getClass(), "deploy");
        }
    }

    public void undeploy(String string) {
        try {
            ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext((ServletContext)this.getServletContext());
            serviceManager.undeploy(string);
            LogHelper.log("CNT021I", this.getClass(), "undeploy");
        }
        catch (Exception exception) {
            LogHelper.traceException(exception, this.getClass(), "undeploy");
        }
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        String string;
        ServiceReference serviceReference = null;
        serviceReference = serviceEvent.getServiceReference();
        if (serviceEvent.getType() == 1) {
            boolean bl = this.deployServiceReference(serviceReference);
            if (!this.isRegistered() & !bl) {
                this.registerWithHttpService(serviceReference);
            }
        } else if (serviceEvent.getType() == 4 && (string = (String)serviceReference.getProperty("org.eclipse.aperi.webservice.name")) != null) {
            this.undeploy(string);
        }
    }

    public void registerExistingServices() {
        try {
            ServiceReference[] serviceReferenceArray = Activator.getContext().getAllServiceReferences(null, null);
            int n = 0;
            while (n < serviceReferenceArray.length) {
                this.deployServiceReference(serviceReferenceArray[n]);
                ++n;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LogHelper.log("CNT019W", this.getClass(), "registerExistingServices");
            LogHelper.logException((Exception)((Object)invalidSyntaxException), this.getClass(), "registerExistingServices");
        }
    }

    protected boolean deployServiceReference(ServiceReference serviceReference) {
        boolean bl = false;
        String string = (String)serviceReference.getProperty("org.eclipse.aperi.webservice.name");
        if (string != null) {
            bl = true;
            Object object = Activator.getContext().getService(serviceReference);
            super.getServletContext().setAttribute(string, object);
            this.deploy(string, object);
        }
        return bl;
    }

    protected void registerWithHttpService(ServiceReference serviceReference) {
        Object object;
        if (serviceReference != null && (object = Activator.getContext().getService(serviceReference)) != null && object instanceof HttpService) {
            HttpService httpService = (HttpService)object;
            try {
                httpService.registerServlet("/ServiceManager", (Servlet)this, null, null);
                this.setRegistered(true);
                LogHelper.log("CNT004I", this.getClass(), "registerWithHttpService");
            }
            catch (Exception exception) {
                LogHelper.logException(exception, this.getClass(), "registerWithHttpService");
            }
        }
    }

    public void dispose() {
        Object object;
        ServiceReference serviceReference = Activator.getContext().getServiceReference(HttpService.class.getName());
        if (serviceReference != null && (object = Activator.getContext().getService(serviceReference)) != null) {
            HttpService httpService = (HttpService)object;
            try {
                httpService.unregister("/ServiceManager");
                this.setRegistered(false);
                LogHelper.log("CNT020I", this.getClass(), "dispose");
            }
            catch (Exception exception) {
                LogHelper.traceException(exception, this.getClass(), "dispose");
            }
        }
    }

    protected boolean isRegistered() {
        return this.registered;
    }

    protected void setRegistered(boolean bl) {
        this.registered = bl;
    }
}

