/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.IKeyStoreMgr;
import org.eclipse.aperi.connector.log.LogHelper;

public class KeyStoreMgr
implements IKeyStoreMgr {
    private KeyStore keystore = null;
    private String keystorePWD = null;
    private static IKeyStoreMgr instance = null;

    public static IKeyStoreMgr getIKeyStoreMgr() {
        if (instance == null) {
            String string = Config.getProperty("connector.ssl.keystore.mgr.impl");
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    instance = (IKeyStoreMgr)clazz.newInstance();
                }
                catch (Exception exception) {
                    LogHelper.log("CNT025W", IKeyStoreMgr.class, "getIKeyStoreMgr", string);
                    LogHelper.logException(exception, IKeyStoreMgr.class, "getIKeyStoreMgr");
                }
            }
            if (instance == null) {
                instance = new KeyStoreMgr();
            }
        }
        return instance;
    }

    private KeyStoreMgr() {
    }

    public KeyStore getKeyStore() throws KeyStoreException {
        if (this.keystore == null) {
            this.keystore = KeyStore.getInstance("JKS");
            String string = Config.getProperty("connector.ssl.keystore");
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogHelper.log("CNT022W", KeyStoreMgr.class, "getKeystore", string);
                inputStream = KeyStoreMgr.class.getResourceAsStream("/org/eclipse/aperi/connector/internal/ssl/defaultKeystore.jks");
            }
            try {
                this.keystore.load(inputStream, this.getPassword());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LogHelper.log("CNT023E", KeyStoreMgr.class, "getKeyStore", this.keystore.getProvider().getName());
                LogHelper.logException(noSuchAlgorithmException, KeyStoreMgr.class, "getKeyStore");
                throw new KeyStoreException(noSuchAlgorithmException);
            }
            catch (IOException iOException) {
                LogHelper.log("CNT024E", KeyStoreMgr.class, "getKeyStore");
                LogHelper.logException(iOException, KeyStoreMgr.class, "getKeyStore");
                throw new KeyStoreException(iOException);
            }
            catch (Exception exception) {
                LogHelper.traceException(exception, KeyStoreMgr.class, "getKeyStore");
                throw new KeyStoreException(exception);
            }
        }
        return this.keystore;
    }

    public char[] getPassword() {
        if (this.keystorePWD == null) {
            this.keystorePWD = Config.getProperty("connector.ssl.keystorepassword");
        }
        return this.keystorePWD.toCharArray();
    }
}

