/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.util.IOUtil;

public class ArchiveEntryOutputStream
extends RAOutputStream {
    protected ArchiveEntry entry;
    private long offset;
    byte[] b = new byte[8];

    public ArchiveEntryOutputStream(ArchiveEntry entry) {
        this.entry = entry;
        this.offset = 0L;
    }

    public long getOffset() throws IOException {
        return this.offset;
    }

    public void seek(long localPos) throws IOException {
        this.entry.ensureSize(localPos);
        this.offset = localPos;
    }

    public void write(int b) throws IOException {
        this.b[0] = (byte)b;
        this.entry.write(this.offset, this.b, 0, 1);
        ++this.offset;
    }

    public void writeInt(int value) throws IOException {
        IOUtil.integerToBytes(value, this.b);
        this.entry.write(this.offset, this.b, 0, 4);
        this.offset += 4L;
    }

    public void writeLong(long value) throws IOException {
        IOUtil.longToBytes(value, this.b);
        this.entry.write(this.offset, this.b, 0, 8);
        this.offset += 8L;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.entry.write(this.offset, b, off, len);
        this.offset += (long)len;
    }
}

