/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

class ArchiveHeader {
    static final long MAGIC_TAG = 90504964424259L;
    static final long VERSION_0 = 0L;
    static final int HEADER_BLOCK = 0;
    static final int FILE_STATUS_OFFSET = 16;
    protected ArchiveFile af;
    protected int fileStatus;

    private ArchiveHeader(ArchiveFile af) {
        this.af = af;
        this.fileStatus = 0;
    }

    static ArchiveHeader createHeader(ArchiveFile af) throws IOException {
        ArchiveHeader header = new ArchiveHeader(af);
        header.flush();
        return header;
    }

    static ArchiveHeader loadHeader(ArchiveFile af) throws IOException {
        ArchiveHeader header = new ArchiveHeader(af);
        header.refresh();
        return header;
    }

    void refresh() throws IOException {
        byte[] b = new byte[4096];
        this.af.read(0, 0, b, 0, 4096);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
        long magicTag = in.readLong();
        if (magicTag != 90504964424259L) {
            throw new IOException("Not a compound file, the magic code is " + magicTag);
        }
        long version = in.readLong();
        if (version != 0L) {
            throw new IOException("Unsupported compound archive version 0");
        }
        this.fileStatus = in.readInt();
    }

    void flush() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buffer);
        out.writeLong(90504964424259L);
        out.writeLong(0L);
        out.writeInt(this.fileStatus);
        byte[] b = buffer.toByteArray();
        this.af.write(0, 0, b, 0, b.length);
    }
}

