/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class ArchiveReader
implements IDocArchiveReader {
    protected ArchiveFile archive;
    protected boolean shareArchive;

    public ArchiveReader(ArchiveFile archive) throws IOException {
        this.shareArchive = true;
        this.archive = archive;
    }

    public ArchiveReader(String archiveName) throws IOException {
        this.archive = new ArchiveFile(archiveName, "r");
        this.shareArchive = false;
    }

    public void close() throws IOException {
        if (!this.shareArchive) {
            this.archive.close();
        }
    }

    public boolean exists(String relativePath) {
        return this.archive.exists(relativePath);
    }

    public String getName() {
        return this.archive.getName();
    }

    public RAInputStream getStream(String relativePath) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(relativePath);
        if (entry != null) {
            return new ArchiveEntryInputStream(entry);
        }
        return null;
    }

    public List listStreams(String relativeStoragePath) throws IOException {
        return this.archive.listEntries(relativeStoragePath);
    }

    public void open() throws IOException {
    }

    public Object lock(String stream) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(stream);
        if (entry != null) {
            return this.archive.lockEntry(entry);
        }
        throw new IOException("can't find the entry " + stream);
    }

    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

