/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.core.archive.compound.Block;
import org.eclipse.birt.core.archive.compound.BlockManagerEventAdapter;

class BlockManager {
    static final int DEFAULT_CACHE_BLOCKS = 64;
    BlockManagerEventAdapter eventAdapter;
    int cacheSize;
    HashMap blocks;
    Block firstBlock;
    Block lastBlock;

    BlockManager(BlockManagerEventAdapter adapter) {
        this.eventAdapter = adapter;
        this.cacheSize = 64;
        this.blocks = new HashMap(this.cacheSize);
        this.firstBlock = null;
        this.lastBlock = null;
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    void setCacheSize(int cacheSize) {
        if (cacheSize <= 2) {
            cacheSize = 64;
        }
        this.cacheSize = cacheSize;
    }

    void close() {
        this.blocks.clear();
        this.firstBlock = null;
        this.lastBlock = null;
    }

    void flush() throws IOException {
        if (this.eventAdapter != null) {
            Block block = this.firstBlock;
            while (block != null) {
                this.eventAdapter.flush(block);
                block = block.next;
            }
        }
    }

    Block getBlock(int id) throws IOException {
        if (this.firstBlock == null) {
            Block block = new Block();
            block.id = id;
            block.prev = null;
            block.next = null;
            if (this.eventAdapter != null) {
                this.eventAdapter.refresh(block);
            }
            this.firstBlock = this.lastBlock = block;
            return block;
        }
        if (id == this.firstBlock.id) {
            return this.firstBlock;
        }
        Block block = (Block)this.blocks.get(new Integer(id));
        if (block == null) {
            if (this.blocks.size() >= this.cacheSize) {
                block = this.lastBlock;
                this.lastBlock = this.lastBlock.prev;
                this.lastBlock.next = null;
                this.blocks.remove(new Integer(block.id));
                if (this.eventAdapter != null) {
                    this.eventAdapter.flush(block);
                }
                block.reset();
            } else {
                block = new Block();
            }
            block.id = id;
            if (this.eventAdapter != null) {
                this.eventAdapter.refresh(block);
            }
            this.blocks.put(new Integer(id), block);
        } else {
            block.prev.next = block.next;
            if (this.lastBlock != block) {
                block.next.prev = block.prev;
            } else {
                this.lastBlock = block.prev;
            }
        }
        block.prev = null;
        block.next = this.firstBlock;
        this.firstBlock.prev = block;
        this.firstBlock = block;
        return block;
    }
}

