/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DateFormatFactory;
import org.eclipse.birt.core.data.DateFormatISO8601;
import org.eclipse.birt.core.data.DateFormatUtil;
import org.eclipse.birt.core.data.DateUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.i18n.ResourceHandle;
import org.eclipse.birt.core.script.JavascriptEvalUtil;

public final class DataTypeUtil {
    private static ULocale DEFAULT_LOCALE = ULocale.US;
    private static int DEFAULT_DATE_STYLE = 2;
    private static Map dfMap = DateFormatUtil.getAllDateFormatter();
    public static ResourceBundle resourceBundle = new ResourceHandle(ULocale.getDefault()).getResourceBundle();
    public static long count = 0L;
    private static final String pluginId = "org.eclipse.birt.core";

    public static Object convert(Object source, int toType) throws BirtException {
        if (source == null) {
            return null;
        }
        source = JavascriptEvalUtil.convertJavascriptValue(source);
        if (toType == -1 || toType == 0) {
            return source;
        }
        switch (toType) {
            case 2: {
                return DataTypeUtil.toInteger(source);
            }
            case 4: {
                return DataTypeUtil.toBigDecimal(source);
            }
            case 1: {
                return DataTypeUtil.toBoolean(source);
            }
            case 6: {
                return DataTypeUtil.toDate(source);
            }
            case 3: {
                return DataTypeUtil.toDouble(source);
            }
            case 5: {
                return DataTypeUtil.toString(source);
            }
            case 7: {
                return DataTypeUtil.toBlob(source);
            }
            case 8: {
                return DataTypeUtil.toBytes(source);
            }
        }
        throw new BirtException(pluginId, "INVALID_TYPE", resourceBundle);
    }

    public static Object convert(Object source, Class toTypeClass) throws BirtException {
        if (toTypeClass == DataType.getClass(0)) {
            return source;
        }
        if (toTypeClass == Integer.class) {
            return DataTypeUtil.toInteger(source);
        }
        if (toTypeClass == BigDecimal.class) {
            return DataTypeUtil.toBigDecimal(source);
        }
        if (toTypeClass == Boolean.class) {
            return DataTypeUtil.toBoolean(source);
        }
        if (toTypeClass == Time.class) {
            return DataTypeUtil.toTime(source);
        }
        if (Date.class.isAssignableFrom(toTypeClass)) {
            return DataTypeUtil.toDate(source);
        }
        if (toTypeClass == Double.class) {
            return DataTypeUtil.toDouble(source);
        }
        if (toTypeClass == String.class) {
            return DataTypeUtil.toString(source);
        }
        if (toTypeClass == Blob.class) {
            return DataTypeUtil.toBlob(source);
        }
        throw new BirtException(pluginId, "INVALID_TYPE", resourceBundle);
    }

    public static Integer toInteger(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Integer) {
            return (Integer)source;
        }
        if (source instanceof Number) {
            int intValue = ((Number)source).intValue();
            return new Integer(intValue);
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        if (source instanceof Date) {
            long longValue = ((Date)source).getTime();
            return new Integer((int)longValue);
        }
        if (source instanceof String) {
            try {
                return new Integer(Double.valueOf((String)source).intValue());
            }
            catch (NumberFormatException e) {
                throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Integer"}, resourceBundle);
            }
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Integer"}, resourceBundle);
    }

    public static BigDecimal toBigDecimal(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof BigDecimal) {
            return (BigDecimal)source;
        }
        if (source instanceof Number) {
            String str = ((Number)source).toString();
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{str, "BigDecimal"}, resourceBundle);
            }
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new BigDecimal(1.0);
            }
            return new BigDecimal(0.0);
        }
        if (source instanceof Date) {
            long longValue = ((Date)source).getTime();
            return new BigDecimal((double)longValue);
        }
        if (source instanceof String) {
            try {
                return new BigDecimal((String)source);
            }
            catch (NumberFormatException e) {
                throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "BigDecimal"}, resourceBundle);
            }
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "BigDecimal"}, resourceBundle);
    }

    public static Boolean toBoolean(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        if (source instanceof Number) {
            int intValue = ((Number)source).intValue();
            if (intValue == 0) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }
        if (source instanceof String) {
            if (((String)source).equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (((String)source).equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            try {
                if (Integer.parseInt((String)source) == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (NumberFormatException e) {
                throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Boolean"});
            }
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Boolean"}, resourceBundle);
    }

    public static Date toDate(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return new Date(((Date)source).getTime());
        }
        if (source instanceof String) {
            return DataTypeUtil.toDate((String)source);
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Date"}, resourceBundle);
    }

    public static Time toTime(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return new Time(((Date)source).getTime());
        }
        if (source instanceof String) {
            try {
                return new Time(DataTypeUtil.toDate((String)source).getTime());
            }
            catch (Exception e) {
                try {
                    return Time.valueOf((String)source);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Time"}, resourceBundle);
    }

    public static Date toDate(String source, Locale locale) throws BirtException {
        return DataTypeUtil.toDate(source, ULocale.forLocale((Locale)locale));
    }

    public static Date toDate(String source, ULocale locale) throws BirtException {
        if (source == null) {
            return null;
        }
        DateFormat dateFormat = null;
        Date resultDate = null;
        boolean existTime = source.matches(".*[0-9]+:[0-9]+:[0-9]+.*") || source.matches(".*[0-9]+:[0-9]+.*");
        for (int i = DEFAULT_DATE_STYLE; i <= 3; ++i) {
            for (int j = DEFAULT_DATE_STYLE; j <= 3; ++j) {
                dateFormat = DateFormatFactory.getDateTimeInstance(i, j, locale);
                try {
                    resultDate = dateFormat.parse(source);
                    return resultDate;
                }
                catch (ParseException e1) {
                    continue;
                }
            }
            if (existTime) continue;
            dateFormat = DateFormatFactory.getDateInstance(i, locale);
            try {
                resultDate = dateFormat.parse(source);
                return resultDate;
            }
            catch (ParseException e1) {
                // empty catch block
            }
        }
        if (resultDate == null) {
            throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Date"}, resourceBundle);
        }
        return resultDate;
    }

    public static Date toDateWithCheck(String source, Locale locale) throws BirtException {
        return DataTypeUtil.toDateWithCheck(source, ULocale.forLocale((Locale)locale));
    }

    public static Date toDateWithCheck(String source, ULocale locale) throws BirtException {
        DateFormat dateFormat = DateFormatFactory.getDateInstance(3, locale);
        Date resultDate = null;
        try {
            resultDate = dateFormat.parse(source);
        }
        catch (ParseException e) {
            return DataTypeUtil.toDate(source, locale);
        }
        if (!DateUtil.checkValid(dateFormat, source)) {
            throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Date"}, resourceBundle);
        }
        return resultDate;
    }

    public static Double toDouble(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Double) {
            return (Double)source;
        }
        if (source instanceof Number) {
            double doubleValue = ((Number)source).doubleValue();
            return new Double(doubleValue);
        }
        if (source instanceof Boolean) {
            if (((Boolean)source).booleanValue()) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        if (source instanceof Date) {
            double doubleValue = ((Date)source).getTime();
            return new Double(doubleValue);
        }
        if (source instanceof String) {
            try {
                return Double.valueOf((String)source);
            }
            catch (NumberFormatException e) {
                throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Double"}, resourceBundle);
            }
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Double"}, resourceBundle);
    }

    public static String toString(Object source) throws BirtException {
        return DataTypeUtil.toString(source, ULocale.getDefault());
    }

    public static String toString(Object source, Locale locale) throws BirtException {
        return DataTypeUtil.toString(source, ULocale.forLocale((Locale)locale));
    }

    public static String toString(Object source, ULocale locale) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            return DataTypeUtil.toString((Date)source, locale);
        }
        String str = "";
        if (source instanceof byte[]) {
            int strLength = 8;
            byte[] sourceValue = (byte[])source;
            int length = Math.min(sourceValue.length, 8);
            for (int i = 0; i < length; ++i) {
                str = str + Integer.toHexString(sourceValue[i]).toUpperCase() + " ";
            }
            if (sourceValue.length > 8) {
                str = str + "...";
            }
        } else {
            str = source.toString();
        }
        return str;
    }

    public static Blob toBlob(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Blob) {
            return (Blob)source;
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Blob"}, resourceBundle);
    }

    public static byte[] toBytes(Object source) throws BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Binary"}, resourceBundle);
    }

    public static int toApiDataType(Class clazz) {
        if (clazz == null) {
            return -1;
        }
        if (clazz == DataType.AnyType.class) {
            return 0;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return 3;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return 5;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if ([B.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (Clob.class.isAssignableFrom(clazz) || clazz.getName().equals("org.eclipse.datatools.connectivity.oda.IClob")) {
            return 5;
        }
        if (Blob.class.isAssignableFrom(clazz) || clazz.getName().equals("org.eclipse.datatools.connectivity.oda.IBlob")) {
            return 8;
        }
        return -1;
    }

    public static int toApiDataType(int odaDataTypeCode) throws BirtException {
        Class odiTypeClass = DataTypeUtil.toOdiTypeClass(odaDataTypeCode);
        return DataTypeUtil.toApiDataType(odiTypeClass);
    }

    public static Object toAutoValue(Object evaValue) {
        if (evaValue == null) {
            return null;
        }
        Object value = null;
        if (evaValue instanceof String) {
            String stringValue = (String)evaValue;
            value = DataTypeUtil.toIntegerValue(evaValue);
            if (value == null) {
                try {
                    value = Double.valueOf(stringValue);
                }
                catch (NumberFormatException e1) {
                    try {
                        value = new BigDecimal(stringValue);
                    }
                    catch (NumberFormatException e2) {
                        try {
                            value = DataTypeUtil.toDate(stringValue);
                        }
                        catch (BirtException e3) {
                            value = evaValue;
                        }
                    }
                }
            }
        }
        return value;
    }

    public static Integer toIntegerValue(Object evaValue) {
        Integer value = null;
        if (evaValue instanceof String) {
            String stringValue = evaValue.toString();
            try {
                value = Integer.valueOf(stringValue);
            }
            catch (NumberFormatException e1) {
                try {
                    Double ddValue = Double.valueOf(stringValue);
                    int intValue = ddValue.intValue();
                    double doubleValue = ddValue;
                    value = Math.abs((double)intValue - doubleValue) < 1.0E-7 ? Integer.valueOf(String.valueOf(intValue)) : null;
                }
                catch (NumberFormatException e2) {
                    value = null;
                }
            }
        }
        return value;
    }

    private static Date toDate(String source) throws BirtException {
        try {
            return DataTypeUtil.toDateISO8601(source);
        }
        catch (BirtException e) {
            try {
                return DataTypeUtil.toDate(source, ULocale.getDefault());
            }
            catch (BirtException use) {
                return DataTypeUtil.toDate(source, DEFAULT_LOCALE);
            }
        }
    }

    private static Date toDateISO8601(String source) throws BirtException {
        Date resultDate = null;
        try {
            resultDate = DateFormatISO8601.parse(source);
            return resultDate;
        }
        catch (ParseException e1) {
            throw new BirtException(pluginId, "CONVERT_FAILS", new Object[]{source.toString(), "Date"}, resourceBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(Date source, ULocale locale) {
        DateFormatter df = null;
        df = (DateFormatter)dfMap.get(locale);
        if (df == null) {
            Map map = dfMap;
            synchronized (map) {
                df = (DateFormatter)dfMap.get(locale);
                if (df == null) {
                    df = new DateFormatter(locale);
                    dfMap.put(locale, df);
                }
            }
        }
        return df.format(source);
    }

    public static Class toOdiTypeClass(int odaDataTypeCode) throws BirtException {
        if (odaDataTypeCode != 1 && odaDataTypeCode != 4 && odaDataTypeCode != 8 && odaDataTypeCode != 3 && odaDataTypeCode != 91 && odaDataTypeCode != 92 && odaDataTypeCode != 93 && odaDataTypeCode != 2004 && odaDataTypeCode != 2005 && odaDataTypeCode != 0) {
            throw new BirtException(pluginId, "INVALID_TYPE", resourceBundle);
        }
        Class fieldClass = null;
        switch (odaDataTypeCode) {
            case 1: {
                fieldClass = String.class;
                break;
            }
            case 4: {
                fieldClass = Integer.class;
                break;
            }
            case 8: {
                fieldClass = Double.class;
                break;
            }
            case 3: {
                fieldClass = BigDecimal.class;
                break;
            }
            case 91: {
                fieldClass = Date.class;
                break;
            }
            case 92: {
                fieldClass = Time.class;
                break;
            }
            case 93: {
                fieldClass = Timestamp.class;
                break;
            }
            case 2004: {
                fieldClass = Blob.class;
                break;
            }
            case 2005: {
                fieldClass = Clob.class;
                break;
            }
            case 0: {
                fieldClass = null;
            }
        }
        return fieldClass;
    }

    public static int toOdaDataType(Class odiTypeClass) {
        int odaType = 1;
        if (odiTypeClass == null) {
            odaType = 1;
        } else if (odiTypeClass == String.class) {
            odaType = 1;
        } else if (odiTypeClass == Integer.class) {
            odaType = 4;
        } else if (odiTypeClass == Double.class) {
            odaType = 8;
        } else if (odiTypeClass == BigDecimal.class) {
            odaType = 3;
        } else if (odiTypeClass == Date.class) {
            odaType = 91;
        } else if (odiTypeClass == Time.class) {
            odaType = 92;
        } else if (odiTypeClass == Timestamp.class) {
            odaType = 93;
        } else if (odiTypeClass == Blob.class) {
            odaType = 2004;
        } else if (odiTypeClass == Clob.class) {
            odaType = 2005;
        }
        return odaType;
    }
}

