/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.IDiskManagementService;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.api.impl.DiskOperations;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.discovery.SubSystemDeletion;
import org.eclipse.aperi.disk.discovery.SubsystemDBHelper;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;

public class DiskManagementOperations
extends DiskOperations
implements IDiskManagementService {
    static final long SUBSYSTEMDELETIONTIMEOUTDEFAULT = 30000L;
    static final String SUBSYSTEM_DELETION_TIMEOUT = "SUBSYSTEMDELETIONTIMEOUT";
    private static volatile Map cStorageSystemUsage = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubsystemDataInUse(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"registerSubsystemDataInUse", (Object[])new Object[]{string});
        Map map = cStorageSystemUsage;
        synchronized (map) {
            Object v = cStorageSystemUsage.get(string);
            int n = 1;
            if (v != null) {
                n = (Integer)v + 1;
            }
            cStorageSystemUsage.put(string, new Integer(n));
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterSubsystemDataInUse(String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"deregisterSubsystemDataInUse", (Object[])new Object[]{string});
        Map map = cStorageSystemUsage;
        synchronized (map) {
            Object v = cStorageSystemUsage.get(string);
            if (v == null) {
                return;
            }
            int n = (Integer)v - 1;
            if (n < 1) {
                cStorageSystemUsage.remove(string);
            } else {
                cStorageSystemUsage.put(string, new Integer(n));
            }
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSubsystemDataInUse(String string) throws IDParseException, EntityNotFoundException {
        Map map;
        LogTraceHelper logTraceHelper;
        block13: {
            block14: {
                logTraceHelper = LogTraceHelper.entry((Object)this, (String)"checkSubsystemDataInUse", (Object[])new Object[]{string});
                map = cStorageSystemUsage;
                synchronized (map) {
                    if (cStorageSystemUsage.containsKey(string)) {
                        logTraceHelper.exit((Object)new Boolean(true));
                        return true;
                    }
                }
                map = null;
                try {
                    map = ServiceUtils.getConnection();
                    StorageSubsystem storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string, (DBConnection)map);
                    if (storageSubsystem.getProbeStatus() == null || !storageSubsystem.getProbeStatus().trim().equals("0")) break block13;
                    logTraceHelper.exit((Object)new Boolean(true));
                    Object var5_5 = null;
                    if (map == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (map != null) {
                        try {
                            map.close();
                        }
                        catch (SQLException sQLException) {
                            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                        }
                    }
                    logTraceHelper.exit((Object)new Boolean(false));
                    throw throwable;
                }
                try {}
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                map.close();
            }
            logTraceHelper.exit((Object)new Boolean(false));
            return true;
        }
        Object var5_7 = null;
        if (map != null) {
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            map.close();
        }
        logTraceHelper.exit((Object)new Boolean(false));
        return false;
    }

    public DiskManagementOperations(DiskManager diskManager) {
        super(diskManager);
    }

    public void handleServiceShutdown() {
        super.handleServiceShutdown();
    }

    protected void initialize() {
    }

    private long getTimeout(DBConnection dBConnection, LogTraceHelper logTraceHelper) {
        long l = 30000L;
        ConfigData configData = ParameterHelper.readConfigData((DBConnection)dBConnection, (String)SUBSYSTEM_DELETION_TIMEOUT, (LogTraceHelper)logTraceHelper);
        l = configData != null ? Long.valueOf(configData.getValue()) : 30000L;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removePhysicalVolumesFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"removePhysicalVolumesFromDB", (Object[])new Object[]{nArray});
        DBConnection dBConnection = null;
        Result result = new Result();
        result.setSRMMessage("HWN020001I", new String[]{"removePhysicalVolumesFromDB"});
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"PhyVolumeAutoIDs", (Object)nArray, (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                long l = this.getTimeout(dBConnection, logTraceHelper);
                logTraceHelper.traceInfo("Timeout for deletion :" + l);
                Object object = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deletePhysicalVolumes", (Object[])new Object[]{nArray}, (long)l, (LogTraceHelper)logTraceHelper);
                result.setResults(new Object[]{object});
                result2 = result;
                Object var8_12 = null;
            }
            catch (DiskManagerExecException diskManagerExecException) {
                logTraceHelper.traceError("Internal error: deletePhysicalVolumes DiskManagerExecException", (Throwable)diskManagerExecException);
                Result result3 = result = new Result(0, new SRMMessage("HWN021503E", new String[]{diskManagerExecException.getMessage()}));
                Object var8_13 = null;
                try {
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                logTraceHelper.exit((Object)result);
                return result3;
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: deletePhysicalVolumes TimeoutException", (Throwable)diskManagerTimeoutException);
                Result result4 = result = new Result(0, new SRMMessage("HWN021503E", new String[0]));
                Object var8_14 = null;
                try {}
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                if (dBConnection != null) {
                    dBConnection.close();
                }
                logTraceHelper.exit((Object)result);
                return result4;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            if (dBConnection != null) {
                dBConnection.close();
            }
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        logTraceHelper.exit((Object)result);
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removeStoragePoolsFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"removeStoragePoolsFromDB", (Object[])new Object[]{nArray});
        DBConnection dBConnection = null;
        Result result = new Result();
        result.setSRMMessage("HWN020001I", new String[]{"removeStoragePoolsFromDB"});
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"PoolAutoIDs", (Object)nArray, (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                long l = this.getTimeout(dBConnection, logTraceHelper);
                logTraceHelper.traceInfo("Timeout for deletion :" + l);
                Object object = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deleteStoragePools", (Object[])new Object[]{nArray}, (long)l, (LogTraceHelper)logTraceHelper);
                result.setResults(new Object[]{object});
                result2 = result;
                Object var8_12 = null;
            }
            catch (DiskManagerExecException diskManagerExecException) {
                logTraceHelper.traceError("Internal error: removeStoragePoolsFromDB DiskManagerExecException", (Throwable)diskManagerExecException);
                Result result3 = result = new Result(0, new SRMMessage("HWN021503E", new String[]{diskManagerExecException.getMessage()}));
                Object var8_13 = null;
                try {
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                logTraceHelper.exit((Object)result);
                return result3;
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: removeStoragePoolsFromDB TimeoutException", (Throwable)diskManagerTimeoutException);
                Result result4 = result = new Result(0, new SRMMessage("HWN021503E", new String[0]));
                Object var8_14 = null;
                try {}
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                if (dBConnection != null) {
                    dBConnection.close();
                }
                logTraceHelper.exit((Object)result);
                return result4;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            if (dBConnection != null) {
                dBConnection.close();
            }
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        logTraceHelper.exit((Object)result);
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removePortsFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"removePortsFromDB", (Object[])new Object[]{nArray});
        DBConnection dBConnection = null;
        Result result = new Result();
        result.setSRMMessage("HWN020001I", new String[]{"removePortsFromDB"});
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"PortAutoIDs", (Object)nArray, (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                long l = this.getTimeout(dBConnection, logTraceHelper);
                logTraceHelper.traceInfo("Timeout for deletion :" + l);
                Object object = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deletePorts", (Object[])new Object[]{nArray}, (long)l, (LogTraceHelper)logTraceHelper);
                result.setResults(new Object[]{object});
                result2 = result;
                Object var8_12 = null;
            }
            catch (DiskManagerExecException diskManagerExecException) {
                logTraceHelper.traceError("Internal error: removePortsFromDB DiskManagerExecException", (Throwable)diskManagerExecException);
                Result result3 = result = new Result(0, new SRMMessage("HWN021503E", new String[]{diskManagerExecException.getMessage()}));
                Object var8_13 = null;
                try {
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                logTraceHelper.exit((Object)result);
                return result3;
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: removePortsFromDB TimeoutException", (Throwable)diskManagerTimeoutException);
                Result result4 = result = new Result(0, new SRMMessage("HWN021503E", new String[0]));
                Object var8_14 = null;
                try {}
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                if (dBConnection != null) {
                    dBConnection.close();
                }
                logTraceHelper.exit((Object)result);
                return result4;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            if (dBConnection != null) {
                dBConnection.close();
            }
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        logTraceHelper.exit((Object)result);
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removeStorageVolumesFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        Result result2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"removeStorageVolumeFromDB", (Object[])new Object[]{nArray});
        DBConnection dBConnection = null;
        Result result = new Result();
        result.setSRMMessage("HWN020001I", new String[]{"removeStorageVolumeFromDB"});
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"VolumeIDs", (Object)nArray, (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                long l = this.getTimeout(dBConnection, logTraceHelper);
                logTraceHelper.traceInfo("Timeout for deletion :" + l);
                Object object = DiskThreadManager.executeWithTimeLimit((Object)new SubsystemDBHelper(), (String)"deleteStorageVolumes", (Object[])new Object[]{nArray}, (long)l, (LogTraceHelper)logTraceHelper);
                result.setResults(new Object[]{object});
                result2 = result;
                Object var8_12 = null;
            }
            catch (DiskManagerExecException diskManagerExecException) {
                logTraceHelper.traceError("Internal error: removeStorageVolumeFromDB DiskManagerExecException", (Throwable)diskManagerExecException);
                Result result3 = result = new Result(0, new SRMMessage("HWN021503E", new String[]{diskManagerExecException.getMessage()}));
                Object var8_13 = null;
                try {
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                logTraceHelper.exit((Object)result);
                return result3;
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: removeStorageVolumeFromDB TimeoutException", (Throwable)diskManagerTimeoutException);
                Result result4 = result = new Result(0, new SRMMessage("HWN021503E", new String[0]));
                Object var8_14 = null;
                try {}
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
                }
                if (dBConnection != null) {
                    dBConnection.close();
                }
                logTraceHelper.exit((Object)result);
                return result4;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            if (dBConnection != null) {
                dBConnection.close();
            }
            logTraceHelper.exit((Object)result);
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        logTraceHelper.exit((Object)result);
        return result2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result[] deleteStorageSubsystems(String[] var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        var2_2 = LogTraceHelper.entry((Object)this, (String)"deleteStorageSubsystems", (Object[])new Object[]{var1_1});
        var3_3 = null;
        var4_4 = null;
        var5_5 = new Result[var1_1.length];
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"SubsystemIDs", (Object)var1_1, (LogTraceHelper)var2_2);
                var6_6 = 0;
                while (true) {
                    if (var6_6 >= var1_1.length) break;
                    try {
                        if (this.checkSubsystemDataInUse(var1_1[var6_6])) {
                            throw DiskMessageHelper.getServerException((String)"HWN021672E", (Object)var1_1[var6_6], (LogTraceHelper)var2_2);
                        }
                    }
                    catch (IDParseException var7_10) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)var7_10, (LogTraceHelper)var2_2);
                    }
                    catch (EntityNotFoundException var7_11) {
                        throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)var7_11, (LogTraceHelper)var2_2);
                    }
                    ++var6_6;
                }
                var4_4 = ServiceUtils.getConnection();
                var6_7 = this.getTimeout(var4_4, var2_2);
                var2_2.traceInfo("Timeout for deletion :" + var6_7);
                var8_13 = DiskThreadManager.getExecutionGroup();
                var9_15 = new Long[var1_1.length];
                var10_16 = 0;
                while (true) {
                    if (var10_16 >= var1_1.length) {
                        var8_13.waitForCompletion(var6_7);
                        var10_16 = 0;
                        break;
                    }
                    var11_17 /* !! */  = null;
                    var11_17 /* !! */  = new Object[]{var1_1[var10_16]};
                    var9_15[var10_16] = var8_13.execute((Object)new SubSystemDeletion(), "deleteStorageSubsystem", var11_17 /* !! */ , var2_2);
                    ++var10_16;
                }
                while (var10_16 < var1_1.length) {
                    var11_17 /* !! */  = var8_13.getExecutionError(var9_15[var10_16]);
                    if (var11_17 /* !! */  == null) {
                        var12_18 = var8_13.getExecutionResult(var9_15[var10_16]);
                        var5_5[var10_16] = (Result)var12_18;
                    } else {
                        var12_18 = new Result(0, new SRMMessage("HWN021503E", new String[0]));
                        if (var11_17 /* !! */  instanceof Exception) {
                            var13_19 = (Exception)var11_17 /* !! */ ;
                            var2_2.traceError("Internal error: deleteStorageSubsystems (" + var1_1[var10_16] + ")", (Throwable)var13_19);
                            var12_18.setResults((Object[])new String[]{var13_19.toString()});
                        }
                        var5_5[var10_16] = var12_18;
                    }
                    ++var10_16;
                }
                ** GOTO lbl-1000
            }
            catch (DiskManagerExecException var6_8) {
                var2_2.traceError("Internal error: deleteStorageSubsystems DiskManagerExecException", (Throwable)var6_8);
                new Result(0, new SRMMessage("HWN021503E", new String[0]));
                ** GOTO lbl-1000
            }
            catch (DiskManagerTimeoutException var6_9) {
                var2_2.traceError("Internal error: deleteStorageSubsystems TimeoutException", (Throwable)var6_9);
                var7_12 = new Result(0, new SRMMessage("HWN021503E", new String[0]));
                var8_14 = 0;
            }
            while (var8_14 < var1_1.length) {
                var5_5[var8_14] = var7_12;
                ++var8_14;
            }
        }
        catch (Throwable var15_20) {
            var14_21 = null;
            try {
                if (var4_4 != null) {
                    var4_4.close();
                }
            }
            catch (SQLException var16_23) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)var16_23.getMessage(), (LogTraceHelper)var2_2);
            }
            var2_2.exit(var3_3);
            throw var15_20;
        }
lbl-1000:
        // 3 sources

        {
            var14_22 = null;
        }
        try {}
        catch (SQLException var16_24) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)var16_24.getMessage(), (LogTraceHelper)var2_2);
        }
        if (var4_4 != null) {
            var4_4.close();
        }
        var2_2.exit(var3_3);
        return var5_5;
    }
}

