/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.IBMDeviceRegistrationDataHelper;
import org.eclipse.aperi.disk.collection.ProbeGenericArraySubsystemProcess;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.collection.step.CommitStep;
import org.eclipse.aperi.disk.collection.step.RemoveDBReferencesStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;

public class ProbeESSSubsystemProcess
extends ProbeGenericArraySubsystemProcess {
    public ProbeESSSubsystemProcess() {
        super("collectDataFromStorageSubsystem", false);
    }

    public ProbeESSSubsystemProcess(String string, boolean bl) {
        super(string, bl);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        DiscoverProcess.RegistrationData[] registrationDataArray = IBMDeviceRegistrationDataHelper.generateDS8kRegistrationData("collectDataFromStorageSubsystem", null);
        DiscoverProcess.RegistrationData[] registrationDataArray2 = IBMDeviceRegistrationDataHelper.generateDS6kRegistrationData("collectDataFromStorageSubsystem", null);
        DiscoverProcess.RegistrationData[] registrationDataArray3 = IBMDeviceRegistrationDataHelper.generateESSRegistrationData("collectDataFromStorageSubsystem", null);
        DiscoverProcess.RegistrationData[] registrationDataArray4 = new DiscoverProcess.RegistrationData[registrationDataArray.length + registrationDataArray2.length + registrationDataArray3.length];
        System.arraycopy(registrationDataArray, 0, registrationDataArray4, 0, registrationDataArray.length);
        System.arraycopy(registrationDataArray2, 0, registrationDataArray4, registrationDataArray.length, registrationDataArray2.length);
        System.arraycopy(registrationDataArray3, 0, registrationDataArray4, registrationDataArray.length + registrationDataArray2.length, registrationDataArray3.length);
        return registrationDataArray4;
    }

    public IStep getStepCollectNodesFromComputerSystem(DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep("collectNodesFromComputerSystem", "CIM_ComputerSystemNodes", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        return discoverStep;
    }

    public IStep getStepCollectExtentData(DiskCIMProcessor diskCIMProcessor, CapabilityData capabilityData, IStep iStep, LogTraceHelper logTraceHelper) {
        COPCacheStep cOPCacheStep = new COPCacheStep("CIM_StorageExtent", diskCIMProcessor, true);
        DiscoverStep discoverStep = new DiscoverStep("collectExtentData_StorageVolume_Names", "CIM_StorageVolume", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StorageVolume"}, diskCIMProcessor);
        CommitStep commitStep = new CommitStep(diskCIMProcessor);
        if (capabilityData.getDiskData() == 1) {
            cOPCacheStep.addNextStep(iStep);
        }
        cOPCacheStep.addNextStep((IStep)discoverStep);
        cOPCacheStep.addNextStep(removeDBReferencesStep);
        cOPCacheStep.addNextStep((IStep)commitStep);
        return cOPCacheStep;
    }

    protected boolean runPreprocess(Map map, String string) {
        Router.getRouter().perform("CIMOMDowngradePopProcessESS11toESS103", map, string);
        return true;
    }

    public IStep getStepCollectDiskDriveFromStorageSubsystem(DiskCIMProcessor diskCIMProcessor, COPCacheStep cOPCacheStep, IStep iStep, LogTraceHelper logTraceHelper) {
        IStep iStep2 = super.getStepCollectDiskDriveFromStorageSubsystem(diskCIMProcessor, cOPCacheStep, iStep, logTraceHelper);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        HashMap<String, Hashtable<String, String>> hashMap = new HashMap<String, Hashtable<String, String>>();
        hashtable.put("ref_storagepool_id", "-1");
        hashMap.put("CIM_StoragePool", hashtable);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StoragePool"}, diskCIMProcessor, hashMap);
        removeDBReferencesStep.addNextStep(iStep2);
        return removeDBReferencesStep;
    }
}

