/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.SimpleCIMDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.DiskProgressLogger;
import org.eclipse.aperi.disk.collection.SubsystemPostCollectionProcess;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.collection.step.CommitStep;
import org.eclipse.aperi.disk.collection.step.FilterPrimordialStep;
import org.eclipse.aperi.disk.collection.step.PersistStorageSettingForVolume;
import org.eclipse.aperi.disk.collection.step.RemoveDBReferencesStep;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.collection.step.StorageExtentCacheStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.discovery.SubSystemDeletion;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.smis.CIMNames;

public abstract class ProbeGenericSubsystemProcess
extends DiscoverProcess
implements CIMNames,
DiscoveryConstants {
    protected static final String COLLECTNODESFROMCOMPUTERSYSTEM = "collectNodesFromComputerSystem";
    protected static final String COLLECTFCPORTSFROMCOMPUTERSYSTEM = "collectFCPortsFromComputerSystem";
    protected static final String COLLECTVOLUMESFROMCOMPUTERSYSTEM = "collectVolumessFromComputerSystem";
    protected static final String COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES = "collectExtentData_StorageVolume_Names";
    protected static final String COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES_CONCRETE_DEPENDENCY = "collectExtentData_StorageVolume_Names_Concrete_Dependency";
    protected static final String COLLECTFCPORTSFROMNODE = "collectFCPortsFromNode";
    protected static final String COLLECTPOOLSFROMCOMPUTERSYSTEM = "collectPoolsFromComputerSystem";
    protected static final String COLLECTCAPABILITIESFROMPOOLS = "collectCapabilitiesFromPools";
    protected static final String COLLECT_EXTENTS_FROM_POOL = "collectExtentsFromPool";
    protected static final String COLLECT_EXTENTS_FROM_RANKPOOL = "collectExtentsFromRankPool";
    protected static final String COLLECT_SUB1EXTENTS_FROM_EXTENT = "collectSub1ExtentsFromExtent";
    protected static final String COLLECT_SUB2EXTENTS_FROM_SUB1EXTENT = "collectSub2ExtentsFromSub1Extent";
    protected static final String COLLECT_SUB3EXTENTS_FROM_SUB2EXTENT = "collectSub3ExtentsFromSub2Extent";
    protected static final String COLLECT_DISKEXTENTS_FROM_SUB2EXTENT = "collectDiskExtentsFromSub2Extent";
    protected static final String COLLECT_DISKEXTENTS_FROM_SUB3EXTENT = "collectDiskExtentsFromSub3Extent";
    protected static final String COLLECT_DISKEXTENTS_FROM_RANKEXTENT = "collectDiskExtentsFromRankExtent";
    protected static final String COLLECT_ARRAYEXTENTS_FROM_RANKEXTENT = "collectArrayExtentsFromRankExtent";
    protected static final String COLLECT_ARRAYSITEEXTENTS_FROM_ARRAYEXTENT = "collectArraySiteExtentsFromArrayExtent";
    protected static final String COLLECT_DISKEXTENTS_FROM_ARRAYSITEEXTENT = "collectDiskExtentsFromArraySiteExtent";
    protected static final String COLLECT_EXTENT_FOR_DISKDRIVE = "collectExtentForDiskDrive";
    protected static final String COLLECT_EXTENTDATA_DISKDRIVES = "collectExtentData_DiskDrives";
    protected static final String COLLECT_DISKEXTENTDATA_DISKDRIVES = "collectDiskExtentData_DiskDrives";
    protected static final String COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM = "collectDiskDrivesFromStorageSubsystem";
    protected static final String COLLECT_DISKDRIVEDATA_PHYSICALPACKAGE = "collectDiskDriveData_PhysicalPackage";
    protected static final String COLLECT_DISKDRIVEDATAL_PHYSICALMEDIA = "collectExtentDataForPool_PhysicalMedia";
    protected static final String COLLECTEXTENTDATAFORPOOL_STORAGEVOLUME = "collectExtentDataForPool_StorageVolume";
    protected static final String COLLECTVOLUMESETTINGS = "collectVolumeSettings";
    protected static final String COLLECTVOLUMESETTINGS_VOLUME = "collectVolumeSettingData_Volume";
    protected static final String COLLECT_VOLUMES_FROM_POOL = "collectVolumesFromPool";
    protected static final String COLLECT_POOL_FROM_POOL = "collectPoolFromConcretePool";
    protected static final String COLLECTCLIENTSETTINGDATAFROMCOMPUTERSYSTEM = "collectClientSettingDataFromComputerSystem";
    protected static final String SUBSYSTEMPOSTCOLLECTIONPROCESS = "SubsystemPostCollectionProcess";
    protected String cProbeProgressVolumeStart;
    protected String cProbeProgressVolumeProgress;
    protected String cProbeProgressVolumeTotal;

    public static void registerSteps(IDiscoverRouterService iDiscoverRouterService) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11;
        Class<?> clazz12;
        Class<?> clazz13;
        Class<?> clazz14;
        Class<?> clazz15;
        Class<?> clazz16;
        Class<?> clazz17;
        Class<?> clazz18;
        Class<?> clazz19;
        Class<?> clazz20;
        Class<?> clazz21;
        Class<?> clazz22;
        Class<?> clazz23;
        Class<?> clazz24;
        Class<?> clazz25;
        Class<?> clazz26;
        Class<?> clazz27;
        Class<?> clazz28;
        Class<?> clazz29;
        Class<?> clazz30;
        try {
            clazz30 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTNODESFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Nodes From ComputerSystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ComponentCS", (String)"CIM_ComputerSystem", null, null), "CIM_ComputerSystem", clazz30.getName(), false));
        try {
            clazz29 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTFCPORTSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect FCPorts From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_FCPort", null, null), "CIM_ComputerSystem", clazz29.getName(), false));
        try {
            clazz28 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTVOLUMESFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Volumes From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_StorageVolume", null, null), "CIM_ComputerSystem", clazz28.getName(), false));
        try {
            clazz27 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES, (IDiscoverProcess)new AssociatorCIMQuery("Collect Extent Data: StorageVolume (Names)", Query.associatorNames((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageVolume", null, null), "CIM_StorageExtent", clazz27.getName(), false));
        try {
            clazz26 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES_CONCRETE_DEPENDENCY, (IDiscoverProcess)new AssociatorCIMQuery("Collect Extent Data: StorageVolume (Names) via Concrete Dependency", Query.associatorNames((String)"CIM_StorageExtent", (String)"CIM_ConcreteDependency", (String)"CIM_StorageVolume", null, null), "CIM_StorageExtent", clazz26.getName(), false));
        try {
            clazz25 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTFCPORTSFROMNODE, (IDiscoverProcess)new AssociatorCIMQuery("Collect FCPorts From Node", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_FCPort", null, null), "CIM_ComputerSystemNodes", clazz25.getName(), false));
        try {
            clazz24 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTPOOLSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Pools From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_HostedStoragePool", (String)"CIM_StoragePool", null, null), "CIM_ComputerSystem", clazz24.getName(), false));
        try {
            clazz23 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTCAPABILITIESFROMPOOLS, (IDiscoverProcess)new AssociatorCIMQuery("Collect Capabilities From Pools", Query.associators((String)"CIM_StoragePool", (String)"CIM_ElementCapabilities", (String)"CIM_StorageCapabilities", null, null), "CIM_StoragePool", clazz23.getName(), false));
        try {
            clazz22 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_VOLUMES_FROM_POOL, (IDiscoverProcess)new AssociatorCIMQuery("Collect Volumes From Pools", Query.associators((String)"CIM_StoragePool", (String)"CIM_AllocatedFromStoragePool", (String)"CIM_StorageVolume", null, null), "CIM_StoragePool", clazz22.getName(), false));
        try {
            clazz21 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_POOL_FROM_POOL, (IDiscoverProcess)new AssociatorCIMQuery("Collect Pools From Concretepools", Query.associators((String)"CIM_StoragePool", (String)"CIM_AllocatedFromStoragePool", (String)"CIM_StoragePool", (String)"Dependent", (String)"Antecedent"), "CIM_StoragePool", clazz21.getName(), false));
        try {
            clazz20 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_EXTENTS_FROM_POOL, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageExtents from Pool", Query.associators((String)"CIM_StoragePool", (String)"CIM_ConcreteComponent", (String)"CIM_StorageExtent", null, null), "CIM_StoragePool", clazz20.getName(), false));
        try {
            clazz19 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_EXTENT_FOR_DISKDRIVE, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageExtents for DiskDrive", Query.associators((String)"CIM_DiskDrive", (String)"CIM_MediaPresent", (String)"CIM_StorageExtent", null, null), "CIM_DiskDrive", clazz19.getName(), false));
        try {
            clazz18 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_EXTENTDATA_DISKDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect ExtentData: DiskDrives", Query.associators((String)"CIM_StorageExtent", (String)"CIM_MediaPresent", (String)"CIM_DiskDrive", null, null), "CIM_StorageExtent", clazz18.getName(), false));
        try {
            clazz17 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_DISKEXTENTDATA_DISKDRIVES, (IDiscoverProcess)new AssociatorCIMQuery("Collect DiskExtentData: DiskDrives ", Query.associators((String)"CIM_StorageExtent", (String)"CIM_MediaPresent", (String)"CIM_DiskDrive", null, null), "CIM_DiskStorageExtent", clazz17.getName(), false));
        try {
            clazz16 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_DISKDRIVEDATA_PHYSICALPACKAGE, (IDiscoverProcess)new AssociatorCIMQuery("Collect ExtentData: PhysicalPackage", Query.associators((String)"CIM_DiskDrive", (String)"CIM_Realizes", (String)"CIM_PhysicalPackage", null, null), "CIM_DiskDrive", clazz16.getName(), false));
        try {
            clazz15 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_DISKDRIVEDATAL_PHYSICALMEDIA, (IDiscoverProcess)new AssociatorCIMQuery("Collect ExtentData: PhysicalMedia", Query.associators((String)"CIM_PhysicalPackage", (String)"CIM_PackagedComponent", (String)"CIM_PhysicalMedia", null, null), "CIM_PhysicalPackage", clazz15.getName(), false));
        try {
            clazz14 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect DiskDrives from StorageSubsystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_DiskDrive", null, null), "CIM_ComputerSystem", clazz14.getName(), false));
        try {
            clazz13 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_EXTENTS_FROM_RANKPOOL, (IDiscoverProcess)new AssociatorCIMQuery("Collect StorageExtents from RankPool", Query.associators((String)"CIM_StoragePool", (String)"CIM_ConcreteComponent", (String)"CIM_StorageExtent", null, null), "CIM_RankStoragePool", clazz13.getName(), false));
        try {
            clazz12 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_DISKEXTENTS_FROM_RANKEXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect DiskExtents from RankExtents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_StorageExtent", clazz12.getName(), false));
        try {
            clazz11 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_ARRAYEXTENTS_FROM_RANKEXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect ArrayExtents from RankExtents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_StorageExtent", clazz11.getName(), false));
        try {
            clazz10 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_ARRAYSITEEXTENTS_FROM_ARRAYEXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect ArraySiteExtents from ArrayExtents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_ArrayStorageExtent", clazz10.getName(), false));
        try {
            clazz9 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_DISKEXTENTS_FROM_ARRAYSITEEXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect DiskExtents from ArraySiteExtents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_ArraySiteStorageExtent", clazz9.getName(), false));
        try {
            clazz8 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_SUB1EXTENTS_FROM_EXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect Sub1Extents from Extents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_StorageExtent", clazz8.getName(), false));
        try {
            clazz7 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_SUB2EXTENTS_FROM_SUB1EXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect Sub2Extents from Sub1Extents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_Sub1StorageExtent", clazz7.getName(), false));
        try {
            clazz6 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_SUB3EXTENTS_FROM_SUB2EXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect Sub3Extents from Sub2Extents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_Sub2StorageExtent", clazz6.getName(), false));
        try {
            clazz5 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_DISKEXTENTS_FROM_SUB2EXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect DiskExtents from Sub2Extents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_Sub2StorageExtent", clazz5.getName(), false));
        try {
            clazz4 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECT_DISKEXTENTS_FROM_SUB3EXTENT, (IDiscoverProcess)new AssociatorCIMQuery("Collect DiskExtents from Sub3Extents", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageExtent", (String)"Dependent", (String)"Antecedent"), "CIM_Sub3StorageExtent", clazz4.getName(), false));
        try {
            clazz3 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTEXTENTDATAFORPOOL_STORAGEVOLUME, (IDiscoverProcess)new AssociatorCIMQuery("Collect Extent Data for Pool: StorageVolume", Query.associators((String)"CIM_StorageExtent", (String)"CIM_BasedOn", (String)"CIM_StorageVolume", null, null), "CIM_StorageExtent", clazz3.getName(), false));
        iDiscoverRouterService.addProcess(COLLECTVOLUMESETTINGS, (IDiscoverProcess)new SimpleCIMDiscoverProcess("Collect Volume Settings", false, new Query[]{Query.enumerateInstancesQuery((String)"CIM_StorageSetting")}, false));
        try {
            clazz2 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTVOLUMESETTINGS_VOLUME, (IDiscoverProcess)new AssociatorCIMQuery("Collect Volume COP for Setting", Query.associatorNames((String)"CIM_StorageSetting", (String)"CIM_ElementSettingData", (String)"CIM_StorageVolume", null, null), "CIM_StorageSetting", clazz2.getName(), false));
        try {
            clazz = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        iDiscoverRouterService.addProcess(COLLECTCLIENTSETTINGDATAFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect Client Setting Data From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_ElementSettingData", (String)"CIM_StorageClientSettingData", null, null), "CIM_ComputerSystem", clazz.getName(), false));
        iDiscoverRouterService.addProcess(SUBSYSTEMPOSTCOLLECTIONPROCESS, (IDiscoverProcess)new SubsystemPostCollectionProcess());
    }

    public ProbeGenericSubsystemProcess(String string, boolean bl) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        String[] stringArray = new String[8];
        try {
            clazz8 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz8.getName();
        try {
            clazz7 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz7.getName();
        try {
            clazz6 = Class.forName("[Ljava.lang.String;");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[2] = clazz6.getName();
        try {
            clazz5 = Class.forName("org.eclipse.aperi.infrastructure.database.objects.CapabilityData");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[3] = clazz5.getName();
        try {
            clazz4 = Class.forName("org.sblim.wbem.cim.CIMObjectPath");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[4] = clazz4.getName();
        try {
            clazz3 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[5] = clazz3.getName();
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[6] = clazz2.getName();
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[7] = clazz.getName();
        super(string, bl, new String[]{"DEVICEID", "SUBSYSTEMID", "CIMOM", "CAPABILITY", "TL_CS", "MODEL", "VENDOR", "CIMOMSWLVL"}, stringArray);
        this.cProbeProgressVolumeStart = "HWN021731I";
        this.cProbeProgressVolumeProgress = "HWN021732I";
        this.cProbeProgressVolumeTotal = "HWN021733I";
    }

    protected boolean supportsSubProfile(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens() && !bl) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equalsIgnoreCase(string2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public IStep getStepCollectPoolsFromComputerSystem(DiskCIMProcessor diskCIMProcessor, CapabilityData capabilityData, String string, LogTraceHelper logTraceHelper) {
        Object object;
        SimpleStep simpleStep = new SimpleStep();
        COPCacheStep cOPCacheStep = null;
        IStep iStep = null;
        IStep iStep2 = null;
        if (capabilityData.getDiskData() == 1) {
            cOPCacheStep = new COPCacheStep("CIM_DiskDrive", diskCIMProcessor, false);
            object = new DiskProgressLogger(logTraceHelper, string, "HWN021734I", "HWN021735I", "HWN021736I", null);
            object.enableHierarchicalMode();
            simpleStep.setProgressLogger((IProgressLogger)object);
            cOPCacheStep.setProgressLogger((IProgressLogger)new ProgressLogger.InnerProgressLogger((ProgressLogger)object));
            iStep = capabilityData.getSmisSubProfiles().indexOf("DDL") != -1 ? this.getStepCollectDiskDriveLiteData(diskCIMProcessor, cOPCacheStep) : this.getStepCollectDiskDriveData(diskCIMProcessor, cOPCacheStep);
            iStep2 = this.getStepCollectDiskDriveFromExtent(diskCIMProcessor, iStep, logTraceHelper);
        }
        object = this.getStepCollectExtentData(diskCIMProcessor, capabilityData, iStep2, logTraceHelper);
        DiscoverStep discoverStep = new DiscoverStep(COLLECTPOOLSFROMCOMPUTERSYSTEM, "CIM_StoragePool", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECTCAPABILITIESFROMPOOLS, null, (CIMProcessor)diskCIMProcessor, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StoragePool"}, diskCIMProcessor);
        CommitStep commitStep = new CommitStep(diskCIMProcessor);
        simpleStep.addNextStep((IStep)discoverStep);
        discoverStep.addNextStep((IStep)discoverStep2);
        DiscoverStep discoverStep3 = (DiscoverStep)this.getStepCollectVolumesFromPool(diskCIMProcessor, logTraceHelper);
        discoverStep.addNextStep((IStep)discoverStep3);
        discoverStep.addNextStep((IStep)commitStep);
        discoverStep.addNextStep(this.getStepCollectExtentsFromPool(diskCIMProcessor, (IStep)object, logTraceHelper));
        if (capabilityData.getExtentData() == 1) {
            simpleStep.addNextStep(this.getStepCollectVolume2ExtentFromPrimordialPool(diskCIMProcessor, logTraceHelper));
        }
        if (capabilityData.getDiskData() == 1) {
            simpleStep.addNextStep(this.getStepCollectDiskDriveFromStorageSubsystem(diskCIMProcessor, cOPCacheStep, (IStep)object, logTraceHelper));
        }
        discoverStep.addNextStep((IStep)removeDBReferencesStep);
        discoverStep.addNextStep((IStep)commitStep);
        DiskProgressLogger diskProgressLogger = new DiskProgressLogger(logTraceHelper, string, this.cProbeProgressVolumeStart, this.cProbeProgressVolumeProgress, this.cProbeProgressVolumeTotal, null);
        diskProgressLogger.enableHierarchicalMode();
        discoverStep.setProgressLogger((IProgressLogger)diskProgressLogger);
        discoverStep3.setProgressLogger((IProgressLogger)new ProgressLogger.InnerProgressLogger((ProgressLogger)diskProgressLogger));
        return simpleStep;
    }

    public IStep getStepCollectVolumeSettings(DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECTVOLUMESETTINGS, "CIM_StorageSetting", null, logTraceHelper);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECTVOLUMESETTINGS_VOLUME, "CIM_StorageVolume", null, logTraceHelper);
        PersistStorageSettingForVolume persistStorageSettingForVolume = new PersistStorageSettingForVolume(diskCIMProcessor);
        CommitStep commitStep = new CommitStep(diskCIMProcessor);
        discoverStep.addNextStep((IStep)discoverStep2);
        discoverStep2.addNextStep((IStep)persistStorageSettingForVolume);
        discoverStep.addNextStep((IStep)commitStep);
        return discoverStep;
    }

    public IStep getStepCollectVolumesFromPool(DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_VOLUMES_FROM_POOL, "CIM_StorageVolume", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StorageVolume"}, diskCIMProcessor);
        discoverStep.addNextStep((IStep)removeDBReferencesStep);
        return discoverStep;
    }

    public IStep getStepCollectExtentsFromPool(DiskCIMProcessor diskCIMProcessor, IStep iStep, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_EXTENTS_FROM_POOL, "CIM_StorageExtent", null, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StorageExtent", "CIM_StorageVolume"}, diskCIMProcessor);
        discoverStep.addNextStep(iStep);
        discoverStep.addNextStep((IStep)removeDBReferencesStep);
        return discoverStep;
    }

    public IStep getStepCollectExtentData(DiskCIMProcessor diskCIMProcessor, CapabilityData capabilityData, IStep iStep, LogTraceHelper logTraceHelper) {
        StorageExtentCacheStep storageExtentCacheStep = new StorageExtentCacheStep("CIM_StorageExtent", diskCIMProcessor, true);
        CommitStep commitStep = new CommitStep(diskCIMProcessor);
        if (capabilityData.getDiskData() == 1) {
            storageExtentCacheStep.addNextStep(iStep);
        }
        if (capabilityData.getExtentData() == 1) {
            storageExtentCacheStep.addCollectVolumesStep(this.getStepCollectVolumeCOPFromExtent(diskCIMProcessor, logTraceHelper));
        } else {
            storageExtentCacheStep.addCollectVolumesStep((IStep)commitStep);
        }
        storageExtentCacheStep.addNextStep((IStep)commitStep);
        return storageExtentCacheStep;
    }

    public IStep getStepCollectDiskDriveFromExtent(DiskCIMProcessor diskCIMProcessor, IStep iStep, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_EXTENTDATA_DISKDRIVES, "CIM_DiskDrive", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_DiskDrive"}, diskCIMProcessor);
        discoverStep.addNextStep(iStep);
        discoverStep.addNextStep((IStep)removeDBReferencesStep);
        return discoverStep;
    }

    public IStep getStepCollectDiskDriveFromStorageSubsystem(DiskCIMProcessor diskCIMProcessor, COPCacheStep cOPCacheStep, IStep iStep, LogTraceHelper logTraceHelper) {
        SimpleStep simpleStep = new SimpleStep();
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM, "CIM_DiskDrive", null, logTraceHelper);
        COPCacheStep cOPCacheStep2 = new COPCacheStep(cOPCacheStep, false);
        cOPCacheStep2.setCacheReadOnly(true);
        discoverStep.addNextStep((IStep)cOPCacheStep2);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECT_EXTENT_FOR_DISKDRIVE, "CIM_StorageExtent", null, logTraceHelper);
        cOPCacheStep2.addNextStep((IStep)discoverStep2);
        discoverStep2.addNextStep(iStep);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StorageExtent", "CIM_StorageVolume"}, diskCIMProcessor);
        cOPCacheStep2.addNextStep(removeDBReferencesStep);
        DiscoverStep discoverStep3 = new DiscoverStep(COLLECT_DISKDRIVES_FROM_STORAGESUBSYSTEM, "CIM_DiskDrive", null, logTraceHelper);
        COPCacheStep cOPCacheStep3 = new COPCacheStep(cOPCacheStep, true);
        IStep iStep2 = this.getStepCollectDiskDriveData(diskCIMProcessor, cOPCacheStep);
        CommitStep commitStep = new CommitStep(diskCIMProcessor);
        discoverStep3.addNextStep((IStep)cOPCacheStep3);
        cOPCacheStep3.addNextStep(iStep2);
        simpleStep.addNextStep((IStep)discoverStep);
        simpleStep.addNextStep((IStep)discoverStep3);
        simpleStep.addNextStep((IStep)commitStep);
        return simpleStep;
    }

    public IStep getStepCollectDiskDriveData(DiskCIMProcessor diskCIMProcessor, COPCacheStep cOPCacheStep) {
        COPCacheStep cOPCacheStep2 = new COPCacheStep(cOPCacheStep);
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_DISKDRIVEDATA_PHYSICALPACKAGE, "CIM_PhysicalPackage", (CIMProcessor)diskCIMProcessor);
        new COPCacheStep("CIM_PhysicalPackage", diskCIMProcessor, true);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECT_DISKDRIVEDATAL_PHYSICALMEDIA, null, (CIMProcessor)diskCIMProcessor);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_PhysicalPackage", "CIM_PhysicalMedia"}, diskCIMProcessor);
        cOPCacheStep2.addNextStep((IStep)discoverStep);
        discoverStep.addNextStep((IStep)discoverStep2);
        cOPCacheStep2.addNextStep(removeDBReferencesStep);
        return cOPCacheStep2;
    }

    public IStep getStepCollectDiskDriveLiteData(DiskCIMProcessor diskCIMProcessor, COPCacheStep cOPCacheStep) {
        COPCacheStep cOPCacheStep2 = new COPCacheStep(cOPCacheStep);
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_DISKDRIVEDATA_PHYSICALPACKAGE, "CIM_PhysicalPackage", (CIMProcessor)diskCIMProcessor);
        new COPCacheStep("CIM_PhysicalPackage", diskCIMProcessor, true);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_PhysicalPackage", "CIM_PhysicalMedia"}, diskCIMProcessor);
        cOPCacheStep2.addNextStep((IStep)discoverStep);
        cOPCacheStep2.addNextStep(removeDBReferencesStep);
        return cOPCacheStep2;
    }

    public IStep getStepCollectVolume2ExtentFromPrimordialPool(DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECTPOOLSFROMCOMPUTERSYSTEM, "CIM_StoragePool", null, logTraceHelper);
        FilterPrimordialStep filterPrimordialStep = new FilterPrimordialStep("CIM_StoragePool");
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECT_EXTENTS_FROM_POOL, "CIM_StorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StorageExtent", "CIM_StorageVolume"}, diskCIMProcessor);
        IStep iStep = this.getStepCollectVolumeCOPFromExtent(diskCIMProcessor, logTraceHelper);
        discoverStep.addNextStep((IStep)filterPrimordialStep);
        filterPrimordialStep.addNextPrimordialStep((IStep)discoverStep2);
        filterPrimordialStep.addNextPrimordialStep(removeDBReferencesStep);
        discoverStep2.addNextStep(iStep);
        return discoverStep;
    }

    public IStep getStepCollectVolumeCOPFromExtent(DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES, "CIM_StorageVolume", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECT_EXTENTDATA_STORAGEVOLUME_NAMES_CONCRETE_DEPENDENCY, "CIM_StorageVolume", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StorageVolume"}, diskCIMProcessor);
        SimpleStep simpleStep = new SimpleStep();
        simpleStep.addNextStep((IStep)discoverStep);
        simpleStep.addNextStep((IStep)discoverStep2);
        simpleStep.addNextStep((IStep)removeDBReferencesStep);
        return simpleStep;
    }

    public String getScannerId(Map map) throws ParameterException {
        String string = "PS1";
        String[] stringArray = (String[])map.get("CIMOM");
        if (stringArray == null || stringArray.length < 1) {
            throw new ParameterException("Missing parameter: CIMOM");
        }
        String string2 = stringArray[0];
        String string3 = (String)map.get("DEVICEID");
        if (string3 == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        String string4 = String.valueOf(string) + ":" + string2 + "+" + string3;
        return string4;
    }

    public int getAuthoritativeReferenceType(Map map) throws ParameterException {
        return 1;
    }

    public int getAuthoritativeReferenceId(Map map) throws ParameterException {
        String string = (String)map.get("DEVICEID");
        if (string == null) {
            throw new ParameterException("Missing parameter: DEVICEID");
        }
        return Integer.parseInt(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int setCollectionStatus(String string, int n, boolean bl, boolean bl2) throws Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)"ProbeGenericSubsystemProcess", (String)"setCollectionStatus", (Object[])new Object[]{string, new Integer(n), new Boolean(bl), new Boolean(bl2)});
        String string2 = string;
        int n2 = -1;
        Timestamp timestamp = null;
        DBConnection dBConnection = null;
        StorageSubsystem storageSubsystem = null;
        try {
            try {
                int n3;
                dBConnection = ServiceUtils.getConnection();
                storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string2, (DBConnection)dBConnection);
                n2 = storageSubsystem.getCollectionStatus();
                String string3 = storageSubsystem.getProbeStatus();
                if (bl) {
                    n2 &= 0xFFFFFFF8;
                    n3 = n & 7;
                    n2 |= n3;
                    switch (n3) {
                        case 0: {
                            string3 = "0";
                            timestamp = new Timestamp(System.currentTimeMillis());
                            break;
                        }
                        case 1: {
                            string3 = "1";
                            timestamp = new Timestamp(System.currentTimeMillis());
                            break;
                        }
                        case 2: {
                            string3 = "0";
                            break;
                        }
                        case 3: {
                            string3 = "3";
                            break;
                        }
                    }
                }
                if (bl2) {
                    n2 &= 0xFFFFFFC7;
                    n3 = n & 0x38;
                    n2 |= n3;
                    switch (n3) {
                        case 0: {
                            string3 = "0";
                            timestamp = new Timestamp(System.currentTimeMillis());
                            break;
                        }
                        case 8: {
                            string3 = "1";
                            timestamp = new Timestamp(System.currentTimeMillis());
                            break;
                        }
                        case 16: {
                            string3 = "0";
                            break;
                        }
                        case 24: {
                            string3 = "3";
                            break;
                        }
                    }
                }
                if (n2 == 0) {
                    string3 = "2";
                }
                StorageSubsystem storageSubsystem2 = new StorageSubsystem();
                storageSubsystem2.setName(storageSubsystem.getName());
                storageSubsystem2.setNameFormat(storageSubsystem.getNameFormat());
                storageSubsystem2.setCollectionStatus(n2);
                storageSubsystem2.setProbeStatus(string3);
                if (timestamp != null) {
                    storageSubsystem2.setLastProbeTime(timestamp);
                }
                storageSubsystem2.update(dBConnection);
                dBConnection.commit();
            }
            catch (SQLException sQLException) {
                dBConnection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                dBConnection.rollback();
                throw new Exception(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                dBConnection.close();
            }
            catch (Exception exception) {}
            logTraceHelper.exit((Object)new Integer(n2));
            throw throwable;
        }
        {
            Object var12_17 = null;
        }
        try {}
        catch (Exception exception) {}
        dBConnection.close();
        logTraceHelper.exit((Object)new Integer(n2));
        return n2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String checkAndHandleMigratedSubsystem(String string) throws Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"checkAndHandleMigratedSubsystem", (Object[])new Object[]{string});
        String string2 = string;
        int n = -1;
        boolean bl = false;
        DBConnection dBConnection = null;
        StorageSubsystem storageSubsystem = null;
        try {
            SubSystemDeletion subSystemDeletion;
            Result result;
            dBConnection = ServiceUtils.getConnection();
            storageSubsystem = ExternalKeyManager.getStorageSubsystem((String)string2, (DBConnection)dBConnection);
            dBConnection.commit();
            n = storageSubsystem.getCollectionStatus();
            boolean bl2 = bl = (n & 0x80) == 128;
            if (bl && (result = (subSystemDeletion = new SubSystemDeletion()).cleanupMigratedStorageSubsystem(string)).getMessage().equals("HWN021672E")) {
                logTraceHelper.traceError("HWN021672E", (Throwable)DiskMessageHelper.getServerException((String)"HWN021672E", (Object)string, (LogTraceHelper)logTraceHelper));
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            dBConnection.close();
            logTraceHelper.exit((Object)(bl ? "1" : "0"));
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        dBConnection.close();
        logTraceHelper.exit((Object)(bl ? "1" : "0"));
        if (!bl) return "0";
        return "1";
    }
}

