/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.CIMDiskManagement;
import org.eclipse.aperi.disk.common.CIM.PrivilegeManagement;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DBHelperCreateAndUpdate;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.IDGenerator;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationResultHelper;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.ProtocolControllerToPrivileges;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class MappingManagement
extends CIMDiskManagement {
    private CIMObjectPath cControllerConfigurationService = null;
    protected CapabilityData cCapablities;
    private HashMap cFCPortsOfProtocolController = new HashMap();
    private HashMap cDeviceNumbersOfProtocolController = new HashMap();

    public MappingManagement(StorageConfigurationPlugin storageConfigurationPlugin, CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, CapabilityData capabilityData, String string, Token token) {
        super(storageConfigurationPlugin, cIMClientWrapper, cIMObjectPath, string, token);
        this.cCapablities = capabilityData;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMObjectPath retrieveAssociatedControllerConfigurationService() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveAssociatedControllerConfigurationService", null);
        try {
            this.cControllerConfigurationService = this.retrieveAssociatedService("CIM_ControllerConfigurationService", "CIM_HostedService", "Antecedent", "Dependent");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit((Object)this.cControllerConfigurationService);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit((Object)this.cControllerConfigurationService);
        return this.cControllerConfigurationService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getDeviceNumbers(CIMObjectPath cIMObjectPath, CIMObjectPath[] cIMObjectPathArray) throws ServerException {
        String[] stringArray;
        LogTraceHelper logTraceHelper;
        block12: {
            String[] stringArray2;
            block11: {
                logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getDeviceNumbers", (Object[])new Object[]{cIMObjectPath, cIMObjectPathArray});
                stringArray = new String[cIMObjectPathArray.length];
                HashMap<CIMObjectPath, String> hashMap = new HashMap<CIMObjectPath, String>();
                try {
                    try {
                        int n;
                        Enumeration enumeration = this.cCimClient.references(cIMObjectPath, "CIM_ProtocolControllerForUnit", null, true, true, null, logTraceHelper);
                        block6: while (true) {
                            if (!enumeration.hasMoreElements()) {
                                if (hashMap.size() == cIMObjectPathArray.length) break;
                                ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)logTraceHelper);
                                logTraceHelper.traceError("CIMOM did not return a ProtocolControllerForUnit for each volume", (Throwable)serverException);
                                stringArray2 = stringArray;
                                Object var11_15 = null;
                                break block11;
                            }
                            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"Dependent");
                            n = 0;
                            while (true) {
                                if (n >= cIMObjectPathArray.length) continue block6;
                                if (cIMObjectPath2.equals((Object)cIMObjectPathArray[n]) && !hashMap.containsKey(cIMObjectPath2)) {
                                    String string = (String)CIMInstanceHelper.getCIMProperyValue((CIMInstance)cIMInstance, (String)"DeviceNumber");
                                    hashMap.put(cIMObjectPathArray[n], string);
                                }
                                ++n;
                            }
                            break;
                        }
                        n = 0;
                        while (n < cIMObjectPathArray.length) {
                            stringArray[n] = (String)hashMap.get(cIMObjectPathArray[n]);
                            ++n;
                        }
                        break block12;
                    }
                    catch (CIMException cIMException) {
                        logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                        throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"references", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                        logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                        throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    logTraceHelper.exit((Object)stringArray);
                    throw throwable;
                }
            }
            logTraceHelper.exit((Object)stringArray);
            return stringArray2;
        }
        Object var11_17 = null;
        logTraceHelper.exit((Object)stringArray);
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllersForStorageHardwareIDs(ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllersForStorageHardwareIDs", (Object[])new Object[]{arrayList, arrayList2});
        ArrayList arrayList3 = null;
        try {
            PrivilegeManagement privilegeManagement = this.cPlugin.getPrivilegeManagement();
            ArrayList arrayList4 = privilegeManagement.retrievePrivilegesForInitiators(arrayList, arrayList2);
            ArrayList arrayList5 = null;
            if (arrayList2 != null) {
                arrayList5 = new ArrayList();
            }
            arrayList3 = this.retrieveProtocolControllersForPrivileges(arrayList4, arrayList5);
            if (arrayList5 != null && !arrayList5.isEmpty()) {
                int n = 0;
                while (n < arrayList5.size()) {
                    PrivilegeToWWPNs privilegeToWWPNs = (PrivilegeToWWPNs)arrayList5.get(n);
                    ArrayList arrayList6 = privilegeToWWPNs.getStorageHardwareIDs();
                    arrayList2.addAll(arrayList6);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        logTraceHelper.exit((Object)arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllersForPrivileges(ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllersForPrivileges", (Object[])new Object[]{arrayList, arrayList2});
        ArrayList<ProtocolControllerToPrivileges> arrayList3 = new ArrayList<ProtocolControllerToPrivileges>();
        try {
            try {
                int n = 0;
                while (n < arrayList.size()) {
                    block14: {
                        Object object;
                        ProtocolControllerToPrivileges protocolControllerToPrivileges;
                        PrivilegeToWWPNs privilegeToWWPNs = (PrivilegeToWWPNs)arrayList.get(n);
                        boolean bl = false;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= arrayList3.size()) {
                                if (!bl) break;
                                break block14;
                            }
                            protocolControllerToPrivileges = (ProtocolControllerToPrivileges)arrayList3.get(n2);
                            bl = protocolControllerToPrivileges.containsPrivilege(privilegeToWWPNs);
                            ++n2;
                        }
                        Enumeration enumeration = this.cCimClient.associatorNames(privilegeToWWPNs.getPrivilege(), null, "CIM_SCSIProtocolController", "Privilege", "TargetElement", this.cLogTraceHelper);
                        if (!enumeration.hasMoreElements()) {
                            if (arrayList2 == null) {
                                object = DiskMessageHelper.getServerException((String)"HWN021614E", privilegeToWWPNs.getWWPNs(), (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                                logTraceHelper.traceError("Privilege has no ProtocolController assigned, its StorageHardwareIDs have no mappings", (Throwable)object);
                                throw object;
                            }
                            arrayList2.add(arrayList.get(n));
                        } else {
                            while (enumeration.hasMoreElements()) {
                                object = (CIMObjectPath)enumeration.nextElement();
                                if (this.validateProtocolController((CIMObjectPath)object) == null) continue;
                                if (((AssignmentParameter)this.cPlugin.getParams()).getCapability().getOneHwIdPerView() != 1) {
                                    ArrayList arrayList4 = this.cPlugin.getPrivilegeManagement().retrievePrivilegesForProtocolController((CIMObjectPath)object, arrayList);
                                    protocolControllerToPrivileges = new ProtocolControllerToPrivileges((CIMObjectPath)object, arrayList4);
                                    arrayList3.add(protocolControllerToPrivileges);
                                    continue;
                                }
                                protocolControllerToPrivileges = new ProtocolControllerToPrivileges((CIMObjectPath)object, (PrivilegeToWWPNs)arrayList.get(n));
                                arrayList3.add(protocolControllerToPrivileges);
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var12_17 = null;
        }
        logTraceHelper.exit(arrayList3);
        return arrayList3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllersForVolumes(CIMObjectPath[] cIMObjectPathArray, ArrayList arrayList) throws ServerException {
        ArrayList<ProtocolControllerToPrivileges> arrayList2;
        LogTraceHelper logTraceHelper;
        block13: {
            ArrayList<ProtocolControllerToPrivileges> arrayList3;
            block12: {
                logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllersForVolumes", (Object[])new Object[]{cIMObjectPathArray, arrayList});
                arrayList2 = new ArrayList<ProtocolControllerToPrivileges>();
                try {
                    try {
                        if (cIMObjectPathArray == null) {
                            arrayList3 = arrayList2;
                            Object var9_6 = null;
                            break block12;
                        }
                        int n = 0;
                        while (n < cIMObjectPathArray.length) {
                            Enumeration enumeration = this.cCimClient.associatorNames(cIMObjectPathArray[n], "CIM_ProtocolControllerForUnit", "CIM_ProtocolController", "Dependent", "Antecedent", this.cLogTraceHelper);
                            if (!enumeration.hasMoreElements()) {
                                if (arrayList == null) {
                                    ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)logTraceHelper);
                                    logTraceHelper.traceError("Volume has no ProtocolControllers. Volume COP: " + cIMObjectPathArray[n], (Throwable)serverException);
                                    throw serverException;
                                }
                                arrayList.add(cIMObjectPathArray[n]);
                            } else {
                                while (enumeration.hasMoreElements()) {
                                    CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                                    if (this.validateProtocolController(cIMObjectPath) == null || arrayList2.contains(new ProtocolControllerToPrivileges(cIMObjectPath))) continue;
                                    arrayList2.add(new ProtocolControllerToPrivileges(cIMObjectPath));
                                }
                            }
                            ++n;
                        }
                        break block13;
                    }
                    catch (CIMException cIMException) {
                        cIMException.printStackTrace();
                        logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                        throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
                    }
                    catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                        logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                        throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    logTraceHelper.exit(arrayList2);
                    throw throwable;
                }
            }
            logTraceHelper.exit(arrayList2);
            return arrayList3;
        }
        Object var9_8 = null;
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveFCPortsOfProtocolController(CIMObjectPath cIMObjectPath) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveFCPortsOfProtocolController", (Object[])new Object[]{cIMObjectPath});
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        try {
            try {
                Enumeration enumeration = this.cCimClient.associators(cIMObjectPath, "CIM_ProtocolControllerForPort", "CIM_FCPort", "Antecedent", "Dependent", true, true, null, this.cLogTraceHelper);
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    arrayList.add(cIMInstance);
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllerForUnit(CIMObjectPath cIMObjectPath) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllerForUnit", (Object[])new Object[]{cIMObjectPath});
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        try {
            try {
                Enumeration enumeration = this.cCimClient.references(cIMObjectPath, "CIM_ProtocolControllerForUnit", "Antecedent", true, true, null, this.cLogTraceHelper);
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    arrayList.add(cIMInstance);
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveStorageVolumeCOPsOfProtocolControllerForUnit(CIMObjectPath cIMObjectPath) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveStorageVolumeCOPsOfProtocolControllerForUnit", (Object[])new Object[]{cIMObjectPath});
        ArrayList<CIMObjectPath> arrayList = new ArrayList<CIMObjectPath>();
        try {
            try {
                Enumeration enumeration = this.cCimClient.associatorNames(cIMObjectPath, "CIM_ProtocolControllerForUnit", "CIM_StorageVolume", null, null, this.cLogTraceHelper);
                while (enumeration.hasMoreElements()) {
                    CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                    arrayList.add(cIMObjectPath2);
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatornames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath[] exposePaths(CapabilityData capabilityData, CIMObjectPath cIMObjectPath, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"exposePaths", (Object[])new Object[]{cIMObjectPath, stringArray, stringArray2, stringArray3, stringArray4});
        CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[1];
        Vector<CIMArgument> vector = new Vector<CIMArgument>();
        Vector vector2 = new Vector();
        try {
            int n;
            if (stringArray != null) {
                vector.add(new CIMArgument("LUNames", new CIMValue((Object)stringArray, CIMDataType.getPredefinedType((int)24))));
            }
            if (stringArray2 != null) {
                vector.add(new CIMArgument("InitiatorPortIDs", new CIMValue((Object)stringArray2, CIMDataType.getPredefinedType((int)24))));
            }
            UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[]{new UnsignedInt16(2)};
            if (stringArray != null) {
                unsignedInt16Array = new UnsignedInt16[stringArray.length];
                n = 0;
                while (true) {
                    if (n >= unsignedInt16Array.length) {
                        vector.add(new CIMArgument("DeviceAccesses", new CIMValue((Object)unsignedInt16Array, CIMDataType.getPredefinedType((int)18))));
                        break;
                    }
                    unsignedInt16Array[n] = new UnsignedInt16(2);
                    ++n;
                }
            }
            if (cIMObjectPath != null) {
                vector.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)new CIMObjectPath[]{cIMObjectPath}, CIMDataType.getPredefinedType((int)30))));
            }
            if (capabilityData.getPortsPerView() != 4 && stringArray3 != null) {
                vector.add(new CIMArgument("TargetPortIDs", new CIMValue((Object)stringArray3, CIMDataType.getPredefinedType((int)24))));
            }
            if (capabilityData.getClntSelctblDevno() == 1 && stringArray4 != null) {
                n = 0;
                while (n < stringArray4.length) {
                    if (stringArray4[n] == null) {
                        stringArray4 = null;
                        break;
                    }
                    ++n;
                }
                if (stringArray4 != null) {
                    vector.add(new CIMArgument("DeviceNumbers", new CIMValue((Object)stringArray4, CIMDataType.getPredefinedType((int)24))));
                }
            }
            this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "ExposePaths", vector, vector2, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            n = 0;
            while (n < vector2.size()) {
                CIMArgument cIMArgument = (CIMArgument)vector2.get(n);
                if (cIMArgument.getName().compareTo("ProtocolControllers") == 0) {
                    cIMObjectPathArray[0] = (CIMObjectPath)((Vector)cIMArgument.getValue().getValue()).elementAt(0);
                }
                if (cIMArgument.getName().compareTo("ProtocolController") == 0) {
                    cIMObjectPathArray[0] = (CIMObjectPath)cIMArgument.getValue().getValue();
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            logTraceHelper.exit((Object)cIMObjectPathArray);
            throw throwable;
        }
        {
            Object var14_16 = null;
        }
        logTraceHelper.exit((Object)cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath[] hidePaths(CIMObjectPath[] cIMObjectPathArray, CapabilityData capabilityData, String[] stringArray, String[] stringArray2, String[] stringArray3) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"hidePaths", (Object[])new Object[]{cIMObjectPathArray, capabilityData, stringArray, stringArray2, stringArray3});
        CIMObjectPath[] cIMObjectPathArray2 = new CIMObjectPath[1];
        Vector<CIMArgument> vector = new Vector<CIMArgument>();
        Vector vector2 = new Vector();
        try {
            if (stringArray2 != null && stringArray2.length != 0) {
                vector.add(new CIMArgument("InitiatorPortIDs", new CIMValue((Object)stringArray2, CIMDataType.getPredefinedType((int)24))));
                vector.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)cIMObjectPathArray, CIMDataType.getPredefinedType((int)30))));
                this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "HidePaths", vector, vector2, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            }
            if (stringArray != null && stringArray.length != 0) {
                vector.clear();
                vector2.clear();
                vector.add(new CIMArgument("LUNames", new CIMValue((Object)stringArray, CIMDataType.getPredefinedType((int)24))));
                vector.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)cIMObjectPathArray, CIMDataType.getPredefinedType((int)30))));
                this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "HidePaths", vector, vector2, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            }
            if (!(stringArray2 != null && stringArray2.length != 0 || stringArray != null && stringArray.length != 0)) {
                vector.add(new CIMArgument("TargetPortIDs", new CIMValue((Object)stringArray3, CIMDataType.getPredefinedType((int)24))));
                vector.add(new CIMArgument("ProtocolControllers", new CIMValue((Object)cIMObjectPathArray, CIMDataType.getPredefinedType((int)30))));
                this.invokeAsyncCIMMethod(this.getControllerConfigurationService(), "HidePaths", vector, vector2, "ProtocolControllers", "CIM_ProtocolController", new Vector());
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMArgument cIMArgument = (CIMArgument)vector2.get(n);
                if (cIMArgument.getName().compareTo("ProtocolControllers") == 0 && cIMArgument.getValue() != null) {
                    Vector vector3 = (Vector)cIMArgument.getValue().getValue();
                    int n2 = 0;
                    while (n2 < vector3.size()) {
                        cIMObjectPathArray2[0] = (CIMObjectPath)vector3.elementAt(n2);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            logTraceHelper.exit((Object)cIMObjectPathArray2);
            throw throwable;
        }
        {
            Object var14_16 = null;
        }
        logTraceHelper.exit((Object)cIMObjectPathArray2);
        return cIMObjectPathArray2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList attachDevices(ProtocolControllerToPrivileges protocolControllerToPrivileges, CIMObjectPath[] cIMObjectPathArray, String[] stringArray, String[] stringArray2, AssignStorageVolumesParameter assignStorageVolumesParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"attachDevices", (Object[])new Object[]{protocolControllerToPrivileges, cIMObjectPathArray, stringArray, stringArray2});
        ArrayList arrayList = new ArrayList();
        String[] stringArray3 = new String[cIMObjectPathArray.length];
        String[] stringArray4 = null;
        int n = 0;
        try {
            try {
                stringArray4 = this.getFCPortWWPNs(protocolControllerToPrivileges.getProtocolController());
                n = 0;
                block5: while (true) {
                    block10: {
                        if (n < cIMObjectPathArray.length) break block10;
                        arrayList.addAll(ConfigurationResultHelper.createMappingResults(protocolControllerToPrivileges.getPrivilegeToWWPNs(), stringArray, stringArray3, stringArray4, protocolControllerToPrivileges.getProtocolController(), this.cToken));
                        assignStorageVolumesParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignStorageVolumesParameter.getAsyncResult(), arrayList, (String)assignStorageVolumesParameter.getAPIMethodName()));
                        break;
                    }
                    Vector<CIMArgument> vector = new Vector<CIMArgument>();
                    Vector vector2 = new Vector();
                    vector.add(new CIMArgument("ProtocolController", new CIMValue((Object)protocolControllerToPrivileges.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                    vector.add(new CIMArgument("Device", new CIMValue((Object)cIMObjectPathArray[n], CIMDataType.getPredefinedType((int)14))));
                    if (this.cCapablities.getClntSelctblDevno() == 1 && stringArray2 != null) {
                        vector.add(new CIMArgument("DeviceNumber", new CIMValue((Object)stringArray2[n], CIMDataType.getPredefinedType((int)8))));
                    }
                    this.invokeCIMMethod(this.getControllerConfigurationService(), "AttachDevice", vector, vector2);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= vector2.size()) {
                            ++n;
                            continue block5;
                        }
                        CIMArgument cIMArgument = (CIMArgument)vector2.get(n2);
                        if (cIMArgument.getName().compareTo("DeviceNumber") == 0) {
                            stringArray3[n] = (String)cIMArgument.getValue().getValue();
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (ServerException serverException) {
                logTraceHelper.traceError("Internal error: ServerException", (Throwable)serverException);
                if (n == 0) throw serverException;
                ConfigurationResultHelper.processPartialMappingFailure(protocolControllerToPrivileges, assignStorageVolumesParameter, arrayList, n - 1, stringArray, stringArray2, stringArray4, serverException, this.cToken);
                throw serverException;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList detachDevices(ProtocolControllerToPrivileges protocolControllerToPrivileges, CIMObjectPath[] cIMObjectPathArray, String[] stringArray, AssignmentParameter assignmentParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"detachDevices", (Object[])new Object[]{protocolControllerToPrivileges, cIMObjectPathArray, stringArray, assignmentParameter});
        ArrayList arrayList = new ArrayList();
        int n = 0;
        try {
            try {
                n = 0;
                while (true) {
                    block6: {
                        if (n < cIMObjectPathArray.length) break block6;
                        arrayList.addAll(ConfigurationResultHelper.createUnMappingResults(protocolControllerToPrivileges.getPrivilegeToWWPNs(), stringArray, this.cToken));
                        assignmentParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignmentParameter.getAsyncResult(), arrayList, (String)assignmentParameter.getAPIMethodName()));
                        break;
                    }
                    Vector<CIMArgument> vector = new Vector<CIMArgument>();
                    Vector vector2 = new Vector();
                    vector.add(new CIMArgument("ProtocolController", new CIMValue((Object)protocolControllerToPrivileges.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
                    vector.add(new CIMArgument("Device", new CIMValue((Object)cIMObjectPathArray[n], CIMDataType.getPredefinedType((int)14))));
                    this.invokeCIMMethod(this.getControllerConfigurationService(), "DetachDevice", vector, vector2);
                    ++n;
                }
            }
            catch (ServerException serverException) {
                logTraceHelper.traceError("Internal error: ServerException", (Throwable)serverException);
                ConfigurationResultHelper.processPartialUnmaskingFailure(protocolControllerToPrivileges.getPrivilegeToWWPNs(), assignmentParameter, arrayList, n - 1, stringArray, serverException, this.cToken);
                throw serverException;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath createProtocolControllerWithPorts(AssignStorageVolumesParameter assignStorageVolumesParameter, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createProtocolControllerWithPorts", (Object[])new Object[]{assignStorageVolumesParameter, cIMObjectPath, cIMObjectPath2});
        CIMObjectPath cIMObjectPath3 = null;
        Vector<CIMArgument> vector = new Vector<CIMArgument>();
        Vector vector2 = new Vector();
        try {
            vector.add(new CIMArgument("ElementName", new CIMValue((Object)IDGenerator.generateUniqueNumericString((int)-1), CIMDataType.getPredefinedType((int)8))));
            vector.add(new CIMArgument("Protocol", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2))));
            if (this.cCapablities.getPortsPerView() != 4 && assignStorageVolumesParameter.getTargetPortCOPs() != null && assignStorageVolumesParameter.getTargetPortCOPs().length != 0) {
                String[] stringArray = this.putCOPsIntoString(assignStorageVolumesParameter.getTargetPortCOPs());
                vector.add(new CIMArgument("Ports", new CIMValue((Object)stringArray, CIMDataType.getPredefinedType((int)24))));
            }
            if (assignStorageVolumesParameter.getCapability().getControllerReqIdentity() == 1) {
                vector.add(new CIMArgument("Identity", new CIMValue((Object)cIMObjectPath, CIMDataType.getPredefinedType((int)14))));
                if (cIMObjectPath2 != null) {
                    vector.add(new CIMArgument("Privilege", new CIMValue((Object)cIMObjectPath2, CIMDataType.getPredefinedType((int)14))));
                }
            }
            this.invokeCIMMethod(this.getControllerConfigurationService(), "CreateProtocolControllerWithPorts", vector, vector2);
            int n = 0;
            while (n < vector2.size()) {
                CIMArgument cIMArgument = (CIMArgument)vector2.get(n);
                if (cIMArgument.getName().compareTo("ProtocolController") == 0) {
                    cIMObjectPath3 = (CIMObjectPath)cIMArgument.getValue().getValue();
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            logTraceHelper.exit(cIMObjectPath3);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        logTraceHelper.exit(cIMObjectPath3);
        return cIMObjectPath3;
    }

    protected String[] putCOPsIntoString(CIMObjectPath[] cIMObjectPathArray) {
        String[] stringArray = new String[cIMObjectPathArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = cIMObjectPathArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList deleteProtocolController(ProtocolControllerToPrivileges protocolControllerToPrivileges, String[] stringArray, AssignmentParameter assignmentParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"deleteProtocolController", (Object[])new Object[]{protocolControllerToPrivileges});
        ArrayList arrayList = new ArrayList();
        try {
            Vector<CIMArgument> vector = new Vector<CIMArgument>();
            Vector vector2 = new Vector();
            vector.add(new CIMArgument("DeleteChildrenProtocolControllers", new CIMValue((Object)new Boolean(false), CIMDataType.getPredefinedType((int)9))));
            vector.add(new CIMArgument("DeleteLogicalUnits", new CIMValue((Object)new Boolean(false), CIMDataType.getPredefinedType((int)9))));
            vector.add(new CIMArgument("ProtocolController", new CIMValue((Object)protocolControllerToPrivileges.getProtocolController(), CIMDataType.getPredefinedType((int)14))));
            this.invokeCIMMethod(this.getControllerConfigurationService(), "DeleteProtocolController", vector, vector2);
            arrayList.addAll(ConfigurationResultHelper.createUnMappingResults(protocolControllerToPrivileges.getPrivilegeToWWPNs(), assignmentParameter.getVolumeIDs(), this.cToken));
            assignmentParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignmentParameter.getAsyncResult(), arrayList, (String)assignmentParameter.getAPIMethodName()));
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveProtocolControllersForMappings(ArrayList arrayList, ArrayList arrayList2, CIMObjectPath[] cIMObjectPathArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveProtocolControllersForMappings", (Object[])new Object[]{arrayList, arrayList2, cIMObjectPathArray});
        ArrayList arrayList3 = null;
        try {
            arrayList3 = this.retrieveProtocolControllersForStorageHardwareIDs(arrayList, arrayList2);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.exit((Object)arrayList3);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        logTraceHelper.exit((Object)arrayList3);
        return arrayList3;
    }

    public ArrayList retrieveProtocolControllersForUnmapping(ArrayList arrayList, CIMObjectPath[] cIMObjectPathArray) throws ServerException {
        return this.retrieveProtocolControllersForMappings(arrayList, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProtocolControllerToPrivileges[] createProtocolControllers(ArrayList arrayList, ConfigurationParameter configurationParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createProtocolControllers", (Object[])new Object[]{arrayList, configurationParameter});
        ProtocolControllerToPrivileges[] protocolControllerToPrivilegesArray = new ProtocolControllerToPrivileges[arrayList.size()];
        try {
            if (arrayList.size() != 0) {
                CIMObjectPath cIMObjectPath = null;
                if (((AssignmentParameter)this.cPlugin.getParams()).getCapability().getControllerReqIdentity() == 1) {
                    cIMObjectPath = this.cPlugin.getPrivilegeManagement().getPrivilege();
                }
                int n = 0;
                while (n < arrayList.size()) {
                    CIMObjectPath cIMObjectPath2 = this.createProtocolControllerWithPorts((AssignStorageVolumesParameter)configurationParameter, ((StorageHardwareID)arrayList.get(n)).getStorageHardwareIDCOP(), cIMObjectPath);
                    protocolControllerToPrivilegesArray[n] = new ProtocolControllerToPrivileges(cIMObjectPath2, new PrivilegeToWWPNs(null, (StorageHardwareID)arrayList.get(n)));
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            logTraceHelper.exit((Object)protocolControllerToPrivilegesArray);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        logTraceHelper.exit((Object)protocolControllerToPrivilegesArray);
        return protocolControllerToPrivilegesArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getProtocolControllersForMappings(ArrayList arrayList, ArrayList arrayList2, AssignStorageVolumesParameter assignStorageVolumesParameter) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getProtocolControllersForMappings", (Object[])new Object[]{arrayList, arrayList2, assignStorageVolumesParameter});
        ArrayList arrayList3 = null;
        try {
            ProtocolControllerToPrivileges[] protocolControllerToPrivilegesArray;
            ArrayList arrayList4 = (ArrayList)arrayList.clone();
            ArrayList<ProtocolControllerToPrivileges[]> arrayList5 = new ArrayList<ProtocolControllerToPrivileges[]>();
            if (!arrayList2.isEmpty()) {
                int n = 0;
                while (n < arrayList2.size()) {
                    protocolControllerToPrivilegesArray = (ProtocolControllerToPrivileges[])arrayList2.get(n);
                    arrayList5.add(protocolControllerToPrivilegesArray);
                    arrayList4.remove(protocolControllerToPrivilegesArray);
                    ++n;
                }
            }
            ArrayList<ProtocolControllerToPrivileges[]> arrayList6 = new ArrayList<ProtocolControllerToPrivileges[]>();
            arrayList3 = this.retrieveProtocolControllersForMappings(arrayList4, arrayList6, assignStorageVolumesParameter.getVolumeCOPs());
            arrayList6.addAll(arrayList5);
            protocolControllerToPrivilegesArray = this.createProtocolControllers(arrayList6, assignStorageVolumesParameter);
            int n = 0;
            while (n < protocolControllerToPrivilegesArray.length) {
                arrayList3.add(protocolControllerToPrivilegesArray[n]);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        logTraceHelper.exit((Object)arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unmapVolumesFromPorts(ArrayList arrayList, AssignmentParameter assignmentParameter, ArrayList arrayList2) throws ServerException {
        DBHelperCreateAndUpdate dBHelperCreateAndUpdate;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"unmapVolumesFromPorts", (Object[])new Object[]{arrayList, assignmentParameter, arrayList2});
        try {
            this.deleteMappings(arrayList, assignmentParameter, arrayList2);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            DBHelperCreateAndUpdate dBHelperCreateAndUpdate2 = new DBHelperCreateAndUpdate(this.cToken);
            dBHelperCreateAndUpdate2.deleteMappings(assignmentParameter.getAsyncResult(), assignmentParameter);
            dBHelperCreateAndUpdate2.close();
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var5_7 = null;
            dBHelperCreateAndUpdate = new DBHelperCreateAndUpdate(this.cToken);
            dBHelperCreateAndUpdate.deleteMappings(assignmentParameter.getAsyncResult(), assignmentParameter);
        }
        dBHelperCreateAndUpdate.close();
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList deleteMappings(ArrayList arrayList, AssignmentParameter assignmentParameter, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"deleteMappings", (Object[])new Object[]{arrayList, assignmentParameter, arrayList2});
        ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
        int n = 0;
        try {
            n = 0;
            while (n < arrayList.size()) {
                ProtocolControllerToPrivileges protocolControllerToPrivileges = (ProtocolControllerToPrivileges)arrayList.get(n);
                ArrayList arrayList4 = this.cPlugin.getVolumeManagement().retrieveVolumesOfProtocolController(protocolControllerToPrivileges.getProtocolController());
                CIMObjectPath[] cIMObjectPathArray = this.checkVolumesOfPC(assignmentParameter.getVolumeCOPs(), arrayList4);
                String[] stringArray = assignmentParameter.getVolumeIDsForCOPs(cIMObjectPathArray);
                if (arrayList4.size() == cIMObjectPathArray.length) {
                    arrayList3.add(this.deleteProtocolController(protocolControllerToPrivileges, stringArray, assignmentParameter));
                } else {
                    arrayList3.add(this.detachDevices(protocolControllerToPrivileges, cIMObjectPathArray, stringArray, assignmentParameter));
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        logTraceHelper.exit(arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mapVolumesToPorts(ArrayList arrayList, AssignStorageVolumesParameter assignStorageVolumesParameter) {
        DBHelperCreateAndUpdate dBHelperCreateAndUpdate;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"mapVolumesToPorts", (Object[])new Object[]{arrayList, assignStorageVolumesParameter});
        try {
            this.createMapping(arrayList, assignStorageVolumesParameter);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            DBHelperCreateAndUpdate dBHelperCreateAndUpdate2 = new DBHelperCreateAndUpdate(this.cToken);
            dBHelperCreateAndUpdate2.createMappings(assignStorageVolumesParameter.getAsyncResult(), assignStorageVolumesParameter);
            dBHelperCreateAndUpdate2.close();
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
            dBHelperCreateAndUpdate = new DBHelperCreateAndUpdate(this.cToken);
            dBHelperCreateAndUpdate.createMappings(assignStorageVolumesParameter.getAsyncResult(), assignStorageVolumesParameter);
        }
        dBHelperCreateAndUpdate.close();
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList createMapping(ArrayList arrayList, AssignStorageVolumesParameter assignStorageVolumesParameter) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createMapping", (Object[])new Object[]{arrayList, assignStorageVolumesParameter});
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        try {
            n = 0;
            while (n < arrayList.size()) {
                ProtocolControllerToPrivileges protocolControllerToPrivileges = (ProtocolControllerToPrivileges)arrayList.get(n);
                arrayList2 = this.attachDevices(protocolControllerToPrivileges, assignStorageVolumesParameter.getVolumeCOPs(), assignStorageVolumesParameter.getVolumeIDs(), assignStorageVolumesParameter.getDeviceNumbers(), assignStorageVolumesParameter);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createMappingExposePathsWithoutProtocolController(AssignStorageVolumesParameter assignStorageVolumesParameter, ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createMappingExposePathsWithoutProtocolController", (Object[])new Object[]{assignStorageVolumesParameter, arrayList, arrayList2});
        try {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            int n = 0;
            while (n < assignStorageVolumesParameter.getInitiatorWWPNsArray().length) {
                if (!arrayList2.contains(assignStorageVolumesParameter.getInitiatorWWPNsArray()[n])) {
                    arrayList3.add(assignStorageVolumesParameter.getInitiatorWWPNsArray()[n]);
                }
                ++n;
            }
            if (arrayList3.size() != 0) {
                CIMObjectPath[] cIMObjectPathArray = this.exposePaths(assignStorageVolumesParameter.getCapability(), null, assignStorageVolumesParameter.getVolumeNames(), assignStorageVolumesParameter.getInitiatorWWPNsArray(), assignStorageVolumesParameter.getTargetPortWWPNs(), assignStorageVolumesParameter.getDeviceNumbers());
                int n2 = 0;
                while (n2 < cIMObjectPathArray.length) {
                    String[] stringArray = this.getDeviceNumbers(cIMObjectPathArray[n2], assignStorageVolumesParameter.getVolumeCOPs());
                    String[] stringArray2 = this.getFCPortWWPNs(cIMObjectPathArray[n2]);
                    ArrayList arrayList4 = this.cPlugin.getHardwareIDManagement().retrieveStorageHardwareIDs(arrayList3, true);
                    arrayList.addAll(ConfigurationResultHelper.createMappingResultsForStorageHardwareIDs(stringArray2, arrayList4, assignStorageVolumesParameter.getVolumeIDs(), stringArray, assignStorageVolumesParameter, this.cPlugin.getHardwareIDManagement(), cIMObjectPathArray[n2], this.cToken));
                    assignStorageVolumesParameter.setAsyncResult(ResultHelper.addAsyncSubResultsSuccess((AsyncResult)assignStorageVolumesParameter.getAsyncResult(), (ArrayList)arrayList, (String)assignStorageVolumesParameter.getAPIMethodName()));
                    ++n2;
                }
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath getControllerConfigurationService() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getControllerConfigurationService", (Object[])new Object[1]);
        try {
            if (this.cControllerConfigurationService == null) {
                this.retrieveAssociatedControllerConfigurationService();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit((Object)this.cControllerConfigurationService);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit((Object)this.cControllerConfigurationService);
        return this.cControllerConfigurationService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getFCPortWWPNs(CIMObjectPath cIMObjectPath) throws ServerException {
        String[] stringArray;
        LogTraceHelper logTraceHelper;
        block7: {
            String[] stringArray2;
            block6: {
                logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getFCPortWWPNs", (Object[])new Object[]{cIMObjectPath});
                stringArray = null;
                try {
                    stringArray = (String[])this.cFCPortsOfProtocolController.get(cIMObjectPath);
                    if (stringArray != null && stringArray.length > 0) {
                        stringArray2 = stringArray;
                        Object var6_5 = null;
                        break block6;
                    }
                    ArrayList arrayList = this.retrieveFCPortsOfProtocolController(cIMObjectPath);
                    stringArray = new String[arrayList.size()];
                    int n = 0;
                    while (true) {
                        if (n >= arrayList.size()) {
                            this.cFCPortsOfProtocolController.put(cIMObjectPath, stringArray);
                            break block7;
                        }
                        stringArray[n] = (String)((CIMInstance)arrayList.get(n)).getProperty("PermanentAddress").getValue().getValue();
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    logTraceHelper.exit((Object)stringArray);
                    throw throwable;
                }
            }
            logTraceHelper.exit((Object)stringArray);
            return stringArray2;
        }
        Object var6_7 = null;
        logTraceHelper.exit((Object)stringArray);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getDeviceNumbersOfProtocolController(CIMObjectPath cIMObjectPath) {
        ArrayList<Object> arrayList;
        LogTraceHelper logTraceHelper;
        block7: {
            ArrayList<Object> arrayList2;
            block6: {
                logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getDeviceNumbersOfProtocolController", (Object[])new Object[]{cIMObjectPath});
                arrayList = null;
                try {
                    arrayList = (ArrayList<Object>)this.cDeviceNumbersOfProtocolController.get(cIMObjectPath);
                    if (arrayList != null) {
                        arrayList2 = arrayList;
                        Object var6_5 = null;
                        break block6;
                    }
                    ArrayList arrayList3 = this.retrieveProtocolControllerForUnit(cIMObjectPath);
                    arrayList = new ArrayList<Object>();
                    int n = 0;
                    while (true) {
                        if (n >= arrayList3.size()) {
                            this.cDeviceNumbersOfProtocolController.put(cIMObjectPath, arrayList);
                            break block7;
                        }
                        arrayList.add(((CIMInstance)arrayList3.get(n)).getProperty("DeviceNumber").getValue().getValue());
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    logTraceHelper.exit((Object)arrayList);
                    throw throwable;
                }
            }
            logTraceHelper.exit((Object)arrayList);
            return arrayList2;
        }
        Object var6_7 = null;
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    protected String[] getDeviceNumbersForVolumesToAttach(AssignStorageVolumesParameter assignStorageVolumesParameter, CIMObjectPath[] cIMObjectPathArray) {
        String[] stringArray;
        String[] stringArray2;
        LogTraceHelper logTraceHelper;
        block6: {
            logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getDeviceNumbersForVolumesToAttach", (Object[])new Object[]{assignStorageVolumesParameter, cIMObjectPathArray});
            stringArray2 = null;
            if (assignStorageVolumesParameter.getDeviceNumbers() != null) break block6;
            String[] stringArray3 = stringArray2 = new String[cIMObjectPathArray.length];
            Object var7_7 = null;
            logTraceHelper.exit((Object)stringArray2);
            return stringArray3;
        }
        try {
            stringArray2 = new String[cIMObjectPathArray.length];
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                int n2 = 0;
                while (n2 < assignStorageVolumesParameter.getVolumeCOPs().length) {
                    if (assignStorageVolumesParameter.getVolumeCOPs()[n2].equals((Object)cIMObjectPathArray[n])) {
                        stringArray2[n] = assignStorageVolumesParameter.getDeviceNumbers()[n2];
                    }
                    ++n2;
                }
                ++n;
            }
            stringArray = stringArray2;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            logTraceHelper.exit((Object)stringArray2);
            throw throwable;
        }
        logTraceHelper.exit((Object)stringArray2);
        return stringArray;
    }

    protected CIMObjectPath[] checkVolumesOfPC(CIMObjectPath[] cIMObjectPathArray, ArrayList arrayList) {
        CIMObjectPath[] cIMObjectPathArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"checkVolumesOfPC", (Object[])new Object[]{cIMObjectPathArray, arrayList});
        try {
            if (arrayList.size() == cIMObjectPathArray.length) {
                int n = 0;
                while (n < cIMObjectPathArray.length) {
                    if (!arrayList.contains(cIMObjectPathArray[n])) {
                        ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                        logTraceHelper.traceError("Volumes mapped differ from expected volumes", (Throwable)serverException);
                        throw serverException;
                    }
                    ++n;
                }
            }
            if (arrayList.size() < cIMObjectPathArray.length) {
                ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                logTraceHelper.traceError("Less Volumes mapped than expected", (Throwable)serverException);
                throw serverException;
            }
            cIMObjectPathArray2 = cIMObjectPathArray;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            logTraceHelper.exit((Object)cIMObjectPathArray);
            throw throwable;
        }
        logTraceHelper.exit((Object)cIMObjectPathArray);
        return cIMObjectPathArray2;
    }

    protected String[] checkWWPNsOfPC(String[] stringArray, ArrayList arrayList) {
        String[] stringArray2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"checkWWPNsOfPC", (Object[])new Object[]{stringArray, arrayList});
        try {
            if (arrayList.size() == stringArray.length) {
                int n = 0;
                while (n < stringArray.length) {
                    if (!arrayList.contains(stringArray[n])) {
                        ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                        logTraceHelper.traceError("Initiator ports mapped differ from expected WWPNs", (Throwable)serverException);
                        throw serverException;
                    }
                    ++n;
                }
            }
            if (arrayList.size() < stringArray.length) {
                ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021617E", (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                logTraceHelper.traceError("Less InitiatorPorts mapped than expected", (Throwable)serverException);
                throw serverException;
            }
            stringArray2 = stringArray;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            logTraceHelper.exit((Object)stringArray);
            throw throwable;
        }
        logTraceHelper.exit((Object)stringArray);
        return stringArray2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkModifiedProtocolControllers(ProtocolControllerToPrivileges protocolControllerToPrivileges, CIMObjectPath[] cIMObjectPathArray) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"checkModifiedProtocolControllers", (Object[])new Object[]{protocolControllerToPrivileges, cIMObjectPathArray});
        try {
            if (cIMObjectPathArray.length != 1 || !cIMObjectPathArray[0].toString().equals(protocolControllerToPrivileges.getProtocolController().toString())) {
                ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)logTraceHelper);
                logTraceHelper.traceError("ExposePaths returned unexpected number of ProtocolControllers. Expected 1, returned: " + cIMObjectPathArray.length, (Throwable)serverException);
                throw serverException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        logTraceHelper.exit(null);
    }

    public CIMObjectPath validateProtocolController(CIMObjectPath cIMObjectPath) {
        return cIMObjectPath;
    }

    protected String[] setDeviceNumbers(String[] stringArray, int n, CIMObjectPath cIMObjectPath) {
        int n2;
        String[] stringArray2 = stringArray;
        if (stringArray2 != null) {
            n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2] == null) {
                    stringArray2 = null;
                    break;
                }
                ++n2;
            }
            if (stringArray2 != null && stringArray2.length == 0) {
                stringArray2 = null;
            }
        }
        if (stringArray2 == null) {
            n2 = n;
            stringArray2 = new String[n2];
            ArrayList arrayList = new ArrayList();
            if (cIMObjectPath != null) {
                arrayList = this.getDeviceNumbersOfProtocolController(cIMObjectPath);
            }
            int n3 = 0;
            while (n3 < n2) {
                stringArray2[n3] = null;
                if (cIMObjectPath != null) {
                    int n4 = 0;
                    int n5 = 0 + n4;
                    while (n5 < 256) {
                        if (!arrayList.contains(Integer.toString(n5))) {
                            stringArray2[n3] = Integer.toHexString(n5).toUpperCase();
                            ++n4;
                            break;
                        }
                        ++n4;
                        ++n5;
                    }
                } else {
                    stringArray2[n3] = Integer.toHexString(n3).toUpperCase();
                }
                ++n3;
            }
        }
        return stringArray2;
    }
}

