/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.util.DBHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.control.util.AssignStorageVolumesParameter;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;

public class DiskParameterHelper
extends ParameterHelper {
    public static Collection combineConfigurationParametersByStorageSystem(ConfigurationParameter configurationParameter) {
        StorageSubsystem[] storageSubsystemArray = configurationParameter.getStorageSubsystemsForSorting();
        HashMap<Integer, ConfigurationParameter> hashMap = new HashMap<Integer, ConfigurationParameter>();
        int n = 0;
        while (n < storageSubsystemArray.length) {
            ConfigurationParameter configurationParameter2 = hashMap.containsKey(new Integer(storageSubsystemArray[n].getSubsystemId())) ? (ConfigurationParameter)hashMap.get(new Integer(storageSubsystemArray[n].getSubsystemId())) : DiskParameterHelper.createConfigurationParameter(configurationParameter, storageSubsystemArray[n]);
            configurationParameter2.addParameters(configurationParameter, n);
            hashMap.put(new Integer(storageSubsystemArray[n].getSubsystemId()), configurationParameter2);
            ++n;
        }
        return hashMap.values();
    }

    private static ConfigurationParameter createConfigurationParameter(ConfigurationParameter configurationParameter, StorageSubsystem storageSubsystem) {
        if (configurationParameter instanceof AssignStorageVolumesParameter) {
            return new AssignStorageVolumesParameter(storageSubsystem, null);
        }
        if (configurationParameter instanceof AssignmentParameter) {
            return new AssignmentParameter(storageSubsystem, null);
        }
        return null;
    }

    public static void getTargetPorts(DBHelper dBHelper, CIMOMSelector.SubsystemConnectionData subsystemConnectionData, String[] stringArray, AssignStorageVolumesParameter assignStorageVolumesParameter) {
        assignStorageVolumesParameter.setTargetPortIDs(stringArray);
        Port[] portArray = dBHelper.getPortObjects(assignStorageVolumesParameter, stringArray);
        assignStorageVolumesParameter.setTargetPorts(portArray);
        assignStorageVolumesParameter.setTargetPortCOPs(dBHelper.getTargetPortCOPs(subsystemConnectionData, stringArray, portArray));
        String[] stringArray2 = new String[portArray.length];
        int n = 0;
        while (n < portArray.length) {
            stringArray2[n] = portArray[n].getName();
            ++n;
        }
        assignStorageVolumesParameter.setTargetPortWWPNs(stringArray2);
    }
}

