/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.DiskMonitorHelper;
import org.eclipse.aperi.disk.monitor.FCPortIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.DataPath;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMObjectPath;

public class FCPortDeletionHandler
extends FCPortIndicationHandler
implements ICIMIndicationHandler {
    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData registrationData = new CIMIndicationHandler.RegistrationData("CIM_FCPort", "CIM_InstDeletion");
        return new CIMIndicationHandler.RegistrationData[]{registrationData};
    }

    public FCPortDeletionHandler(String string, String string2, CIMIndicationEvent cIMIndicationEvent) {
        super(string, string2, cIMIndicationEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HandlingResult handle(LogTraceHelper logTraceHelper, String string) {
        LogTraceHelper logTraceHelper2 = LogTraceHelper.entry((Object)((Object)this), (String)"handle", null);
        CIMObjectPath cIMObjectPath = this.getEvent().getSourceCop();
        try {
            block17: {
                try {
                    DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
                    try {
                        HashMap hashMap = DiskMonitorHelper.getKeyMapFromCOP(dBConnection, cIMObjectPath);
                        String string2 = "SELECT PORT_ID FROM " + TResCimkeyPortTable.getTablename() + " WHERE (" + "CREATION_CLASS_NAME_ID" + " = (?) AND " + "DEVICE_ID" + " = (?) AND " + "SYSTEM_CREATION_CLASS_NAME_ID" + " = (?) AND " + "SYSTEM_NAMES_ID" + " = (?))";
                        Hashtable hashtable = new Hashtable();
                        hashtable.put(TResCimkeyPortTable.getColumnInfo((String)"CREATION_CLASS_NAME_ID"), hashMap.get("CreationClassName"));
                        hashtable.put(TResCimkeyPortTable.getColumnInfo((String)"DEVICE_ID"), hashMap.get("DeviceID"));
                        hashtable.put(TResCimkeyPortTable.getColumnInfo((String)"SYSTEM_CREATION_CLASS_NAME_ID"), hashMap.get("SystemCreationClassName"));
                        hashtable.put(TResCimkeyPortTable.getColumnInfo((String)"SYSTEM_NAMES_ID"), hashMap.get("SystemName"));
                        logTraceHelper2.traceHigh(string2);
                        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string2, hashtable);
                        try {
                            if (dBResultSet.next()) {
                                try {
                                    String string3 = Integer.toString(dBResultSet.getInt("PORT_ID"));
                                    boolean bl = false;
                                    if (Port.getColumnInfo((String)"DETECTABLE") != null) {
                                        bl = true;
                                    }
                                    if (bl) {
                                        FCPortIndicationHandler.changeDetectableAttributeForFCPort(dBConnection, "0", new Integer(string3));
                                    } else {
                                        hashtable.clear();
                                        hashtable.put(TResCimkeyPortTable.getColumnInfo((String)"PORT_ID"), string3);
                                        int n = CimkeyPort.deletes((DBConnection)dBConnection, hashtable);
                                        logTraceHelper2.traceHigh(String.valueOf(Integer.toString(n)) + "row(s) in " + TResCimkeyPortTable.getTablename() + " deleted.");
                                        hashtable.clear();
                                        hashtable.put(TResPortTable.getColumnInfo((String)"PORT_ID"), string3);
                                        n = Port.deletes((DBConnection)dBConnection, hashtable);
                                        logTraceHelper2.traceHigh(String.valueOf(Integer.toString(n)) + "row(s) in " + TResPortTable.getTablename() + " deleted.");
                                        hashtable.clear();
                                        hashtable.put(TResDataPathTable.getColumnInfo((String)"INITIATOR_PORT_ID"), string3);
                                        n = DataPath.deletes((DBConnection)dBConnection, hashtable);
                                        logTraceHelper2.traceHigh(String.valueOf(Integer.toString(n)) + "row(s) in " + TResDataPathTable.getTablename() + " deleted.");
                                        hashtable.clear();
                                        hashtable.put(TResDataPathTable.getColumnInfo((String)"TARGET_PORT_ID"), string3);
                                        n = DataPath.deletes((DBConnection)dBConnection, hashtable);
                                        logTraceHelper2.traceHigh(String.valueOf(Integer.toString(n)) + "row(s) in " + TResDataPathTable.getTablename() + " deleted.");
                                    }
                                    dBConnection.commit();
                                    LinkedList<String> linkedList = new LinkedList<String>();
                                    linkedList.add(string3);
                                    HashMap<String, LinkedList<String>> hashMap2 = new HashMap<String, LinkedList<String>>();
                                    hashMap2.put(TResPortTable.getTablename(), linkedList);
                                    Processor.getEventMonitorProxy().handleDeviceStateChange(string, Port.getTablename(), string3, 1, 0);
                                    Processor.getEventMonitorProxy().handleModelUpdate(string);
                                }
                                catch (Exception exception) {
                                    dBConnection.rollback();
                                    throw new RuntimeException(exception);
                                }
                            }
                            Object var14_19 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_18 = null;
                            dBResultSet.closeAll();
                            throw throwable;
                        }
                        dBResultSet.closeAll();
                        Object var16_22 = null;
                        if (dBConnection == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var16_21 = null;
                        if (dBConnection == null) throw throwable;
                        dBConnection.close();
                        throw throwable;
                    }
                    dBConnection.close();
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            }
            Object var18_25 = null;
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            logTraceHelper2.exit(null);
            throw throwable;
        }
        logTraceHelper2.exit(null);
        return HandlingResult.SUCCESS;
    }
}

