/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.hostquery;

import com.ibm.log.Level;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.agent.Activator;
import org.eclipse.aperi.agent.hostquery.HostInfo;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.interfaces.ISANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;
import org.eclipse.aperi.sanmgmt.subagent.common.SubagentInfo;
import org.eclipse.aperi.sanmgmt.subagent.hostquery.interfaces.IHostQuery;

public class HostQuery
implements IHostQuery,
IService,
Runnable {
    static final String TRACE_LOGGER_NAME = "aperi.logger.trace.SANAgentHostQuery";
    static final String MESSAGE_LOGGER_NAME = "aperi.logger.message.SANAgentHostQuery";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.subagent.hostquery.HostQueryMessages";
    static ILogger trace_logger;
    static ILogger message_logger;
    static final long RETRY_REGISTRY_PERIOD = 20000L;
    private ISANDiskMgrHostService hms = null;
    private Thread queryThread = null;
    private boolean shutFlag = false;
    private HostQueryInfo hostQueryInfo = null;
    private Status status = new Status(5, 9);

    static {
        block2: {
            trace_logger = null;
            message_logger = null;
            try {
                trace_logger = LogManagerFactory.getTraceLogger((String)TRACE_LOGGER_NAME);
                message_logger = LogManagerFactory.getMessageLogger((String)MESSAGE_LOGGER_NAME);
                message_logger.setMessageFile(BUNDLENAME);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!trace_logger.isLogging()) break block2;
                trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostQuery Class", "Exception On Creating Logger " + exception);
            }
        }
    }

    public HostQueryInfo getHostInfo() {
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getHostInfo");
        }
        if (trace_logger.isLogging()) {
            trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "getHostInfo", " AgentHostQuery: Host osname=" + this.hostQueryInfo.osName + ", jvmVersion=" + this.hostQueryInfo.jvmVersion + ", hostName=" + this.hostQueryInfo.hostName + ", hostPort=" + this.hostQueryInfo.hostPort + ", hostIP=" + this.hostQueryInfo.hostIP + ", guid=" + this.hostQueryInfo.GUID.toString());
        }
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this, "getHostInfo");
        }
        return this.hostQueryInfo;
    }

    public boolean startup() {
        Class<?> clazz;
        Class<?> clazz2;
        String string = null;
        String string2 = null;
        int n = 0;
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)this.getClass().getName(), "startup");
        }
        this.status.setRunStatus(9);
        SubagentInfo[] subagentInfoArray = null;
        HostInfo hostInfo = new HostInfo();
        this.hostQueryInfo = new HostQueryInfo(hostInfo.osName, hostInfo.jvmVersion, hostInfo.hostName, Integer.toString(hostInfo.hostPort), hostInfo.hostIP, subagentInfoArray, GUID.readGUID(), "5.0.0");
        try {
            clazz2 = Class.forName("org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IConfigService iConfigService = (IConfigService)Activator.getService(clazz2);
        if (iConfigService != null) {
            String string3;
            String string4 = iConfigService.getProperty("my.name", "user");
            if (string4 != null && (string4 = string4.trim()).length() > 0) {
                this.hostQueryInfo.hostName = string4;
            }
            if ((string3 = iConfigService.getProperty("my.ip", "user")) != null && (string3 = string3.trim()).length() > 0) {
                this.hostQueryInfo.hostIP = string3;
            }
        }
        if (this.hostQueryInfo.hostName == null) {
            if (trace_logger.isLogging()) {
                trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "Failed to retrieve HostName, Unable to start HostQuery ");
            }
            this.shutFlag = true;
            this.status.setRunStatus(2);
            return false;
        }
        if (iConfigService != null) {
            string = iConfigService.getProperty("manager.loc", "setup");
            string2 = iConfigService.getProperty("manager.port", "setup");
            if (string == null || string2 == null) {
                if (trace_logger.isLogging()) {
                    trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "dbParm failed to get managerLoc or managerPort properties ");
                }
                this.shutFlag = true;
                return false;
            }
            n = new Integer(string2);
            try {
                clazz = Class.forName("org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.interfaces.ISANDiskMgrHostService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } else {
            if (trace_logger.isLogging()) {
                trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "Failed to get a connection to the ConfigService.");
            }
            this.shutFlag = true;
            this.status.setRunStatus(2);
            return false;
        }
        this.hms = (ISANDiskMgrHostService)ConnectorClient.getService((String)string, (int)n, clazz, (String)"SANHostMgr");
        this.shutFlag = false;
        if (this.hostQueryInfo.GUID != null) {
            this.hostQueryInfo = this.getHostInfo();
            this.queryThread = new Thread((Runnable)this, "SANAgentHostQuery");
            this.queryThread.start();
            this.status.setRunStatus(8);
            if (message_logger.isLogging()) {
                message_logger.message(IRecordType.TYPE_INFO, (Object)this, "startup", "BTSserviceStartup", (Object)this.getName());
            }
        } else {
            this.status.setRunStatus(2);
            if (trace_logger.isLogging()) {
                trace_logger.text(IRecordType.TYPE_ERROR_EXC, (Object)this, "startup", "HostQuery Service failed to start.  Failed to read the GUID");
                trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "startup");
            }
            return false;
        }
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "startup");
        }
        return true;
    }

    public boolean shutdown() {
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)this.getClass().getName(), "shutdown");
        }
        this.shutFlag = true;
        this.queryThread.interrupt();
        try {
            this.queryThread.join();
        }
        catch (InterruptedException interruptedException) {}
        message_logger.message(IRecordType.TYPE_INFO, (Object)this, "shutdown", "BTSserviceShutdown", (Object)this.getName());
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "shutdown");
        }
        return true;
    }

    public void run() {
        int n = 1;
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_API, (Object)this.getClass().getName(), "run");
        }
        while (!this.shutFlag) {
            block13: {
                try {
                    this.hms.agentHeartbeat(this.hostQueryInfo);
                    if (trace_logger.isLogging()) {
                        trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "run", " HostQuery: Agent Heartbeat sent.");
                    }
                    if (n > 0) {
                        if (message_logger.isLogging()) {
                            message_logger.message(IRecordType.TYPE_INFO, (Object)this, "run", "BTSheartbeatStart", (Object)"agentHeartbeat");
                        }
                        if (trace_logger.isLogging()) {
                            trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "run", " HostQuery: Agent Heartbeat started...");
                        }
                        n = 0;
                    }
                }
                catch (Exception exception) {
                    if (n >= 10) break block13;
                    if (message_logger.isLogging()) {
                        message_logger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, "run", "BTSheartbeatFail", (Object)"agentHeartbeat");
                    }
                    if (trace_logger.isLogging()) {
                        trace_logger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "run", (Throwable)exception);
                    }
                    ++n;
                }
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                if (!trace_logger.isLogging()) continue;
                trace_logger.exception(Level.WARN, (Object)this, "run", (Throwable)interruptedException);
            }
        }
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "run");
        }
    }

    public String getName() {
        return "SANAgentHostQuery";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("HostQuery_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("HostQuery_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        return this.getLocalizedDescription(Locale.getDefault());
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }
}

