/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.inbandchangeagent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.agent.Activator;
import org.eclipse.aperi.agent.inbandchangeagent.InbandChangeAgentConstants;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.IChangeAgent;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.IEventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.InstantiationFailedException;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class InbandChangeAgent
implements IService,
IChangeAgent,
Runnable {
    private static final String FILE_NAME = "InbandEvents";
    static final String className;
    static ILogger msgLogger;
    static ILogger traceLogger;
    public static final String MINIMUM_EVENTCORRELATORFACTORY_VERSION;
    private Thread scannerThread = null;
    private String command;
    private boolean shutdownInvoked = false;
    private StringBuffer nativeBinDirectory = null;
    private StringBuffer subagentHomeDirectory = null;
    private StringBuffer valuePath = null;
    private StringBuffer valueSystemroot = null;
    private StringBuffer valueLdlibrarypath = null;
    public static final String w32ix86 = "w32-ix86";
    public static final String aix5 = "aix";
    public static final String winnt = "Windows NT";
    public static final String win2k = "Windows 2000";
    private Process p = null;
    InputStream p_stdout;
    static String exeName1;
    static String exeName2;
    private String xmlEvent = "";
    private int period;
    private String mgrHost = null;
    private int mgrPort = 0;
    private String propertyFileLocation = null;
    private String executableLocation = null;
    IEventCorrelatorFactory eventCorrelatorFactory = null;
    private Status status = new Status();

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.agent.inbandchangeagent.InbandChangeAgent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = InbandChangeAgentConstants.msgLogger;
        traceLogger = InbandChangeAgentConstants.traceLogger;
        MINIMUM_EVENTCORRELATORFACTORY_VERSION = null;
        exeName1 = "oslevel -r";
        exeName2 = "lslpp -l";
    }

    public InbandChangeAgent() {
        this.status.setRunStatus(3);
        String string = "InbandChangeAgent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        this.shutdownInvoked = false;
        this.setPulseRate(20);
        String string2 = Variables.getBaseDirectory();
        if (string2 == null || string2.equalsIgnoreCase("")) {
            this.propertyFileLocation = FILE_NAME;
            this.executableLocation = "." + File.separator;
        } else {
            this.propertyFileLocation = String.valueOf(string2) + File.separator + FILE_NAME;
            this.executableLocation = String.valueOf(string2) + File.separator + "bin" + File.separator + this.getInterp() + File.separator;
        }
    }

    private IEventCorrelatorFactory getEventCorrelator() throws InstantiationFailedException {
        String string = "getEventCorrelator";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (this.eventCorrelatorFactory == null) {
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.IEventCorrelatorFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                this.eventCorrelatorFactory = (IEventCorrelatorFactory)ConnectorClient.getService((String)this.mgrHost, (int)this.mgrPort, clazz, (String)"SANEventCorrelatorFactory");
            }
            catch (Exception exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandChangeAgent_contactEventCorrelatorError");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                throw new InstantiationFailedException();
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return this.eventCorrelatorFactory;
    }

    public void setPulseRate(int n) {
        String string = "setPulseRate";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)("Rate = " + n + " seconds."));
        }
        this.period = n * 1000;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private int runScanner() {
        int n;
        String string;
        block81: {
            string = "runScanner";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            n = -1;
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
            String string2 = simpleDateFormat.format(date);
            String[] stringArray = new String[4];
            try {
                block82: {
                    Object object;
                    int n2;
                    block77: {
                        File file = new File(this.propertyFileLocation);
                        file.delete();
                        n2 = 0;
                        while (file.exists() && n2 < 10) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++n2;
                            file.delete();
                        }
                        try {
                            object = this.getInterp();
                            stringArray[0] = object != null && ((String)object).equals(w32ix86) ? new String("PATH=" + this.valuePath + ";" + this.nativeBinDirectory.toString() + ";" + this.executableLocation) : new String("PATH=" + this.valuePath + ":" + this.nativeBinDirectory.toString() + ":" + this.executableLocation);
                            stringArray[1] = new String("TSNM_SM_HOME=" + this.subagentHomeDirectory.toString());
                            String string3 = new String(System.getProperty("os.name"));
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "hostOsName is " + string3);
                            }
                            stringArray[2] = new String("SystemRoot=" + this.valueSystemroot);
                            stringArray[3] = new String("LD_LIBRARY_PATH=" + this.valueLdlibrarypath + ":" + this.nativeBinDirectory.toString());
                            if (this.shutdownInvoked) {
                                if (traceLogger.isLogging()) {
                                    traceLogger.exit(IRecordType.TYPE_MISC_DATA, (Object)className, string, (Object)"Shutdown invoked, will not invoke EventScanner");
                                }
                                if (traceLogger.isLogging()) {
                                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                                }
                                n = -1;
                                return n;
                            }
                            if (this.command != null && this.command.length() == 0) {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Native scanner can not be executed because command is empty. No date will be gathered. This can be caused if the OS is not of sufficient level, please ensure that your OS meets TPC's minimum requirements.");
                                }
                                break block77;
                            }
                            if (((String)object).equals(aix5) && this.command.indexOf("Event2") != -1) {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Event command invoked is " + this.command);
                                }
                                this.p = Runtime.getRuntime().exec(this.command);
                            } else {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Environment to be passed to scanner is " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3]);
                                }
                                this.p = Runtime.getRuntime().exec(this.command, stringArray);
                            }
                            if (this.p != null) {
                                this.p.waitFor();
                            } else {
                                n = 0;
                            }
                            if (this.p != null) {
                                block80: {
                                    block79: {
                                        block78: {
                                            n = this.p.exitValue();
                                            try {
                                                this.p.getErrorStream().close();
                                                if (traceLogger != null && traceLogger.isLogging()) {
                                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed error stream ");
                                                }
                                            }
                                            catch (Exception exception) {
                                                if (traceLogger == null || !traceLogger.isLogging()) break block78;
                                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing error stream for process");
                                            }
                                        }
                                        try {
                                            this.p.getInputStream().close();
                                            if (traceLogger != null && traceLogger.isLogging()) {
                                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed input stream ");
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (traceLogger == null || !traceLogger.isLogging()) break block79;
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing input stream for process");
                                        }
                                    }
                                    try {
                                        this.p.getOutputStream().close();
                                        if (traceLogger != null && traceLogger.isLogging()) {
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed output stream ");
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (traceLogger == null || !traceLogger.isLogging()) break block80;
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing output stream for process");
                                    }
                                }
                                try {
                                    this.p.destroy();
                                }
                                catch (Exception exception) {
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception destroying process");
                                    }
                                    break block77;
                                }
                            }
                            n = 0;
                        }
                        catch (IOException iOException) {
                            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)iOException);
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)iOException);
                            }
                            n = -1;
                        }
                    }
                    if (n != 0) break block81;
                    object = new File(this.propertyFileLocation);
                    boolean bl2 = !((File)object).exists();
                    n2 = 0;
                    while (bl2 && n2 < 300) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++n2;
                        boolean bl3 = bl2 = !((File)object).exists();
                    }
                    if (((File)object).exists()) {
                        boolean bl4 = true;
                        int n3 = 0;
                        while (bl4 && n3 < 5) {
                            Object object2;
                            Vector<String> vector = new Vector<String>();
                            try {
                                String string4 = null;
                                object2 = new BufferedReader(new FileReader(this.propertyFileLocation));
                                string4 = ((BufferedReader)object2).readLine();
                                while (string4 != null) {
                                    vector.add(string4);
                                    string4 = ((BufferedReader)object2).readLine();
                                }
                                ((BufferedReader)object2).close();
                            }
                            catch (Exception exception) {}
                            ++n3;
                            if (vector.size() > 0) {
                                boolean bl5 = false;
                                object2 = "</InbandEvents>";
                                String string5 = null;
                                Enumeration enumeration = vector.elements();
                                while (enumeration.hasMoreElements()) {
                                    string5 = (String)enumeration.nextElement();
                                    if (string5.indexOf((String)object2) == -1) continue;
                                    bl5 = true;
                                    break;
                                }
                                if (bl5) {
                                    bl4 = false;
                                    continue;
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            if (n3 == 3) {
                                bl4 = false;
                                continue;
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    this.xmlEvent = new String();
                    if (!((File)object).exists()) break block81;
                    FileInputStream fileInputStream = new FileInputStream(this.propertyFileLocation);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                    while (bl) {
                        try {
                            String string6 = bufferedReader.readLine();
                            if (string6.indexOf("TIMESTAMP") != -1) {
                                int n4 = string6.indexOf("TIMESTAMP");
                                StringBuffer stringBuffer2 = new StringBuffer(string6.substring(1, n4));
                                stringBuffer2.append(string2);
                                stringBuffer2.append("\">");
                                string6 = new String(stringBuffer2);
                            }
                            if (string6.equals("")) continue;
                            stringBuffer.append(String.valueOf(string6) + "\n");
                        }
                        catch (Exception exception) {
                            bl = false;
                        }
                    }
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed file stream ");
                            }
                        } else if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change dataInputStream is null did not close file stream ");
                        }
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block82;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing file stream ");
                    }
                }
                this.xmlEvent = new String(stringBuffer);
            }
            catch (Exception exception) {
                block85: {
                    block84: {
                        block83: {
                            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandChangeAgent_ReadEventFileError");
                            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                            }
                            n = -1;
                            try {
                                if (this.p != null) {
                                    this.p.getErrorStream().close();
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed error stream ");
                                    }
                                }
                            }
                            catch (Exception exception2) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block83;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing error stream for process");
                            }
                        }
                        try {
                            if (this.p != null) {
                                this.p.getInputStream().close();
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed input stream ");
                                }
                            }
                        }
                        catch (Exception exception3) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block84;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing input stream for process");
                        }
                    }
                    try {
                        if (this.p != null) {
                            this.p.getOutputStream().close();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed output stream ");
                            }
                        }
                    }
                    catch (Exception exception4) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block85;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing output stream for process");
                    }
                }
                try {
                    if (this.p != null) {
                        this.p.destroy();
                    }
                }
                catch (Exception exception5) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block81;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception destroying process");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public void run() {
        String string = "run";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        while (this.scannerThread != null) {
            block12: {
                int n;
                block11: {
                    try {
                        this.eventCorrelatorFactory = this.getEventCorrelator();
                    }
                    catch (Exception exception) {
                        this.eventCorrelatorFactory = null;
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandChangeAgent_contactEventCorrelatorError");
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                        if (!traceLogger.isLogging()) break block11;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
                if (this.eventCorrelatorFactory != null && (n = this.runScanner()) == 0) {
                    try {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "INBANDEVENTS XML --- " + this.xmlEvent);
                        }
                        if (!this.xmlEvent.equals("")) {
                            this.eventCorrelatorFactory.postEvent(this.xmlEvent);
                        }
                    }
                    catch (Exception exception) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandChangeAgent_contactEventCorrelatorError");
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                        if (!traceLogger.isLogging()) break block12;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException interruptedException) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandChangeAgent_InterruptedException");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)interruptedException);
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)interruptedException);
            }
        }
    }

    public void onConfirmation(int n, boolean bl, String string) {
        String string2 = "onConfirmation";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public void onException(int n, Exception exception) {
        String string = "onException";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public void onSpecialMessage(String string) {
        String string2 = "onSpecialMessage";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string2);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
    }

    public boolean isAlive() {
        return true;
    }

    public String getName() {
        return "SANAgentInbandChangeAgent";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("InbandChangeAgent_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("InbandChangeAgent_Description");
    }

    public Status getStatus() {
        return new Status(5, 8);
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean shutdown() {
        String string;
        block25: {
            string = "shutdown";
            String[] stringArray = new String[4];
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            this.status.setRunStatus(11);
            this.shutdownInvoked = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "value of shutdownInvoked is " + this.shutdownInvoked);
            }
            Thread thread = this.scannerThread;
            this.scannerThread.interrupt();
            this.scannerThread = null;
            try {
                block28: {
                    block27: {
                        block26: {
                            thread.join(15000L);
                            String string2 = System.getProperty("os.name");
                            this.command = string2.indexOf("windows") != -1 || string2.indexOf("Windows") != -1 || string2.indexOf("WINDOWS") != -1 ? "\"" + this.executableLocation + "Event" + "\"" + " -close" : (string2 != null && string2.equals("AIX") ? this.determineCommandForAIXHost(false) : String.valueOf(this.executableLocation) + "Event" + " -close");
                            String string3 = this.getInterp();
                            stringArray[0] = string3 != null && string3.equals(w32ix86) ? new String("PATH=" + this.valuePath + ";" + this.nativeBinDirectory.toString() + ";" + this.executableLocation) : new String("PATH=" + this.valuePath + ":" + this.nativeBinDirectory.toString() + ":" + this.executableLocation);
                            stringArray[1] = new String("TSNM_SM_HOME=" + this.subagentHomeDirectory.toString());
                            String string4 = new String(System.getProperty("os.name"));
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "hostOsName is " + string4);
                            }
                            stringArray[2] = new String("SystemRoot=" + this.valueSystemroot);
                            stringArray[3] = new String("LD_LIBRARY_PATH=" + this.valueLdlibrarypath + ":" + this.nativeBinDirectory.toString());
                            if (string3.equals(aix5) && this.command.indexOf("Event2") != -1) {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Event command invoked is " + this.command);
                                }
                                this.p = Runtime.getRuntime().exec(this.command);
                            } else {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Environment to be passed to scanner is " + stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3]);
                                }
                                this.p = Runtime.getRuntime().exec(this.command, stringArray);
                            }
                            if (this.p != null) {
                                this.p.waitFor();
                            }
                            if (this.p == null) break block25;
                            try {
                                this.p.getErrorStream().close();
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed error stream ");
                                }
                            }
                            catch (Exception exception) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block26;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing error stream for process");
                            }
                        }
                        try {
                            this.p.getInputStream().close();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed input stream ");
                            }
                        }
                        catch (Exception exception) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block27;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing input stream for process");
                        }
                    }
                    try {
                        this.p.getOutputStream().close();
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed output stream ");
                        }
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block28;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing output stream for process");
                    }
                }
                try {
                    this.p.destroy();
                }
                catch (Exception exception) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception destroying process");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, string, "InbandChangeAgent_InterruptedException");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)interruptedException);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)interruptedException);
                }
            }
            catch (IOException iOException) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)iOException);
                if (!traceLogger.isLogging()) break block25;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)iOException);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    public boolean startup() {
        String string;
        block20: {
            Class<?> clazz;
            string = "startup";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            this.status.setRunStatus(9);
            try {
                clazz = Class.forName("org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IConfigService iConfigService = (IConfigService)Activator.getService(clazz);
            this.mgrHost = iConfigService.getProperty("manager.loc", "setup");
            this.mgrPort = new Integer(iConfigService.getProperty("manager.port", "setup"));
            String string2 = System.getProperty("os.name");
            this.command = string2.indexOf("windows") != -1 || string2.indexOf("Windows") != -1 || string2.indexOf("WINDOWS") != -1 ? "\"" + this.executableLocation + "Event" + "\"" + " " + "\"" + this.propertyFileLocation + "\"" : (string2 != null && string2.equals("AIX") ? this.determineCommandForAIXHost(true) : String.valueOf(this.executableLocation) + "Event" + " " + this.propertyFileLocation);
            try {
                String string3;
                String string4;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "command is " + this.command);
                }
                this.nativeBinDirectory = new StringBuffer(Variables.getNativeLibDirectory());
                if (this.nativeBinDirectory == null) {
                    this.nativeBinDirectory = new StringBuffer("");
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "nativeBinDirectory is " + this.nativeBinDirectory);
                }
                this.subagentHomeDirectory = new StringBuffer(Variables.getBaseDirectory());
                if (this.subagentHomeDirectory == null) {
                    this.subagentHomeDirectory = new StringBuffer("");
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "subAgentHomeDirectory is " + this.subagentHomeDirectory);
                }
                this.valuePath = (string4 = Variables.getEnvironmentValue((String)"PATH")) != null ? new StringBuffer(string4) : new StringBuffer("");
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for PATH returned " + this.valuePath);
                }
                if ((string3 = this.getInterp()) != null && string3.equals(w32ix86)) {
                    string4 = Variables.getEnvironmentValue((String)"SYSTEMROOT");
                    this.valueSystemroot = string4 != null ? new StringBuffer(string4) : new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                    }
                } else {
                    this.valueSystemroot = new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                    }
                }
                if (string3 != null && string3.equals(w32ix86)) {
                    this.valueLdlibrarypath = new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                    }
                } else {
                    string4 = Variables.getEnvironmentValue((String)"LD_LIBRARY_PATH");
                    this.valueLdlibrarypath = string4 != null ? new StringBuffer(string4) : new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                    }
                }
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, string, (Throwable)exception);
                if (!traceLogger.isLogging()) break block20;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        this.scannerThread = new Thread((Runnable)this, "SANAgentInbandChangeAgent");
        this.scannerThread.start();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return true;
    }

    public String getDescription() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getDescription");
        }
        String string = "Listens for inband events";
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getDescription");
        }
        return string;
    }

    public String getInterp() {
        String string;
        String string2;
        String string3 = "getInterp";
        String string4 = System.getProperty("os.name");
        String string5 = InterpResolver.getInterp((String)string4, (String)(string2 = System.getProperty("os.version")), (String)(string = System.getProperty("os.arch")));
        if (string5 != null && string5.equals("unknown") || string5 == null) {
            string5 = System.getProperty("orb.interp");
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_EXIT, (Object)this, string3, (Object)("Interp for " + string4 + " version " + string2 + " arch " + string + " is " + string5));
        }
        return string5;
    }

    private void exec1() {
        block3: {
            String string = "exec1";
            try {
                this.p = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Runtime.getRuntime().exec(exeName1);
                    }
                });
                this.p_stdout = this.p.getInputStream();
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block3;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
    }

    private void exec2() {
        block3: {
            String string = "exec2";
            try {
                this.p = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Runtime.getRuntime().exec(exeName2);
                    }
                });
                this.p_stdout = this.p.getInputStream();
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block3;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
    }

    private void endExec() {
        block20: {
            String string = "endExec";
            try {
                block19: {
                    block18: {
                        block17: {
                            this.p_stdout.close();
                            this.p.waitFor();
                            this.p.exitValue();
                            try {
                                if (this.p != null) {
                                    this.p.getErrorStream().close();
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed error stream in endExec");
                                    }
                                } else if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent p is null did not close error stream in endExec");
                                }
                            }
                            catch (Exception exception) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block17;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing error stream in endExec");
                            }
                        }
                        try {
                            if (this.p != null) {
                                this.p.getOutputStream().close();
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent closed output stream in endExec");
                                }
                            } else if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change p is null did not close output stream in endExec");
                            }
                        }
                        catch (Exception exception) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block18;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception closing output stream in endExec");
                        }
                    }
                    try {
                        this.p.destroy();
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block19;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "inband change agent ran into exception destroying process endExec");
                    }
                }
                this.p = null;
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block20;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
    }

    private String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        try {
            while ((n = this.p_stdout.read()) != 10) {
                if (n != -1) {
                    ++n2;
                    stringBuffer.append((char)n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (n2 > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    String determineCommandForAIXHost(boolean bl) {
        block38: {
            int n = 0;
            int n2 = 0;
            boolean bl2 = false;
            String string = "determineCommandForAIXHost";
            String string2 = System.getProperty("os.version");
            if (string2 != null && string2.equals("5.1")) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Will invoke Event since host is running AIX 5.1");
                }
                this.command = bl ? String.valueOf(this.executableLocation) + "Event" + " " + this.propertyFileLocation : String.valueOf(this.executableLocation) + "Event -close";
            } else if (string2 != null && (string2.equals("5.2") || string2.equals("5.3"))) {
                try {
                    this.exec1();
                    String string3 = this.readLine();
                    this.endExec();
                    n2 = string3 == null ? 0 : ((n = string3.indexOf("-")) == -1 || n == string3.length() ? 0 : new Integer(string3.substring(n + 1)));
                    this.exec2();
                    do {
                        if ((string3 = this.readLine()) == null || string3.indexOf("Event Protocol") == -1) continue;
                        bl2 = true;
                        break;
                    } while (string3 != null);
                    this.endExec();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "oslevel is " + n2 + " protocolDriverInstalled is " + bl2);
                    }
                    if (string2.equals("5.2") && n2 >= 2) {
                        if (bl2) {
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_UninstallProtocolDriver");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                            }
                        }
                        this.command = bl ? String.valueOf(this.executableLocation) + "Event2" + " " + this.propertyFileLocation : String.valueOf(this.executableLocation) + "Event2 -close";
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Will invoke Event2 since host is running AIX 5.2 with atleast maintenance level 2");
                        }
                    } else if (string2.equals("5.2") && n2 < 2) {
                        if (bl2) {
                            this.command = bl ? String.valueOf(this.executableLocation) + "Event" + " " + this.propertyFileLocation : String.valueOf(this.executableLocation) + "Event -close";
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_UninstallProtocolDriver");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                            }
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_ApplyAIX52MaintenanceLevel2OrHigher");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Need to apply atleast maintenance level 2 to AIX 5.2.");
                            }
                        } else {
                            this.command = "";
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_ApplyAIX52MaintenanceLevel2OrHigher");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Need to apply atleast maintenance level 2 to AIX 5.2.");
                            }
                        }
                    }
                    if (string2.equals("5.3") && n2 >= 1) {
                        if (bl2) {
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_UninstallProtocolDriver");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                            }
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Will invoke Event2 since host is running AIX 5.3 with atleast maintenance level 1");
                        }
                        this.command = bl ? String.valueOf(this.executableLocation) + "Event2" + " " + this.propertyFileLocation : String.valueOf(this.executableLocation) + "Event2 -close";
                        break block38;
                    }
                    if (!string2.equals("5.3") || n2 >= 1) break block38;
                    if (bl2) {
                        this.command = bl ? String.valueOf(this.executableLocation) + "Event" + " " + this.propertyFileLocation : String.valueOf(this.executableLocation) + "Event -close";
                        if (msgLogger != null) {
                            msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_UninstallProtocolDriver");
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                        }
                        if (msgLogger != null) {
                            msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_ApplyAIX53MaintenanceLevel1OrHigher");
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Need to apply atleast maintenance level 1 to AIX 5.3.");
                        }
                        break block38;
                    }
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_ApplyAIX53MaintenanceLevel1OrHigher");
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Need to apply atleast maintenance level 1 to AIX 5.3.");
                    }
                    this.command = "";
                }
                catch (Exception exception) {
                    this.command = "";
                }
            } else {
                this.command = bl ? String.valueOf(this.executableLocation) + "Event2" + " " + this.propertyFileLocation : String.valueOf(this.executableLocation) + "Event2 -close";
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "InbandChangeAgent_UnsupportedOSLevel");
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "AIX managed host is running a unsupported AIX OS level.");
                }
            }
        }
        return this.command;
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }
}

