@echo off
REM  ######################################################################
REM  Aperi Database Creation/Drop Script
REM  ######################################################################

setlocal
goto Start

REM =======================================================================
REM
:Usage
echo "db2cmd /c db2config.bat DB2AdminID DB2AdminPassword DBName CDFlag LogSize LogLocation"
echo where:
echo    DB2AdminID       = the DB2 Administrator user ID
echo    DB2AdminPassword = the DB2 Administrator password
echo    DBName           = the IBM Aperi Database name
echo    CDFlag           = the Create/Drop flag
echo    LogSize          = size of DB2 log file
echo    LogLocation      = Location of DB2 log file
echo    DB2 CFG ARGs     = SHEAPTHRES, DBHEAP, APPLHEAPSZ, APP_CTL_HEAP_SZ, APPGROUP_MEM_SZ,
echo      		           SORTHEAP, STMTHEAP, MAXLOCKS, LOCKLIST, MAXAPPLS, LOGPRIMARY, LOGSECOND
    
echo Note:
echo    The IBM Aperi database will be enabled for on-line backups.
echo.
goto exit
REM
REM =======================================================================

:Start
REM -----------------------------------------------------------------------
REM Initialize variables
REM -----------------------------------------------------------------------
set errorlevel=
if "%1"=="" goto Usage
set DB2ADMIN=%1
if "%2"=="" goto Usage
set DB2ADMPASS=%2
if "%3"=="" goto Usage
set DBNAME=%3
if "%4"=="" goto Usage
set CDFLAG=%4
if "%5"=="" goto Usage
set LOGSIZE=%5
set LOGPATH=%6
set SHEAPTHRES=%7
set DBHEAP=%8
set APPLHEAPSZ=%9
SHIFT
set APP_CTL_HEAP_SZ=%9
SHIFT
set APPGROUP_MEM_SZ=%9
SHIFT
set SORTHEAP=%9
SHIFT
set STMTHEAP=%9
SHIFT
set MAXLOCKS=%9
SHIFT
set LOCKLIST=%9
SHIFT
set MAXAPPLS=%9
SHIFT
set LOGPRIMARY=%9
SHIFT
set LOGSECOND=%9

REM -----------------------------------------------------------------------
REM Check if DB already exists
REM -----------------------------------------------------------------------
    set DBEXISTS=YES
    db2 connect to %DBNAME% user %DB2ADMIN% using %DB2ADMPASS% > NUL 2>&1
    if %errorlevel% GEQ 4 (
        echo Database %DBNAME% does not exist
        if "%CDFLAG%"=="Create" (
            goto createdb
        ) else (
            goto exit
        )
    )


    if "%CDFLAG%"=="Create" (
        echo Database %DBNAME% already exists
        db2 disconnect %DBNAME% > NUL 2>&1
        goto configdb
    ) else (
        goto dropdb
    )

:dropdb
REM -----------------------------------------------------------------------
REM catalog, drop and uncatalog the db
REM -----------------------------------------------------------------------
    db2 disconnect %DBNAME% > NUL 2>&1
    db2 catalog db %DBNAME% > NUL 2>&1
    echo Dropping database %DBNAME%
    db2 drop db %DBNAME%
    if %errorlevel% GEQ 4 goto dropErrExit
    echo %DBNAME% database dropped
    db2 uncatalog db %DBNAME% > NUL 2>&1
    goto end

:createdb
REM -----------------------------------------------------------------------
REM catalog, drop and uncatalog the db first
REM -----------------------------------------------------------------------
    db2 catalog db %DBNAME% > NUL 2>&1
    db2 drop db %DBNAME% > NUL 2>&1
    db2 uncatalog db %DBNAME% > NUL 2>&1
    echo Creating database %DBNAME%
    set DBEXISTS=NO
    db2 create db %DBNAME%
    if %errorlevel% GEQ 4 goto createErrExit

:configdb
REM -----------------------------------------------------------------------
REM Configure the database
REM -----------------------------------------------------------------------
    db2 list application show detail

REM default for SHEAPTHRES = 65537
    db2 update dbm cfg using SHEAPTHRES %SHEAPTHRES%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for DBHEAP = 1000
    db2 update db cfg for %DBNAME% using DBHEAP %DBHEAP%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for APPLHEAPSZ = 10240
    db2 update db cfg for %DBNAME% using APPLHEAPSZ %APPLHEAPSZ%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for APP_CTL_HEAP_SZ = 1024
    db2 update db cfg for %DBNAME% using APP_CTL_HEAP_SZ %APP_CTL_HEAP_SZ%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for APPGROUP_MEM_SZ = 40000
    db2 update db cfg for %DBNAME% using APPGROUP_MEM_SZ %APPGROUP_MEM_SZ%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for SORTHEAP = 4096
    db2 update db cfg for %DBNAME% using SORTHEAP %SORTHEAP%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for STMTHEAP = 10240
    db2 update db cfg for %DBNAME% using STMTHEAP %STMTHEAP%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for MAXLOCKS = 50
    db2 update db cfg for %DBNAME% using MAXLOCKS %MAXLOCKS%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for LOCKLIST = 10000
    db2 update db cfg for %DBNAME% using LOCKLIST %LOCKLIST%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for MAXAPPLS = 150
    db2 update db cfg for %DBNAME% using MAXAPPLS %MAXAPPLS%
    if %errorlevel% GEQ 4 goto createErrExit
REM TPC is designed with lock requests never timeout (LOCKTIMEOUT -1 )
REM do not change this value
    db2 update db cfg for %DBNAME% using LOCKTIMEOUT -1
    if %errorlevel% GEQ 4 goto createErrExit
REM default for logfilsiz = 1000
    db2 update db cfg for %DBNAME% using logfilsiz %LOGSIZE%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for logprimary = 8
    db2 update db cfg for %DBNAME% using logprimary %LOGPRIMARY%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for logsecond = 16
    db2 update db cfg for %DBNAME% using logsecond %LOGSECOND%
    if %errorlevel% GEQ 4 goto createErrExit
REM default for auto_maint = on
    db2 update db cfg for %DBNAME% using auto_maint on
    if %errorlevel% GEQ 4 goto createErrExit
REM default for auto_tbl_maint = on
    db2 update db cfg for %DBNAME% using auto_tbl_maint on
    if %errorlevel% GEQ 4 goto createErrExit
REM default for auto_runstats = on
    db2 update db cfg for %DBNAME% using auto_runstats on
    if %errorlevel% GEQ 4 goto createErrExit
REM default for newlogpath = ""
    if not "%LOGPATH%" == "-1"  db2 update db cfg for %DBNAME% using newlogpath %LOGPATH%
    if %errorlevel% GEQ 4 goto createErrExit
    db2updv8 -d %DBNAME% -u %DB2ADMIN% -p %DB2ADMPASS% 
    if %errorlevel% GEQ 4 goto createErrExit
    db2 connect to %DBNAME% user %DB2ADMIN% using %DB2ADMPASS%
    if %errorlevel% GEQ 4 goto createErrExit
    cd /D "%DB2PATH%\bnd"
    db2 bind @db2cli.lst blocking all grant public sqlerror continue CLIPKG 30

goto end

:createErrExit
    db2 disconnect %DBNAME%
    if "%DBEXISTS%"=="YES" goto createErrExit2
    echo Dropping %DBNAME% database because an error was encountered.
    db2 drop database %DBNAME%
    echo %DBNAME% database dropped
:createErrExit2
    echo IBM Aperi database creation or configuration failed.
    goto ErrExit

:dropErrExit
    echo IBM Aperi database drop failed.
    goto ErrExit

REM -----------------------------------------------------------------------
REM Success exit point
REM -----------------------------------------------------------------------
:end

    if "%CDFLAG%"=="Create" (
        db2 commit work
        db2 disconnect %DBNAME%
        echo Aperi database creation and configuration completed successfully.
    ) else (
        echo Aperi database drop completed successfully.
    )
    goto exit

:ErrExit
	dir > %TEMP%\done
	echo Creating file done
    endlocal
    exit 1

:exit
	dir > %TEMP%\done
	echo Creating file done
    endlocal
