/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OctetString;

public class OID
implements Serializable,
Comparable {
    public long[] value;
    private int berLength = -1;

    public OID(int[] nArray) {
        int n = nArray.length;
        this.value = new long[n];
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = nArray[n2];
            ++n2;
        }
    }

    public OID(long[] lArray) {
        this(lArray, false);
    }

    public OID(OID oID) {
        this.value = new long[oID.value.length];
        System.arraycopy(oID.value, 0, this.value, 0, oID.value.length);
    }

    public OID(int[] nArray, int n) {
        this.value = new long[n];
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = nArray[n2];
            ++n2;
        }
    }

    public OID(long[] lArray, int n) {
        this.value = new long[n];
        System.arraycopy(lArray, 0, this.value, 0, n);
    }

    public OID(long[] lArray, boolean bl) {
        if (bl) {
            this.value = lArray;
        } else {
            this.value = new long[lArray.length];
            System.arraycopy(lArray, 0, this.value, 0, lArray.length);
        }
    }

    public OID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        this.value = new long[n];
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = Long.parseLong(stringTokenizer.nextToken());
            ++n2;
        }
    }

    public int getBERlength() {
        if (this.berLength == -1) {
            this.berLength = 1;
            int n = this.value.length;
            int n2 = 2;
            while (n2 < n) {
                long l = this.value[n2];
                this.berLength = l < 0L ? (this.berLength += 9) : (l < 128L ? ++this.berLength : (l < 16384L ? (this.berLength += 2) : (l < 0x200000L ? (this.berLength += 3) : (l < 0x10000000L ? (this.berLength += 4) : (l < 0x800000000L ? (this.berLength += 5) : (l < 0x40000000000L ? (this.berLength += 6) : (l < 0x2000000000000L ? (this.berLength += 7) : (l < 0x100000000000000L ? (this.berLength += 8) : (this.berLength += 9)))))))));
                ++n2;
            }
            return this.berLength;
        }
        return this.berLength;
    }

    public OID concatenate(int n) {
        int n2 = this.value.length;
        long[] lArray = new long[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            lArray[n3] = this.value[n3];
            ++n3;
        }
        lArray[n3] = n;
        OID oID = new OID(lArray, true);
        return oID;
    }

    public OID concatenate(long l) {
        int n = this.value.length;
        long[] lArray = new long[n + 1];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = this.value[n2];
            ++n2;
        }
        lArray[n2] = l;
        OID oID = new OID(lArray, true);
        return oID;
    }

    public OID concatenate(String string, boolean bl) {
        int n = this.value.length;
        int n2 = string.length();
        long[] lArray = bl ? new long[n + 1 + n2] : new long[n + n2];
        int n3 = 0;
        while (n3 < n) {
            lArray[n3] = this.value[n3];
            ++n3;
        }
        if (bl) {
            lArray[n3++] = n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            lArray[n3] = string.charAt(n4);
            ++n3;
            ++n4;
        }
        OID oID = new OID(lArray, true);
        return oID;
    }

    public OID concatenate(OctetString octetString, boolean bl) {
        int n = this.value.length;
        int n2 = octetString.value.length;
        long[] lArray = bl ? new long[n + 1 + n2] : new long[n + n2];
        int n3 = 0;
        while (n3 < n) {
            lArray[n3] = this.value[n3];
            ++n3;
        }
        if (bl) {
            lArray[n3++] = n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            lArray[n3] = (long)octetString.value[n4] & 0xFFL;
            ++n3;
            ++n4;
        }
        OID oID = new OID(lArray, true);
        return oID;
    }

    public OID concatenate(IPAddress iPAddress) {
        int n = this.value.length;
        byte[] byArray = iPAddress.getBytes();
        int n2 = byArray.length;
        long[] lArray = new long[n + n2];
        int n3 = 0;
        while (n3 < n) {
            lArray[n3] = this.value[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            lArray[n3] = (long)byArray[n4] & 0xFFL;
            ++n3;
            ++n4;
        }
        OID oID = new OID(lArray, true);
        return oID;
    }

    public OID concatenate(OID oID) {
        return this.concatenate(oID.value);
    }

    public OID concatenate(int[] nArray) {
        if (nArray == null) {
            return this;
        }
        int n = this.value.length;
        int n2 = nArray.length;
        long[] lArray = new long[n + n2];
        int n3 = 0;
        while (n3 < n) {
            lArray[n3] = this.value[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            lArray[n3++] = nArray[n4];
            ++n4;
        }
        OID oID = new OID(lArray, true);
        return oID;
    }

    public OID concatenate(long[] lArray) {
        if (lArray == null) {
            return this;
        }
        int n = this.value.length;
        int n2 = lArray.length;
        long[] lArray2 = new long[n + n2];
        int n3 = 0;
        while (n3 < n) {
            lArray2[n3] = this.value[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            lArray2[n3++] = lArray[n4];
            ++n4;
        }
        OID oID = new OID(lArray2, true);
        return oID;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.value[0]));
        int n = 1;
        while (n < this.value.length) {
            stringBuffer.append(".");
            stringBuffer.append(this.value[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof OID) {
            OID oID = (OID)object;
            boolean bl = true;
            if (this.value.length == oID.value.length) {
                int n = this.value.length - 1;
                while (bl && n >= 0) {
                    bl = this.value[n] == oID.value[n];
                    --n;
                }
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (n == 0) {
            int n2 = 0;
            long[] lArray = this.value;
            int n3 = this.value.length;
            int n4 = 0;
            while (n4 < n3) {
                long l = lArray[n2++];
                int n5 = (int)(l ^ l >>> 32);
                n = 31 * n + n5;
                ++n4;
            }
        }
        return n;
    }

    public boolean startsWith(OID oID) {
        boolean bl = true;
        if (oID.value.length <= this.value.length) {
            int n;
            int n2 = n = oID.value.length - 1;
            while (bl && n2 >= 0) {
                bl = oID.value[n2] == this.value[n2];
                --n2;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public int compareTo(Object object) {
        return this.compareTo((OID)object);
    }

    public int compareTo(OID oID) {
        int n = this.value.length;
        int n2 = oID.value.length;
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n3-- != 0) {
            long l;
            long l2 = this.value[n4];
            if (l2 < (l = oID.value[n4++])) {
                return -1;
            }
            if (l2 <= l) continue;
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.value.length);
        int n = 0;
        while (n < this.value.length) {
            objectOutputStream.writeLong(this.value[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.value = new long[n];
        int n2 = 0;
        while (n2 < n) {
            this.value[n2] = objectInputStream.readLong();
            ++n2;
        }
        this.berLength = -1;
    }
}

