/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.utils.CallbackThread;
import org.eclipse.aperi.snmp.utils.OrderedQueue;
import org.eclipse.aperi.snmp.utils.Timer;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class TimerService
extends Thread {
    private static boolean running = false;
    private static boolean started = false;
    private static boolean waiting = false;
    private static OrderedQueue timerQ = new OrderedQueue();
    private static TimerService inst = null;
    private static Object lock = new Object();

    private TimerService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Object object = lock;
        synchronized (object) {
            if (!started) {
                started = true;
                inst = new TimerService();
                inst.setDaemon(true);
                inst.start();
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        boolean bl;
        Object object = lock;
        synchronized (object) {
            bl = started && waiting;
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: isReady=" + bl);
        }
        return bl;
    }

    public static Timer scheduleWakeUp(int n, Wakeable wakeable) {
        return TimerService.scheduleWakeUp(n, wakeable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer scheduleWakeUp(int n, Wakeable wakeable, Object object) {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: scheduling wakeup");
        }
        if (!started) {
            TimerService.initialize();
        }
        if (!running) {
            return null;
        }
        Timer timer = new Timer(n, wakeable, object);
        Object object2 = lock;
        synchronized (object2) {
            boolean bl;
            timerQ.enqueue(timer);
            boolean bl2 = bl = timer == (Timer)timerQ.peek();
            if (bl && waiting) {
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("TimerService: wakeup is first, notifying");
                }
                lock.notify();
            }
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: scheduled wakeup");
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelWakeUp(Timer timer) {
        boolean bl;
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: canceling wakeup");
        }
        Object object = lock;
        synchronized (object) {
            boolean bl2 = timer == (Timer)timerQ.peek();
            bl = timerQ.dequeue(timer);
            if (bl2 && waiting) {
                lock.notify();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        this.setName("TimerService");
        var4_1 = false;
        TimerService.started = true;
        TimerService.running = true;
        var5_2 = TimerService.lock;
        synchronized (var5_2) {
            TimerService.waiting = true;
            TimerService.lock.notify();
            try {
                TimerService.lock.wait();
            }
            catch (InterruptedException v0) {}
            if (true) ** GOTO lbl64
        }
        do {
            var1_3 = null;
            var2_4 = -1L;
            var5_2 = TimerService.lock;
            synchronized (var5_2) {
                if (!TimerService.timerQ.isEmpty()) {
                    var4_1 = false;
                    var1_3 = (Timer)TimerService.timerQ.peek();
                    var2_4 = var1_3.getPopTime() - System.currentTimeMillis();
                    if (var2_4 <= 0L) {
                        var1_3 = (Timer)TimerService.timerQ.dequeue();
                        if (var2_4 < 0L) {
                            var4_1 = true;
                        }
                    } else {
                        TimerService.waiting = true;
                        try {
                            if (SnmpV1API.isTracing()) {
                                SnmpV1API.trace("TimerService: waiting(1) " + var2_4);
                            }
                            TimerService.lock.wait(var2_4);
                        }
                        catch (InterruptedException v2) {}
                        TimerService.waiting = false;
                        var1_3 = null;
                    }
                } else {
                    TimerService.waiting = true;
                    try {
                        if (SnmpV1API.isTracing()) {
                            SnmpV1API.trace("TimerService: waiting(2) ");
                        }
                        TimerService.lock.wait();
                    }
                    catch (InterruptedException v3) {}
                    TimerService.waiting = false;
                }
            }
            if (var1_3 == null) continue;
            if (var4_1) {
                var5_2 = new CallbackThread(var1_3);
                if (SnmpV1API.isTracing()) {
                    SnmpV1API.trace("TimerService: starting thread");
                }
                var5_2.start();
                continue;
            }
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("TimerService: waking up");
            }
            var1_3.wakeUp();
lbl64:
            // 4 sources

        } while (TimerService.running);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("TimerService: terminating");
        }
        Object object = lock;
        synchronized (object) {
            if (running) {
                running = false;
                if (waiting) {
                    lock.notify();
                    Thread.yield();
                }
            }
        }
        started = false;
        running = false;
        waiting = false;
        inst = null;
    }
}

