/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.Variables;

public class SNMPTraceLogger
extends PrintStream {
    private String fileName = null;
    private PrintStream log = null;
    private int offset = 0;
    private long bytesOut = 0L;
    private boolean logTimeStamp = false;
    private boolean logThreadName = true;
    private static final int maxLogs = 10;
    private static final long maxLogSize = 20480000L;

    public SNMPTraceLogger() throws FileNotFoundException {
        this(String.valueOf(Variables.getBaseDirectory()) + File.separator + "log" + File.separator + "SnmpTrace.log", false, true);
    }

    public SNMPTraceLogger(String string) throws FileNotFoundException {
        this(string, false, true);
    }

    public SNMPTraceLogger(String string, boolean bl) throws FileNotFoundException {
        this(string, bl, true);
    }

    public SNMPTraceLogger(boolean bl) throws FileNotFoundException {
        this(String.valueOf(Variables.getBaseDirectory()) + File.separator + "log" + File.separator + "SnmpTrace.log", bl, true);
    }

    public SNMPTraceLogger(boolean bl, boolean bl2) throws FileNotFoundException {
        this(String.valueOf(Variables.getBaseDirectory()) + File.separator + "log" + File.separator + "SnmpTrace.log", bl, bl2);
    }

    public SNMPTraceLogger(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        super(new BufferedOutputStream(new FileOutputStream(string, true)), true);
        this.fileName = string;
        this.logTimeStamp = bl;
        this.logThreadName = bl2;
        this.log = new PrintStream(new BufferedOutputStream(new FileOutputStream(string, true)), true);
        File file = new File(string);
        this.bytesOut = file.length();
    }

    public void flush() {
        if (this.log != null) {
            this.log.flush();
        }
    }

    public void close() {
        if (this.log != null) {
            this.log.close();
        }
        super.close();
    }

    public boolean checkError() {
        if (this.log != null) {
            return this.log.checkError();
        }
        return true;
    }

    public void write(int n) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.write(n);
            this.log.flush();
            ++this.offset;
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.write(byArray, n, n2);
            this.log.flush();
            this.offset += n2;
            this.bytesOut += (long)n2;
        }
    }

    public void write(byte[] byArray) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            try {
                this.log.write(byArray);
            }
            catch (IOException iOException) {}
            this.log.flush();
            this.offset += byArray.length;
            this.bytesOut += (long)byArray.length;
        }
    }

    public void print(boolean bl) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(bl);
            this.log.flush();
            this.offset += bl ? 4 : 5;
            this.bytesOut += (long)(bl ? 4 : 5);
        }
    }

    public void print(char c) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(c);
            this.log.flush();
            this.offset += String.valueOf(c).length();
            this.bytesOut += (long)String.valueOf(c).length();
        }
    }

    public void print(int n) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(n);
            this.log.flush();
            this.offset += String.valueOf(n).length();
            this.bytesOut += (long)String.valueOf(n).length();
        }
    }

    public void print(long l) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(l);
            this.log.flush();
            this.offset += String.valueOf(l).length();
            this.bytesOut += (long)String.valueOf(l).length();
        }
    }

    public void print(float f) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(f);
            this.log.flush();
            this.offset += String.valueOf(f).length();
            this.bytesOut += (long)String.valueOf(f).length();
        }
    }

    public void print(double d) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(d);
            this.log.flush();
            this.offset += String.valueOf(d).length();
            this.bytesOut += (long)String.valueOf(d).length();
        }
    }

    public void print(char[] cArray) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(cArray);
            this.log.flush();
            this.offset += cArray.length;
            this.bytesOut += (long)cArray.length;
        }
    }

    public void print(Object object) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(object);
            this.log.flush();
            this.offset += String.valueOf(object).length();
            this.bytesOut += (long)String.valueOf(object).length();
        }
    }

    public void print(String string) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(string);
            this.log.flush();
            this.offset += string.length();
            this.bytesOut += (long)string.length();
        }
    }

    public void println(boolean bl) {
        this.print(bl);
        this.newLine();
    }

    public void println(char c) {
        this.print(c);
        this.newLine();
    }

    public void println(int n) {
        this.print(n);
        this.newLine();
    }

    public void println(long l) {
        this.print(l);
        this.newLine();
    }

    public void println(float f) {
        this.print(f);
        this.newLine();
    }

    public void println(double d) {
        this.print(d);
        this.newLine();
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.newLine();
    }

    public void println(String string) {
        this.print(string);
        this.newLine();
    }

    public void println(Object object) {
        this.print(object);
        this.newLine();
    }

    public void println() {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.newLine();
        }
    }

    private void newLine() {
        if (this.log != null) {
            this.logThreadName();
            this.log.println();
            this.log.flush();
            this.offset = 0;
        }
    }

    private String getNewFileName(String string, int n) {
        File file = new File(string);
        String string2 = file.getName();
        String string3 = file.getPath().substring(0, file.getPath().indexOf(string2));
        new Vector();
        String string4 = string3;
        int n2 = string2.indexOf(".");
        string4 = n2 != -1 ? string4.concat(String.valueOf(string2.substring(0, n2)) + n + string2.substring(n2)) : string4.concat(String.valueOf(string2) + n);
        return string4;
    }

    private synchronized void wrapLog() {
        boolean bl = false;
        File file = new File(this.fileName);
        try {
            file.length();
            if (file.length() >= 20480000L || this.bytesOut >= 20480000L) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        if (bl) {
            int n = 9;
            while (n > 0) {
                File file2 = new File(this.getNewFileName(this.fileName, n));
                if (file2.exists()) {
                    file2.renameTo(new File(this.getNewFileName(this.fileName, n + 1)));
                }
                --n;
            }
            File file3 = new File(this.getNewFileName(this.fileName, 10));
            if (file3.exists()) {
                file3.delete();
            }
            this.close();
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
            this.bytesOut = 0L;
            this.offset = 0;
            file.renameTo(new File(this.getNewFileName(this.fileName, 1)));
            this.log = null;
            try {
                this.log = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.fileName, true)), true);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
    }

    private synchronized void logDateAndTime() {
        if (this.logTimeStamp && this.offset == 0 && this.log != null) {
            TimeZone timeZone = TimeZone.getDefault();
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(timeZone);
            String string = String.valueOf(simpleDateFormat.format(date)) + "  ";
            this.log.print(string);
            this.offset += string.length();
            this.bytesOut += (long)string.length();
        }
    }

    private synchronized void logThreadName() {
        if (this.logThreadName && this.log != null) {
            String string = "  [" + Thread.currentThread().getName() + "]";
            this.log.print(string);
            this.offset += string.length();
            this.bytesOut += (long)string.length();
        }
    }
}

