/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import com.tivoli.tec.event_delivery.EDException;
import com.tivoli.tec.event_delivery.TECAgent;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.event.DestinationFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class TecEventProcessor
implements Runnable {
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;
    private Vector eventQueue = new Vector();
    DestinationFactory destFactory = null;
    private Thread workerThread = null;
    private static TecEventProcessor myThread;
    private static long MAXNUMBEROFTRAP;
    private TECAgent tecAgent = null;
    private String serverLocation = null;
    private int serverPort = -1;
    private String debugMode = null;

    static {
        Class<?> clazz;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.TecEventProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
        myThread = null;
        MAXNUMBEROFTRAP = 1000L;
    }

    private TecEventProcessor() {
    }

    public static TecEventProcessor instance() {
        if (myThread == null) {
            myThread = new TecEventProcessor();
        }
        return myThread;
    }

    public void start(DestinationFactory destinationFactory) {
        String string = "start";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.destFactory = destinationFactory;
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String string = "stop";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.workerThread = null;
        TecEventProcessor tecEventProcessor = this;
        synchronized (tecEventProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string;
        block15: {
            string = "run";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            try {
                Thread thread = Thread.currentThread();
                while (this.workerThread == thread) {
                    String string2;
                    try {
                        Object object;
                        while (this.eventQueue.isEmpty()) {
                            object = this;
                            synchronized (object) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                                if (this.workerThread == null) {
                                    if (traceLogger.isLogging()) {
                                        string2 = "TecEventProcessor was shutdown";
                                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, string2);
                                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                                    }
                                    return;
                                }
                            }
                        }
                        object = (String)this.eventQueue.firstElement();
                        this.eventQueue.remove(0);
                        this.sendTecEvent((String)object);
                    }
                    catch (Exception exception) {
                        string2 = "Failed to send Tec Event";
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string, string2);
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                String string3 = "Failed to start TecEventProcessor";
                if (!traceLogger.isLogging()) break block15;
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string, string3);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTecEvent(String string) {
        String string2;
        String string3 = "addTecEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string3, (Object)new String("TECEvent"));
        }
        if ((string2 = this.destFactory.getTECServerLocation()) == null) {
            if (!this.eventQueue.isEmpty()) {
                this.eventQueue.removeAllElements();
            }
            return;
        }
        if ((long)this.eventQueue.size() < MAXNUMBEROFTRAP) {
            this.eventQueue.addElement(string);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "New TEC event added to TecEventProcessor for TEC client@" + string2);
        } else {
            if (!this.eventQueue.isEmpty()) {
                this.eventQueue.remove(0);
            }
            this.eventQueue.addElement(string);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Tec event queue for client@" + string2 + " is full, delete the oldest one and add the new one.");
        }
        TecEventProcessor tecEventProcessor = this;
        synchronized (tecEventProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
    }

    private int sendTecEvent(String string) {
        String string2 = "sendTecEvent";
        String string3 = null;
        int n = -1;
        int n2 = -2;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, (Object)new String("tecEvent"));
        }
        string3 = this.destFactory.getTECServerLocation();
        n = this.destFactory.getTECServerPort();
        if (string3 == null || string3.equals("")) {
            this.serverLocation = null;
            this.serverPort = -1;
            if (this.tecAgent != null) {
                this.tecAgent.disconnect();
                this.tecAgent = null;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "The TEC server location or the port was not set.  The TECAgent is null.");
                }
            }
            n2 = -2;
        } else if (this.tecAgent == null) {
            this.createTecAgent();
        } else if (!string3.equals(this.serverLocation) || n != this.serverPort) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "The TEC server location or port number has changed. A new TECAgent will be created to send TEC events.");
            }
            this.createTecAgent();
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Sending TEC event: " + string);
        }
        if (this.tecAgent != null) {
            n2 = this.tecAgent.sendEvent(string);
        }
        String string4 = n2 < 0 ? "Unable to send TEC event with return code = " + n2 : (n2 == 0 ? "The TEC event is filtered out with return code = " + n2 : "TEC event was sent successfully with number of bytes sent = " + n2);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, string4);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return n2;
    }

    private void createTecAgent() {
        String string;
        block11: {
            String string2;
            string = "createTecAgent";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            if ((string2 = this.getTecConfigString()) != null) {
                if (this.tecAgent != null) {
                    this.tecAgent.disconnect();
                    this.tecAgent = null;
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "TECAgent disconnected and was set to null.  The TECAgent will be recreated.");
                    }
                }
                try {
                    this.tecAgent = new TECAgent((Reader)new StringReader(string2), 0, false);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "TECAgent created successfully.");
                    }
                }
                catch (EDException eDException) {
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)className, string, "SANEventMessage_tecException");
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string, "Unable to create TEC agent to establish connection with the TEC server.");
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)eDException);
                    }
                }
                catch (Exception exception) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block11;
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)className, string, "Unable to create TEC agent to establish connection with the TEC server.");
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private String getTecConfigString() {
        String string = "getTecConfigString";
        this.serverLocation = this.destFactory.getTECServerLocation();
        this.serverPort = this.destFactory.getTECServerPort();
        this.debugMode = this.destFactory.getTECDebugMode();
        if (this.serverLocation == null || this.serverLocation.equals("")) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Server location returned is null. No TEC event will be sent.");
            }
            return null;
        }
        String string2 = Variables.getBaseDirectory();
        if (string2 == null) {
            string2 = "";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "The base product directory could not be located.");
            }
        } else {
            char c = File.separator.charAt(0);
            string2 = string2.replace('\\', c);
        }
        String string3 = String.valueOf(string2) + File.separator + "tec" + File.separator;
        String string4 = String.valueOf(string3) + "cache";
        String string5 = "";
        if (this.debugMode.equalsIgnoreCase("YES")) {
            string5 = "LogLevel=ALL\nTraceLevel=ALL\nLogFileName=" + string3 + "adptlog.log\n" + "TraceFileName=" + string3 + "adpttrc.log\n";
        }
        String string6 = "ServerLocation=" + this.serverLocation + "\n" + "ServerPort=" + this.serverPort + "\n" + "BufferEvents=YES\n" + "BufEvtPath=" + string4 + "\n" + "BufEvtMaxSize=512\n" + "ConnectionMode=connection_oriented\n" + string5;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "TEC Server configuration has value: \n" + string6);
        }
        return string6;
    }
}

