/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.discovery;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.agentreq.DiscoveryData;
import org.eclipse.aperi.agent.discovery.LANManagerDiscovery;
import org.eclipse.aperi.agent.handler.job.IExecutable;
import org.eclipse.aperi.agent.handler.job.IRestartable;
import org.eclipse.aperi.agent.handler.job.JobState;
import org.eclipse.aperi.agent.nas.AutoMounts;
import org.eclipse.aperi.agent.nas.Contactor;
import org.eclipse.aperi.agent.nas.ImportManager;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.nas.RemoteMountInfo;
import org.eclipse.aperi.agent.nas.netware.NetWareDiscovery;
import org.eclipse.aperi.agent.probe.ExecProbe;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.agent.util.NetWareLoader;
import org.eclipse.aperi.agent.util.SnmpPeer;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecDiscovery
implements IExecutable,
IRestartable {
    public static final String ARG_NETWARE = "NETWARE";
    public static final String ARG_NETWORK_DISCOVERY = "NETWORK_DISCOVERY";
    public static final int NETAPP_VENDOR_ID = 789;
    public static final int DEFAULT_SCHEDULE_ID = -1;
    private static final int COUNT_UP_TO = 50;
    public int rc;
    private FoundComputer prev;
    private FoundComputer fc;
    private boolean rejectNonRoot;
    private boolean lastWasRoot;

    @Override
    public int exec(StartedJob startedJob, String[] stringArray) {
        JobState jobState;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"main", (String)"");
        }
        this.rc = 0;
        boolean bl = startedJob == null;
        boolean bl2 = this.arrayContains(stringArray, ARG_NETWARE);
        boolean bl3 = this.arrayContains(stringArray, ARG_NETWORK_DISCOVERY);
        int n = -1;
        if (startedJob != null) {
            n = startedJob.getJobRun().getSchedID();
        }
        DiscoveryData discoveryData = new DiscoveryData();
        if (bl2) {
            discoveryData.dfNetwareOnlyDiscovery = true;
            discoveryData.dfNoNetworkDiscovery = true;
        }
        discoveryData.dfComputerID = ComputerID.cachedCID;
        discoveryData.dfDomain = Agent.domain;
        discoveryData.dfRunNumber = n;
        CheckedRequest checkedRequest = Agent.makeCheckedRequest();
        checkedRequest.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        checkedRequest.subType = "org.eclipse.aperi.server.handler.agent.DiscoveryHndlr";
        checkedRequest.serviceName = RequestTypeManager.getInternalName((String)checkedRequest.typeCode);
        checkedRequest.machineName = Agent.localName;
        checkedRequest.flags = 0;
        checkedRequest.requestData = discoveryData;
        MessageLog.logMessage((String)"AGT0145I");
        Response response = Agent.reporter.sendRequest((Request)checkedRequest, (byte)1);
        if (response == null || response.status > 4) {
            MessageLog.logMessage((String)"STA0245E");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"main", (int)8);
            }
            return 8;
        }
        MessageLog.logMessage((String)"STA0246I");
        discoveryData = (DiscoveryData)response.responseData;
        discoveryData.unpack();
        discoveryData.dfPackedNasFiler = null;
        boolean bl4 = this.rejectNonRoot = !discoveryData.dfIncludeNonRoot;
        if (bl) {
            boolean bl5 = discoveryData.dfNoNetworkDiscovery = !bl3;
        }
        if (bl2) {
            discoveryData.dfNoNetworkDiscovery = true;
        }
        new ExecProbe();
        if (Agent.isWindows) {
            this.rc = this.doWindowsDiscovery(discoveryData, bl, bl2);
        } else {
            discoveryData.dfNoNetworkDiscovery = false;
            this.rc = this.doUnixDiscovery(discoveryData);
        }
        if (this.rc > 4) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"main", (int)this.rc);
            }
            return this.rc;
        }
        discoveryData.dfComputerID = ComputerID.cachedCID;
        discoveryData.dfDomain = Agent.domain;
        discoveryData.dfNasVendor = null;
        discoveryData.dfPackedLdapTree = null;
        discoveryData.dfLdapTree = null;
        discoveryData.dfDefaultNasLogin = null;
        discoveryData.dfDefaultNasPwd = null;
        discoveryData.dfFirstDiscovery = bl;
        discoveryData.pack();
        if (bl) {
            jobState = null;
        } else {
            startedJob.setExitCode(this.rc);
            jobState = new JobState(startedJob, discoveryData);
            jobState.saveState();
        }
        if (this.sendResults(discoveryData, bl) && jobState != null) {
            jobState.deleteState();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"main", (int)this.rc);
        }
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contactFiler(NasFiler nasFiler, int n, String string, String string2, boolean bl) {
        block34: {
            block33: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"contactFiler", (String)"nf, vendorID, login, password");
                }
                Computer computer = nasFiler.nfComputer;
                try {
                    NasUtil.cifsLogIn(computer.cmpDomain.domName, nasFiler.nfNetworkName, string, string2);
                }
                catch (LocalizableException localizableException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"contactFiler", (Throwable)localizableException);
                    }
                    if (bl) {
                        localizableException.print();
                        this.rc = 4;
                    }
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"contactFiler", (boolean)false);
                    }
                    return false;
                }
                try {
                    Iterator iterator;
                    if (!Probe.enumExports(computer, nasFiler.nfNetworkName)) {
                        this.rc = 4;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"contactFiler", (boolean)false);
                        }
                        Object var14_9 = null;
                        break block33;
                    }
                    RemoteMountInfo remoteMountInfo = new RemoteMountInfo();
                    Map map = null;
                    PathConverter pathConverter = this.makePathConverter(n);
                    Object object = computer.cmpExport;
                    while (true) {
                        block35: {
                            if (object == null) {
                                if (this.rejectNonRoot) {
                                    iterator = map.entrySet().iterator();
                                    break;
                                }
                                break block34;
                            }
                            try {
                                remoteMountInfo.getInfo(nasFiler.nfNetworkName, ((Export)object).xpExportName);
                            }
                            catch (LocalizableException localizableException) {
                                if (TraceLogger.enableTrace) {
                                    Class<?> clazz;
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.exception((String)clazz.getName(), (String)"contactFiler", (Throwable)localizableException);
                                }
                                localizableException.print();
                                this.rc = 4;
                                break block35;
                            }
                            if (this.rejectNonRoot) {
                                this.hashByVolID(new HashMap<MutableInteger, String>(), pathConverter, remoteMountInfo, nasFiler, (Export)object);
                            } else {
                                this.hashByName(new HashMap<String, String>(), pathConverter, remoteMountInfo, nasFiler, (Export)object);
                            }
                        }
                        object = ((Export)object).xpNext;
                    }
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!Util.isEmpty((String)((String)object.getValue()))) continue;
                        MutableInteger mutableInteger = (MutableInteger)object.getKey();
                        String string3 = ExecDiscovery.makeVolSerString(mutableInteger.value);
                        MessageLog.logMessage((String)"NAA0067W", (Object)nasFiler.nfName, (Object)string3);
                        this.rc = 4;
                    }
                    break block34;
                }
                catch (Throwable throwable) {
                    Object var14_10 = null;
                    NasUtil.cifsLogOut(nasFiler.nfNetworkName);
                    throw throwable;
                }
            }
            NasUtil.cifsLogOut(nasFiler.nfNetworkName);
            return false;
        }
        Object var14_11 = null;
        NasUtil.cifsLogOut(nasFiler.nfNetworkName);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"contactFiler", (boolean)true);
        }
        return true;
    }

    @Override
    public int restart(JobState jobState) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"restart", (String)"jobState");
        }
        this.rc = jobState.job.getExitCode();
        DiscoveryData discoveryData = (DiscoveryData)jobState.state;
        this.sendResults(discoveryData, jobState == null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"restart", (int)this.rc);
        }
        return this.rc;
    }

    public void setRejectNonRoot(boolean bl) {
        this.rejectNonRoot = bl;
    }

    public static NasFiler newSANFSFileset(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"newSANFSFileset", (String)"sanfsClusterName");
        }
        NasFiler nasFiler = new NasFiler();
        nasFiler.nfName = string;
        nasFiler.nfNetworkName = " ";
        nasFiler.nfIPAddress = "";
        nasFiler.nfManufacturer = "IBM";
        nasFiler.nfSnmpCommunity = null;
        Computer computer = new Computer(true);
        computer.cmpManufacturer = nasFiler.nfManufacturer;
        computer.cmpDomain = null;
        nasFiler.nfOSType = computer.cmpOSType = (short)23;
        nasFiler.nfComputer = computer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"newSANFSFileset", (Object)nasFiler);
        }
        return nasFiler;
    }

    public static NasFiler newFiler(SnmpPeer snmpPeer, String string, Contactor contactor, Domain domain) {
        NameList nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"newFiler", (String)"peer, networkName, contactor, domain");
        }
        NasFiler nasFiler = new NasFiler();
        nasFiler.nfName = snmpPeer.name.toLowerCase();
        nasFiler.nfNetworkName = string;
        nasFiler.nfIPAddress = snmpPeer.address.getHostAddress();
        if (contactor.vendor != null) {
            nasFiler.nfManufacturer = contactor.vendor.nlName;
        } else if (contactor.vendorID > 0) {
            nasFiler.nfManufacturer = "unknown";
        }
        nasFiler.nfVendorID = contactor.vendorID;
        NameList nameList2 = contactor.communities;
        if (nameList2.nlID == -1) {
            nasFiler.nfSnmpCommunity = null;
        } else {
            nameList = (NameList)nameList2.clone();
            nameList.nlNext = null;
            nasFiler.nfSnmpCommunity = nameList;
        }
        nameList = new Computer(true);
        nameList.cmpManufacturer = nasFiler.nfManufacturer;
        nameList.cmpDomain = domain;
        nameList.cmpOSType = nasFiler.nfVendorID == 789 ? (short)10 : (short)9;
        nasFiler.nfOSType = nameList.cmpOSType;
        nasFiler.nfComputer = nameList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"newFiler", (Object)nasFiler);
        }
        return nasFiler;
    }

    private boolean loginsExpected(boolean bl) {
        return !bl;
    }

    private boolean sendResults(DiscoveryData discoveryData, boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"sendResults", (String)"results, jobState");
        }
        MessageLog.logMessage((String)"STA0249I");
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.AgentSvp";
        request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        request.machineName = Agent.localName;
        request.subType = "org.eclipse.aperi.server.handler.agent.DiscoveryHndlr";
        request.requestData = discoveryData;
        request.flags = (byte)(request.flags | 2);
        Response response = Agent.reporter.sendRequest(request, (byte)2);
        if (response != null && response.status <= 4) {
            MessageLog.logMessage((String)"STA0250I");
            if (response.status > this.rc) {
                this.rc = response.status;
            }
            if (this.rc == 0) {
                MessageLog.logMessage((String)"STA0252I");
            } else {
                MessageLog.logMessage((String)"STA0253I");
            }
        } else {
            MessageLog.logMessage((String)"STA0251E");
            if (!(bl || response != null && response.status != 8 && response.status != 24)) {
                MessageLog.logMessage((String)"STA0255I");
                this.rc = -4096;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"sendResults");
                }
                return false;
            }
            this.rc = response.status;
            MessageLog.logMessage((String)"STA0254I");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"sendResults");
        }
        return true;
    }

    private PathConverter makePathConverter(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makePathConverter", (String)"vendorID");
        }
        PathConverter pathConverter = null;
        switch (n) {
            case 789: {
                pathConverter = new NetAppPathConverter();
                break;
            }
            default: {
                pathConverter = new PathConverter(null, null);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makePathConverter", (Object)pathConverter);
        }
        return pathConverter;
    }

    private static void make4HexDigits(int n, char[] cArray, int n2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"make4HexDigits", (String)"value, array, pos");
        }
        int n3 = 0;
        while (n3 < 4) {
            int n4 = n & 0xF;
            if (n4 < 10) {
                n4 += 48;
            } else {
                n4 -= 10;
                n4 += 65;
            }
            cArray[n2] = (char)n4;
            --n2;
            n >>= 4;
            ++n3;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"make4HexDigits");
        }
    }

    private static String makeVolSerString(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeVolSerString", (String)"value");
        }
        char[] cArray = new char[9];
        ExecDiscovery.make4HexDigits(n >> 16, cArray, 3);
        cArray[4] = 45;
        ExecDiscovery.make4HexDigits(n, cArray, 8);
        String string = new String(cArray);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeVolSerString", (Object)string);
        }
        return string;
    }

    private void addFilesystem(NasFiler nasFiler, Export export, RemoteMountInfo remoteMountInfo, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addFilesystem", (String)"filer, xp, queryObj, path");
        }
        Computer computer = nasFiler.nfComputer;
        Filesystem filesystem = new Filesystem();
        filesystem.fsNasFiler = nasFiler;
        filesystem.fsMaxFiles = -1;
        filesystem.fsUsedInodes = -1;
        filesystem.fsFreeInodes = -1;
        filesystem.fsPhysicalSize = -1L;
        filesystem.fsCapacity = remoteMountInfo.rmCapacity;
        filesystem.fsFreeSpace = remoteMountInfo.rmFreeSpace;
        computer.cmpFilesystemFreeSpace += filesystem.fsFreeSpace;
        filesystem.fsUsedSpace = filesystem.fsCapacity - filesystem.fsFreeSpace;
        filesystem.fsType = this.lastWasRoot ? remoteMountInfo.rmFSType : (short)16;
        filesystem.fsMountPoint = string;
        filesystem.fsExportName = export.xpExportName;
        LogicalDisk logicalDisk = new LogicalDisk();
        logicalDisk.ldCapacity = filesystem.fsCapacity;
        logicalDisk.ldPath = filesystem.fsMountPoint;
        logicalDisk.ldFilesystem = filesystem;
        filesystem.fsLogicalDisk = logicalDisk;
        logicalDisk.ldType = (byte)7;
        logicalDisk.ldNext = computer.cmpLogicalDisk;
        computer.cmpLogicalDisk = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addFilesystem");
        }
    }

    private void hashByVolID(Map<MutableInteger, String> map, PathConverter pathConverter, RemoteMountInfo remoteMountInfo, NasFiler nasFiler, Export export) {
        MutableInteger mutableInteger;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"hashByVolID", (String)"map, converter, queryObj, nf, xp");
        }
        if (Util.isEmpty((String)map.get(mutableInteger = new MutableInteger(remoteMountInfo.rmVolID)))) {
            String string = pathConverter.convert(export);
            if (string == null) {
                map.put(mutableInteger, "");
            } else {
                this.addFilesystem(nasFiler, export, remoteMountInfo, string);
                map.put(mutableInteger, string);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"hashByVolID");
        }
    }

    private void hashByName(Map<String, String> map, PathConverter pathConverter, RemoteMountInfo remoteMountInfo, NasFiler nasFiler, Export export) {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"hashByName", (String)"map, converter, queryObj, nf, xp");
        }
        if ((string = pathConverter.convert(export)) != null && map.get(string) == null) {
            this.addFilesystem(nasFiler, export, remoteMountInfo, string);
            map.put(string, string);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"hashByName");
        }
    }

    private void advance(boolean bl) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"advance", (String)"setPrev");
        }
        if (bl) {
            this.prev = this.fc;
        }
        this.fc = this.fc.fcNext;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"advance");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doWindowsDiscovery(DiscoveryData var1_1, boolean var2_2, boolean var3_3) {
        block95: {
            block92: {
                block93: {
                    block90: {
                        block89: {
                            block88: {
                                block87: {
                                    block86: {
                                        if (TraceLogger.enableTrace) {
                                            try {
                                                v0 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                            }
                                            catch (ClassNotFoundException v1) {
                                                throw new NoClassDefFoundError(v1.getMessage());
                                            }
                                            TraceLogger.entry((String)v0.getName(), (String)"doWindowsDiscovery", (String)"structure");
                                        }
                                        var4_4 = var1_1.dfNasFiler;
                                        var5_5 = new MutableInteger();
                                        var5_5.value = 0;
                                        if (!var3_3) {
                                            var5_5 = this.doWindowsSanfsDiscovery(var1_1);
                                        }
                                        if (var5_5.value != 0) {
                                            MessageLog.logMessage((String)"STA0627I", (Object)var5_5);
                                        }
                                        var6_6 = var1_1.dfNasFiler;
                                        try {
                                            block99: {
                                                block97: {
                                                    block98: {
                                                        block96: {
                                                            if (var1_1.dfPackedLdapTree != null && var1_1.dfPackedLdapTree.length != 0) break block96;
                                                            this.rc = 0;
                                                            var1_1.dfNasFiler = null;
                                                            break block97;
                                                        }
                                                        if (NetWareLoader.loadNetWare(true)) break block98;
                                                        MessageLog.logMessage((String)"STA0247E");
                                                        v2 = var7_7 = var5_5.value != 0 ? var5_5.value : this.rc;
                                                        if (TraceLogger.enableTrace) {
                                                            try {
                                                                v3 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                                            }
                                                            catch (ClassNotFoundException v4) {
                                                                throw new NoClassDefFoundError(v4.getMessage());
                                                            }
                                                            TraceLogger.exit((String)v3.getName(), (String)"doWindowsDiscovery", (int)var7_7);
                                                        }
                                                        var28_10 = var7_7;
                                                        var26_15 = null;
                                                        if (var1_1.dfNasFiler == null) {
                                                            var1_1.dfNasFiler = var6_6;
                                                            break block86;
                                                        }
                                                        var29_22 = var1_1.dfNasFiler;
                                                        if (true) ** GOTO lbl218
                                                    }
                                                    var7_8 = new NetWareDiscovery(var1_1.dfPackedLdapTree);
                                                    MessageLog.logMessage((String)"STA0341I");
                                                    var8_29 = var7_8.go(null);
                                                    this.rc = var7_8.rc;
                                                    if (this.rc > 4) {
                                                        MessageLog.logMessage((String)"NAA0046E");
                                                        if (TraceLogger.enableTrace) {
                                                            try {
                                                                v5 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                                            }
                                                            catch (ClassNotFoundException v6) {
                                                                throw new NoClassDefFoundError(v6.getMessage());
                                                            }
                                                            TraceLogger.exit((String)v5.getName(), (String)"doWindowsDiscovery", (int)this.rc);
                                                        }
                                                        var28_11 = this.rc;
                                                        break block87;
                                                    }
                                                    var1_1.dfNasFiler = var8_29.ddNasFiler;
                                                }
                                                if (var1_1.dfNoNetworkDiscovery) {
                                                    v7 = var7_9 = var5_5.value != 0 ? var5_5.value : this.rc;
                                                    if (TraceLogger.enableTrace) {
                                                        try {
                                                            v8 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                                        }
                                                        catch (ClassNotFoundException v9) {
                                                            throw new NoClassDefFoundError(v9.getMessage());
                                                        }
                                                        TraceLogger.exit((String)v8.getName(), (String)"doWindowsDiscovery", (int)var7_9);
                                                    }
                                                    var28_12 = var7_9;
                                                    break block88;
                                                }
                                                var7_8 = Agent.domain;
                                                if (var7_8 == null) {
                                                    var7_8 = "(null)";
                                                }
                                                MessageLog.logMessage((String)"STA0339I", (Object)var7_8);
                                                var8_30 = var1_1.dfExcludeWorkstations;
                                                var9_31 = null;
                                                var10_32 = false;
                                                try {
                                                    var9_31 = LANManagerDiscovery.findComputers(null, var8_30);
                                                }
                                                catch (LocalizableException var11_33) {
                                                    if (TraceLogger.enableTrace) {
                                                        try {
                                                            v10 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                                        }
                                                        catch (ClassNotFoundException v11) {
                                                            throw new NoClassDefFoundError(v11.getMessage());
                                                        }
                                                        TraceLogger.exception((String)v10.getName(), (String)"doWindowsDiscovery", (Throwable)var11_33);
                                                    }
                                                    var11_33.print();
                                                    var10_32 = true;
                                                }
                                                if (var9_31 == null) {
                                                    v12 = var11_34 = var10_32 != false ? 8 : 0;
                                                    if (TraceLogger.enableTrace) {
                                                        try {
                                                            v13 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                                        }
                                                        catch (ClassNotFoundException v14) {
                                                            throw new NoClassDefFoundError(v14.getMessage());
                                                        }
                                                        TraceLogger.exit((String)v13.getName(), (String)"doWindowsDiscovery", (int)var11_34);
                                                    }
                                                    var28_13 = var11_34;
                                                    break block89;
                                                }
                                                var11_35 = NasUtil.parseVendorArray(var1_1.dfNasVendor);
                                                if (var11_35 == null) break block99;
                                                var12_36 = new MutableInteger();
                                                this.fc = var9_31;
                                                while (true) {
                                                    if (this.fc == null) {
                                                        var13_37 = new MutableInteger();
                                                        var14_38 = new Domain();
                                                        var14_38.domName = Agent.domain;
                                                        var15_39 = new HashMap<String, FoundComputer>();
                                                        var16_40 = new SnmpPeer(null, null);
                                                        var17_41 = new Contactor(var16_40, var11_35, var1_1.dfCommunity);
                                                        this.prev = null;
                                                        this.fc = var9_31;
                                                        break;
                                                    }
                                                    if (this.fc.fcAddress != null) {
                                                        ++var12_36.value;
                                                    }
                                                    this.fc = this.fc.fcNext;
                                                }
                                                while (this.fc != null && this.rc <= 4) {
                                                    block101: {
                                                        block104: {
                                                            block91: {
                                                                block103: {
                                                                    block102: {
                                                                        block100: {
                                                                            var18_42 = true;
                                                                            if (!Agent.stopNow) break block100;
                                                                            MessageLog.logMessage((String)"AGT0157E");
                                                                            this.rc = 8;
                                                                            break block101;
                                                                        }
                                                                        if (this.fc.fcWin2kCluster) {
                                                                            if (this.prev == null) {
                                                                                var9_31 = this.fc.fcNext;
                                                                            } else {
                                                                                this.prev.fcNext = this.fc.fcNext;
                                                                            }
                                                                            var18_42 = false;
                                                                        }
                                                                        if (this.fc.fcAddress == null) break block101;
                                                                        ++var13_37.value;
                                                                        if (var13_37.value % 50 == 0) {
                                                                            var19_43 = new Object[]{var13_37, var12_36};
                                                                            MessageLog.logMessage((String)"STA0340I", (Object[])var19_43);
                                                                        }
                                                                        var16_40.address = this.fc.fcAddress;
                                                                        var16_40.name = this.fc.fcName;
                                                                        if (var17_41.contact() != null) break block102;
                                                                        if (var17_41.rc > this.rc) {
                                                                            this.rc = var17_41.rc;
                                                                            if (this.rc > 4) {
                                                                                if (TraceLogger.enableTrace) {
                                                                                    try {
                                                                                        v15 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                                                                    }
                                                                                    catch (ClassNotFoundException v16) {
                                                                                        throw new NoClassDefFoundError(v16.getMessage());
                                                                                    }
                                                                                    TraceLogger.exit((String)v15.getName(), (String)"doWindowsDiscovery", (int)this.rc);
                                                                                }
                                                                                var28_14 = this.rc;
                                                                                break block90;
                                                                            }
                                                                        }
                                                                        break block101;
                                                                    }
                                                                    if (this.prev == null) {
                                                                        var9_31 = this.fc.fcNext;
                                                                    } else {
                                                                        this.prev.fcNext = this.fc.fcNext;
                                                                    }
                                                                    var18_42 = false;
                                                                    var19_43 = (Object[])var15_39.get(var16_40.name);
                                                                    if (var19_43 == null) break block103;
                                                                    MessageLog.logMessage((String)"NAA0011I", (Object)var16_40.name, (Object)this.fc.fcName, (Object)var19_43.fcName);
                                                                    break block101;
                                                                }
                                                                var15_39.put(var16_40.name, this.fc);
                                                                var20_44 = null;
                                                                var21_45 = null;
                                                                var22_46 = null;
                                                                var23_47 = var4_4;
                                                                var24_48 = true;
                                                                while (true) {
                                                                    if (!var24_48 || var23_47 == null) {
                                                                        if (var22_46 != null && !Util.isEmpty((String)var22_46.ltLdapUser) && !Util.isEmpty((String)var22_46.ltPassword)) {
                                                                            var20_44 = var22_46.ltLdapUser;
                                                                            var21_45 = var22_46.ltPassword;
                                                                        }
                                                                        if (var20_44 == null && !Util.isEmpty((String)var1_1.dfDefaultNasLogin) && !Util.isEmpty((String)var1_1.dfDefaultNasPwd)) {
                                                                            var20_44 = var1_1.dfDefaultNasLogin;
                                                                            var21_45 = var1_1.dfDefaultNasPwd;
                                                                        }
                                                                        var23_47 = ExecDiscovery.newFiler(var16_40, this.fc.fcName, var17_41, var14_38);
                                                                        var25_49 = false;
                                                                        if (var20_44 == null) break block91;
                                                                    }
                                                                    if (!var23_47.nfName.equals(var16_40.name)) {
                                                                        var23_47 = var23_47.nfNext;
                                                                        continue;
                                                                    }
                                                                    var22_46 = var23_47.nfLdapTree;
                                                                    var24_48 = false;
                                                                }
                                                                var25_49 = this.contactFiler(var23_47, var17_41.vendor.nlID, var20_44, var21_45, var2_2 == false);
                                                                break block104;
                                                            }
                                                            if (this.loginsExpected(var2_2)) {
                                                                MessageLog.logMessage((String)"NAA0065W", (Object)var23_47.nfName);
                                                                this.rc = 4;
                                                            }
                                                        }
                                                        if (var25_49 || var24_48) {
                                                            var23_47.nfNext = var1_1.dfNasFiler;
                                                            var1_1.dfNasFiler = var23_47;
                                                        }
                                                    }
                                                    this.advance(var18_42);
                                                }
                                            }
                                            var1_1.dfManageable = var9_31;
                                            ** GOTO lbl-1000
                                        }
                                        catch (Throwable var27_50) {
                                            var26_20 = null;
                                            if (var1_1.dfNasFiler == null) {
                                                var1_1.dfNasFiler = var6_6;
                                                break block92;
                                            }
                                            var29_27 = var1_1.dfNasFiler;
                                            break block93;
                                        }
                                        do {
                                            var29_22 = var29_22.nfNext;
lbl218:
                                            // 2 sources

                                        } while (var29_22 != null);
                                        var29_22 = var6_6;
                                    }
                                    if (this.rc == 0) {
                                        this.rc = var5_5.value;
                                    }
                                    if (TraceLogger.enableTrace == false) return var28_10;
                                    try {
                                        v17 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                                    }
                                    catch (ClassNotFoundException v18) {
                                        throw new NoClassDefFoundError(v18.getMessage());
                                    }
                                    TraceLogger.exit((String)v17.getName(), (String)"doWindowsDiscovery", (int)this.rc);
                                    return var28_10;
                                }
                                var26_16 = null;
                                if (var1_1.dfNasFiler == null) {
                                    var1_1.dfNasFiler = var6_6;
                                } else {
                                    var29_23 = var1_1.dfNasFiler;
                                    while (var29_23 != null) {
                                        var29_23 = var29_23.nfNext;
                                    }
                                    var29_23 = var6_6;
                                }
                                if (this.rc == 0) {
                                    this.rc = var5_5.value;
                                }
                                if (TraceLogger.enableTrace == false) return var28_11;
                                try {}
                                catch (ClassNotFoundException v19) {
                                    throw new NoClassDefFoundError(v19.getMessage());
                                }
                                TraceLogger.exit((String)Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery").getName(), (String)"doWindowsDiscovery", (int)this.rc);
                                return var28_11;
                            }
                            var26_17 = null;
                            if (var1_1.dfNasFiler == null) {
                                var1_1.dfNasFiler = var6_6;
                            } else {
                                var29_24 = var1_1.dfNasFiler;
                                while (var29_24 != null) {
                                    var29_24 = var29_24.nfNext;
                                }
                                var29_24 = var6_6;
                            }
                            if (this.rc == 0) {
                                this.rc = var5_5.value;
                            }
                            if (TraceLogger.enableTrace == false) return var28_12;
                            try {}
                            catch (ClassNotFoundException v20) {
                                throw new NoClassDefFoundError(v20.getMessage());
                            }
                            TraceLogger.exit((String)Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery").getName(), (String)"doWindowsDiscovery", (int)this.rc);
                            return var28_12;
                        }
                        var26_18 = null;
                        if (var1_1.dfNasFiler == null) {
                            var1_1.dfNasFiler = var6_6;
                        } else {
                            var29_25 = var1_1.dfNasFiler;
                            while (var29_25 != null) {
                                var29_25 = var29_25.nfNext;
                            }
                            var29_25 = var6_6;
                        }
                        if (this.rc == 0) {
                            this.rc = var5_5.value;
                        }
                        if (TraceLogger.enableTrace == false) return var28_13;
                        try {}
                        catch (ClassNotFoundException v21) {
                            throw new NoClassDefFoundError(v21.getMessage());
                        }
                        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery").getName(), (String)"doWindowsDiscovery", (int)this.rc);
                        return var28_13;
                    }
                    var26_19 = null;
                    if (var1_1.dfNasFiler == null) {
                        var1_1.dfNasFiler = var6_6;
                    } else {
                        var29_26 = var1_1.dfNasFiler;
                        while (var29_26 != null) {
                            var29_26 = var29_26.nfNext;
                        }
                        var29_26 = var6_6;
                    }
                    if (this.rc == 0) {
                        this.rc = var5_5.value;
                    }
                    if (TraceLogger.enableTrace == false) return var28_14;
                    try {}
                    catch (ClassNotFoundException v22) {
                        throw new NoClassDefFoundError(v22.getMessage());
                    }
                    TraceLogger.exit((String)Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery").getName(), (String)"doWindowsDiscovery", (int)this.rc);
                    return var28_14;
                }
                while (true) {
                    if (var29_27 == null) {
                        var29_27 = var6_6;
                        break;
                    }
                    var29_27 = var29_27.nfNext;
                }
            }
            if (this.rc == 0) {
                this.rc = var5_5.value;
            }
            if (TraceLogger.enableTrace == false) throw var27_50;
            try {}
            catch (ClassNotFoundException v23) {
                throw new NoClassDefFoundError(v23.getMessage());
            }
            TraceLogger.exit((String)Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery").getName(), (String)"doWindowsDiscovery", (int)this.rc);
            throw var27_50;
lbl-1000:
            // 1 sources

            {
                var26_21 = null;
                if (var1_1.dfNasFiler == null) {
                    var1_1.dfNasFiler = var6_6;
                    break block95;
                }
                var29_28 = var1_1.dfNasFiler;
            }
            while (true) {
                if (var29_28 == null) {
                    var29_28 = var6_6;
                    break;
                }
                var29_28 = var29_28.nfNext;
            }
        }
        if (this.rc == 0) {
            this.rc = var5_5.value;
        }
        if (TraceLogger.enableTrace == false) return this.rc;
        try {}
        catch (ClassNotFoundException v24) {
            throw new NoClassDefFoundError(v24.getMessage());
        }
        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery").getName(), (String)"doWindowsDiscovery", (int)this.rc);
        return this.rc;
    }

    private MutableInteger doWindowsSanfsDiscovery(DiscoveryData discoveryData) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"doWindowsSanfsDiscovery", (String)"structure");
        }
        MutableInteger mutableInteger = new MutableInteger();
        mutableInteger.value = 0;
        discoveryData.dfNasFiler = null;
        Mounts mounts = new Mounts();
        HashMap hashMap = new HashMap();
        mounts.openMnttab();
        while (mounts.findSanFSMount()) {
            if (!mounts.type.equalsIgnoreCase("SANFS")) continue;
            String string = mounts.mountPoint;
            FoundComputer foundComputer = (FoundComputer)hashMap.get(string);
            if (foundComputer != null) {
                MessageLog.logMessage((String)"NAA0117I", (Object)string, (Object)foundComputer.fcName);
                continue;
            }
            MessageLog.logMessage((String)"NAA0118I", (Object)string);
            NasFiler nasFiler = ExecDiscovery.newSANFSFileset(string);
            Filesystem filesystem = new Filesystem();
            filesystem.fsNasFiler = nasFiler;
            if (mounts.statFS(filesystem) != 0) {
                MessageLog.logMessage((String)"NAA0119I", (Object)string);
                mutableInteger.value = 4;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"doWindowsSanfsDiscovery", (Object)mutableInteger);
                }
                return mutableInteger;
            }
            filesystem.fsType = (short)18;
            Computer computer = nasFiler.nfComputer;
            computer.cmpFilesystemFreeSpace += filesystem.fsFreeSpace;
            StringBuffer stringBuffer = new StringBuffer("/");
            stringBuffer.append(string);
            filesystem.fsMountPoint = stringBuffer.toString();
            LogicalDisk logicalDisk = new LogicalDisk();
            logicalDisk.ldFilesystem = filesystem;
            filesystem.fsLogicalDisk = logicalDisk;
            logicalDisk.ldCapacity = filesystem.fsCapacity;
            logicalDisk.ldPath = string;
            logicalDisk.ldType = (byte)7;
            logicalDisk.ldNext = computer.cmpLogicalDisk;
            computer.cmpLogicalDisk = logicalDisk;
            nasFiler.nfNext = discoveryData.dfNasFiler;
            discoveryData.dfNasFiler = nasFiler;
            discoveryData.dfManageable = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"doWindowsSanfsDiscovery", (Object)mutableInteger);
        }
        return mutableInteger;
    }

    /*
     * Unable to fully structure code
     */
    private int handleMounts(ImportManager var1_1, Mounts var2_2) {
        if (TraceLogger.enableTrace) {
            try {
                v0 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            TraceLogger.entry((String)v0.getName(), (String)"handleMounts", (String)"thing, mounts");
        }
        if (var2_2.openMnttab()) ** GOTO lbl24
        if (TraceLogger.enableTrace) {
            try {
                v2 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException v3) {
                throw new NoClassDefFoundError(v3.getMessage());
            }
            TraceLogger.exit((String)v2.getName(), (String)"handleMounts", (int)8);
        }
        return 8;
lbl-1000:
        // 1 sources

        {
            if (var2_2.type != null && var2_2.type.startsWith("nfs")) {
                var3_3 = var1_1.handleImport(var2_2, null);
                if (var3_3 <= this.rc) continue;
                this.rc = var3_3;
                continue;
            }
            if (var2_2.type == null || !var2_2.type.equals("sanfs") || (var3_3 = var1_1.handleSANFSMount(var2_2)) <= this.rc) continue;
            this.rc = var3_3;
lbl24:
            // 5 sources

            ** while (this.rc <= 4 && var2_2.nextMount())
        }
lbl25:
        // 1 sources

        if (TraceLogger.enableTrace) {
            try {
                v4 = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException v5) {
                throw new NoClassDefFoundError(v5.getMessage());
            }
            TraceLogger.exit((String)v4.getName(), (String)"handleMounts", (int)this.rc);
        }
        return this.rc;
    }

    private int doUnixDiscovery(DiscoveryData discoveryData) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"doUnixDiscovery", (String)"structure");
        }
        this.rc = 0;
        if (discoveryData.dfNasVendor == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"doUnixDiscovery", (int)this.rc);
            }
            return this.rc;
        }
        discoveryData.dfNasFiler = null;
        Computer computer = new Computer();
        ImportManager importManager = new ImportManager(computer, discoveryData.dfNasVendor, discoveryData.dfCommunity, this.rejectNonRoot);
        Mounts mounts = new Mounts();
        if (this.handleMounts(importManager, mounts) > 4) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"doUnixDiscovery", (int)8);
            }
            return 8;
        }
        if (Agent.hardwareID.osType == 6) {
            importManager.enterAutomountMode();
            mounts = new AutoMounts();
            if (this.handleMounts(importManager, mounts) > 4) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"doUnixDiscovery", (int)8);
                }
                return 8;
            }
        }
        discoveryData.dfNasFiler = computer.cmpNasFiler;
        discoveryData.dfManageable = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"doUnixDiscovery", (int)this.rc);
        }
        return this.rc;
    }

    private boolean arrayContains(String[] stringArray, String string) {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private class PathConverter {
        private PathConverter() {
        }

        public String convert(Export export) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery$PathConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"convert", (String)"xp");
            }
            ExecDiscovery.this.lastWasRoot = false;
            String string = export.xpExportName;
            boolean bl = !ExecDiscovery.this.rejectNonRoot ? true : string.length() == 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == '$' && export.xpAdministrative;
            String string2 = bl ? export.xpPath.replace('\\', '/') : null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery$PathConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"convert", (Object)string2);
            }
            return string2;
        }

        /* synthetic */ PathConverter(PathConverter pathConverter, PathConverter pathConverter2) {
            this();
        }
    }

    private class NetAppPathConverter
    extends PathConverter {
        private NetAppPathConverter() {
        }

        public String convert(Export export) {
            String string;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery$NetAppPathConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"convert", (String)"xp");
            }
            ExecDiscovery.this.lastWasRoot = false;
            String string2 = export.xpPath.toLowerCase();
            if (!string2.startsWith("c:\\")) {
                MessageLog.logMessage((String)"NAA0066W", (Object)export.xpExportName, (Object)string2);
                ExecDiscovery.this.rc = 4;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery$NetAppPathConverter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"convert", null);
                }
                return null;
            }
            int n = string2.length();
            if (n == 3) {
                String string3 = "/vol/vol0";
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery$NetAppPathConverter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"convert", (Object)string3);
                }
                return string3;
            }
            if (n < 8 || !string2.startsWith("c:\\vol\\")) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery$NetAppPathConverter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"convert", null);
                }
                return null;
            }
            string2 = export.xpPath;
            int n2 = 7;
            while (n2 < n && string2.charAt(n2) != '\\') {
                ++n2;
            }
            if (n2 >= n - 1) {
                ExecDiscovery.this.lastWasRoot = true;
            }
            if (ExecDiscovery.this.rejectNonRoot && !ExecDiscovery.this.lastWasRoot) {
                string = null;
            } else {
                if (!ExecDiscovery.this.lastWasRoot && string2.charAt((n2 = string2.length()) - 1) == '\\') {
                    --n2;
                }
                string = string2.substring(2, n2).replace('\\', '/');
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.discovery.ExecDiscovery$NetAppPathConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"convert", (Object)string);
            }
            return string;
        }
    }
}

