/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.agent.exec.CmdExecer;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class AutoMounts
extends Mounts {
    private static final int ETC_FILES = 0;
    private static final int YELLOW_PAGES = 1;
    private static final int NISPLUS = 2;
    private static final String NSSWITCH_CONF = "/etc/nsswitch.conf";
    private static final String[] nameServiceNames = new String[]{"files", "nis", "nisplus"};
    private Map mapFilesProcessed;
    private int[] nameServices;
    private List mounts;
    private Iterator iterator;

    private static String readExtendedLine(BufferedReader bufferedReader, MutableBoolean mutableBoolean) throws IOException {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"readExtendedLine", (String)"in, atEOF");
        }
        if ((string = bufferedReader.readLine()) == null || !string.endsWith("\\")) {
            if (string == null) {
                mutableBoolean.value = true;
            }
            String string2 = string;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"readExtendedLine", (Object)string2);
            }
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setLength(stringBuffer.length() - 1);
        boolean bl = true;
        while (bl && (string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            if (string.endsWith("\\")) {
                stringBuffer.setLength(stringBuffer.length() - 1);
                continue;
            }
            bl = false;
        }
        if (string == null) {
            mutableBoolean.value = true;
        }
        String string3 = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"readExtendedLine", (Object)string3);
        }
        return string3;
    }

    private static boolean isSingleCharacterToken(char c) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isSingleCharacterToken", (String)"c");
        }
        boolean bl2 = bl = c == '[' || c == '=' || c == ']';
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isSingleCharacterToken", (boolean)bl);
        }
        return bl;
    }

    private static String nextToken(String string, MutableInteger mutableInteger) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"nextToken", (String)"line, pPos");
        }
        char c = '\u0000';
        int n = string.length();
        int n2 = mutableInteger.value;
        while (n2 < n && Character.isWhitespace(c = string.charAt(n2))) {
            ++n2;
        }
        if (n2 >= n) {
            String string2 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"nextToken", string2);
            }
            return string2;
        }
        if (AutoMounts.isSingleCharacterToken(c)) {
            mutableInteger.value = n2 + 1;
            char[] cArray = new char[]{c};
            String string3 = new String(cArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"nextToken", (Object)string3);
            }
            return string3;
        }
        int n3 = n2;
        while (++n2 < n && !Character.isWhitespace(c = string.charAt(n2)) && !AutoMounts.isSingleCharacterToken(c)) {
        }
        mutableInteger.value = n2;
        String string4 = string.substring(n3, n2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"nextToken", (Object)string4);
        }
        return string4;
    }

    private boolean processAutoFSMap(AutomountMap automountMap) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processAutoFSMap", (String)"mapFile");
        }
        boolean bl = true;
        while (automountMap.lastServiceQueried < this.nameServices.length) {
            Parser parser = null;
            int n = this.nameServices[automountMap.lastServiceQueried];
            switch (n) {
                case 0: {
                    parser = new EtcFileParser(automountMap);
                    break;
                }
                case 1: {
                    parser = new YellowPagesParser(automountMap);
                    break;
                }
                case 2: {
                    parser = new NISPlusParser(automountMap);
                }
            }
            if (!parser.go()) {
                bl = false;
            }
            ++automountMap.lastServiceQueried;
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processAutoFSMap", (boolean)bl2);
        }
        return bl2;
    }

    private boolean processAutoFSMap(String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processAutoFSMap", (String)"resource, localPath");
        }
        AutomountMap automountMap = new AutomountMap(string, string2);
        this.mapFilesProcessed.put(string, automountMap);
        boolean bl = this.processAutoFSMap(automountMap);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processAutoFSMap", (boolean)bl);
        }
        return bl;
    }

    private boolean parseNSSwitch() {
        int n;
        String string;
        String string2;
        MutableInteger mutableInteger;
        boolean bl;
        boolean bl2;
        block36: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"parseNSSwitch", (String)"");
            }
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(NSSWITCH_CONF);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"parseNSSwitch", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)iOException);
            }
            if (fileReader == null) {
                boolean bl3 = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"parseNSSwitch", (boolean)bl3);
                }
                return bl3;
            }
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            bl2 = false;
            bl = false;
            mutableInteger = new MutableInteger();
            string2 = null;
            string = null;
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            try {
                while (!bl2 && !mutableBoolean.value) {
                    string2 = AutoMounts.readExtendedLine(bufferedReader, mutableBoolean);
                    if (string2 == null) continue;
                    mutableInteger.value = 0;
                    string = AutoMounts.nextToken(string2, mutableInteger);
                    if (string == null || !string.startsWith("automount")) continue;
                    bl2 = true;
                }
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"parseNSSwitch", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0133E", (Exception)iOException, (Object)NSSWITCH_CONF);
                bl = true;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block36;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"parseNSSwitch", (Throwable)iOException);
            }
        }
        if (!bl2) {
            boolean bl4;
            boolean bl5 = bl4 = !bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"parseNSSwitch", (boolean)bl4);
            }
            return bl4;
        }
        LinkedList<MutableInteger> linkedList = new LinkedList<MutableInteger>();
        boolean[] blArray = new boolean[nameServiceNames.length];
        while (true) {
            if ((string = AutoMounts.nextToken(string2, mutableInteger)) != null && string.equals("[")) {
                n = string2.indexOf(93, mutableInteger.value);
                mutableInteger.value = n < 0 ? string2.length() : n + 1;
                continue;
            }
            if (string != null) {
                bl2 = false;
                n = 0;
                while (!bl2 && n < nameServiceNames.length) {
                    if (string.equals(nameServiceNames[n])) {
                        bl2 = true;
                        continue;
                    }
                    ++n;
                }
                if (bl2 && !blArray[n]) {
                    blArray[n] = true;
                    linkedList.add(new MutableInteger(n));
                }
            }
            if (string == null) break;
        }
        n = 0;
        this.nameServices = new int[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            MutableInteger mutableInteger2 = (MutableInteger)iterator.next();
            this.nameServices[n] = mutableInteger2.value;
            ++n;
        }
        boolean bl6 = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"parseNSSwitch", (boolean)bl6);
        }
        return bl6;
    }

    public boolean openMnttab() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"openMnttab", (String)"");
        }
        boolean bl = this.parseNSSwitch();
        if (this.nameServices == null) {
            boolean bl2 = bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"openMnttab", (boolean)bl2);
            }
            return bl2;
        }
        this.mounts = new LinkedList();
        this.mapFilesProcessed = new HashMap();
        this.processAutoFSMap("auto_master", null);
        this.mapFilesProcessed = null;
        this.iterator = this.mounts.iterator();
        boolean bl3 = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"openMnttab", (boolean)bl3);
        }
        return bl3;
    }

    public boolean nextMount() {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"nextMount", (String)"");
        }
        if (bl = this.iterator.hasNext()) {
            Mounts mounts = (Mounts)this.iterator.next();
            this.special = mounts.special;
            this.mountPoint = mounts.mountPoint;
            this.type = mounts.type;
            this.flags = mounts.flags;
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"nextMount", (boolean)bl2);
        }
        return bl2;
    }

    private static class AutomountMap {
        public int lastServiceQueried;
        public final String name;
        private String directory;
        private Map subdirs;

        public AutomountMap(String string, String string2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"AutomountMap", (String)"pName, pDirectory");
            }
            this.name = string;
            this.lastServiceQueried = 0;
            this.directory = string2;
            this.subdirs = new HashMap();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"AutomountMap");
            }
        }

        public boolean isMaster() {
            boolean bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"isMaster", (String)"");
            }
            boolean bl2 = bl = this.directory == null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"isMaster", (boolean)bl);
            }
            return bl;
        }

        public String fullyQualified(String string, MutableBoolean mutableBoolean) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"fullyQualified", (String)"subdir, startsWithPlus");
            }
            mutableBoolean.value = false;
            if (string.length() == 0) {
                String string2 = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"fullyQualified", string2);
                }
                return string2;
            }
            char c = string.charAt(0);
            switch (c) {
                case '+': {
                    mutableBoolean.value = true;
                }
                case '#': 
                case '*': {
                    String string3 = null;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"fullyQualified", string3);
                    }
                    return string3;
                }
            }
            String string4 = null;
            if (this.isMaster()) {
                if (c == '/') {
                    string4 = string;
                }
            } else if (c != '/') {
                string4 = string;
            }
            if (string4 != null) {
                if (this.subdirs.containsKey(string4)) {
                    string4 = null;
                } else {
                    this.subdirs.put(string4, string4);
                    if (!this.isMaster()) {
                        string4 = String.valueOf(this.directory) + '/' + string4;
                    }
                }
            }
            String string5 = string4;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$AutomountMap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fullyQualified", (Object)string5);
            }
            return string5;
        }
    }

    private abstract class Parser {
        protected AutomountMap mapFile;
        private int level;

        public Parser(AutomountMap automountMap) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"Parser", (String)"pMapFile");
            }
            this.mapFile = automountMap;
            this.level = this.mapFile.lastServiceQueried;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"Parser");
            }
        }

        protected abstract BufferedReader open(MutableBoolean var1);

        protected BufferedReader doOpen(String string, MutableBoolean mutableBoolean) {
            FileReader fileReader;
            block11: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"doOpen", (String)"path, aOK");
                }
                fileReader = null;
                try {
                    fileReader = new FileReader(string);
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"doOpen", (Throwable)iOException);
                    }
                    if (mutableBoolean == null) break block11;
                    MessageLog.logException((String)"GEN0029E", (Exception)iOException);
                    mutableBoolean.value = false;
                }
            }
            BufferedReader bufferedReader = fileReader == null ? null : new BufferedReader(fileReader);
            BufferedReader bufferedReader2 = bufferedReader;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"doOpen", (Object)bufferedReader2);
            }
            return bufferedReader2;
        }

        protected boolean handleInclude(String string) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"handleInclude", (String)"included");
            }
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleInclude", (boolean)bl);
            }
            return bl;
        }

        protected void cleanUp() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"cleanUp", (String)"");
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"cleanUp");
            }
        }

        private String extractFSType(String string, int n, int n2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"extractFSType", (String)"line, pos, length");
            }
            String string2 = null;
            do {
                int n3;
                if ((n3 = string.indexOf(44, n)) < 0) {
                    n3 = n2;
                }
                if (string.regionMatches(n, "fstype=", 0, 7)) {
                    string2 = string.substring(n + 7, n3);
                }
                n = n3 + 1;
            } while (string2 == null && n < n2);
            String string3 = string2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"extractFSType", (Object)string3);
            }
            return string3;
        }

        private boolean handleAutoFS(String string, String string2) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"handleAutoFS", (String)"localPath, resource");
            }
            if (AutoMounts.this.mapFilesProcessed.containsKey(string2)) {
                boolean bl = true;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handleAutoFS", (boolean)bl);
                }
                return bl;
            }
            if (string2.indexOf(58) >= 0) {
                Object[] objectArray = new Object[]{this.mapFile.name, string, string2};
                MessageLog.logMessage((String)"NAA0112I", (Object[])objectArray);
            }
            boolean bl = AutoMounts.this.processAutoFSMap(string2, string);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleAutoFS", (boolean)bl);
            }
            return bl;
        }

        private boolean handleNFSImport(String string, String string2) {
            int n;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"handleNFSImport", (String)"localPath, resource");
            }
            if ((n = string2.indexOf(58)) <= 0) {
                Object[] objectArray = new Object[]{this.mapFile.name, string, string2};
                MessageLog.logMessage((String)"NAA0113W", (Object[])objectArray);
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"handleNFSImport", (boolean)bl);
                }
                return bl;
            }
            String string3 = string2.substring(0, n);
            boolean bl = false;
            int n2 = string3.indexOf(44);
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
                bl = true;
            }
            if ((n2 = string3.indexOf(40)) > 0) {
                string3 = string3.substring(0, n2);
                bl = true;
            }
            if (bl) {
                string2 = String.valueOf(string3) + string2.substring(n);
            }
            Mounts mounts = new Mounts();
            mounts.special = string2;
            mounts.mountPoint = string;
            mounts.type = "nfs";
            mounts.flags = 14;
            AutoMounts.this.mounts.add(mounts);
            boolean bl2 = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleNFSImport", (boolean)bl2);
            }
            return bl2;
        }

        public boolean go() {
            boolean bl;
            block32: {
                MutableBoolean mutableBoolean;
                BufferedReader bufferedReader;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"go", (String)"");
                }
                if ((bufferedReader = this.open(mutableBoolean = new MutableBoolean())) == null) {
                    boolean bl2 = mutableBoolean.value;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"go", (boolean)bl2);
                    }
                    return bl2;
                }
                MutableInteger mutableInteger = new MutableInteger();
                MutableBoolean mutableBoolean2 = new MutableBoolean(false);
                bl = true;
                try {
                    while (!mutableBoolean2.value) {
                        boolean bl3;
                        int n;
                        String string = AutoMounts.readExtendedLine(bufferedReader, mutableBoolean2);
                        if (string == null) continue;
                        mutableInteger.value = 0;
                        String string2 = AutoMounts.nextToken(string, mutableInteger);
                        if (string2 == null) continue;
                        String string3 = this.mapFile.fullyQualified(string2, mutableBoolean);
                        if (string3 == null) {
                            if (!mutableBoolean.value || this.handleInclude(string2)) continue;
                            bl = false;
                            continue;
                        }
                        int n2 = string.length();
                        boolean bl4 = this.mapFile.isMaster();
                        String string4 = null;
                        String string5 = null;
                        boolean bl5 = false;
                        while (!(bl5 || string4 != null && string5 != null)) {
                            String string6 = AutoMounts.nextToken(string, mutableInteger);
                            if (string6 == null) {
                                bl5 = true;
                                continue;
                            }
                            if (string6.charAt(0) != '-') {
                                if (string4 != null) continue;
                                string4 = string6;
                                continue;
                            }
                            if (string6.equals("-null") || string6.equals("-hosts") || string6.equals("-xfn")) {
                                string4 = null;
                                bl5 = true;
                                continue;
                            }
                            int n3 = mutableInteger.value - string6.length() + 1;
                            while (mutableInteger.value < n2 && !Character.isWhitespace(string.charAt(mutableInteger.value))) {
                                ++mutableInteger.value;
                            }
                            if (string5 != null || (string6 = this.extractFSType(string, n3, mutableInteger.value)) == null) continue;
                            string5 = string6;
                        }
                        if (string5 != null) {
                            if (string5.equals("autofs")) {
                                bl4 = true;
                            } else if (!string5.equals("nfs")) {
                                string4 = null;
                            }
                        }
                        if (string4 == null) continue;
                        if (string2.charAt(0) != '/' && (n = string4.indexOf(38)) >= 0) {
                            StringBuffer stringBuffer = new StringBuffer(n2);
                            int n4 = 0;
                            do {
                                stringBuffer.append(string4.substring(n4, n));
                                stringBuffer.append(string2);
                            } while ((n = string4.indexOf(38, n4 = n + 1)) >= n4);
                            stringBuffer.append(string4.substring(n4));
                            string4 = stringBuffer.toString();
                        }
                        if (bl3 = !bl4 ? this.handleNFSImport(string3, string4) : this.handleAutoFS(string3, string4)) continue;
                        bl = false;
                    }
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"go", (Throwable)iOException);
                    }
                    String string = nameServiceNames[AutoMounts.this.nameServices[this.level]];
                    Object[] objectArray = new Object[]{this.mapFile.name, string};
                    MessageLog.logException((String)"NAA0111W", (Exception)iOException, (Object[])objectArray);
                    bl = false;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block32;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"go", (Throwable)iOException);
                }
            }
            this.cleanUp();
            boolean bl6 = bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"go", (boolean)bl6);
            }
            return bl6;
        }
    }

    private class EtcFileParser
    extends Parser {
        public EtcFileParser(AutomountMap automountMap) {
            super(automountMap);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$EtcFileParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"EtcFileParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$EtcFileParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"EtcFileParser");
            }
        }

        protected BufferedReader open(MutableBoolean mutableBoolean) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$EtcFileParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"open", (String)"aOK");
            }
            mutableBoolean.value = true;
            String string = "/etc/" + this.mapFile.name;
            BufferedReader bufferedReader = this.doOpen(string, null);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$EtcFileParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"open", (Object)bufferedReader);
            }
            return bufferedReader;
        }

        protected boolean handleInclude(String string) {
            boolean bl;
            int n;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$EtcFileParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"handleInclude", (String)"resource");
            }
            if (!string.regionMatches(1, this.mapFile.name, 0, n = string.length() - 1)) {
                bl = true;
            } else {
                ++this.mapFile.lastServiceQueried;
                bl = AutoMounts.this.processAutoFSMap(this.mapFile);
            }
            boolean bl2 = bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$EtcFileParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"handleInclude", (boolean)bl2);
            }
            return bl2;
        }
    }

    private abstract class CommandParser
    extends Parser {
        private File tempFile;

        public CommandParser(AutomountMap automountMap) {
            super(automountMap);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"CommandParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"CommandParser");
            }
        }

        protected void cleanUp() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"cleanUp", (String)"");
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
                this.tempFile = null;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"cleanUp");
            }
        }

        protected BufferedReader open(String[] stringArray, MutableBoolean mutableBoolean) {
            Object object;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"open", (String)"commandLine, aOK");
            }
            this.tempFile = null;
            mutableBoolean.value = false;
            CmdExecer cmdExecer = new CmdExecer(stringArray);
            if (!cmdExecer.exec()) {
                mutableBoolean.value = true;
                BufferedReader bufferedReader = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"open", bufferedReader);
                }
                return bufferedReader;
            }
            try {
                this.tempFile = File.createTempFile("TRLLS", null);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)iOException);
            }
            FileWriter fileWriter = null;
            if (this.tempFile != null) {
                try {
                    fileWriter = new FileWriter(this.tempFile);
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)iOException);
                    }
                    MessageLog.logMessage((String)"GEN0002E", (Object)iOException.getMessage());
                }
            }
            if (fileWriter == null) {
                cmdExecer.close();
                this.cleanUp();
                BufferedReader bufferedReader = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"open", bufferedReader);
                }
                return bufferedReader;
            }
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            boolean bl = false;
            boolean bl2 = false;
            try {
                String string;
                while ((string = cmdExecer.stdout.readLine()) != null) {
                    bl2 = true;
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    bl2 = false;
                }
                bl2 = true;
                bl = true;
                bufferedWriter.close();
                mutableBoolean.value = true;
            }
            catch (IOException iOException) {
                String string;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)iOException);
                }
                if (bl2) {
                    string = "GEN0152E";
                    object = new Object[]{this.tempFile.getPath()};
                } else {
                    string = "AGT0016E";
                    object = null;
                }
                MessageLog.logException((String)string, (Exception)iOException, (Object[])object);
            }
            cmdExecer.close();
            if (!mutableBoolean.value) {
                block49: {
                    if (!bl) {
                        try {
                            ((Writer)fileWriter).close();
                        }
                        catch (IOException iOException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block49;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)iOException);
                        }
                    }
                }
                this.cleanUp();
                BufferedReader bufferedReader = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"open", bufferedReader);
                }
                return bufferedReader;
            }
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(this.tempFile);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"open", (Throwable)iOException);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)iOException);
                mutableBoolean.value = false;
            }
            if (fileReader != null) {
                object = new BufferedReader(fileReader);
            } else {
                object = null;
                this.cleanUp();
            }
            Object object2 = object;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$CommandParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"open", (Object)object2);
            }
            return object2;
        }
    }

    private class YellowPagesParser
    extends CommandParser {
        public YellowPagesParser(AutomountMap automountMap) {
            super(automountMap);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$YellowPagesParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"YellowPagesParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$YellowPagesParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"YellowPagesParser");
            }
        }

        public BufferedReader open(MutableBoolean mutableBoolean) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$YellowPagesParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"open", (String)"aOK");
            }
            String[] stringArray = new String[]{"/usr/bin/ypcat", "-k", this.mapFile.name};
            BufferedReader bufferedReader = this.open(stringArray, mutableBoolean);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$YellowPagesParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"open", (Object)bufferedReader);
            }
            return bufferedReader;
        }
    }

    private class NISPlusParser
    extends CommandParser {
        public NISPlusParser(AutomountMap automountMap) {
            super(automountMap);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$NISPlusParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"NISPlusParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$NISPlusParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"NISPlusParser");
            }
        }

        public BufferedReader open(MutableBoolean mutableBoolean) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$NISPlusParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"open", (String)"aOK");
            }
            String[] stringArray = new String[]{"/usr/bin/niscat", String.valueOf(this.mapFile.name) + ".org_dir"};
            BufferedReader bufferedReader = this.open(stringArray, mutableBoolean);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.nas.AutoMounts$NISPlusParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"open", (Object)bufferedReader);
            }
            return bufferedReader;
        }
    }
}

