/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.identity.MainframeLinuxHWID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeLinux
extends Probe {
    private static final String PROC_DASD_DEVICES = "/proc/dasd/devices";
    private static final String PROC_PARTITIONS = "/proc/partitions";
    private static final String SYS = "/sys";
    private static final String CLASS_SCSI_HOST = "/class/scsi_host";
    private static final String PROC_NAME = "proc_name";
    private static final String PROC_SCSI = "/proc/scsi";
    private static final int IDA_DRIVER = 1;
    private static final int CCISS_DRIVER = 2;
    private static String osVersion;
    private boolean useSGDevice = true;
    private boolean useSG = false;
    private HashMap targetPorts = new HashMap();
    private HashMap adapterPorts = new HashMap();
    private static Map deviceTypes;

    static {
        block4: {
            osVersion = null;
            ProbeLinux.initIDs();
            deviceTypes = new HashMap();
            deviceTypes.put("disk", new Integer(0));
            deviceTypes.put("floppy", new Integer(4));
            deviceTypes.put("cdrom", new Integer(1));
            deviceTypes.put("tape", new Integer(256));
            try {
                Properties properties = System.getProperties();
                osVersion = properties.getProperty("os.version");
            }
            catch (SecurityException securityException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block4;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"static", (String)"Failed to obtain OS version.");
            }
        }
    }

    private static native void initIDs();

    private native int probeSCSIDevice(String var1, boolean var2, String var3);

    private native int probeIDEDevice(String var1, Controller var2, int var3, int var4);

    private native int probeXenDevice(String var1, Controller var2, int var3, int var4);

    private native void probeDASD(Disk var1) throws LocalizableException;

    private native int probeVpathDevice(String var1, Controller var2, int var3, boolean var4);

    private native int getComputerConfig();

    private static native boolean findPartitions(Disk var0, String var1);

    private Controller findDASDController(String string, int n) {
        Controller controller = this.computer.cmpController;
        while (controller != null && !controller.ctlrDriverName.equals(string) && controller.ctlrInstance != n) {
            controller = controller.ctlrNext;
        }
        if (controller == null) {
            controller = new Controller();
            controller.ctlrType = (short)12;
            controller.ctlrDriverName = string;
            controller.ctlrInstance = (short)n;
            controller.ctlrBusNumber = 0;
            controller.ctlrTarget = (short)-1;
            controller.ctlrDriverDescription = " ";
            controller.ctlrNext = this.computer.cmpController;
            this.computer.cmpController = controller;
        }
        return controller;
    }

    private void detectSGUsage() {
        block17: {
            Object object;
            File file;
            File file2;
            this.useSG = false;
            this.useSGDevice = true;
            String string = this.computer.cmpProcessorType.toLowerCase();
            File file3 = new File(String.valueOf(Variables.homeDirectory) + "/config/useSGIO.config");
            if (string.indexOf("power5") > -1 || file3.isFile()) {
                file2 = new File("/proc/scsi/sg/version");
                if (file2.isFile()) {
                    this.useSG = true;
                }
                if ((file = new File("/usr/bin/sg_inq")).isFile()) {
                    this.useSG = true;
                }
            }
            if ((file2 = new File("/etc/SuSE-release")).isFile()) {
                file = new File("/proc/scsi/sg/version");
                if (file.isFile()) {
                    this.useSG = true;
                }
                if (((File)(object = new File("/usr/bin/sg_inq"))).isFile()) {
                    this.useSG = true;
                }
            }
            if ((file = new File("/etc/redhat-release")).isFile()) {
                try {
                    File file4;
                    object = new BufferedReader(new FileReader("/etc/redhat-release"));
                    StringTokenizer stringTokenizer = new StringTokenizer(((BufferedReader)object).readLine());
                    String string2 = null;
                    String string3 = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        if (stringTokenizer.countTokens() == 6) {
                            string2 = stringTokenizer.nextToken();
                            continue;
                        }
                        if (stringTokenizer.countTokens() == 4) {
                            string3 = stringTokenizer.nextToken();
                            continue;
                        }
                        stringTokenizer.nextToken();
                    }
                    if (string2.equals("AS") && string3.equals("4") && (file4 = new File("/proc/scsi/sg/version")).isFile()) {
                        this.useSG = true;
                    }
                }
                catch (Exception exception) {
                    if (!(exception instanceof FileNotFoundException)) break block17;
                    MessageLog.logException((String)"STA0500E", (Exception)exception);
                }
            }
        }
        if (osVersion != null && osVersion.startsWith("2.6")) {
            this.useSG = true;
            this.useSGDevice = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSCSIDisk", (String)"Linux kernel 2.6 detected.");
            }
        }
    }

    private void findSCSIControllers() throws GeneralException {
        if (osVersion != null && osVersion.compareTo("2.6") >= 0) {
            this.findSCSIControllersFromSys();
        } else {
            this.findSCSIControllersFromProc();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findSCSIControllersFromSys() throws GeneralException {
        String string = SYS + CLASS_SCSI_HOST;
        StringBuffer stringBuffer = new StringBuffer(PROC_SCSI);
        Reader reader = null;
        File file = new File(string);
        String string2 = null;
        String[] stringArray = file.list();
        if (stringArray == null) {
            MessageLog.logMessage((String)"STA0214I");
            return;
        }
        String string3 = null;
        int n = 0;
        while (true) {
            block20: {
                Object var12_12;
                if (n >= stringArray.length) {
                    return;
                }
                int n2 = -1;
                try {
                    try {
                        n2 = Integer.parseInt(stringArray[n].substring(4));
                        string3 = string + "/" + stringArray[n] + "/" + PROC_NAME;
                        reader = null;
                        string2 = null;
                        reader = new FileReader(string3);
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        string2 = bufferedReader.readLine();
                        bufferedReader.close();
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"findSCSIControllersFromSys", (String)("Create controller " + string2 + " instance " + n2));
                        }
                        Controller controller = new Controller();
                        controller.ctlrNext = this.computer.cmpController;
                        this.computer.cmpController = controller;
                        controller.ctlrDriverName = string2;
                        controller.ctlrDriverDescription = null;
                        controller.ctlrTarget = (short)-1;
                        controller.ctlrType = 0;
                        controller.ctlrInstance = (short)n2;
                        controller.ctlrHBAPortWWN = 0L;
                        this.getHBAPortWWNFromSys(stringArray[n], controller);
                        if (controller.ctlrHBAPortWWN == 0L) {
                            stringBuffer.setLength(PROC_SCSI.length());
                            stringBuffer.append("/").append(string2);
                            this.getHBAPortWWNFromProc(stringBuffer, controller);
                        }
                    }
                    catch (IOException iOException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) throw new GeneralException();
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"findSCSIControllersFromSys", (String)("Failed to get controller name from " + string3));
                        throw new GeneralException();
                    }
                    catch (Exception exception) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) throw new GeneralException();
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"findSCSIControllersFromSys", (String)("Failed to get controller instance from " + stringArray[n]));
                        throw new GeneralException();
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (reader == null) throw throwable;
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    var12_12 = null;
                    if (reader == null) break block20;
                }
                try {}
                catch (IOException iOException) {}
                reader.close();
            }
            ++n;
        }
    }

    private void findSCSIControllersFromProc() throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer(PROC_SCSI);
        File file = new File(stringBuffer.toString());
        stringBuffer.append('/');
        String[] stringArray = file.list();
        if (stringArray == null) {
            MessageLog.logMessage((String)"STA0214I");
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            File file2 = new File(stringBuffer.toString());
            String[] stringArray2 = file2.list();
            if (stringArray2 == null) {
                stringBuffer.setLength(11);
            } else {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    block7: {
                        int n3;
                        try {
                            n3 = Integer.parseInt(stringArray2[n2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            break block7;
                        }
                        Controller controller = new Controller();
                        controller.ctlrNext = this.computer.cmpController;
                        this.computer.cmpController = controller;
                        controller.ctlrDriverName = stringArray[n];
                        controller.ctlrDriverDescription = null;
                        controller.ctlrTarget = (short)-1;
                        controller.ctlrType = 0;
                        controller.ctlrInstance = (short)n3;
                        this.getHBAPortWWNFromProc(stringBuffer, controller);
                    }
                    ++n2;
                }
                stringBuffer.setLength(11);
            }
            ++n;
        }
    }

    private void findSCSIDisks() throws GeneralException {
        CharSequence charSequence;
        boolean bl;
        FileReader fileReader;
        StringBuffer stringBuffer = new StringBuffer(PROC_SCSI).append("/").append("scsi");
        try {
            fileReader = new FileReader(stringBuffer.toString());
        }
        catch (IOException iOException) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[512];
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            bl = false;
            while ((charSequence = bufferedReader.readLine()) != null) {
                if (((String)charSequence).startsWith("Host:")) {
                    nArray[n2] = -1;
                    ++n;
                }
                if (((String)charSequence).indexOf("Virtual") > -1) {
                    bl = true;
                }
                if (((String)charSequence).indexOf("Direct-Access") <= -1) continue;
                if (!bl) {
                    nArray[n2] = n - 1;
                    ++n2;
                    continue;
                }
                bl = false;
            }
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0119E", (Exception)iOException, (Object)stringBuffer.toString());
            this.rc = 4;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        this.detectSGUsage();
        stringBuffer.setLength(0);
        stringBuffer.append("/dev/sd");
        charSequence = new StringBuffer("/dev/sg");
        int n3 = 0;
        while (n3 < n2 && this.rc <= 4) {
            char c;
            if (n3 >= 26) {
                c = (char)(97 + n3 / 26 - 1);
                stringBuffer.append(c);
            }
            c = (char)(97 + n3 % 26);
            stringBuffer.append(c);
            ((StringBuffer)charSequence).append(nArray[n3]);
            if (Agent.stopNow) {
                this.rc = 8;
            } else {
                bl = this.useSG;
                if (this.useSG && nArray[n3] < 0) {
                    bl = false;
                }
                int n4 = this.useSGDevice ? this.probeSCSIDevice(stringBuffer.toString(), bl, ((StringBuffer)charSequence).toString()) : this.probeSCSIDevice(stringBuffer.toString(), bl, stringBuffer.toString());
                stringBuffer.setLength(7);
                ((StringBuffer)charSequence).setLength(7);
                if (n4 > this.rc) {
                    this.rc = n4;
                }
            }
            ++n3;
        }
        if (this.rc > 4) {
            throw new GeneralException();
        }
    }

    private void getHBAPortWWNFromSys(String string, Controller controller) {
        FileReader fileReader;
        String string2 = "/sys/class/fc_host/" + string + "/port_name";
        if (!new File(string2).isFile()) {
            return;
        }
        try {
            fileReader = new FileReader(string2);
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0800W", (Exception)iOException, (Object)string2);
            this.rc = 4;
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith("0x")) continue;
                try {
                    long l;
                    controller.ctlrHBAPortWWN = l = Long.valueOf(string3.substring(2), 16).longValue();
                    controller.ctlrType = (short)5;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("Port Line = " + string3);
                }
                break;
            }
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0800E", (Exception)iOException, (Object)string2);
            this.rc = 4;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
    }

    private void getHBAPortWWNFromProc(StringBuffer stringBuffer, Controller controller) {
        FileReader fileReader;
        String string = String.valueOf(stringBuffer.toString()) + "/" + Integer.toString(controller.ctlrInstance);
        if (!new File(string).isFile()) {
            return;
        }
        try {
            fileReader = new FileReader(string);
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0800W", (Exception)iOException, (Object)string);
            this.rc = 4;
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        this.targetPorts = new HashMap();
        try {
            String string2;
            boolean bl = false;
            boolean bl2 = false;
            block24: while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                int n;
                String string4;
                int n2;
                block35: {
                    block34: {
                        block33: {
                            n2 = string2.indexOf("adapter-port=");
                            if (n2 > -1 && !bl) {
                                try {
                                    Class<?> clazz;
                                    string4 = string2.substring(n2 + 13, n2 + 29);
                                    controller.ctlrHBAPortWWN = this.parseWWN(string4);
                                    controller.ctlrType = (short)5;
                                    bl = true;
                                    if (!TraceLogger.enableTrace) break block33;
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getHBAPortWWN", (String)(">> Found:  Adapter Port = " + controller.ctlrDriverName + " Adapter Port WWN = [" + string4 + "]"));
                                }
                                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                    System.out.println("Port Line = " + string2);
                                }
                            }
                        }
                        if ((n2 = string2.indexOf("target-")) > -1 && (n = string2.indexOf("=")) > -1) {
                            try {
                                Class<?> clazz;
                                string3 = string2.substring(n2 + 7, n);
                                string4 = string2.substring(n + 1, n + 17);
                                this.targetPorts.put(string3, Long.toString(this.parseWWN(string4)));
                                bl2 = true;
                                if (!TraceLogger.enableTrace) break block34;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getHBAPortWWN", (String)(">> Found: Target Number = " + string3 + " Target Port WWN = [" + string4 + "]"));
                            }
                            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                                System.out.println("Target Line = " + string2);
                            }
                        }
                    }
                    if ((n2 = string2.indexOf("Portname:")) > -1 && !bl) {
                        try {
                            Class<?> clazz;
                            string4 = string2.substring(n2 + 10, n2 + 33);
                            controller.ctlrHBAPortWWN = this.parseWWN(string4);
                            controller.ctlrType = (short)5;
                            bl = false;
                            if (!TraceLogger.enableTrace) break block35;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getHBAPortWWN", (String)(">> Found:  Adapter Port = " + controller.ctlrDriverName + " Adapter Port WWN = [" + string4 + "]"));
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            System.out.println("Port Line = " + string2);
                        }
                    }
                }
                if ((n2 = string2.indexOf("lpfc")) != 0) continue;
                String[] stringArray = string2.split("\\s");
                try {
                    n = stringArray[0].indexOf("t");
                    if (n <= -1) continue;
                    string3 = stringArray[0].substring(n + 1);
                    string3 = Short.toString(Short.parseShort(string3, 16));
                    int n3 = 1;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].equals("WWPN")) {
                            Class<?> clazz;
                            string4 = stringArray[n3 + 1];
                            this.targetPorts.put(string3, Long.toString(this.parseWWN(string4)));
                            bl2 = true;
                            if (!TraceLogger.enableTrace) continue block24;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getHBAPortWWN", (String)(">> Found: Target Number = " + string3 + " Target Port WWN = [" + string4 + "]"));
                            continue block24;
                        }
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeLinux");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"getHBAPortWWN", (String)(">> Cannot find Target Port WWN for Target Number = " + string3));
                        }
                        ++n3;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("Target Line = " + string2);
                }
            }
            if (bl2) {
                this.adapterPorts.put(Long.toString(controller.ctlrHBAPortWWN), this.targetPorts);
            }
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0800E", (Exception)iOException, (Object)string);
            this.rc = 4;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
    }

    private long parseWWN(String string) {
        long l = 0L;
        if ((string = string.trim()).indexOf(58) > -1) {
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string.substring(0, 2));
            stringBuffer.append(string.substring(3, 5));
            stringBuffer.append(string.substring(6, 8));
            stringBuffer.append(string.substring(9, 11));
            stringBuffer.append(string.substring(12, 14));
            stringBuffer.append(string.substring(15, 17));
            stringBuffer.append(string.substring(18, 20));
            stringBuffer.append(string.substring(21, 23));
            string = stringBuffer.toString();
        }
        string = string.toUpperCase();
        try {
            l = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            l = -2L;
        }
        return l;
    }

    private void updateTargetPorts() {
        Controller controller = this.computer.cmpController;
        while (controller != null) {
            HashMap hashMap;
            if (controller.ctlrHBAPortWWN != 0L && (hashMap = (HashMap)this.adapterPorts.get(Long.toString(controller.ctlrHBAPortWWN))) != null) {
                DevAccess devAccess = controller.ctlrDevices;
                while (devAccess != null) {
                    String string = (String)hashMap.get(Short.toString(devAccess.daTarget));
                    if (string != null) {
                        devAccess.daTargetPortWWN = Long.parseLong(string);
                    }
                    devAccess = devAccess.daNextDevice;
                }
            }
            controller = controller.ctlrNext;
        }
    }

    private void findVpaths() throws GeneralException {
        StringTokenizer stringTokenizer;
        FileReader fileReader;
        ArrayList<String> arrayList = new ArrayList<String>(20);
        StringBuffer stringBuffer = new StringBuffer(PROC_PARTITIONS);
        try {
            fileReader = new FileReader(stringBuffer.toString());
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0121E", (Exception)iOException, (Object)stringBuffer.toString());
            throw new GeneralException();
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2 = null;
                stringTokenizer = new StringTokenizer(string, " ");
                if (stringTokenizer.countTokens() < 4) continue;
                int n = 0;
                while (n < 4) {
                    string2 = stringTokenizer.nextToken();
                    ++n;
                }
                if (string2 == null || !string2.startsWith("vpath") || Character.isDigit(string2.charAt(string2.length() - 1))) continue;
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0119E", (Exception)iOException, (Object)stringBuffer.toString());
            this.rc = 4;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        if (arrayList.size() > 0) {
            this.detectSGUsage();
            stringTokenizer = new Controller();
            ((Controller)stringTokenizer).ctlrNext = this.computer.cmpController;
            this.computer.cmpController = stringTokenizer;
            ((Controller)stringTokenizer).ctlrDriverName = "SDD";
            ((Controller)stringTokenizer).ctlrDriverDescription = "IBM Subsystem Device Driver";
            ((Controller)stringTokenizer).ctlrTarget = (short)-1;
            ((Controller)stringTokenizer).ctlrType = (short)10;
            ((Controller)stringTokenizer).ctlrInstance = (short)-1;
            int n = 0;
            while (n < arrayList.size() && this.rc <= 4) {
                stringBuffer.setLength(0);
                stringBuffer.append("/dev/");
                stringBuffer.append(arrayList.get(n));
                if (Agent.stopNow) {
                    this.rc = 8;
                } else {
                    int n2 = this.probeVpathDevice(stringBuffer.toString(), (Controller)stringTokenizer, n, this.useSG);
                    if (n2 > this.rc) {
                        this.rc = n2;
                    }
                }
                ++n;
            }
        }
        if (this.rc > 4) {
            throw new GeneralException();
        }
    }

    private void findIDEDisks() throws GeneralException {
        StringBuffer stringBuffer = new StringBuffer("/proc/ide");
        File file = new File(stringBuffer.toString());
        stringBuffer.append('/');
        String[] stringArray = file.list();
        if (stringArray == null) {
            MessageLog.logMessage((String)"STA0215I");
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            block24: {
                if (stringArray[n].startsWith("ide")) {
                    FileReader fileReader;
                    int n2;
                    try {
                        n2 = Integer.parseInt(stringArray[n].substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        break block24;
                    }
                    stringBuffer.append(stringArray[n]);
                    File file2 = new File(stringBuffer.toString());
                    stringBuffer.append('/');
                    String[] stringArray2 = file2.list();
                    if (stringArray2 == null) {
                        MessageLog.logMessage((String)"STA0121E", (Object)stringBuffer.toString());
                        throw new GeneralException();
                    }
                    Controller controller = new Controller();
                    controller.ctlrNext = this.computer.cmpController;
                    this.computer.cmpController = controller;
                    controller.ctlrTarget = (short)-1;
                    controller.ctlrType = 1;
                    controller.ctlrInstance = (short)n2;
                    controller.ctlrDriverName = "ide";
                    controller.ctlrDriverDescription = " ";
                    int n3 = stringBuffer.length();
                    stringBuffer.append("model");
                    BufferedReader bufferedReader = null;
                    try {
                        fileReader = new FileReader(stringBuffer.toString());
                        bufferedReader = new BufferedReader(fileReader);
                        String string = bufferedReader.readLine();
                        if (string != null) {
                            controller.ctlrDriverDescription = string;
                        }
                    }
                    catch (IOException iOException) {}
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < stringArray2.length && this.rc <= 4) {
                        stringBuffer.setLength(n3);
                        stringBuffer.append(stringArray2[n5]);
                        stringBuffer.append("/media");
                        bufferedReader = null;
                        String string = null;
                        try {
                            fileReader = new FileReader(stringBuffer.toString());
                            bufferedReader = new BufferedReader(fileReader);
                            string = bufferedReader.readLine();
                        }
                        catch (IOException iOException) {}
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {}
                            if (string == null) {
                                MessageLog.logMessage((String)"STA0119E", (Object)stringBuffer.toString());
                                throw new GeneralException();
                            }
                            Integer n6 = (Integer)deviceTypes.get(string);
                            int n7 = n6 != null ? n6 : -1;
                            if (Agent.stopNow) {
                                this.rc = 8;
                            } else if (n7 != 1) {
                                int n8 = this.probeIDEDevice("/dev/" + stringArray2[n5], controller, n4, n7);
                                if (n8 > this.rc) {
                                    this.rc = n8;
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    if (this.rc > 4) {
                        throw new GeneralException();
                    }
                    stringBuffer.setLength(10);
                }
            }
            ++n;
        }
    }

    private void findXenDisks() throws GeneralException {
        String[] stringArray;
        FileReader fileReader;
        String string = null;
        try {
            fileReader = new FileReader("/sys/hypervisor/type");
            stringArray = new BufferedReader(fileReader);
            string = stringArray.readLine();
        }
        catch (IOException iOException) {}
        if (string == null) {
            return;
        }
        if (!string.toLowerCase().equals("xen")) {
            return;
        }
        fileReader = new Controller();
        ((Controller)fileReader).ctlrNext = this.computer.cmpController;
        this.computer.cmpController = fileReader;
        ((Controller)fileReader).ctlrTarget = (short)-1;
        ((Controller)fileReader).ctlrType = (short)14;
        ((Controller)fileReader).ctlrInstance = 0;
        ((Controller)fileReader).ctlrDriverName = Controller.TYPES[15];
        ((Controller)fileReader).ctlrDriverDescription = "XenBus Controller";
        stringArray = new File("/sys/block").list();
        if (stringArray == null) {
            MessageLog.logMessage((String)"STA0215I");
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("xvd")) {
                int n3 = 0;
                try {
                    FileReader fileReader2 = new FileReader("/sys/block/" + stringArray[n2] + "/size");
                    BufferedReader bufferedReader = new BufferedReader(fileReader2);
                    n3 = Integer.parseInt(bufferedReader.readLine());
                }
                catch (IOException iOException) {}
                this.probeXenDevice("/dev/" + stringArray[n2], (Controller)fileReader, n, n3);
                ++n;
            }
            ++n2;
        }
    }

    private static String readLine(BufferedReader bufferedReader, String string) throws GeneralException {
        String string2;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"GEN0133E", (Exception)iOException, (Object)string);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException2) {}
            throw new GeneralException();
        }
        return string2;
    }

    private static long getNumber(String string, String string2, int n, char c, String string3) throws GeneralException {
        int n2 = string.indexOf(c);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        int n3 = -1;
        try {
            n3 = (int)Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{string2, new Integer(n), string3};
            throw new GeneralException("STA0343E", objectArray);
        }
        return n3;
    }

    private static BufferedReader openReader(String string) throws GeneralException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (IOException iOException) {
            throw new GeneralException("GEN0029E", null, iOException.getMessage());
        }
        return new BufferedReader(fileReader);
    }

    private static void closeReader(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }

    private static String makeDASDKey(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(n);
        stringBuffer.append('/');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static Map findDASDPartitions() throws GeneralException {
        String string;
        HashMap hashMap = new HashMap();
        BufferedReader bufferedReader = ProbeLinux.openReader(PROC_PARTITIONS);
        int n = 0;
        String[] stringArray = new String[4];
        while ((string = ProbeLinux.readLine(bufferedReader, PROC_PARTITIONS)) != null) {
            Chunk chunk;
            long l;
            int n2;
            Object[] objectArray;
            if (n <= 1) {
                ++n;
                continue;
            }
            LinkedList linkedList = Util.splitLine((String)string, (int)0);
            Iterator iterator = linkedList.iterator();
            int n3 = 0;
            while (n3 < stringArray.length && iterator.hasNext()) {
                stringArray[n3] = (String)iterator.next();
                ++n3;
            }
            if (n3 < stringArray.length) {
                ProbeLinux.closeReader(bufferedReader);
                objectArray = new Object[]{string, PROC_PARTITIONS};
                throw new GeneralException("STA0344E", objectArray);
            }
            objectArray = stringArray[3];
            n3 = objectArray.length();
            while (n3 > 0 && Character.isDigit(objectArray.charAt(n3 - 1))) {
                --n3;
            }
            if (n3 == objectArray.length()) continue;
            String string2 = objectArray.substring(0, n3);
            String string3 = objectArray.substring(n3);
            short s = Short.parseShort(string3);
            try {
                n2 = (int)ProbeLinux.getNumber(stringArray[0], string, 0, '\u0000', PROC_PARTITIONS);
                l = ProbeLinux.getNumber(stringArray[2], string, 2, '\u0000', PROC_PARTITIONS);
            }
            catch (GeneralException generalException) {
                ProbeLinux.closeReader(bufferedReader);
                throw generalException;
            }
            l <<= 1;
            String string4 = ProbeLinux.makeDASDKey(n2, string2);
            linkedList = (List)hashMap.get(string4);
            if (linkedList == null) {
                linkedList = new LinkedList();
                hashMap.put(string4, linkedList);
            }
            boolean bl = true;
            ListIterator<Chunk> listIterator = linkedList.listIterator();
            while (bl && listIterator.hasNext()) {
                chunk = (Chunk)listIterator.next();
                if (chunk.chkSeqno >= s) continue;
                bl = false;
            }
            if (!bl) {
                listIterator.previous();
            }
            chunk = new Chunk();
            chunk.chkPartition = s;
            chunk.chkUnitSize = 512;
            chunk.chkSize = l;
            listIterator.add(chunk);
        }
        ProbeLinux.closeReader(bufferedReader);
        return hashMap;
    }

    private void findDASD() throws GeneralException {
        String string;
        Map map = ProbeLinux.findDASDPartitions();
        BufferedReader bufferedReader = ProbeLinux.openReader(PROC_DASD_DEVICES);
        while ((string = ProbeLinux.readLine(bufferedReader, PROC_DASD_DEVICES)) != null) {
            CharSequence charSequence;
            Object object;
            List list = Util.splitLine((String)string, (int)0);
            Iterator iterator = list.iterator();
            String string2 = null;
            Object object2 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            long l = -1L;
            while (l < 0L && iterator.hasNext()) {
                ++n;
                object = (String)iterator.next();
                if (!bl) {
                    if (!((String)object).equals("at")) continue;
                    bl = true;
                    continue;
                }
                if (n2 < 0) {
                    if (((String)object).length() <= 1) continue;
                    if (((String)object).charAt(0) == '(') {
                        object = ((String)object).substring(1);
                    }
                    try {
                        n2 = (int)ProbeLinux.getNumber((String)object, string, n, ':', PROC_DASD_DEVICES);
                        continue;
                    }
                    catch (GeneralException generalException) {
                        ProbeLinux.closeReader(bufferedReader);
                        throw generalException;
                    }
                }
                if (!bl2) {
                    if (!((String)object).equals("is")) continue;
                    bl2 = true;
                    continue;
                }
                if (string2 == null) {
                    int n4 = ((String)object).indexOf(58);
                    object2 = n4 > 0 ? ((String)object).substring(0, n4) : object;
                    string2 = "/dev/" + (String)object2;
                    continue;
                }
                if (!bl3) {
                    if (!((String)object).startsWith("blocksize")) continue;
                    bl3 = true;
                    continue;
                }
                try {
                    if (n3 < 0) {
                        n3 = (int)ProbeLinux.getNumber((String)object, string, n, ',', PROC_DASD_DEVICES);
                        continue;
                    }
                    l = ProbeLinux.getNumber((String)object, string, n, ',', PROC_DASD_DEVICES);
                }
                catch (GeneralException generalException) {
                    ProbeLinux.closeReader(bufferedReader);
                    throw generalException;
                }
            }
            if (string2 == null) {
                ProbeLinux.closeReader(bufferedReader);
                object = new Object[]{string, PROC_DASD_DEVICES};
                throw new GeneralException("STA0344E", (Object[])object);
            }
            object = new DevAccess();
            ((DevAccess)object).daPath = string2;
            Disk disk = new Disk();
            disk.initUnknown();
            ((DevAccess)object).daDevice = disk;
            disk.devControllers = object;
            disk.devType = 0;
            disk.devFirmwareRev = " ";
            disk.dskLogicalBlockSize = n3;
            disk.dskCapacity = l < 0L ? -1L : l * (long)n3 >> 9;
            DiskHistory diskHistory = disk.dskHistory;
            diskHistory.dkhFreeSpace = -1L;
            if (Agent.stopNow) {
                throw new GeneralException("AGT0157E", null);
            }
            try {
                this.probeDASD(disk);
            }
            catch (LocalizableException localizableException) {
                disk = null;
                localizableException.print();
                this.rc = 4;
            }
            if (disk == null) continue;
            diskHistory.dkhCapacity = disk.dskCapacity;
            if (MainframeLinuxHWID.underVM) {
                charSequence = new StringBuffer(64);
                ((StringBuffer)charSequence).append(disk.devSerialNumber);
                ((StringBuffer)charSequence).append(' ');
                ((StringBuffer)charSequence).append(Agent.localName);
                ((StringBuffer)charSequence).append(',');
                ((StringBuffer)charSequence).append((String)object2);
                disk.devSerialNumber = ((StringBuffer)charSequence).toString();
            }
            if ((list = (List)map.get(charSequence = ProbeLinux.makeDASDKey(n2, (String)object2))) == null) continue;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                chunk.chkDisk = disk;
                chunk.chkNextOnDisk = disk.dskChunk;
                disk.dskChunk = chunk;
            }
            long l2 = 0L;
            iterator = list.iterator();
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                chunk.chkOffset = l2;
                l2 += chunk.chkSize;
            }
            diskHistory.dkhFreeSpace = diskHistory.dkhCapacity - l2;
        }
        ProbeLinux.closeReader(bufferedReader);
    }

    private static String stripLeadingSpace(String string, int n) {
        int n2 = string.length();
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        string = n < n2 ? string.substring(n) : " ";
        return string;
    }

    private static String extractCompaqDescription(String string) {
        String string2 = " ";
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = ProbeLinux.stripLeadingSpace(string, n + 1);
        }
        return string2;
    }

    private boolean parseCompaqVolume(Controller controller, String string, int n, String string2, String string3, int n2) {
        boolean bl;
        Object object;
        int n3 = -1;
        int n4 = string.lastIndexOf(100, n);
        if (n4 > 0 && Character.isDigit(string.charAt(n4 - 1))) {
            try {
                n3 = Integer.parseInt(string.substring(n4 + 1, n));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n3 < 0) {
            Object[] objectArray = new Object[]{new Integer(controller.ctlrInstance), string};
            MessageLog.logMessage((String)"STA0261E", (Object[])objectArray);
            return false;
        }
        int n5 = string.length();
        int n6 = -1;
        long l = -1L;
        String string4 = null;
        if (n2 == 1) {
            int n7 = string.indexOf("blksz=", n);
            if (n7 > 0) {
                n4 = n7 += 6;
                while (n4 < n5 && Character.isDigit(string.charAt(n4))) {
                    ++n4;
                }
                try {
                    n6 = Integer.parseInt(string.substring(n7, n4));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (n6 < 0) {
                string4 = "STA0262W";
            }
            if ((n7 = string.indexOf("nr_blks=", n)) > 0) {
                n4 = n7 += 8;
                while (n4 < n5 && Character.isDigit(string.charAt(n4))) {
                    ++n4;
                }
                try {
                    l = Long.parseLong(string.substring(n7, n4));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (l < 0L) {
                string4 = "STA0263W";
            }
            if (string4 != null) {
                object = new Object[]{new Integer(controller.ctlrInstance), string};
                MessageLog.logMessage((String)string4, (Object[])object);
                this.rc = 4;
            }
        } else {
            String string5 = string.substring(0, n);
            try {
                l = this.findCCISSDiskCapacity(string5);
                if (l > 0L) {
                    n6 = 512;
                }
            }
            catch (GeneralException generalException) {}
        }
        Disk disk = new Disk();
        disk.initUnknown();
        disk.devManufacturer = "COMPAQ";
        disk.devModel = "Logical Disk";
        disk.devFirmwareRev = string3;
        disk.devSerialNumber = String.valueOf(string2) + "-" + n3;
        disk.devType = 0;
        disk.dskSectorSize = n6;
        disk.dskLogicalBlockSize = n6;
        if (l > 0L && n6 > 0) {
            l *= (long)n6;
            l >>= 9;
        }
        disk.dskCapacity = l;
        disk.dskHistory.dkhCapacity = l;
        object = "/dev/" + string.substring(0, n);
        if (n2 == 2) {
            disk.devFlags = (short)2;
            disk.devSerialNumber = String.valueOf(ComputerID.cachedCID.computerID) + "-" + (String)object;
        }
        if (bl = ProbeLinux.findPartitions(disk, (String)object)) {
            DevAccess devAccess = new DevAccess();
            devAccess.daDevice = disk;
            disk.devControllers = devAccess;
            devAccess.daTarget = (short)n3;
            devAccess.daLUN = 0;
            devAccess.daPath = object;
            devAccess.daController = controller;
            devAccess.daNextDevice = controller.ctlrDevices;
            controller.ctlrDevices = devAccess;
            disk.devCanonicalName = "p";
            if (n2 == 2) {
                devAccess.daDevice.devUnsupportedModel = true;
            }
        }
        return bl;
    }

    private void findCompaqArrays() throws GeneralException {
        String string = null;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("/proc/driver/cpqarray");
        File file = new File(stringBuffer.toString());
        stringBuffer.append('/');
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringBuffer = new StringBuffer("/proc/driver/cciss");
            file = new File(stringBuffer.toString());
            stringBuffer.append('/');
            stringArray = file.list();
            if (stringArray == null) {
                return;
            }
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            block28: {
                block27: {
                    block26: {
                        if (!stringArray[n2].startsWith("ida")) break block26;
                        n = 1;
                        stringBuffer.setLength(22);
                        break block27;
                    }
                    if (!stringArray[n2].startsWith("cciss")) break block28;
                    n = 2;
                    stringBuffer.setLength(19);
                }
                stringBuffer.append(stringArray[n2]);
                String string2 = stringBuffer.toString();
                int n3 = -1;
                try {
                    n3 = n == 1 ? Integer.parseInt(stringArray[n2].substring(3)) : Integer.parseInt(stringArray[n2].substring(5));
                }
                catch (NumberFormatException numberFormatException) {}
                if (n3 < 0) {
                    MessageLog.logMessage((String)"STA0258W", (Object)string2);
                    this.rc = 4;
                } else {
                    FileReader fileReader;
                    try {
                        fileReader = new FileReader(string2);
                    }
                    catch (IOException iOException) {
                        MessageLog.logException((String)"GEN0029E", (Exception)iOException);
                        throw new GeneralException();
                    }
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String string3 = " ";
                    String string4 = " ";
                    String string5 = " ";
                    boolean bl = false;
                    boolean bl2 = true;
                    while (bl2 && (string = ProbeLinux.readLine(bufferedReader, string2)) != null) {
                        if ((string = ProbeLinux.stripLeadingSpace(string, 0)).startsWith(stringArray[n2])) {
                            string5 = ProbeLinux.extractCompaqDescription(string);
                            continue;
                        }
                        if (string.startsWith("Controller Sig: 0x") || string.startsWith("Board ID: 0x")) {
                            if (n == 1) {
                                string4 = string.substring(18);
                                continue;
                            }
                            string4 = string.substring(12);
                            continue;
                        }
                        if (string.startsWith("Firmware Revision: ") || string.startsWith("Firmware Version: ")) {
                            string3 = string.substring(19);
                            continue;
                        }
                        if (string.startsWith("Logical Drive Info")) {
                            bl2 = false;
                            continue;
                        }
                        if (string.startsWith("Sequential access devices")) {
                            bl = true;
                            continue;
                        }
                        if (!string.startsWith(" ") || string.length() != 1 || !bl && n == 2) continue;
                        bl2 = false;
                    }
                    boolean bl3 = true;
                    if (!bl2 && !Util.isEmpty((String)string4)) {
                        int n4;
                        Controller controller = new Controller();
                        controller.ctlrInstance = (short)n3;
                        controller.ctlrDriverName = n == 1 ? "ida" : "cciss";
                        controller.ctlrDriverDescription = string5;
                        controller.ctlrTarget = (short)-1;
                        controller.ctlrType = (short)7;
                        while (bl3 && (string = ProbeLinux.readLine(bufferedReader, string2)) != null && (n4 = string.indexOf(58)) > 0) {
                            bl3 = this.parseCompaqVolume(controller, string, n4, string4, string3, n);
                        }
                        if (bl3) {
                            controller.ctlrNext = this.computer.cmpController;
                            this.computer.cmpController = controller;
                        }
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                    if (bl2) {
                        throw new GeneralException();
                    }
                    if (Util.isEmpty((String)string4)) {
                        MessageLog.logMessage((String)"STA0260E", (Object)string2);
                        throw new GeneralException();
                    }
                    if (!bl3) {
                        throw new GeneralException();
                    }
                }
            }
            ++n2;
        }
    }

    private long findCCISSDiskCapacity(String string) throws GeneralException {
        FileReader fileReader;
        StringBuffer stringBuffer = new StringBuffer(PROC_PARTITIONS);
        try {
            fileReader = new FileReader(stringBuffer.toString());
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0121E", (Exception)iOException, (Object)stringBuffer.toString());
            throw new GeneralException();
        }
        long l = -1L;
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String string2;
            boolean bl = false;
            while (!bl && (string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf(string) <= 0) continue;
                String string3 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                if (stringTokenizer.countTokens() <= 4) continue;
                int n = 0;
                while (n < 4) {
                    string3 = stringTokenizer.nextToken();
                    if (n == 2) {
                        try {
                            l = Long.parseLong(string3) * 2L;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Object[] objectArray = new Object[]{string2, new Integer(3), stringBuffer.toString()};
                            throw new GeneralException("STA0343E", objectArray);
                        }
                    } else if (n == 3 && string3.compareToIgnoreCase(string) == 0) {
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"STA0119E", (Exception)iOException, (Object)stringBuffer.toString());
            this.rc = 4;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return l;
    }

    protected LogicalDisk promoteChunk(Chunk chunk) {
        LogicalDisk logicalDisk = super.promoteChunk(chunk);
        if (logicalDisk.ldType == 0 && logicalDisk.ldPath == null) {
            Disk disk = chunk.chkDisk;
            logicalDisk.ldPath = disk.devCanonicalName == null ? String.valueOf(disk.devControllers.daPath) + Integer.toString(chunk.chkPartition) : String.valueOf(disk.devControllers.daPath) + disk.devCanonicalName + Integer.toString(chunk.chkPartition);
        }
        return logicalDisk;
    }

    /*
     * Unable to fully structure code
     */
    protected void platformSpecific() {
        this.rc = this.getComputerConfig();
        if (this.rc > 4) {
            return;
        }
        var1_1 = Agent.hardwareID;
        this.computer.cmpManufacturer = var1_1.manufacturer;
        this.computer.cmpModel = HardwareID.model != null ? HardwareID.model : " ";
        this.computer.cmpSerialNumber = HardwareID.serialNumber != null ? HardwareID.serialNumber : " ";
        try {
            if (Agent.hardwareID.cpuArchitecture == 5) {
                this.findDASD();
            } else {
                this.findSCSIControllers();
                this.findSCSIDisks();
                this.findIDEDisks();
                this.findXenDisks();
                this.findVpaths();
                this.findCompaqArrays();
                this.updateTargetPorts();
            }
        }
        catch (GeneralException var2_2) {
            if (var2_2.messageID != null) {
                var2_2.print();
            }
            this.rc = 8;
            return;
        }
        if (this.computer.cmpController == null) {
            MessageLog.logMessage((String)"STA0216E");
            this.rc = 8;
            return;
        }
        this.arrangeDevices();
        this.cleanUpPartitionsAndDisks();
        var2_3 = this.buildMultipathAccessMap();
        var3_4 = new Mounts();
        if (var3_4.openMnttab()) ** GOTO lbl108
        this.rc = 8;
        return;
lbl-1000:
        // 1 sources

        {
            if (var3_4.type.startsWith("nfs") || var3_4.type.startsWith("sanfs") || var3_4.type.equals("rpc_pipefs") || var3_4.type.equals("usbfs") || var3_4.type.equals("sysfs")) continue;
            if (var3_4.type.equals("tmpfs") || var3_4.type.equals("shm")) {
                var4_5 = this.handleTMPFS(var3_4);
                if (var4_5 <= this.rc) continue;
                this.rc = var4_5;
                continue;
            }
            var5_7 = var3_4.special.length();
            while (var5_7 > 0 && Character.isDigit(var3_4.special.charAt(var5_7 - 1))) {
                --var5_7;
            }
            var6_8 = var3_4.special.substring(0, var5_7);
            var7_9 = var3_4.special.substring(var5_7, var3_4.special.length());
            var8_10 = var3_4.special;
            if (var2_3.containsKey(var6_8)) {
                var9_11 = (DevAccess)var2_3.get(var6_8);
                var10_14 = new StringBuffer(var9_11.daPath);
                var10_14.append(var7_9);
                var8_10 = var10_14.toString();
            }
            var4_6 = this.computer.cmpLogicalDisk;
            while (var4_6 != null && !var8_10.equals(var4_6.ldPath)) {
                var4_6 = var4_6.ldNext;
            }
            if (var4_6 != null && var4_6.ldFilesystem == null && !var8_10.equals(var3_4.special)) {
                var4_6.ldPath = var3_4.special;
                var9_11 = (DevAccess)var2_3.get(var6_8);
                var10_14 = var9_11.daDevice;
                var11_15 = null;
                var12_16 = null;
                var11_15 = var9_11;
                while (!var11_15.daNextController.daPath.equals(var6_8)) {
                    var11_15 = var11_15.daNextController;
                }
                var12_16 = var11_15.daNextController;
                var11_15.daNextController = var9_11;
                var11_15 = var9_11.daNextController;
                var9_11.daNextController = var12_16.daNextController;
                var12_16.daNextController = var11_15;
                var10_14.devControllers = var12_16;
                var2_3 = this.buildMultipathAccessMap();
            }
            if (var4_6 == null) {
                var9_12 = true;
                var10_14 = this.removables;
                while (var9_12 && var10_14 != null) {
                    if (var6_8.equals(var10_14.daPath)) {
                        var9_12 = false;
                        continue;
                    }
                    var10_14 = var10_14.daNextDevice;
                }
                if (var9_12) {
                    MessageLog.logMessage((String)"STA0101W", (Object)var3_4.mountPoint, (Object)var3_4.type, (Object)var3_4.special);
                    this.rc = 4;
                    var4_6 = new LogicalDisk();
                    var4_6.ldPath = var3_4.special;
                    var4_6.ldType = (byte)7;
                    var4_6.ldCapacity = -1L;
                    var4_6.ldNext = this.computer.cmpLogicalDisk;
                    this.computer.cmpLogicalDisk = var4_6;
                }
            }
            if (var4_6 == null) continue;
            var9_13 = new Filesystem();
            if (var3_4.statFS(var9_13) != 0) {
                this.rc = 4;
                continue;
            }
            if (var4_6.ldFilesystem != null) {
                MessageLog.logMessage((String)"STA0100W", (Object)var3_4.special, (Object)var3_4.mountPoint, (Object)var4_6.ldFilesystem.fsMountPoint);
                this.rc = 4;
                continue;
            }
            var4_6.ldFilesystem = var9_13;
            var9_13.fsLogicalDisk = var4_6;
            var4_6.ldIsSwap = false;
            var9_13.fsType = var3_4.type.endsWith("msdos") || var3_4.type.endsWith("fat") ? 0 : (var3_4.type.startsWith("reiser") ? (short)20 : (var3_4.type.startsWith("ocfs") ? (short)22 : (var3_4.type.startsWith("ext") ? (var3_4.type.charAt(3) > '2' ? (short)5 : (short)4) : (short)-1)));
            var9_13.fsMountPoint = var3_4.mountPoint;
lbl108:
            // 8 sources

            ** while (this.rc <= 4 && var3_4.nextMount())
        }
lbl109:
        // 1 sources

    }

    private Map buildMultipathAccessMap() {
        HashMap<String, DevAccess> hashMap = new HashMap<String, DevAccess>();
        Device device = null;
        device = this.computer.cmpDevice;
        while (device != null) {
            if (device instanceof Disk && device.devControllers.daNextController != null) {
                DevAccess devAccess = device.devControllers;
                hashMap.put(devAccess.daPath, devAccess);
                DevAccess devAccess2 = null;
                devAccess2 = devAccess.daNextController;
                while (devAccess2 != null) {
                    hashMap.put(devAccess2.daPath, devAccess);
                    devAccess2 = devAccess2.daNextController;
                }
            }
            device = device.devNext;
        }
        return hashMap;
    }
}

