/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.agent.exec.CmdExecer;
import org.eclipse.aperi.agent.probe.Probe;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LineBreaker;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeSolaris
extends Probe {
    private boolean preSol7;
    private boolean pipeAtEOF;
    private Set badDevices;
    private Map canonicalToTrue;
    private Map trueToCanonical;
    private Map deviceMap;
    private String veritasHostName;
    private static final String OLD_SBIN_DIRECTORY = "/usr/opt/SUNWmd/sbin";
    private static final String SBIN_DIRECTORY = "/usr/sbin";
    private static final short WHOLE_DISK_MASK = 16384;
    private static final byte FAKE_LD_TYPE = -1;
    private static final short FAKE_POWERPATH_TARGET = -2;
    private static final String EMCPOWER = "emcpower";
    private static final String VPATH = "vpath";
    private static boolean veritasLoaded = false;
    private static boolean veritasTested = false;
    private Map concats;
    private Map raid5s;
    private Map mirrors;
    private Map trans;

    static {
        ProbeSolaris.initIDs();
    }

    private static native String getenv(String var0);

    private static native String packageVersion(String var0) throws LocalizableException;

    private static native void describeController(Controller var0, String var1);

    private native int getComputerConfig(Computer var1) throws LocalizableException;

    private native int findDisks(Computer var1) throws LocalizableException;

    private native int probe1Disk(Controller var1, String var2, int var3, int var4);

    private native boolean readCapacityInternal(LogicalDisk var1);

    private static boolean powerPathEntry(String string) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"powerPathEntry", (String)"dirEntry");
        }
        boolean bl2 = bl = string.startsWith(EMCPOWER) || string.startsWith(VPATH);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"powerPathEntry", (boolean)bl);
        }
        return bl;
    }

    private static int embeddedInteger(String string, int n) {
        int n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"embeddedInteger", (String)"s, pos");
        }
        if (n >= (n2 = string.length()) || !Character.isDigit(string.charAt(n))) {
            int n3 = 0;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"embeddedInteger", (int)n3);
            }
            return n3;
        }
        while (++n < n2 && Character.isDigit(string.charAt(n))) {
        }
        int n4 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"embeddedInteger", (int)n4);
        }
        return n4;
    }

    private static boolean isUpperHexDigit(char c) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"isUpperHexDigit", (String)"ch");
        }
        boolean bl2 = bl = Character.isDigit(c) || c >= 'A' && c <= 'F';
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"isUpperHexDigit", (boolean)bl);
        }
        return bl;
    }

    private static int embeddedHexInteger(String string, int n) {
        int n2;
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"embeddedHexInteger", (String)"s, pos");
        }
        boolean bl2 = false;
        int n3 = string.length() - n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"embeddedHexInteger", (String)(">> input: s = " + string + " and pos = " + n + "...length = " + n3));
        }
        if (n3 >= 16) {
            bl = true;
            boolean bl3 = false;
            int n4 = 0;
            while (bl && !bl3) {
                if (ProbeSolaris.isUpperHexDigit(string.charAt(n + n4))) {
                    if (++n4 != 16 && n4 != 32 || string.charAt(n + n4) != 'd') continue;
                    bl3 = true;
                    continue;
                }
                bl = false;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"embeddedHexInteger", (String)(">> going = " + bl + ", i = " + n4 + ", s[" + (n + n4) + "] = " + string.charAt(n + n4)));
            }
            if (bl && (n4 == n3 || !ProbeSolaris.isUpperHexDigit(string.charAt(n + n4)))) {
                n2 = n + n4;
            }
        }
        bl = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"embeddedHexInteger", (int)(bl ? 1 : 0));
        }
        return bl ? 1 : 0;
    }

    private static int powerPathSlice(String string, MutableInteger mutableInteger, MutableInteger mutableInteger2) {
        int n;
        int n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"powerPathSlice", (String)"s, target, LUN");
        }
        if ((n2 = ProbeSolaris.embeddedInteger(string, n = string.charAt(0) == EMCPOWER.charAt(0) ? EMCPOWER.length() : VPATH.length())) != string.length() - 1) {
            int n3 = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"powerPathSlice", (int)n3);
            }
            return n3;
        }
        if (mutableInteger != null) {
            mutableInteger.value = -2;
        }
        if (mutableInteger2 != null) {
            mutableInteger2.value = Integer.parseInt(string.substring(n, n2));
        }
        int n4 = string.charAt(n2) - 97;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"powerPathSlice", (int)n4);
        }
        return n4;
    }

    private int canonicalSlice(String string, MutableInteger mutableInteger, MutableInteger mutableInteger2) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"canonicalSlice", (String)"s, target, LUN");
        }
        if (mutableInteger != null && mutableInteger2 != null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> input: s = " + string + ", target = " + mutableInteger.value + ", LUN = " + mutableInteger2.value));
            } else if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> input: s = " + string + ", target = NULL, LUN = NULL"));
            }
        }
        if (ProbeSolaris.powerPathEntry(string)) {
            int n2 = ProbeSolaris.powerPathSlice(string, mutableInteger, mutableInteger2);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz2.getName(), (String)"canonicalSlice", (String)(">> returned from powerPathSlice() with traceResult = " + n2));
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n2);
            }
            return n2;
        }
        int n3 = string.length();
        if (n3 <= 0 || string.charAt(0) != 'c') {
            int n4 = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n4);
            }
            return n4;
        }
        int n5 = ProbeSolaris.embeddedInteger(string, 1);
        if (n5 == 0 || n5 >= n3 || string.charAt(n5) != 't') {
            int n6 = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n6);
            }
            return n6;
        }
        int n7 = n5 + 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> calling embeddedHexInteger() with s = " + string + " and start = " + n7));
        }
        int n8 = ProbeSolaris.embeddedHexInteger(string, n7);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> returned from embeddedHexInteger() with hexPos = " + n8));
        }
        if ((n5 = n8 == 0 ? ProbeSolaris.embeddedInteger(string, n7) : n8) == 0 || n5 >= n3 || string.charAt(n5) != 'd') {
            int n9 = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n9);
            }
            return n9;
        }
        if (mutableInteger != null) {
            n = n8 > 0 ? 16 : 10;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> length of target = " + (n5 - n7) + " where pos = " + n5 + " and start = " + n7));
            }
            if (n5 - n7 >= 32) {
                String string2 = string.substring(n7 + 24, n5);
                Long.parseLong(string2, n);
                mutableInteger.value = (int)Long.parseLong(string2, n);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> 32-digit HEX target = " + mutableInteger.value));
                }
            } else if (n5 - n7 >= 16) {
                String string3 = string.substring(n7 + 8, n5);
                Long.parseLong(string3, n);
                mutableInteger.value = (int)Long.parseLong(string3, n);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> 16-digit HEX target = " + mutableInteger.value));
                }
            } else {
                mutableInteger.value = (int)Long.parseLong(string.substring(n7, n5), n);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> Integer target = " + mutableInteger.value));
                }
            }
            if (mutableInteger.value < 0) {
                mutableInteger.value ^= 0xFFFFFFFF;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> after ~target.value ... target.value = " + mutableInteger.value));
                }
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> TARGET = " + mutableInteger.value));
            }
        }
        if ((n5 = ProbeSolaris.embeddedInteger(string, n7 = n5 + 1)) == 0 || n5 >= n3 || string.charAt(n5) != 's') {
            n = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n);
            }
            return n;
        }
        if (mutableInteger2 != null) {
            mutableInteger2.value = Integer.parseInt(string.substring(n7, n5));
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"canonicalSlice", (String)(">> LUN = " + mutableInteger2.value));
            }
        }
        if (ProbeSolaris.embeddedInteger(string, ++n5) < n3) {
            n = -1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n);
            }
            return n;
        }
        n = Integer.parseInt(string.substring(n5));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n);
        }
        return n;
    }

    private int canonicalSlice(String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"canonicalSlice", (String)"s");
        }
        int n = this.canonicalSlice(string, null, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"canonicalSlice", (int)n);
        }
        return n;
    }

    private Device findDeviceAndPutName(String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"findDeviceAndPutName", (String)"accessPath, devName");
        }
        Device device = null;
        Controller controller = this.computer.cmpController;
        while (device == null && controller != null) {
            DevAccess devAccess = controller.ctlrDevices;
            while (device == null && devAccess != null) {
                if (devAccess.daPath.equals(string)) {
                    devAccess.daName = string2;
                    device = devAccess.daDevice;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findDeviceAndPutName", (String)(">> Found matching device for accessPath " + string + " and set da.daName to " + string2));
                    }
                }
                devAccess = devAccess.daNextDevice;
            }
            controller = controller.ctlrNext;
        }
        Device device2 = device;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"findDeviceAndPutName", device2);
        }
        return device2;
    }

    private boolean makeDeviceMap() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"makeDeviceMap", (String)"");
        }
        this.deviceMap = new HashMap();
        File file = new File("/dev/dsk");
        String[] stringArray = file.list();
        if (stringArray == null) {
            MessageLog.logMessage((String)"STA0102E", (Object)"/dev/dsk");
            this.rc = 8;
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"makeDeviceMap", (boolean)bl);
            }
            return bl;
        }
        String string = null;
        String string2 = null;
        MutableInteger mutableInteger = new MutableInteger();
        int n = 0;
        while (n < stringArray.length) {
            block38: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"makeDeviceMap", (String)(">> contents[" + n + "] = " + stringArray[n]));
                }
                mutableInteger.value = 0;
                if (this.canonicalSlice(stringArray[n], mutableInteger, null) >= 0) {
                    int n2;
                    String string3;
                    boolean bl;
                    boolean bl2 = bl = mutableInteger.value == -2;
                    if (bl) {
                        string3 = stringArray[n].substring(0, stringArray[n].length() - 1);
                    } else {
                        n2 = stringArray[n].lastIndexOf(115);
                        string3 = stringArray[n].substring(0, n2);
                    }
                    if (this.deviceMap.get(string3) == null) {
                        File file2;
                        block37: {
                            file2 = new File(file, stringArray[n]);
                            try {
                                Class<?> clazz;
                                string = file2.getCanonicalPath();
                                if (!TraceLogger.enableTrace) break block37;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"makeDeviceMap", (String)(">> resolvedPath = " + string));
                            }
                            catch (IOException iOException) {
                                if (TraceLogger.enableTrace) {
                                    Class<?> clazz;
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.exception((String)clazz.getName(), (String)"makeDeviceMap", (Throwable)iOException);
                                }
                                MessageLog.logException((String)"STA0070W", (Exception)iOException, (Object)file2.getPath());
                                this.rc = 4;
                                break block38;
                            }
                        }
                        if ((n2 = string.lastIndexOf(58)) < 0 || string.indexOf(47, n2) >= 0) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"makeDeviceMap", (String)">> Slice-name has wrong form: resolvedPath does not contain ':' or contains '/' after ':'...");
                            }
                            MessageLog.logMessage((String)"STA0066W", (Object)string);
                        } else {
                            Device device;
                            string = string.substring(0, n2);
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"makeDeviceMap", (String)(">> resolvedPath = " + string));
                            }
                            if ((device = this.findDeviceAndPutName(string, string2 = file2.getPath())) != null) {
                                device.devCanonicalName = string3;
                                this.deviceMap.put(string3, device);
                                if (TraceLogger.enableTrace) {
                                    Class<?> clazz;
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"makeDeviceMap", (String)(">> device.devCanonicalName = " + device.devCanonicalName));
                                }
                            }
                        }
                    }
                }
            }
            ++n;
        }
        n = 1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"makeDeviceMap", n != 0);
        }
        return n != 0;
    }

    protected void multiPathDevice(Device device, Device device2) {
        String string = device2.devCanonicalName;
        if (string != null) {
            this.deviceMap.put(string, device);
        }
    }

    private void mapTrueCanonical() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"mapTrueCanonical", (String)"");
        }
        this.canonicalToTrue = new HashMap();
        this.trueToCanonical = new HashMap();
        StringBuffer stringBuffer = new StringBuffer(30);
        Iterator iterator = this.deviceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Device device = (Device)entry.getValue();
            if (!(device instanceof Disk)) continue;
            Disk disk = (Disk)device;
            stringBuffer.setLength(0);
            String string = entry.getKey().toString();
            boolean bl = ProbeSolaris.powerPathEntry(string);
            stringBuffer.append(string);
            stringBuffer.append('s');
            int n = stringBuffer.length();
            Chunk chunk = disk.dskChunk;
            while (chunk != null) {
                stringBuffer.setLength(n);
                if (!bl) {
                    stringBuffer.append(chunk.chkPartition);
                } else {
                    char c = (char)chunk.chkPartition;
                    c = (char)(c + 97);
                    stringBuffer.append(c);
                }
                string = stringBuffer.toString();
                this.canonicalToTrue.put(string, chunk);
                this.trueToCanonical.put(chunk, string);
                chunk = chunk.chkNextOnDisk;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"mapTrueCanonical");
        }
    }

    private Chunk chunkFromCanonical(String string) {
        Chunk chunk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"chunkFromCanonical", (String)"s");
        }
        if ((chunk = (Chunk)this.canonicalToTrue.get(string)) == null && !this.badDevices.contains(string)) {
            MessageLog.logMessage((String)"STA0067W", (Object)string);
            this.badDevices.add(string);
            this.rc = 4;
        }
        Chunk chunk2 = chunk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"chunkFromCanonical", (Object)chunk2);
        }
        return chunk2;
    }

    protected LogicalDisk promoteChunk(Chunk chunk) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"promoteChunk", (String)"chunk");
        }
        LogicalDisk logicalDisk = chunk.chkPartition >= 0 ? this.reallyPromoteChunk(chunk) : null;
        LogicalDisk logicalDisk2 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"promoteChunk", (Object)logicalDisk2);
        }
        return logicalDisk2;
    }

    private LogicalDisk reallyPromoteChunk(Chunk chunk) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"reallyPromoteChunk", (String)"chunk");
        }
        LogicalDisk logicalDisk = super.promoteChunk(chunk);
        if (logicalDisk.ldType == 0 && logicalDisk.ldPath == null) {
            short s = chunk.chkPartition;
            if (s >= 16384) {
                s = (short)(s - 16384);
                logicalDisk.ldType = (byte)-1;
            }
            String string = chunk.chkDisk.devControllers.daPath;
            char c = (char)(97 + s);
            logicalDisk.ldTruePath = String.valueOf(string) + ':' + c;
            String string2 = (String)this.trueToCanonical.get(chunk);
            logicalDisk.ldPath = string2 != null ? "/dev/dsk/" + string2 : logicalDisk.ldTruePath;
        }
        LogicalDisk logicalDisk2 = logicalDisk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"reallyPromoteChunk", (Object)logicalDisk2);
        }
        return logicalDisk2;
    }

    protected Disk lookUpDisk(String string) {
        Object v;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"lookUpDisk", (String)"canonicalName");
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"lookUpDisk", (String)(">> input canonicalName = " + string));
        }
        Disk disk = null;
        int n = string.length() - 1;
        if (n >= 0 && string.charAt(n) == 'c') {
            string = string.substring(0, n);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"lookUpDisk", (String)(">> modified PowerPath canonicalName = " + string));
            }
        }
        if ((v = this.deviceMap.get(string)) == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"lookUpDisk", (String)(">> WARNING: Disk not found: " + string));
            }
            MessageLog.logMessage((String)"STA0226W", (Object)string);
        } else if (v instanceof Disk) {
            disk = (Disk)v;
        } else {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"lookUpDisk", (String)(">> WARNING: VRTSvxvm managing removable disk: " + string));
            }
            MessageLog.logMessage((String)"STA0227W", (Object)string);
        }
        Disk disk2 = disk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"lookUpDisk", (Object)disk2);
        }
        return disk2;
    }

    private static String alternateVeritasPath(String string) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"alternateVeritasPath", (String)"primaryPath");
        }
        String string2 = "";
        int n2 = string.lastIndexOf(47);
        if (n2 > 0 && (n = string.substring(0, n2).lastIndexOf(47)) >= 0) {
            string2 = String.valueOf(string.substring(0, n)) + string.substring(n2);
        }
        String string3 = string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"alternateVeritasPath", (Object)string3);
        }
        return string3;
    }

    private static boolean pathsMatch(String string, String string2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"pathsMatch", (String)"mountSpecial, ldTruePath");
        }
        if (string.equals(string2)) {
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"pathsMatch", (boolean)bl);
            }
            return bl;
        }
        if (!string2.startsWith("/dev/vx/dsk/")) {
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"pathsMatch", (boolean)bl);
            }
            return bl;
        }
        boolean bl = string.equals(ProbeSolaris.alternateVeritasPath(string2));
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"pathsMatch", (boolean)bl);
        }
        return bl;
    }

    private void addToAppropriateSet(String string) {
        block40: {
            String[] stringArray;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"addToAppropriateSet", (String)"line");
            }
            if ((stringArray = LineBreaker.parse((String)string)).length < 2) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"addToAppropriateSet");
                }
                return;
            }
            char c = stringArray[1].charAt(0);
            try {
                MetaDevice metaDevice;
                Map map;
                if (Character.isDigit(c)) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"addToAppropriateSet", (String)(">> Processing description " + stringArray + " as new Concat()"));
                    }
                    map = this.concats;
                    metaDevice = new Concat(stringArray);
                } else {
                    if (c != '-' || stringArray[1].length() < 2) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"addToAppropriateSet");
                        }
                        return;
                    }
                    switch (stringArray[1].charAt(1)) {
                        case 'r': {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"addToAppropriateSet", (String)(">> Processing description " + stringArray + " as new Raid5()"));
                            }
                            map = this.raid5s;
                            metaDevice = new Raid5(stringArray);
                            break;
                        }
                        case 'm': {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"addToAppropriateSet", (String)(">> Processing description " + stringArray + " as new Mirror()"));
                            }
                            map = this.mirrors;
                            metaDevice = new Mirror(stringArray);
                            break;
                        }
                        case 't': {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"addToAppropriateSet", (String)(">> Processing description " + stringArray + " as new Trans()"));
                            }
                            map = this.trans;
                            metaDevice = new Trans(stringArray);
                            break;
                        }
                        default: {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exit((String)clazz.getName(), (String)"addToAppropriateSet");
                            }
                            return;
                        }
                    }
                }
                map.put(metaDevice, metaDevice);
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block40;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"addToAppropriateSet", (Throwable)generalException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addToAppropriateSet");
        }
    }

    private String pipeLine(BufferedReader bufferedReader) {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"pipeLine", (String)"in");
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        do {
            String string;
            block17: {
                bl = false;
                string = null;
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block17;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"pipeLine", (Throwable)iOException);
                }
            }
            if (string == null) {
                this.pipeAtEOF = true;
                continue;
            }
            int n = string.length();
            if (n > 0 && string.charAt(n - 1) == '\\') {
                string = string.substring(0, n - 1);
                bl = true;
            }
            stringBuffer.append(string);
        } while (bl);
        if (stringBuffer.length() == 0 && this.pipeAtEOF) {
            String string = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"pipeLine", string);
            }
            return string;
        }
        String string = stringBuffer.toString();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"pipeLine", (Object)string);
        }
        return string;
    }

    private static void cleanUpChild(CmdExecer cmdExecer) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"cleanUpChild", (String)"execer");
        }
        cmdExecer.close();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanUpChild");
        }
    }

    private static native void initIDs();

    private boolean findSSDisks() {
        boolean bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"findSSDisks", (String)"");
        }
        int n = 1;
        short s = -1;
        Controller controller = this.computer.cmpController;
        if (controller != null) {
            bl = true;
            while (bl) {
                if (controller.ctlrInstance > s) {
                    s = controller.ctlrInstance;
                }
                if (controller.ctlrNext != null) {
                    controller = controller.ctlrNext;
                    continue;
                }
                bl = false;
            }
        }
        s = (short)(s + 1);
        HashMap<String, Controller> hashMap = new HashMap<String, Controller>();
        MutableInteger mutableInteger = new MutableInteger();
        MutableInteger mutableInteger2 = new MutableInteger();
        File file = new File("/dev/rdsk");
        String[] stringArray = file.list();
        if (stringArray == null) {
            MessageLog.logMessage((String)"STA0102E", (Object)"/dev/rdsk");
            this.rc = 8;
            boolean bl2 = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"findSSDisks", (boolean)bl2);
            }
            return bl2;
        }
        int n2 = 0;
        while (n2 < stringArray.length && this.rc <= 4) {
            block71: {
                int n3;
                Controller controller2;
                String string;
                block76: {
                    String string2;
                    int n4;
                    block75: {
                        block74: {
                            block73: {
                                block72: {
                                    block69: {
                                        block70: {
                                            if (this.canonicalSlice(stringArray[n2], mutableInteger, mutableInteger2) >= 0) break block70;
                                            if (TraceLogger.enableTrace) {
                                                Class<?> clazz;
                                                try {
                                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)">> canonicalSlice() returned with rc < 0...continue to next slice");
                                            }
                                            break block71;
                                        }
                                        string = null;
                                        File file2 = new File(file, stringArray[n2]);
                                        try {
                                            Class<?> clazz;
                                            string = file2.getCanonicalPath();
                                            if (!TraceLogger.enableTrace) break block69;
                                            try {
                                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> file.getCanonicalPath() returned with resolvedPath = " + string));
                                        }
                                        catch (IOException iOException) {
                                            if (TraceLogger.enableTrace) {
                                                Class<?> clazz;
                                                try {
                                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                                TraceLogger.exception((String)clazz.getName(), (String)"findSSDisks", (Throwable)iOException);
                                            }
                                            MessageLog.logException((String)"STA0070W", (Exception)iOException, (Object)file2.getPath());
                                        }
                                    }
                                    if (string != null) break block72;
                                    this.rc = 4;
                                    if (TraceLogger.enableTrace) {
                                        Class<?> clazz;
                                        try {
                                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)">> resolvedPath = NULL...continue to next slice");
                                    }
                                    break block71;
                                }
                                if (string.startsWith("/devices/")) break block73;
                                if (TraceLogger.enableTrace) {
                                    Class<?> clazz;
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)">> resolvedPath doesn't start with /devices/...continue to next slice");
                                }
                                break block71;
                            }
                            n4 = string.lastIndexOf(47);
                            string2 = string.substring(n4 + 1);
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> resolvedPath after last / (pos = " + n4 + ") = " + string2));
                            }
                            if (this.preSol7 || mutableInteger.value == -2 || string2.startsWith("ssd@")) break block74;
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)">> not FAKE_POWERPATH_TARGET or ssd disk...continue to next slice");
                            }
                            break block71;
                        }
                        if (mutableInteger.value == -2) {
                            mutableInteger.value = 0;
                            n4 += 1 + string2.indexOf(64);
                        }
                        string2 = string.substring(0, n4);
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> looking for controller " + string2));
                        }
                        if ((controller2 = (Controller)hashMap.get(string2)) != null) break block75;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> create new Controller for " + string2));
                        }
                        controller2 = new Controller();
                        n4 = string2.lastIndexOf(47);
                        String string3 = string2.substring(n4 + 1);
                        if ((n4 = string3.indexOf(64)) > 0) {
                            string3 = string3.substring(0, n4);
                        }
                        if (string3.startsWith("SUNW,")) {
                            string3 = string3.substring(5);
                        }
                        controller2.ctlrDriverName = string3;
                        ProbeSolaris.describeController(controller2, string3);
                        controller2.ctlrBusNumber = 0;
                        controller2.ctlrTarget = (short)-1;
                        controller2.ctlrInstance = s;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> ...with DriverName = " + controller2.ctlrDriverName + ", BusNumber = " + controller2.ctlrBusNumber + ", Target = " + controller2.ctlrTarget + ", Instance = " + controller2.ctlrInstance));
                        }
                        s = (short)(s + 1);
                        if (controller != null) {
                            controller.ctlrNext = controller2;
                        } else {
                            this.computer.cmpController = controller2;
                        }
                        controller = controller2;
                        hashMap.put(string2, controller2);
                        break block76;
                    }
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> found existing Controller " + string2));
                    }
                    String string4 = (n4 = string.lastIndexOf(58)) > 0 ? string.substring(0, n4) : string;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> resolvedPath after last : (pos = " + n4 + ") = " + string4));
                    }
                    bl = true;
                    DevAccess devAccess = controller2.ctlrDevices;
                    while (devAccess != null && bl) {
                        if (string4.equals(devAccess.daPath)) {
                            bl = false;
                            continue;
                        }
                        devAccess = devAccess.daNextDevice;
                    }
                    if (!bl) break block71;
                }
                if (Agent.stopNow) {
                    MessageLog.logMessage((String)"AGT0157E");
                    n3 = 8;
                } else {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"findSSDisks", (String)(">> calling native probe1Disk() with controller = " + controller2.ctlrDriverName + ", resolvedPath = " + string + ", target = " + mutableInteger.value + ", LUN = " + mutableInteger2.value));
                    }
                    n3 = this.probe1Disk(controller2, string, mutableInteger.value, mutableInteger2.value);
                }
                if (n3 > this.rc) {
                    this.rc = n3;
                    if (n3 > 4) {
                        n = 0;
                    }
                }
            }
            ++n2;
        }
        n2 = n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"findSSDisks", n2 != 0);
        }
        return n2 != 0;
    }

    private void handleWholeDiskLDs() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handleWholeDiskLDs", (String)"");
        }
        LogicalDisk logicalDisk = null;
        LogicalDisk logicalDisk2 = this.computer.cmpLogicalDisk;
        while (logicalDisk2 != null) {
            if (logicalDisk2.ldType != -1) {
                logicalDisk = logicalDisk2;
            } else {
                Chunk chunk = logicalDisk2.ldCollectionList.ccChunkList;
                Disk disk = chunk.chkDisk;
                if (logicalDisk2.ldFilesystem == null) {
                    if (logicalDisk != null) {
                        logicalDisk.ldNext = logicalDisk2.ldNext;
                    } else {
                        this.computer.cmpLogicalDisk = logicalDisk2.ldNext;
                    }
                    Chunk chunk2 = null;
                    boolean bl = true;
                    Chunk chunk3 = disk.dskChunk;
                    while (bl && chunk3 != null) {
                        if (chunk3 == chunk) {
                            if (chunk2 != null) {
                                chunk2.chkNextOnDisk = chunk.chkNextOnDisk;
                            } else {
                                disk.dskChunk = chunk.chkNextOnDisk;
                            }
                            bl = false;
                            continue;
                        }
                        chunk2 = chunk3;
                        chunk3 = chunk3.chkNextOnDisk;
                    }
                } else {
                    logicalDisk2.ldType = 0;
                    chunk.chkPartition = (short)(chunk.chkPartition - 16384);
                    chunk.chkNextOnDisk = null;
                    disk.dskChunk = chunk;
                    logicalDisk = logicalDisk2;
                }
            }
            logicalDisk2 = logicalDisk2.ldNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handleWholeDiskLDs");
        }
    }

    private void parseEnterprisePrtdiag(BufferedReader bufferedReader) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"parseEnterprisePrtdiag", (String)"prtdiagOut");
        }
        String string = null;
        String string2 = this.computer.cmpModel;
        String string3 = null;
        boolean bl = true;
        while (bl && (string3 = this.pipeLine(bufferedReader)) != null) {
            if (string3.length() <= 0 || string3.charAt(0) != '-') continue;
            bl = false;
        }
        if (bl) {
            string = "STA0267W";
        } else {
            string3 = this.pipeLine(bufferedReader);
            if (string3 == null) {
                string = "STA0268W";
            } else {
                string2 = string3;
                List list = Util.splitLine((String)string3, (int)0);
                if (list.size() < 6) {
                    string = "STA0269W";
                } else {
                    block20: {
                        try {
                            this.computer.cmpProcessorSpeed = (short)Integer.parseInt(list.get(3).toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block20;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"parseEnterprisePrtdiag", (Throwable)numberFormatException);
                        }
                    }
                    if (this.computer.cmpProcessorSpeed >= 0) {
                        this.computer.cmpProcessorType = list.get(5).toString();
                    } else {
                        string = "STA0270W";
                    }
                }
            }
        }
        if (string != null) {
            MessageLog.logMessage((String)string, (Object)string2);
            this.rc = 4;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"parseEnterprisePrtdiag");
        }
    }

    private int parsePrtdiag(String string) {
        block23: {
            int n;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"parsePrtdiag", (String)"line");
            }
            if ((n = string.lastIndexOf(40)) < 0) {
                int n2 = 1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"parsePrtdiag", (int)n2);
                }
                return n2;
            }
            List list = Util.splitLine((String)string, (int)(n + 1));
            int n3 = list.size();
            if (n3 < 2) {
                int n4 = -1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"parsePrtdiag", (int)n4);
                }
                return n4;
            }
            this.computer.cmpProcessorType = list.get(n3 - 2).toString();
            String string2 = list.get(n3 - 1).toString();
            list = null;
            int n5 = string2.length();
            n3 = 0;
            while (n3 < n5 && Character.isDigit(string2.charAt(n3))) {
                ++n3;
            }
            if (n3 == 0) {
                int n6 = -1;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"parsePrtdiag", (int)n6);
                }
                return n6;
            }
            String string3 = string2.substring(0, n3);
            try {
                this.computer.cmpProcessorSpeed = (short)Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block23;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"parsePrtdiag", (Throwable)numberFormatException);
            }
        }
        int n = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"parsePrtdiag", (int)n);
        }
        return n;
    }

    private void invokePrtdiag() {
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"invokePrtdiag", (String)"");
        }
        if (Util.isEmpty((String)this.computer.cmpModel)) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"invokePrtdiag");
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        if (Util.isEmpty((String)this.computer.cmpManufacturer)) {
            string = this.computer.cmpModel;
        } else {
            stringBuffer.append(this.computer.cmpManufacturer);
            stringBuffer.append(',');
            stringBuffer.append(this.computer.cmpModel);
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringBuffer.append("/usr/platform/");
        stringBuffer.append(string);
        stringBuffer.append("/sbin/prtdiag");
        String[] stringArray = new String[]{stringBuffer.toString()};
        stringBuffer = null;
        CmdExecer cmdExecer = new CmdExecer(stringArray);
        if (!cmdExecer.exec()) {
            this.rc = 4;
        } else {
            this.pipeAtEOF = false;
            String string2 = this.pipeLine(cmdExecer.stdout);
            if (string2 != null) {
                int n = this.parsePrtdiag(string2);
                if (n != 0) {
                    if (n > 0) {
                        this.parseEnterprisePrtdiag(cmdExecer.stdout);
                    } else {
                        MessageLog.logMessage((String)"STA0266W", (Object)stringArray[0], (Object)string2);
                        this.rc = 4;
                    }
                }
            } else {
                MessageLog.logMessage((String)"STA0265W", (Object)stringArray[0]);
                this.rc = 4;
            }
            ProbeSolaris.cleanUpChild(cmdExecer);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"invokePrtdiag");
        }
    }

    private static void removeUnownedLogicalDisks(Computer computer) {
        DevAccess devAccess;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeUnownedLogicalDisks", (String)"comp");
        }
        LogicalDisk logicalDisk = computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldType == 0 && logicalDisk.ldFilesystem != null) {
                devAccess = logicalDisk.ldCollectionList.ccChunkList.chkDisk.devControllers;
                while (devAccess != null) {
                    devAccess.daInactive = false;
                    devAccess = devAccess.daNextController;
                }
            }
            logicalDisk = logicalDisk.ldNext;
        }
        devAccess = null;
        logicalDisk = computer.cmpLogicalDisk;
        while (logicalDisk != null) {
            if (logicalDisk.ldType != 0 || !logicalDisk.ldCollectionList.ccChunkList.chkDisk.devControllers.daInactive) {
                devAccess = logicalDisk;
            } else if (devAccess != null) {
                devAccess.ldNext = logicalDisk.ldNext;
            } else {
                computer.cmpLogicalDisk = logicalDisk.ldNext;
            }
            logicalDisk = logicalDisk.ldNext;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeUnownedLogicalDisks");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void platformSpecific() {
        if (TraceLogger.enableTrace) {
            try {
                v0 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            TraceLogger.entry((String)v0.getName(), (String)"platformSpecific", (String)"");
        }
        try {
            this.rc = this.getComputerConfig(this.computer);
        }
        catch (LocalizableException var1_1) {
            if (TraceLogger.enableTrace) {
                try {
                    v2 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException v3) {
                    throw new NoClassDefFoundError(v3.getMessage());
                }
                TraceLogger.exception((String)v2.getName(), (String)"platformSpecific", (Throwable)var1_1);
            }
            var1_1.print();
            this.rc = 8;
        }
        if (this.rc >= 8) {
            if (TraceLogger.enableTrace) {
                try {
                    v4 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException v5) {
                    throw new NoClassDefFoundError(v5.getMessage());
                }
                TraceLogger.exit((String)v4.getName(), (String)"platformSpecific");
            }
            return;
        }
        if (this.preSol7) {
            this.invokePrtdiag();
        }
        if (!ProbeSolaris.veritasTested) {
            var1_2 = null;
            try {
                var1_2 = ProbeSolaris.packageVersion("VRTSvxvm");
                if (var1_2 != null) {
                    var2_7 = this.isVeritasRunning();
                    if (!var2_7) {
                        var1_2 = null;
                    }
                } else {
                    var1_2 = ProbeSolaris.packageVersion("SUNWvxvm");
                }
                ProbeSolaris.veritasTested = true;
            }
            catch (LocalizableException var2_8) {
                if (TraceLogger.enableTrace) {
                    try {
                        v6 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException v7) {
                        throw new NoClassDefFoundError(v7.getMessage());
                    }
                    TraceLogger.exception((String)v6.getName(), (String)"platformSpecific", (Throwable)var2_8);
                }
                var2_8.print();
                this.rc = 4;
            }
            if (var1_2 != null) {
                ProbeSolaris.veritasLoaded = true;
            }
        }
        if (ProbeSolaris.veritasLoaded) {
            this.determineVeritasHostName();
        } else {
            this.veritasHostName = "";
        }
        this.badDevices = new HashSet<E>();
        if (!this.preSol7) {
            try {
                var1_3 = this.findDisks(this.computer);
                if (var1_3 > this.rc) {
                    this.rc = var1_3;
                }
            }
            catch (LocalizableException var1_4) {
                if (TraceLogger.enableTrace) {
                    try {
                        v8 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException v9) {
                        throw new NoClassDefFoundError(v9.getMessage());
                    }
                    TraceLogger.exception((String)v8.getName(), (String)"platformSpecific", (Throwable)var1_4);
                }
                var1_4.print();
                this.rc = 8;
            }
            if (this.rc >= 8) {
                if (TraceLogger.enableTrace) {
                    try {
                        v10 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException v11) {
                        throw new NoClassDefFoundError(v11.getMessage());
                    }
                    TraceLogger.exit((String)v10.getName(), (String)"platformSpecific");
                }
                return;
            }
        }
        if (!this.findSSDisks()) {
            if (TraceLogger.enableTrace) {
                try {
                    v12 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException v13) {
                    throw new NoClassDefFoundError(v13.getMessage());
                }
                TraceLogger.exit((String)v12.getName(), (String)"platformSpecific");
            }
            return;
        }
        if (!this.makeDeviceMap()) {
            if (TraceLogger.enableTrace) {
                try {
                    v14 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException v15) {
                    throw new NoClassDefFoundError(v15.getMessage());
                }
                TraceLogger.exit((String)v14.getName(), (String)"platformSpecific");
            }
            return;
        }
        this.arrangeDevices();
        this.mapTrueCanonical();
        if (ProbeSolaris.veritasLoaded && (var1_5 = this.handleVeritas()) > this.rc) {
            this.rc = var1_5;
            if (this.rc > 4) {
                if (TraceLogger.enableTrace) {
                    try {
                        v16 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException v17) {
                        throw new NoClassDefFoundError(v17.getMessage());
                    }
                    TraceLogger.exit((String)v16.getName(), (String)"platformSpecific");
                }
                return;
            }
        }
        var1_6 = null;
        try {
            if (ProbeSolaris.packageVersion("SUNWmd") != null) {
                var1_6 = "/usr/opt/SUNWmd/sbin";
            } else if (ProbeSolaris.packageVersion("SUNWmdu") != null) {
                var1_6 = "/usr/sbin";
            }
        }
        catch (LocalizableException var2_9) {
            if (TraceLogger.enableTrace) {
                try {
                    v18 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException v19) {
                    throw new NoClassDefFoundError(v19.getMessage());
                }
                TraceLogger.exception((String)v18.getName(), (String)"platformSpecific", (Throwable)var2_9);
            }
            var2_9.print();
            this.rc = 4;
        }
        var2_10 = null;
        v20 = var7_11 = var1_6 != null;
        if (var7_11) {
            var2_10 = new LinkedList<String>();
            var2_10.add(null);
            var3_12 = new String[]{String.valueOf(var1_6) + "/metaset"};
            var5_13 = new CmdExecer(var3_12);
            if (var5_13.exec()) {
                this.pipeAtEOF = false;
                while (!this.pipeAtEOF && (var4_14 = this.pipeLine(var5_13.stdout)) != null) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v21 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException v22) {
                            throw new NoClassDefFoundError(v22.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v21.getName(), (String)"platformSpecific", (String)(">> metaset output: current line = " + var4_14));
                    }
                    if (!var4_14.startsWith("Set name = ") || (var8_15 = var4_14.indexOf(44, 11)) <= 11) continue;
                    if (TraceLogger.enableTrace) {
                        try {
                            v23 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException v24) {
                            throw new NoClassDefFoundError(v24.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v23.getName(), (String)"platformSpecific", (String)(">> Adding Set name " + var4_14.substring(11, var8_15) + " to shareSet..."));
                    }
                    var2_10.add(var4_14.substring(11, var8_15));
                }
                ProbeSolaris.cleanUpChild(var5_13);
            }
            this.concats = new HashMap<K, V>();
            this.raid5s = new HashMap<K, V>();
            this.mirrors = new HashMap<K, V>();
            this.trans = new HashMap<K, V>();
            var9_19 /* !! */  = new LogicalDisk[]{String.valueOf(var1_6) + "/metastat", "-p"};
            var10_20 = new String[4];
            var10_20[0] = var9_19 /* !! */ [0];
            var10_20[1] = "-s";
            var10_20[3] = var9_19 /* !! */ [1];
            var6_23 = var2_10.iterator();
            while (var7_11 && var6_23.hasNext()) {
                var8_16 = (String)var6_23.next();
                if (var8_16 == null) {
                    var3_12 = var9_19 /* !! */ ;
                    if (TraceLogger.enableTrace) {
                        try {
                            v25 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException v26) {
                            throw new NoClassDefFoundError(v26.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v25.getName(), (String)"platformSpecific", (String)(">> Executing " + (String)var9_19 /* !! */ [0] + " " + (String)var9_19 /* !! */ [1] + "..."));
                    }
                } else {
                    var10_20[2] = var8_16;
                    var3_12 = var10_20;
                    if (TraceLogger.enableTrace) {
                        try {
                            v27 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException v28) {
                            throw new NoClassDefFoundError(v28.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v27.getName(), (String)"platformSpecific", (String)(">> Executing " + (String)var10_20[0] + " " + (String)var10_20[1] + " " + (String)var10_20[2] + " " + (String)var10_20[3] + "..."));
                    }
                }
                if (!(var7_11 = (var5_13 = new CmdExecer(var3_12)).exec())) continue;
                this.pipeAtEOF = false;
                while (!this.pipeAtEOF && (var4_14 = this.pipeLine(var5_13.stdout)) != null) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v29 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException v30) {
                            throw new NoClassDefFoundError(v30.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)v29.getName(), (String)"platformSpecific", (String)(">> metastat output: current line = " + var4_14));
                    }
                    this.addToAppropriateSet(var4_14);
                }
                ProbeSolaris.cleanUpChild(var5_13);
            }
        }
        if (var7_11) {
            var9_19 /* !! */  = new LogicalDisk[]{this.mirrors, this.concats, this.raid5s, this.trans};
            var10_21 = 0;
            while (var10_21 < 4) {
                var6_23 = var9_19 /* !! */ [var10_21].values().iterator();
                while (var6_23.hasNext()) {
                    var8_17 = (MetaDevice)var6_23.next();
                    var8_17.pass2();
                }
                ++var10_21;
            }
        }
        this.getHBAPortWWNs();
        this.correlateHBAs();
        this.cleanUpPartitionsAndDisks();
        var8_18 = new Mounts();
        if (var8_18.openMnttab()) ** GOTO lbl314
        this.rc = 8;
        if (TraceLogger.enableTrace) {
            try {
                v31 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException v32) {
                throw new NoClassDefFoundError(v32.getMessage());
            }
            TraceLogger.exit((String)v31.getName(), (String)"platformSpecific");
        }
        return;
lbl-1000:
        // 1 sources

        {
            if (var8_18.type.startsWith("nfs") || var8_18.type.startsWith("sanfs")) continue;
            if (var8_18.type.equals("tmpfs")) {
                var10_22 = this.handleTMPFS(var8_18);
                if (var10_22 <= this.rc) continue;
                this.rc = var10_22;
                continue;
            }
            var11_24 = null;
            var12_25 = new File(var8_18.special);
            try {
                var10_20 = var12_25.getCanonicalPath();
            }
            catch (IOException var13_27) {
                if (TraceLogger.enableTrace) {
                    try {
                        v33 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException v34) {
                        throw new NoClassDefFoundError(v34.getMessage());
                    }
                    TraceLogger.exception((String)v33.getName(), (String)"platformSpecific", (Throwable)var13_27);
                }
                MessageLog.logException((String)"STA0070W", (Exception)var13_27, (Object)var8_18.special);
                this.rc = 4;
                continue;
            }
            var9_19 /* !! */  = this.computer.cmpLogicalDisk;
            while (var9_19 /* !! */  != null && !ProbeSolaris.pathsMatch((String)var10_20, var9_19 /* !! */ .ldTruePath)) {
                var9_19 /* !! */  = var9_19 /* !! */ .ldNext;
            }
            if (var9_19 /* !! */  == null && var7_11) {
                var13_28 = null;
                var6_23 = this.trans.values().iterator();
                var14_32 = 0;
                while (var14_32 == 0 && var6_23.hasNext()) {
                    var13_28 = (Trans)var6_23.next();
                    if (!var10_20.equals(var13_28.logicalDisk.ldTruePath)) continue;
                    var14_32 = 1;
                }
                if (var14_32 != 0) {
                    var9_19 /* !! */  = var13_28.dataDevice;
                    var11_24 = var13_28.logDevice;
                }
            }
            if (var9_19 /* !! */  == null && var10_20.startsWith("/dev/vx/dsk/")) {
                var9_19 /* !! */  = new LogicalDisk();
                var9_19 /* !! */ .ldPath = var10_20;
                var9_19 /* !! */ .ldTruePath = var10_20;
                var9_19 /* !! */ .ldType = (byte)7;
                var9_19 /* !! */ .ldCapacity = -1L;
                var9_19 /* !! */ .ldNext = this.computer.cmpLogicalDisk;
                this.computer.cmpLogicalDisk = var9_19 /* !! */ ;
            }
            if (var9_19 /* !! */  != null) {
                var13_29 = new Filesystem();
                if (var8_18.statFS(var13_29) != 0) {
                    this.rc = 4;
                    continue;
                }
                if (var9_19 /* !! */ .ldFilesystem != null) {
                    MessageLog.logMessage((String)"STA0100W", (Object)var8_18.special, (Object)var8_18.mountPoint, (Object)var9_19 /* !! */ .ldFilesystem.fsMountPoint);
                    this.rc = 4;
                    continue;
                }
                var9_19 /* !! */ .ldFilesystem = var13_29;
                var13_29.fsLogicalDisk = var9_19 /* !! */ ;
                var13_29.fsLogDisk = var11_24;
                var9_19 /* !! */ .ldIsSwap = false;
                var13_29.fsType = var8_18.type.equals("ufs") != false ? (short)9 : (var8_18.type.equals("vxfs") != false ? (short)8 : (short)-1);
                var13_29.fsMountPoint = var8_18.mountPoint;
                continue;
            }
            var13_30 = true;
            var14_32 = var10_20.lastIndexOf(58);
            if (var14_32 >= 0 && var10_20.indexOf(47, var14_32) < 0) {
                var15_33 = var10_20.substring(0, var14_32);
                var16_34 = this.removables;
                while (var13_30 && var16_34 != null) {
                    if (var15_33.equals(var16_34.daPath)) {
                        var13_30 = false;
                        continue;
                    }
                    var16_34 = var16_34.daNextDevice;
                }
            }
            if (var13_30 && var10_20.startsWith("/vol/")) {
                var13_30 = false;
            }
            if (!var13_30) continue;
            MessageLog.logMessage((String)"STA0101W", (Object)var8_18.mountPoint, (Object)var8_18.type, (Object)var10_20);
            this.rc = 4;
lbl314:
            // 10 sources

            ** while (this.rc <= 4 && var8_18.nextMount())
        }
lbl315:
        // 1 sources

        this.handleWholeDiskLDs();
        ProbeSolaris.removeUnownedLogicalDisks(this.computer);
        if (var7_11) {
            var10_20 = new String[]{String.valueOf(var1_6) + "/metadb"};
            v35 = new String[3];
            v35[0] = var10_20[0];
            v35[1] = "-s";
            var11_24 = v35;
            var6_23 = var2_10.iterator();
            while (var7_11 && var6_23.hasNext()) {
                var9_19 /* !! */  = (String)var6_23.next();
                if (var9_19 /* !! */  == null) {
                    var3_12 = var10_20;
                } else {
                    var11_24[2] = var9_19 /* !! */ ;
                    var3_12 = var11_24;
                }
                var5_13 = new CmdExecer(var3_12);
                var7_11 = var5_13.exec();
                if (!var7_11) continue;
                this.pipeAtEOF = false;
                while (!this.pipeAtEOF && (var4_14 = this.pipeLine(var5_13.stdout)) != null) {
                    var12_26 = var4_14.lastIndexOf(47);
                    if (var12_26 < 0 || (var13_31 = this.chunkFromCanonical(var4_14 = var4_14.substring(var12_26 + 1))) == null) continue;
                    var13_31.chkHasDB = true;
                }
                ProbeSolaris.cleanUpChild(var5_13);
            }
        }
        if (TraceLogger.enableTrace) {
            try {
                v36 = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
            }
            catch (ClassNotFoundException v37) {
                throw new NoClassDefFoundError(v37.getMessage());
            }
            TraceLogger.exit((String)v36.getName(), (String)"platformSpecific");
        }
    }

    private class MetaDevice {
        public String shareSet;
        public String node;
        public String[] description;
        public String rawDevice;
        public String cookedDevice;
        public LogicalDisk logicalDisk;

        private void fillSomeFields(String string) throws GeneralException {
            int n;
            int n2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"fillSomeFields", (String)"name");
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"fillSomeFields", (String)(">> input: name = " + string));
            }
            if ((n2 = string.lastIndexOf(47)) <= 0) {
                this.shareSet = null;
                this.node = string;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"fillSomeFields", (String)(">> pos = " + n2 + ", shareSet = NULL, and node = " + this.node));
                }
            } else {
                this.shareSet = string.substring(0, n2);
                this.node = string.substring(n2 + 1);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"fillSomeFields", (String)(">> pos = " + n2 + ", shareSet = " + this.shareSet + ", and node = " + this.node));
                }
            }
            if ((n = this.node.length()) < 1 || this.node.charAt(0) != 'd' || ProbeSolaris.embeddedInteger(this.node, 1) < n) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"fillSomeFields");
                }
                throw new GeneralException();
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fillSomeFields");
            }
        }

        protected MetaDevice(String string) throws GeneralException {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"MetaDevice", (String)(">> Inside MetaDevice(name)...calling fileSomeFields() with name = " + string));
            }
            this.fillSomeFields(string);
        }

        public MetaDevice(String[] stringArray) throws GeneralException {
            block31: {
                File file;
                int n;
                StringBuffer stringBuffer;
                block30: {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.entry((String)clazz.getName(), (String)"MetaDevice", (String)"pDescription");
                    }
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"MetaDevice", (String)(">> Inside MetaDevice(pDescription)...calling fileSomeFields() with pDescription[0] = " + stringArray[0]));
                    }
                    this.fillSomeFields(stringArray[0]);
                    this.description = stringArray;
                    stringBuffer = new StringBuffer("/dev/md/");
                    if (this.shareSet != null) {
                        stringBuffer.append(this.shareSet);
                        stringBuffer.append('/');
                    }
                    n = stringBuffer.length();
                    stringBuffer.append("rdsk/");
                    stringBuffer.append(this.node);
                    file = new File(stringBuffer.toString());
                    try {
                        Class<?> clazz;
                        this.rawDevice = file.getCanonicalPath();
                        if (!TraceLogger.enableTrace) break block30;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"MetaDevice", (String)(">> Found rawDevice " + this.rawDevice + " for " + stringBuffer.toString()));
                    }
                    catch (IOException iOException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"MetaDevice", (Throwable)iOException);
                        }
                        MessageLog.logException((String)"STA0070W", (Exception)iOException, (Object)file.getPath());
                        ProbeSolaris.this.rc = 4;
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exit((String)clazz.getName(), (String)"MetaDevice");
                        }
                        throw new GeneralException();
                    }
                }
                stringBuffer.setLength(n);
                stringBuffer.append("dsk/");
                stringBuffer.append(this.node);
                this.logicalDisk = new LogicalDisk();
                this.logicalDisk.ldPath = stringBuffer.toString();
                file = new File(this.logicalDisk.ldPath);
                try {
                    Class<?> clazz;
                    this.cookedDevice = file.getCanonicalPath();
                    if (!TraceLogger.enableTrace) break block31;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"MetaDevice", (String)(">> Found cookedDevice " + this.cookedDevice + " for " + stringBuffer.toString()));
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"MetaDevice", (Throwable)iOException);
                    }
                    MessageLog.logException((String)"STA0070W", (Exception)iOException, (Object)file.getPath());
                    ProbeSolaris.this.rc = 4;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"MetaDevice");
                    }
                    throw new GeneralException();
                }
            }
            this.logicalDisk.ldTruePath = this.cookedDevice;
            this.logicalDisk.ldCollectionList = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"MetaDevice");
            }
        }

        public boolean equals(Object object) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"pRight");
            }
            MetaDevice metaDevice = (MetaDevice)object;
            if (this.shareSet != null) {
                if (!this.shareSet.equals(metaDevice.shareSet)) {
                    boolean bl = false;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
                    }
                    return bl;
                }
            } else if (metaDevice.shareSet != null) {
                boolean bl = false;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
                }
                return bl;
            }
            boolean bl = this.node.equals(metaDevice.node);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int hashCode() {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"hashCode", (String)"");
            }
            int n = 0;
            if (this.shareSet != null) {
                n = this.shareSet.hashCode();
            }
            int n2 = n ^ this.node.hashCode();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"hashCode", (int)n2);
            }
            return n2;
        }

        protected void readCapacity() {
            this.logicalDisk.ldTruePath = this.rawDevice;
            boolean bl = ProbeSolaris.this.readCapacityInternal(this.logicalDisk);
            if (!bl) {
                ProbeSolaris.this.rc = 4;
            }
            this.logicalDisk.ldTruePath = this.cookedDevice;
        }

        public void pass2() {
            this.readCapacity();
            this.logicalDisk.ldNext = ProbeSolaris.this.computer.cmpLogicalDisk;
            ProbeSolaris.this.computer.cmpLogicalDisk = this.logicalDisk;
        }

        protected void logParseError(String string, int n) throws GeneralException {
            ProbeSolaris.this.rc = 4;
            MessageLog.logMessage((String)string, (Object)new Integer(n + 1));
            PrintWriter printWriter = MessageLog.getThreadLog();
            int n2 = 0;
            while (n2 < this.description.length) {
                printWriter.println("                         " + this.description[n2]);
                ++n2;
            }
            throw new GeneralException();
        }

        protected int parseInterleave(String string, int n) throws GeneralException {
            int n2;
            int n3;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"parseInterleave", (String)"messageID, pos");
            }
            if (n >= this.description.length) {
                this.logParseError(string, n);
            }
            if ((n3 = this.description[n].length()) < 2) {
                this.logParseError(string, n);
            }
            if ((n2 = ProbeSolaris.embeddedInteger(this.description[n], 0)) != n3 - 1) {
                this.logParseError(string, n);
            }
            int n4 = Integer.parseInt(this.description[n].substring(0, n2));
            int n5 = 9;
            switch (this.description[n].charAt(n2)) {
                case 'b': {
                    break;
                }
                case 'k': {
                    n5 = 10;
                    break;
                }
                case 'm': {
                    n5 = 20;
                    break;
                }
                default: {
                    this.logParseError(string, n);
                }
            }
            int n6 = n4 << n5;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$MetaDevice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"parseInterleave", (int)n6);
            }
            return n6;
        }
    }

    private class Concat
    extends MetaDevice {
        public Concat(String[] stringArray) throws GeneralException {
            super(stringArray);
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Concat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"Concat", (String)"pDescription");
            }
            this.logicalDisk.ldType = 1;
            int n = 0;
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Concat");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"Concat", (Throwable)numberFormatException);
                }
                this.logParseError("STA0071W", 1);
            }
            int n2 = 0;
            int n3 = 2;
            ChunkCollection chunkCollection = null;
            int n4 = 0;
            while (n4 < n) {
                if (n3 >= stringArray.length) {
                    this.logParseError("STA0072W", n3);
                }
                try {
                    n2 = Integer.parseInt(stringArray[n3]);
                }
                catch (NumberFormatException numberFormatException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Concat");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"Concat", (Throwable)numberFormatException);
                    }
                    this.logParseError("STA0072W", n3);
                }
                ChunkCollection chunkCollection2 = new ChunkCollection();
                chunkCollection2.ccLogicalDisk = this.logicalDisk;
                chunkCollection2.ccSeqno = (short)n4;
                if (n2 > 1) {
                    chunkCollection2.ccType = 1;
                    chunkCollection2.ccStripingSize = 16384;
                } else {
                    chunkCollection2.ccType = 0;
                    chunkCollection2.ccStripingSize = -1;
                }
                if (chunkCollection != null) {
                    chunkCollection.ccNext = chunkCollection2;
                } else {
                    this.logicalDisk.ldCollectionList = chunkCollection2;
                }
                chunkCollection = chunkCollection2;
                ++n3;
                Chunk chunk = null;
                int n5 = 0;
                while (n5 < n2) {
                    Chunk chunk2;
                    if (n3 >= stringArray.length) {
                        this.logParseError("STA0073W", n3);
                    }
                    if ((chunk2 = ProbeSolaris.this.chunkFromCanonical(stringArray[n3])) == null) {
                        this.logParseError("STA0073W", n3);
                    }
                    if (chunk2.chkCollection != null) {
                        this.logParseError("STA0074W", n3);
                    }
                    chunk2.chkCollection = chunkCollection2;
                    chunk2.chkSeqno = (short)n5;
                    if (chunk != null) {
                        chunk.chkNextInCollection = chunk2;
                    } else {
                        chunkCollection2.ccChunkList = chunk2;
                    }
                    chunk = chunk2;
                    ++n3;
                    ++n5;
                }
                if (n3 < stringArray.length && stringArray[n3].charAt(0) == '-') {
                    if (stringArray[n3].length() < 2 || stringArray[n3].charAt(1) != 'i' && stringArray[n3].charAt(1) != 'h') {
                        this.logParseError("STA0075W", n3);
                    }
                    if (stringArray[n3].charAt(1) == 'i' && n2 > 1) {
                        chunkCollection2.ccStripingSize = this.parseInterleave("STA0076W", n3 + 1);
                    }
                    n3 += 2;
                }
                ++n4;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Concat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"Concat");
            }
        }
    }

    private class Raid5
    extends MetaDevice {
        public Raid5(String[] stringArray) throws GeneralException {
            super(stringArray);
            ChunkCollection chunkCollection;
            this.logicalDisk.ldType = 1;
            this.logicalDisk.ldCollectionList = chunkCollection = new ChunkCollection();
            chunkCollection.ccLogicalDisk = this.logicalDisk;
            chunkCollection.ccStripingSize = 16384;
            chunkCollection.ccSeqno = 0;
            chunkCollection.ccType = (byte)2;
            Chunk chunk = null;
            boolean bl = true;
            int n = 2;
            int n2 = 0;
            while (bl) {
                if (n >= stringArray.length) {
                    bl = false;
                    continue;
                }
                if (stringArray[n].charAt(0) == '-') {
                    if (stringArray[n].length() < 2) {
                        this.logParseError("STA0077W", n);
                    }
                    switch (stringArray[n].charAt(1)) {
                        case 'h': {
                            bl = false;
                            break;
                        }
                        case 'k': {
                            break;
                        }
                        case 'o': {
                            ++n;
                            break;
                        }
                        case 'i': {
                            chunkCollection.ccStripingSize = this.parseInterleave("STA0078W", n + 1);
                            ++n;
                            bl = false;
                            break;
                        }
                        default: {
                            this.logParseError("STA0077W", n);
                            break;
                        }
                    }
                } else {
                    Chunk chunk2 = ProbeSolaris.this.chunkFromCanonical(stringArray[n]);
                    if (chunk2 == null) {
                        this.logParseError("STA0079W", n);
                    }
                    if (chunk2.chkCollection != null) {
                        this.logParseError("STA0080W", n);
                    }
                    chunk2.chkCollection = chunkCollection;
                    chunk2.chkSeqno = (short)n2;
                    n2 = (short)(n2 + 1);
                    if (chunk != null) {
                        chunk.chkNextInCollection = chunk2;
                    } else {
                        chunkCollection.ccChunkList = chunk2;
                    }
                    chunk = chunk2;
                }
                ++n;
            }
            if (n2 < 2) {
                this.logParseError("STA0081W", 0);
            }
        }
    }

    private class Mirror
    extends MetaDevice {
        public Mirror(String[] stringArray) throws GeneralException {
            super(stringArray);
        }

        private void resolve() throws GeneralException {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Mirror");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"resolve", (String)"");
            }
            this.logicalDisk.ldCollectionList = null;
            this.logicalDisk.ldType = (byte)3;
            this.logicalDisk.ldNextMirror = null;
            this.logicalDisk.ldMirrorCount = 0;
            LogicalDisk logicalDisk = this.logicalDisk;
            MetaDevice metaDevice = null;
            int n = 2;
            boolean bl = true;
            while (n < this.description.length && bl) {
                LogicalDisk logicalDisk2;
                try {
                    metaDevice = new MetaDevice(this.description[n]);
                }
                catch (GeneralException generalException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Mirror");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"resolve", (Throwable)generalException);
                    }
                    bl = false;
                }
                if (!bl) continue;
                Concat concat = (Concat)ProbeSolaris.this.concats.remove(metaDevice);
                if (concat == null) {
                    this.logParseError("STA0087W", n);
                }
                concat.readCapacity();
                logicalDisk.ldNextMirror = logicalDisk2 = concat.logicalDisk;
                logicalDisk2.ldNextMirror = null;
                logicalDisk = logicalDisk2;
                this.logicalDisk.ldMirrorCount = (byte)(this.logicalDisk.ldMirrorCount + 1);
                ++n;
            }
            if (this.logicalDisk.ldMirrorCount == 0) {
                this.logParseError("STA0084W", 0);
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Mirror");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"resolve");
            }
        }

        public void pass2() {
            block10: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Mirror");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"pass2", (String)"");
                }
                try {
                    this.resolve();
                    super.pass2();
                }
                catch (GeneralException generalException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block10;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Mirror");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"pass2", (Throwable)generalException);
                }
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Mirror");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"pass2");
            }
        }
    }

    private class Trans
    extends MetaDevice {
        public LogicalDisk dataDevice;
        public LogicalDisk logDevice;

        public Trans(String[] stringArray) throws GeneralException {
            super(stringArray);
        }

        private MetaDevice lookUp(Map map, MetaDevice metaDevice, boolean bl) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"lookUp", (String)"map, key, parsingLog");
            }
            MetaDevice metaDevice2 = bl ? (MetaDevice)map.get(metaDevice) : (MetaDevice)map.remove(metaDevice);
            MetaDevice metaDevice3 = metaDevice2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"lookUp", (Object)metaDevice3);
            }
            return metaDevice3;
        }

        private void resolve() throws GeneralException {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"resolve", (String)"");
            }
            int n = 2;
            while (n <= 3) {
                LogicalDisk logicalDisk;
                Object object;
                int n2;
                boolean bl;
                boolean bl2 = bl = n == 3;
                if (n >= this.description.length) {
                    String string = bl ? "STA0089W" : "STA0088W";
                    this.logParseError(string, n);
                }
                if ((n2 = ProbeSolaris.this.canonicalSlice(this.description[n])) >= 0) {
                    object = ProbeSolaris.this.chunkFromCanonical(this.description[n]);
                    if (object == null) {
                        this.logParseError("STA0093W", n);
                    }
                    if (!bl && object.chkCollection != null) {
                        this.logParseError("STA0090W", n);
                    }
                    logicalDisk = ProbeSolaris.this.reallyPromoteChunk(object);
                } else {
                    MetaDevice metaDevice;
                    block20: {
                        object = null;
                        metaDevice = null;
                        try {
                            metaDevice = new MetaDevice(this.description[n]);
                        }
                        catch (GeneralException generalException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block20;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"resolve", (Throwable)generalException);
                        }
                    }
                    if (metaDevice == null) {
                        this.logParseError("STA0092W", n);
                    }
                    if ((object = this.lookUp(ProbeSolaris.this.concats, metaDevice, bl)) == null && (object = this.lookUp(ProbeSolaris.this.raid5s, metaDevice, bl)) == null && (object = this.lookUp(ProbeSolaris.this.mirrors, metaDevice, bl)) == null) {
                        this.logParseError("STA0091W", n);
                    }
                    logicalDisk = object.logicalDisk;
                }
                if (bl) {
                    this.logDevice = logicalDisk;
                } else {
                    this.dataDevice = logicalDisk;
                }
                ++n;
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"resolve");
            }
        }

        public void pass2() {
            block10: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.entry((String)clazz.getName(), (String)"pass2", (String)"");
                }
                try {
                    this.resolve();
                }
                catch (GeneralException generalException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block10;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"pass2", (Throwable)generalException);
                }
            }
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.agent.probe.ProbeSolaris$Trans");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"pass2");
            }
        }
    }
}

