/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.Date;
import java.util.LinkedList;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.RunningAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMovingAve
implements IAggregation {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$aggregation$TotalMovingAve;

    public String getName() {
        return "MOVINGAVE";
    }

    public int getType() {
        return 1;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true, false};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends RunningAccumulator {
        private LinkedList list;
        private int window = 1;
        private double sum = 0.0;
        private boolean isDateType = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MyAccumulator() {
        }

        public void start() {
            this.sum = 0.0;
            this.list = new LinkedList();
            this.window = 1;
            this.isDateType = false;
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 1) {
                throw new AssertionError();
            }
            if (args[0] != null && args[1] != null) {
                try {
                    if (this.list.size() == 0) {
                        this.window = DataTypeUtil.toInteger((Object)args[1]);
                        if (!$assertionsDisabled && this.window <= 0) {
                            throw new AssertionError();
                        }
                        if (args[0] instanceof Date) {
                            this.isDateType = true;
                        }
                    }
                    if (this.isDateType) {
                        long value = ((Date)args[0]).getTime();
                        this.list.addLast(new Long(value));
                        this.sum += (double)value;
                    } else {
                        Double value = DataTypeUtil.toDouble((Object)args[0]);
                        this.list.addLast(value);
                        this.sum += value.doubleValue();
                    }
                    if (this.list.size() > this.window) {
                        this.sum -= ((Number)this.list.get(0)).doubleValue();
                        this.list.remove(0);
                    }
                }
                catch (BirtException e) {
                    throw new DataException("data.engine.DataConversionError", e);
                }
            }
        }

        public Object getValue() {
            if (this.list.size() == 0) {
                return null;
            }
            return new Double(this.sum / (double)this.list.size());
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$aggregation$TotalMovingAve == null ? (class$org$eclipse$birt$data$engine$aggregation$TotalMovingAve = TotalMovingAve.class$("org.eclipse.birt.data.engine.aggregation.TotalMovingAve")) : class$org$eclipse$birt$data$engine$aggregation$TotalMovingAve).desiredAssertionStatus();
        }
    }
}

