/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation.rank;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.aggregation.RunningAccumulator;
import org.eclipse.birt.data.engine.aggregation.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.Aggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalPercentRank
extends Aggregation {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$aggregation$rank$TotalPercentRank;

    public String getName() {
        return "PERCENTRANK";
    }

    public int getType() {
        return 1;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true};
    }

    public int getNumberOfPasses() {
        return 2;
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends RunningAccumulator {
        private Double sum;
        private List cachedValues;
        private int passCount = 0;
        private Object[] sortedObjs;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MyAccumulator() {
        }

        public void start() {
            if (this.passCount == 0) {
                this.cachedValues = new ArrayList();
                this.sum = new Double(0.0);
            }
            ++this.passCount;
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 0) {
                throw new AssertionError();
            }
            if (this.passCount == 1) {
                if (args[0] != null) {
                    this.cachedValues.add(args[0]);
                } else {
                    this.cachedValues.add(RankAggregationUtil.getNullObject());
                }
            } else {
                Object compareValue = args[0] != null ? args[0] : RankAggregationUtil.getNullObject();
                this.sum = new Double(this.getPercentRank(compareValue, this.sortedObjs));
            }
        }

        public void finish() throws DataException {
            if (this.passCount == 1) {
                this.sortedObjs = this.cachedValues.toArray();
                RankAggregationUtil.sortArray(this.sortedObjs);
            }
        }

        private double getPercentRank(Object o, Object[] objs) {
            double smaller = -1.0;
            for (int i = 0; i < objs.length; ++i) {
                if (!o.equals(objs[i]) || smaller != -1.0) continue;
                smaller = i;
            }
            if (smaller == -1.0 || smaller == 0.0) {
                return 0.0;
            }
            double result = smaller / (double)(objs.length - 1);
            return result;
        }

        public Object getValue() throws DataException {
            return this.sum;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$aggregation$rank$TotalPercentRank == null ? (class$org$eclipse$birt$data$engine$aggregation$rank$TotalPercentRank = TotalPercentRank.class$("org.eclipse.birt.data.engine.aggregation.rank.TotalPercentRank")) : class$org$eclipse$birt$data$engine$aggregation$rank$TotalPercentRank).desiredAssertionStatus();
        }
    }
}

