/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.util.ArrayList;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class CachedResultSet
implements IResultIterator {
    private ResultSetPopulator resultSetPopulator;
    private IEventHandler handler;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CachedResultSet() {
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, ResultSet odaResultSet, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, eventHandler, session);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaResultSet));
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, IDataSetPopulator odaResultSet, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, eventHandler, session);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaResultSet));
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, DataSetResultCache odaCacheResultSet, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, eventHandler, session);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaCacheResultSet));
        odaCacheResultSet.close();
    }

    public CachedResultSet(BaseQuery query, ICustomDataSet customDataSet, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        if (!$assertionsDisabled && customDataSet == null) {
            throw new AssertionError();
        }
        this.resultSetPopulator = new ResultSetPopulator(query, customDataSet.getResultClass(), this, eventHandler, session);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(customDataSet));
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, IResultIterator parentResultIterator, int groupLevel, IEventHandler eventHandler, DataEngineSession session) throws DataException {
        this.handler = eventHandler;
        if (!$assertionsDisabled && !(parentResultIterator instanceof CachedResultSet)) {
            throw new AssertionError();
        }
        CachedResultSet parentResultSet = (CachedResultSet)parentResultIterator;
        int[] groupInfo = parentResultSet.getCurrentGroupInfo(groupLevel);
        this.resultSetPopulator = new ResultSetPopulator(query, this.createCustomDataSetMetaData(query, meta), this, eventHandler, session);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(new Object[]{parentResultSet.resultSetPopulator.getCache(), groupInfo}));
    }

    private IResultClass createCustomDataSetMetaData(BaseQuery query, IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        if (query.getFetchEvents() != null) {
            for (int i = 0; i < meta.getFieldCount(); ++i) {
                projectedColumns.add(new ResultFieldMetadata(i, meta.getFieldName(i + 1), meta.getFieldLabel(i + 1), meta.getFieldValueClass(i + 1), meta.getFieldNativeTypeName(i + 1), false));
            }
            for (int j = 0; j < query.getFetchEvents().size(); ++j) {
                if (query.getFetchEvents().get(j) instanceof ComputedColumnHelper) {
                    ComputedColumnHelper helper = (ComputedColumnHelper)query.getFetchEvents().get(j);
                    helper.setModel(1);
                    for (int i = 0; i < helper.getComputedColumnList().size(); ++i) {
                        projectedColumns.add(new ResultFieldMetadata(i + 1 + meta.getFieldCount(), ((IComputedColumn)helper.getComputedColumnList().get(i)).getName(), ((IComputedColumn)helper.getComputedColumnList().get(i)).getName(), DataType.getClass((int)((IComputedColumn)helper.getComputedColumnList().get(i)).getDataType()), null, true));
                    }
                }
                meta = new ResultClass(projectedColumns);
            }
        }
        return meta;
    }

    private int[] getCurrentGroupInfo(int groupLevel) throws DataException {
        return this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getCurrentGroupInfo(groupLevel);
    }

    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        if (streamsWrapper.getStreamForGroupInfo() != null) {
            this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().doSave(streamsWrapper.getStreamForGroupInfo());
        }
        if (!isSubQuery && streamsWrapper.getStreamForResultClass() != null) {
            ((ResultClass)this.resultSetPopulator.getResultSetMetadata()).doSave(streamsWrapper.getStreamForResultClass(), this.resultSetPopulator.getEventHandler().getAllColumnBindings());
        }
        if (streamsWrapper.getStreamForDataSet() != null) {
            this.resultSetPopulator.getCache().doSave(streamsWrapper.getStreamForDataSet(), this.resultSetPopulator.getEventHandler().getAllColumnBindings());
        }
    }

    public void close() {
        if (this.resultSetPopulator == null || this.resultSetPopulator.getCache() == null) {
            return;
        }
        this.resultSetPopulator.getCache().close();
        this.resultSetPopulator = null;
    }

    public IResultObject getCurrentResult() throws DataException {
        if (!($assertionsDisabled || this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null)) {
            throw new AssertionError();
        }
        return this.resultSetPopulator.getCache().getCurrentResult();
    }

    public boolean next() throws DataException {
        if (!($assertionsDisabled || this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null)) {
            throw new AssertionError();
        }
        boolean hasNext = this.resultSetPopulator.getCache().next();
        this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().next(hasNext);
        return hasNext;
    }

    public int getEndingGroupLevel() throws DataException {
        return this.resultSetPopulator.getEndingGroupLevel();
    }

    public int getStartingGroupLevel() throws DataException {
        return this.resultSetPopulator.getStartingGroupLevel();
    }

    public void first(int groupLevel) throws DataException {
        this.resultSetPopulator.first(groupLevel);
    }

    public void last(int groupLevel) throws DataException {
        this.resultSetPopulator.last(groupLevel);
    }

    public IResultClass getResultClass() throws DataException {
        return this.resultSetPopulator.getResultSetMetadata();
    }

    public int getCurrentResultIndex() throws DataException {
        if (!($assertionsDisabled || this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null)) {
            throw new AssertionError();
        }
        return this.resultSetPopulator.getCache().getCurrentIndex();
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.resultSetPopulator.getCurrentGroupIndex(groupLevel);
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return this.resultSetPopulator.getGroupStartAndEndIndex(groupLevel);
    }

    public int getRowCount() throws DataException {
        return this.resultSetPopulator.getCache().getCount();
    }

    public ResultSetCache getResultSetCache() {
        return this.resultSetPopulator.getCache();
    }

    public IExecutorHelper getExecutorHelper() {
        if (this.handler != null) {
            return this.handler.getExecutorHelper();
        }
        return null;
    }

    static {
        $assertionsDisabled = !CachedResultSet.class.desiredAssertionStatus();
    }
}

