/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DataEngineSession {
    private Map context = new HashMap();
    private Scriptable scope;
    private DataSetCacheManager dataSetCacheManager;
    private CacheUtil cacheUtil;

    public DataEngineSession(DataEngineContext context) {
        this.dataSetCacheManager = new DataSetCacheManager(context.getTmpdir());
        this.cacheUtil = new CacheUtil(context.getTmpdir());
        this.scope = context.getJavaScriptScope();
        Context cx = Context.enter();
        if (this.scope == null) {
            this.scope = new ImporterTopLevel(cx);
        }
        new CoreJavaScriptInitializer().initialize(cx, this.scope);
        Context.exit();
    }

    public Object get(String key) {
        if (key != null) {
            return this.context.get(key);
        }
        return null;
    }

    public void set(String key, Object value) {
        this.context.put(key, value);
    }

    public Scriptable getSharedScope() {
        return this.scope;
    }

    public DataSetCacheManager getDataSetCacheManager() {
        return this.dataSetCacheManager;
    }

    public CacheUtil getCacheUtil() {
        return this.cacheUtil;
    }
}

