/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryDefnUtil;

public class GroupDefnUtil {
    static void saveGroupDefn(OutputStream outputStream, List groupList) throws DataException {
        DataOutputStream dos = new DataOutputStream(outputStream);
        int size = groupList == null ? 0 : groupList.size();
        try {
            IOUtil.writeInt((OutputStream)dos, (int)size);
            for (int i = 0; i < size; ++i) {
                IGroupDefinition groupDefn = (IGroupDefinition)groupList.get(i);
                IOUtil.writeString((DataOutputStream)dos, (String)groupDefn.getName());
                IOUtil.writeString((DataOutputStream)dos, (String)groupDefn.getKeyColumn());
                IOUtil.writeString((DataOutputStream)dos, (String)groupDefn.getKeyExpression());
                IOUtil.writeInt((OutputStream)dos, (int)groupDefn.getInterval());
                IOUtil.writeDouble((DataOutputStream)dos, (double)groupDefn.getIntervalRange());
                IOUtil.writeInt((OutputStream)dos, (int)groupDefn.getSortDirection());
                FilterDefnUtil.saveFilterDefn(dos, groupDefn.getFilters());
                QueryDefnUtil.saveSorts(dos, groupDefn.getSorts());
                QueryDefnUtil.saveSubQuery(dos, groupDefn.getSubqueries());
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    static List loadGroupDefn(InputStream inputStream) throws DataException {
        ArrayList<GroupDefinition> groupList = new ArrayList<GroupDefinition>();
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            int size = IOUtil.readInt((InputStream)inputStream);
            for (int i = 0; i < size; ++i) {
                GroupDefinition groupDefn = new GroupDefinition(IOUtil.readString((DataInputStream)dis));
                String keyColumn = IOUtil.readString((DataInputStream)dis);
                String keyExpr = IOUtil.readString((DataInputStream)dis);
                if (keyColumn != null) {
                    groupDefn.setKeyColumn(keyColumn);
                } else {
                    groupDefn.setKeyExpression(keyExpr);
                }
                groupDefn.setInterval(IOUtil.readInt((InputStream)dis));
                groupDefn.setIntervalRange(IOUtil.readDouble((DataInputStream)dis));
                groupDefn.setSortDirection(IOUtil.readInt((InputStream)dis));
                groupDefn.getFilters().addAll(FilterDefnUtil.loadFilterDefn(dis));
                groupDefn.getSorts().addAll(QueryDefnUtil.loadSorts(dis));
                groupDefn.getSubqueries().addAll(QueryDefnUtil.loadSubQuery(dis));
                groupList.add(groupDefn);
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", e);
        }
        return groupList;
    }

    public static boolean isEqualGroups(List list1, List list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (GroupDefnUtil.isEqualGroup((IGroupDefinition)list1.get(i), (IGroupDefinition)list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualGroup(IGroupDefinition groupDefn1, IGroupDefinition groupDefn2) {
        if (groupDefn1 == groupDefn2) {
            return true;
        }
        if (groupDefn1 == null || groupDefn2 == null) {
            return false;
        }
        return GroupDefnUtil.isEqualStr(groupDefn1.getName(), groupDefn2.getName()) && GroupDefnUtil.isEqualStr(groupDefn1.getKeyColumn(), groupDefn2.getKeyColumn()) && GroupDefnUtil.isEqualStr(groupDefn1.getKeyExpression(), groupDefn2.getKeyExpression()) && groupDefn1.getSortDirection() == groupDefn2.getSortDirection() && QueryDefnUtil.isEqualSorts(groupDefn1.getSorts(), groupDefn2.getSorts()) && FilterDefnUtil.isEqualFilter(groupDefn1.getFilters(), groupDefn2.getFilters()) && QueryDefnUtil.isCompatibleSQs(groupDefn1.getSubqueries(), groupDefn2.getSubqueries());
    }

    private static boolean isEqualStr(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }
}

